
b start
	@dup dcb 0xBA (0)

; --------------------------------------------------------------------------------------
; ----- main ---------------------------------------------------------------------------
start

;	set up graphics
	
	mov	r0,$04000000
	mov	r1,$1100				; mode 0, bg 0 enabled, sprites enabled
	orr	r1,r1,$40				; sprite 1-d mapping
	str	r1,[r0]				
	ldr     r1,=$8883				; lowest priority (3)
	str 	r1,[r0,+8]
	
	bl loadFont


	mov     r0,M_STRING1
	mov	r1,11
	mov     r2,1
	bl	draw_string
	mov     r0,M_STRING2
	mov	r1,4
	mov     r2,5
	bl	draw_string
	mov     r0,M_STRING3
	mov	r1,4
	mov     r2,6
	bl	draw_string
	mov     r0,M_STRING4
	mov	r1,5
	mov     r2,8
	bl	draw_string
	mov     r0,M_STRING5
	mov	r1,4
	mov     r2,9
	bl	draw_string
	mov     r0,M_STRING6
	mov	r1,9
	mov     r2,10
	bl	draw_string
	mov     r0,M_STRING7
	mov	r1,4
	mov     r2,12
	bl	draw_string
	mov     r0,M_STRING8
	mov	r1,9
	mov     r2,13
	bl	draw_string
	mov     r0,M_STRING9
	mov	r1,11
	mov     r2,17
	bl	draw_string

ForEver	b 	ForEver



@ltorg
; --------------------------------------------------------------------------------------


; --------------------------------------------------------------------------------------
M_STRING1		@ascii	"hello!"	
			@dcb 	$FF
M_STRING2		@ascii  "This is a writing demo"
			@dcb	$FF
M_STRING3		@ascii  "for the gameboy advance"
			@dcb    $FF
M_STRING4		@ascii  "using goldroad ARM "
			@dcb    $FF
M_STRING5		@ascii  "perhaps a little buggy"
			@dcb    $FF
M_STRING6		@ascii  "but still,"
			@dcb    $FF
M_STRING7		@ascii  "the friendliest assembler"
			@dcb    $FF
M_STRING8		@ascii  "around :)"
			@dcb    $FF
M_STRING9		@ascii  " - fools"
			@dcb    $FF


;-- dma memory copy routine ---------------------------------------------------------;
;------------------------------------------------------------------------------------;
dmaMemCpy  ; r0 = source; r1 = destination; r2 = count;

	mov 	r3,$04000000			; io regs address base
	str 	r0,[r3,+$D4]			; store source address (DMA 3)
	str	r1,[r3,+$D8]			; store destination
	mov	r2,r2 LSR 2			; divide count by 4
	strh 	r2,[r3,+$DC]			; store count
	mov 	r0,%1000010000000000		;		
	strh	r0,[r3,+$DE]			; set DMA to 32-bit, and enable
	mov 	pc,lr				; return
;--------------------------------------------------------------------------------------;

; -------------------------------------------------------------------------------------
; -- load font ------------------------------------------------------------------------
loadFont

	stmia		r13!,{r0,r1,r2,lr}
	mov r0,AZDATA
	mov r1,$06000000
	ldr r2,=5377
	bl  dmaMemCpy
	mov r0,AZPAL
	mov r1,$05000000
	ldr r2,=513
	bl  dmaMemCpy
	ldmia		r13!,{r0,r1,r2,lr}
	mov pc,lr

	@ltorg
;-------------------------------------------------------------------------------------


; -----------------------------------------------------------------------------------
; -- draw_string --------------------------------------------------------------------
; r0 = pointer to string
; r1 = x pos
; r2 = y pos
draw_string

	stmia r13,!{r0,r1,r2,r3,r4}
	ldr r3,=$06004000			; tile map address
	mov r4,64				; 
	mul r2,r2,r4				;
	add r2,r2,r1 LSL 1			; make coordinate
	orr r3,r3,r2
	mov r2,ASCIILUT
plotstring
	ldrb r1,[r0]+1
	cmp  r1,$FF
	beq endstring
	ldrb r4,[r2,r1]
	strh r4,[r3]+2
	b 	plotstring
endstring
	ldmia r13,!{r0,r1,r2,r3,r4}
	mov pc,lr
	@ltorg
;
; notes: this is a simple string writing routine, using the null terminating character
; $FF.  It uses the ascii look up table to find the right tile numbers as it scans through
; the string
; ------------------------------------------------------------------------------------


ASCIILUT
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $3F $00 $41 $42 $43 $44 $45 
@DCB $46 $47 $48 $49 $4A $4B $4C $4D $35 $36 
@DCB $37 $38 $39 $3A $3B $3C $3D $3E $4E $4F 
@DCB $50 $51 $52 $53 $00 $01 $02 $03 $04 $05 
@DCB $06 $07 $08 $09 $0A $0B $0C $0D $0E $0F 
@DCB $10 $11 $12 $13 $14 $15 $16 $17 $18 $19 
@DCB $1A $00 $00 $00 $00 $00 $00 $1B $1C $1D 
@DCB $1E $1F $20 $21 $22 $23 $24 $25 $26 $27 
@DCB $28 $29 $2A $2B $2C $2D $2E $2F $30 $31 
@DCB $32 $33 $34 $00 $00 $00 $40 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00  


AZDATA
	@incbin AZ.raw
AZPAL
	@incbin AZ.pal