#include <ncurses/ncurses.h>
#include <stdlib.h>
#include <stdio.h>

int modrandom();

int main(){
	const int numxlines = 50;
	const int numylines = 20;
	int x, y, xloc, yloc, enemyx, enemyy, ch;
	int points = 0;
	initscr();
	keypad(stdscr, true);
	noecho();
	start_color();
	init_pair(1, COLOR_RED, COLOR_BLACK);
	init_pair(2, COLOR_YELLOW, COLOR_BLACK);
	xloc = 1;
	yloc = 1;
	enemyx = 5;
	enemyy = 5;
	do {
		ch = getch();
		clear();
		switch (ch){
			case KEY_UP:
				--yloc;
				break;
			case KEY_DOWN:
				++yloc;
				break;
			case KEY_LEFT:
				--xloc;
				break;
			case KEY_RIGHT:
				++xloc;
				break;
			case ' ':
				if (yloc == enemyy && xloc == enemyx)
					++points;
				break;
		}
		if (xloc < 1)
			xloc = numxlines;
		else if (xloc > numxlines)
			xloc = 1;
		if (yloc < 1)
			yloc = numylines;
		else if (yloc > numylines)
			yloc = 1;
		enemyy += modrandom();
		enemyx += modrandom();
		if (enemyx < 1)
			enemyx = numxlines;
		else if (enemyx > numxlines)
			enemyx = 1;
		if (enemyy < 1)
			enemyy = numylines;
		else if (enemyy > numylines)
			enemyy = 1;

		for (y = 1; y <= numylines; y++){
			for (x = 1;x <= numxlines; x++){
				if (y == yloc && x == xloc){
					if (yloc == enemyy && xloc == enemyx)
						attron(COLOR_PAIR(1));
					printw("#");
					attroff(COLOR_PAIR(1));
				}
				else if (y == yloc){
					if (yloc == enemyy)
						attron(COLOR_PAIR(1));
					printw("-");
					attroff(COLOR_PAIR(1));
				}
				else if (x == xloc){
					if (xloc == enemyx)
						attron(COLOR_PAIR(1));
					printw("|");
					attroff(COLOR_PAIR(1));
				}
				else if (y == enemyy && x == enemyx){
					attron(COLOR_PAIR(2));
					printw("*");
					attroff(COLOR_PAIR(2));
				}
				else
					printw(" ");
			}
			printw("\n");
		}
		printw("%i points", points);
	} while (ch != KEY_F(1));
	endwin();
	return 0;
}




int modrandom(){
	int a;
	a = rand();
	if (a % 3 == 0)
		return -1;
	else if (a % 2 == 0)
		return 1;
	else
		return 0;
}
