#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <inttypes.h>
#include <stdint.h>
#include <sys/types.h>
#include <errno.h>
#include "graml.h"

// these are the defines for our command flags
#define CONFIG_PATH_GIVEN 1
#define TRAIT_PATH_GIVEN 2
#define OUT_PATH_GIVEN 4

#define PATH_BUFFER_SIZE 512

#define ALLOCATION_ERROR -1
#define FILE_OPEN_ERROR -2
#define TRAIT_PARSE_ERROR -3
#define RULE_PARSE_ERROR -4

#define UINT_FORMAT_STR "%12u"

void print_help_info();
void print_version_info();

int main(int argc, char **argv){
	int a,b,c,d,e,f,i; // iterative variables
	int retval; // return value of functions
	int size_alloced; //number of bytes allocated for organism array
	int command_flags = 0; // our command flags
	
	trait_t gendertrait; /* trait that determins gender; X is dominant, Y is recessive, and double Y is invalid. Thus,
	XX (1, 1) = female, XY(1, 0) = male, and YY (0, 0), is invalid; repeat spawn until not YY */
	
	double average_age, // our average age
	cumulative_average_age; // average age over all generations
	
	Trait_Table trait_table; // our trait table
	Ruleset ruleset; // our ruleset
	
	char *trait_file_path, *config_file_path, *out_file_path; // paths to said files
	
	Organism *organism; // our organism array
	
	FILE *trait_in, *config_in, *out; // our trait & config input files, and our output files
	
	//debugging code
	printf("# of args: %d\n", argc);
	for(i = 0; i < argc; i++)
		printf("argument %d: %s\n", i, argv[i]);
	// end debuggin code
	
	/* PLEASE INSERT FILE READING/PARSING CODE HERE */
	
	// parse traits from file
	printf("parsing traits... ");
	retval = parse_traits(&trait_table, trait_in);
	if(retval){
		printf("Error: Could not parse traits.\n");
		exit(TRAIT_PARSE_ERROR);
	}
	else printf("done.\n");
	
	// parse rules from rules file:
	printf("parsing rules... ");
	retval = parse_rules(&ruleset, trait_table, config_in);
	if(retval){
		printf("Error: Could not parse rules.\n");
		exit(RULE_PARSE_ERROR);
	}
	else printf(" done.\n");
	
	// put out the header for our output file
	fprintf(out, "%.12s", "generation");
	
	// and so we begin
	for(iteration = 0; iteration < ruleset.max_iterations; iteration++){
		printf("Starting iteration %d\n", iteration);
		// begin the 'die' code
		printf("beginning 'die' code...\n");
		for(i = 0; i < numalloced; i++){
			if(organism[i].flags & FLAGS_LIVING){
				if(evaluate_rule(organism[i], ruleset.die_if, trait_table)){
					organism[i].flags = organism[i].flags ^ FLAGS_LIVING;
					printf("killed creature at [%d].\n", i);
				}
			}
		}
		// end 'die' code
		// begin 'neuter' code
		printf("beginning 'neuter' code...\n");
		for(i = 0; i < numalloced; i++){
			if(is_valid_female(organism[i], ruleset.gender_trait) || is_valid_male(organism[i], ruleset.gender_trait)){
				if(evaluate_rule(organism[i], ruleset.neuter_if, trait_table)){
					neuter(organism[i]);
					printf("neutered organism at [%d].\n", i);
				}
			}
		}
		
		//INSERT REPRODUCE CODE HERE
		
		//INSERT STATISTICS CODE HERE
		
		// remember, fields are as follows:
		// iteration  number_living number_male number_female number_neuter number_trait1_dom number_trait1_rec ... number_traitn_dom ...
		
		fprintf(out, UINT_FORMAT_STR, iteration);
		fprintf(out, UINT_FORMAT_STR, numliving);
		fprintf(out, UINT_FORMAT_STR, num_male);
		fprintf(out, UINT_FORMAT_STR, num_female);
		fprintf(out, UINT_FORMAT_STR, num_neuter);
		fprintf(out, UINT_FORMAT_STR, num_new);
		for(a = 0; a < trait_table.numtraits; a++){
			fprintf(out, UINT_FORMAT_STR, num_dominant[a]);
			fprintf(out, UINT_FORMAT_STR, num_recessive[a]);
		}
		fprintf(out, "\n");
		
		
		
		
		printf("completed iteration %d.\n", iteration);
	}
		
	
	
	
	
	


			
	return 0;
}

void chompstr(char *s){
	size_t len = strlen(s);
	size_t i;
	for(i = 0; i < len; i++){
		if(s[i] = '\n')
			s[i] = '\0';
	}
	return;
}

void print_version_info(){
	printf("GRAML\n");
	printf("Genetic Recursion and Manipulation Language\n");
	printf("version: devel\n");
	return;
}


	
	
	