/*
 *  graml.h
 *  graml
 *
 *  Created by Pat O'Hara on 11/23/04.
 *  Copyright 2004 __MyCompanyName__. All rights reserved.
 *
 */
#include <inttypes.h>
#include <sys/types.h>

typedef uint8_t byte; // a simple byte
typedef uint16_t trait_t; // type for counting traits
typedef uint32_t age_t; // type for counting age
typedef uint16_t info_t; // type for info member
typedef byte statement_t; // type for our rule statements
#define TRAIT_T_MAX UINT16_MAX
// Here follows whether or not we have a global error variable

#define ERROR_VAR

#ifdef ERROR_VAR
int error_var;
#endif
// ERROR_VAR

//begin defines

// flags for info member of struct Organism
#define INFO_MALE 1
#define INFO_FEMALE 2





//define a 'Trait' object
typedef struct{
	char* dominant_desc; // describe the dominant phenotype, i.e. "brown haired"
	char* recessive_desc;
	size_t dd_size; // equal to strlen(dominant_desc);
	size_t rd_size;
} Trait;

// define our 'Trait_Table' object
typedef struct{
	trait_t numtraits; // number of traits
	Trait *traits; // actual array of traits
} Trait_Table;

//define our organism
struct organism_struct{
	struct organism_struct *mom, *dad;
	byte *ls, *rs;
	uint16_t numchildren;
	struct organism_struct *children;
	age_t age;
	short info;
};

typedef struct organism Organism;

typedef struct{
	uint16_t numstatements;
	statement_t *statements;
} Rule;

typedef struct{
	Rule die_if, neuter_if, flag_if[14], spawn_if, *spawn_dad_if, *spawn_mom_if;
	uint16_t mom_dad_pairs;
	int32_t numalloced;
	trait_t gender_trait;
} Ruleset;

// make it so we don't have to type 'struct organism_struct' every time
typedef struct organism_struct Organism;

int main(int argc, char **argv); // our main function
int eval_rules(Organism o, Rule r, Trait_Table t); // our function for evaluating rules
Organism organism_spawn(Organism male, Organism female, Trait_Table t); // our function for spawning a new organism
info_t info_flag(int n); // return the bit for a flag on an organism
int parse_rules(Ruleset *rules, Trait_Table t, FILE *infile); // parses rules into machine-readable form; returns non-zero upon error
int parse_traits(Trait_Table *t, FILE *infile); // parses traits from a file into machine-readable form; returns non-zero upon error
void chompstr(char *s); // chops of eol characters and makes them into \n's
int is_valid_female(Organism o, trait_t gender_trait); // determines if creature is valid reproducible female
itn is_valid_male(Organism o, trait_t gender_trait); // determines if creature is valid reproducible male



