#ifndef MAZE_H_
#define MAZE_H_

#include <sdl.h>
#include "SDLSprite.h"
#include "apmatrix.h"


enum TerrianType {START, WALL, EMPTY, FINISH};
enum Last {UP, DOWN, LEFT, RIGHT};

class Maze
{
public:
	Maze();
	Maze(const char * path);
	void LoadTerrain();
	void DrawMaze(SDL_Surface *Screen);
	void NavigateMaze(int x, int y, Last Prev);
	Draw(SDL_Surface * Screen);
	SDL_Surface *Screen;
	
	TerrianType GetLocation(int x, int y) {return myMaze[x][y];}
	int Rows() { return myMaze.numrows();}
	int Cols() { return myMaze.numcols();}
	int POSX() { return m_PosX;}
	int POSY() { return m_PosY;}


private:
	int m_PosX;
	int m_PosY;
	apmatrix<TerrianType> myMaze;
	SDLSprite *Terrian[5];


};
#endif
