#include <sdl.h>
#include "apmatrix.h"
#include "apstring.h"
#include <fstream.h>
#include <stdio.h>
#include <conio.h>
#include "maze.h"
#include "SDLSprite.h"


Maze::Maze()
{
//	for(int x = 0; x < 4; x++)
//	Terrain[x] = NULL;
}
Maze::Maze(const char * path)
{	
	LoadTerrain();
	apstring Input;
	ifstream fin;
	int Rows, Cols;
fin.open(path, ios::nocreate);
	if(! fin)
		cout << "CANNOT OPEN MAZE" << endl;
	fin >> Rows;
	fin >> Cols;

	myMaze.resize(Rows, Cols);
	
	getline(fin, Input);

	for(int x = 0; x < Rows; x++)
	{
		getline(fin, Input);
		for(int y = 0; y < Input.length(); y++)
			switch(Input[y])
			{
				case 's':
					myMaze[x][y] = START;
					m_PosX = x;
					m_PosY = y;
					break;
				case 'f':
					myMaze[x][y] = FINISH;
					break;
				case '*':
					myMaze[x][y] = WALL;
					break;
				case ' ':
					myMaze[x][y] = EMPTY;
					break;
				default:
					break;
			}
	}
	fin.close();
}
void Maze::DrawMaze(SDL_Surface *Screen)
{

	fprintf(stderr, "Drawing Maze\n");
	SDLSprite *Temp;
	for(int x = 0; x < Rows(); x++)
{
	for(int y = 0; y < Cols(); y++)
	{
		if(x == m_PosX && y == m_PosY)
		{
		//	cout << "#";
					Temp = (Terrian[4]);
					Temp->m_PosX = (y*20);
					Temp->m_PosY = (x*20);
					Temp->m_Frame = ((SDL_GetTicks()/30)%3);

					Temp->Draw(Screen, 0, 0);
			continue;
		}

		switch(GetLocation(x, y))
			{
				case START:
					Temp = (Terrian[0]);
					Temp->m_PosX = (y*20);
					Temp->m_PosY = (x*20);
					Temp->Draw(Screen, 0, 0);
					//	cout << "S";
					break;
				case FINISH:
					Temp = (Terrian[1]);
					Temp->m_PosX = (y*20);
					Temp->m_PosY = (x*20);
					Temp->Draw(Screen, 0, 0);
				//	cout << "F";
					break;
				case WALL:
					Temp = (Terrian[2]);
					Temp->m_PosX = (y*20);
					Temp->m_PosY = (x*20);
					Temp->Draw(Screen, 0, 0);
				//	cout << "*";
					break;
				case EMPTY:
					Temp = (Terrian[3]);
					Temp->m_PosX = (y*20);
					Temp->m_PosY = (x*20);
					Temp->Draw(Screen, 0, 0);
				//	cout << " ";
					break;
			}
	}
}
			SDL_UpdateRect(Screen, 0, 0, 0, 0);

}
void Maze::LoadTerrain()
{
	SDLSprite *temp = new SDLSprite("Start.bmp", 20, 20, 1);
	Terrian[0] = temp;
	temp = new SDLSprite("Finish.bmp", 20, 20, 1);
	Terrian[1] = temp;
	temp = new SDLSprite("Wall.bmp", 20, 20, 1);
	Terrian[2] = temp;
	temp = new SDLSprite("Empty.bmp", 20, 20,1);
	Terrian[3] = temp;
	temp = new SDLSprite("Navigator.bmp", 20, 20, 8);
	Terrian[4] = temp;

}



void Maze::NavigateMaze(int  x, int y, Last Prev)
{

	m_PosX = x;
	m_PosY = y;
	DrawMaze(Screen);
	SDL_Delay(150);

	fprintf(stderr, "pos x:%d, pos y:%d", x, y);

	switch(GetLocation(x, y))
			{
				case START:
				//	cout << "S";
					break;
				case FINISH:
				//	cout << "F";
					break;
				case WALL:
				//	cout << "*";
					break;
				case EMPTY:
				//	cout << " ";
					break;
			}
	//getch();

	if(myMaze[x][y] == FINISH)
	{
	//	cout << "finish" <<endl;
		
		 exit(0);
	}

if(x-1 > -1 && Prev != DOWN && (myMaze[x-1][y] == EMPTY || myMaze[x-1][y] == FINISH))
	{
	//	cout << x << y << "up"  <<endl;
		NavigateMaze(x-1, y, UP);
	}
if(x+1 < Rows()  && Prev != UP &&  (myMaze[x+1][y] == EMPTY || myMaze[x+1][y+1] == FINISH))
	{			
	//	cout << x << y << "down"  <<endl;
		NavigateMaze(x+1, y, DOWN);
	}
	if(y-1 > -1 && Prev != LEFT &&  (myMaze[x][y-1] == EMPTY || myMaze[x][y-1] == FINISH))
	{
	//	cout << x << y << "right"  <<endl;
		NavigateMaze(x, y-1, RIGHT);
	}
	
	if(y+1 < Cols() && Prev != RIGHT &&  (myMaze[x][y+1] == EMPTY || myMaze[x][y+1] == FINISH))
	{
	//	cout << x << y << "left"  <<endl;
		NavigateMaze(x, y+1, LEFT);
	}
	
	
	
	
//	cout << "FELL OUT" << x<<y<< endl;
//	getch();
}
	


