#ifndef RATIONAL_H_
#define RATIONAL_H_

#include "ostream.h"
#include "istream.h"
const int TOLERANCE = 400;
const int DECIMAL = 1000000;
const int RESOLUTION = 4;
/*********************************************************************************
//					The RATIONAL Class
//			ALEC BERNTSON		www.angelfire.com/al4/hardcprogramming
//				
//
//
//
//		Creates an accurate Rational Number
//		Constructors:   Rational(1)
//						Rational(1.5)
//						Rational(1, 2)
//						Rational(1.5, 2.5)
//						Rational("1/2")
//						Rational("1 1/2")
//
//		Every Operation is defined
//					Rational rat1 = "1/2", rat2 = "1/4";
//				rat1 + rat2 = ("3/4")
//				rat1 - rat2 = ("1/4")
//				rat1 / rat2 = ("2"  )
//				rat1 * rat2 = ("1/8")
//
//				rat1+= rat2;    (rat1 = "3/4")
//				rat1-= rat2;    (rat1 = "1/4")
//				rat1/= rat2;    (rat1 = "2"  )
//				rat1*= rat2;    (rat1 = "1/8")
//
//				rat1.ToInt		 = ("0")		
//				rat1.ToDouble	 = ("0.5")
//				
//				fudge() is very messy, and finds the closest Rational number
//					Tolerance defines how many pairs are tryed, (TOLERANCE^2 combos)
//				ex.	rat1 = (2.111111)	rat1.Fudge() = ("19/9")
//		Every Boolean is defined
//					Rational rat1 = "1/2", rat2 = "1/4";
//				rat1 == rat2	(false)
//				rat1 != rat2	(true)
//				rat1 <  rat2	(false)
//				rat1 <= rat2	(false)
//				rat1 >  rat2	(true)
//				rat1 >=	rat2	(true)
//
//		Outputing:
//			use Rational::SetMixed(bool) to set output style
//				Rational rat1 = 2.1111111	
//
//				Rational::SetMixed(false);				
//				cout << rat << endl;				outputs  211111/1000000
//				cout << rat.fudge() <<endl;			outputs  19/9
//				Rational::SetMixed(true);
//				cout << rat <<endl;					outputs	 2 11111/1000000
//				cout << rat.fudge() <<endl			outputs  2 2/9
//**************************************************************************************************	
*/

class Rational
{
public:
	Rational();
	Rational(int);
	Rational(int, int);
	Rational(char *);
	Rational(double);
	Rational(double, double);
	Rational(const Rational & rat);


	const Rational &operator += ( const Rational & lhs);
	const Rational &operator -= ( const Rational & lhs);
	const Rational &operator /= ( const Rational & lhs);
	const Rational &operator *= ( const Rational & lhs);
	
	Rational fudge()	const;
	int ToInt()			const;	
	double ToDouble()	const;
	int GetNumerator()	const{return Numerator;	 }
	int GetDenominator()const{return Denominator;}

	static	void SetMixed(bool in)  {MixedOut = in;}
	static	bool Mixed()			{return MixedOut;}
	static  void SetFudge(bool in)  {FudgeOut = in;}
	static  bool FudgedOut()		{return FudgeOut;}


private:

	int GCF(int, int);
	void Reduce();
	int Numerator;
	int Denominator;
	
	static bool MixedOut;
	static bool FudgeOut;
};

ostream &operator << (ostream & os,  const Rational & rat);
istream &operator >> (istream & os,   Rational & rat);

Rational operator + (const Rational & lhs, const Rational & rhs);
Rational operator - (const Rational & lhs, const Rational & rhs);
Rational operator / (const Rational & lhs, const Rational & rhs);
Rational operator * (const Rational & lhs, const Rational & rhs);

bool operator ==(const Rational & lhs, const Rational & rhs);
bool operator !=(const Rational & lhs, const Rational & rhs);
bool operator  <(const Rational & lhs, const Rational & rhs);
bool operator <=(const Rational & lhs, const Rational & rhs);
bool operator  >(const Rational & lhs, const Rational & rhs);
bool operator >=(const Rational & lhs, const Rational & rhs);



#endif;