#include "Rational.h"
#include <stdio.h>
#include <math.h>
//********************************************************************************
//					The RATIONAL Class
//			ALEC BERNTSON		www.angelfire.com/al4/hardcprogramming
//********************************************************************************


bool Rational::MixedOut = false;
bool Rational::FudgeOut = false;


Rational::Rational()
:Numerator(0), Denominator(1)

{}
Rational::Rational(const Rational & rat)
:Numerator(rat.GetNumerator()), Denominator(rat.GetDenominator())
{}
Rational::Rational(int num)
:Numerator(num), Denominator(1)
{}

Rational::Rational(int num1, int num2)
:Numerator(num1), Denominator(num2)
{
	Reduce();
}

Rational::Rational(double num)
// saves 8 decimal places
{
	int MostSig = (int)num;
	num -= MostSig;
	num *= DECIMAL;
	num += MostSig*DECIMAL;
	int gcf = GCF((int)num, DECIMAL);
	Numerator = (int)num/gcf;
	Denominator = DECIMAL/gcf;	
		Reduce();

}

Rational::Rational(double num1, double num2)

{
	double num = (num1/num2);
	int MostSig = (int)num;
	num -= MostSig;
	num *= DECIMAL;
	num += MostSig*DECIMAL;
	int gcf = GCF((int)num, DECIMAL);
	Numerator = (int)num/gcf;
	Denominator = DECIMAL/gcf;	
		Reduce();

}
Rational::Rational(char * str)
{
	float num1, num2 = 1, num3 = 0;
	if(sscanf(str, "%f/%f", &num1, &num2) != 2	&&	sscanf(str, "%f %f/%f", &num3, &num1, &num2) != 3 )
	{ 
		if(sscanf(str, "%f", &num1) == 1)
		{
			num2 = 1;
			
			double num = (num1/num2);
			int MostSig = (int)num;
			num -= MostSig;
			num *= DECIMAL;
			num += MostSig*DECIMAL;
			int gcf = GCF((int)num, DECIMAL);
			Numerator = (int)num/gcf;
			Denominator = DECIMAL/gcf;	
					Reduce();
				return;

		}
				Numerator = 0;
			Denominator = 1;
			return;
	}
	else
	{
		num1 = num3*num2+num1;

		double num = (num1/num2);
		int MostSig = (int)num;
		num -= MostSig;
		num *= DECIMAL;
		num += MostSig*DECIMAL;
		int gcf = GCF((int)num, DECIMAL);
		Numerator = (int)num/gcf;
		Denominator = DECIMAL/gcf;	
	}
		Reduce();

}
int Rational::ToInt() const 
{
	return Numerator/Denominator;
}
double Rational::ToDouble() const 
{
	return (double)Numerator/(double)Denominator;
}


void Rational::Reduce()
{
	int div = GCF(Numerator, Denominator);
	Numerator/=div;
	Denominator/=div;

	if(Numerator < 0 && Denominator < 0)
		Numerator*=-1, Denominator*=-1;
	if(Numerator >= 0 && Denominator < 0)
		Numerator*=-1, Denominator*=-1;

}


int Rational::GCF(int m, int n)
{
	int r;
	for(;;)
	{
		r = m%n;
		if(r == 0)
			break;
		m = n;
		n = r;
	}
	return n;
}



ostream &operator << (ostream & os, const Rational & rat)
{
		Rational out = rat;
		if(rat.FudgedOut())
			out = rat.fudge();

	if(out.Mixed() && out.GetNumerator() >  out.GetDenominator())
		os << out.GetNumerator() / out.GetDenominator() << " " << out.GetNumerator() % out.GetDenominator() <<  "/" << out.GetDenominator();
	else
		os << out.GetNumerator() << "/" << out.GetDenominator();
		return os;

}
istream &operator >> (istream & is,  Rational & rat)
{
	char* num = "";
	is >> num;
	rat = Rational(num);
	return is;

}
const Rational & Rational::operator += (const Rational & lhs)
{

	(Numerator*=lhs.GetDenominator());
	Numerator+= (lhs.GetNumerator()*Denominator);
	(Denominator*=lhs.GetDenominator()) ;
		Reduce();

	return *this;
}
const Rational & Rational::operator -= ( const Rational & lhs)
{
	(Numerator*=lhs.GetDenominator());
	Numerator-= (lhs.GetNumerator()*Denominator);
	(Denominator*=lhs.GetDenominator()) ;
		Reduce();

	return *this;
}
const Rational & Rational::operator /= ( const Rational & lhs)
{	
	if(lhs == 0)
	{
		cerr << "Cannot Divide by 0" << endl;
		return *this;
	}

	Numerator*=lhs.GetDenominator();
	Denominator*=lhs.GetNumerator();
		Reduce();

	return *this;
}
const Rational & Rational::operator *= ( const Rational & lhs)
{
	Numerator*=lhs.GetNumerator();
	Denominator*=lhs.GetDenominator();
		Reduce();

	return *this;
}

Rational operator + (const Rational & lhs, const Rational & rhs)
{
	Rational tmp(lhs);
//	cout << tmp <<endl;
	return tmp+=rhs;

}
Rational operator - (const Rational & lhs, const Rational & rhs)
{

	Rational tmp(lhs);
//	cout << tmp <<endl;
//	cout <<  <<endl;
	return tmp-=rhs;
}
Rational operator / (const Rational & lhs, const Rational & rhs)
{
	Rational tmp(lhs);
	return tmp/=rhs;

}
Rational operator * (const Rational & lhs, const Rational & rhs)
{
	Rational tmp(lhs);
	return tmp*=rhs;
}

double Dabs(double num)
{
	if(num < 0)
		num*=-1;
return num;

}

Rational Rational::fudge() const
{
	double tmp = ToDouble(), num;
	double dif = 100;
	int x1, y1;
for(int x = -TOLERANCE; x < TOLERANCE; x+=RESOLUTION)
	for(int y = -TOLERANCE; y < TOLERANCE; y+=RESOLUTION)
	{
		if(y == 0)
			continue;
		num = (double)x/(double)y;
		if(Dabs(tmp-num) < dif)
		{
			dif = Dabs(tmp-num);
			x1 = x, y1 = y;
		}
	}
	Rational Tmp(x1, y1);
	Tmp.SetMixed(MixedOut);
	return Tmp;

}

bool operator ==(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() == rhs.ToDouble();
}
bool operator !=(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() == rhs.ToDouble();

}
bool operator  <(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() < rhs.ToDouble();

}
bool operator <=(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() <= rhs.ToDouble();

}
bool operator  >(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() > rhs.ToDouble();
}
bool operator >=(const Rational & lhs, const Rational & rhs)
{
	return lhs.ToDouble() >= rhs.ToDouble();
}
