#ifndef BST_H_
#define BST_H_


template <class itemType> struct Node
{
	itemType data;
	Node<itemType> *right;
	Node<itemType> *left;
};

template <class itemType> class BST
{
public:
	BST();
	BST(const BST & rhs);
//	~BST();

	void Insert(Node<itemType> *&p, itemType data);
	void Remove(Node<itemType> *&p, itemType data);
	void SaveTree( const char * path);
	bool LoadTree( const char * path);

	void PostOrder(Node<itemType> *p);
	void PreOrder(Node<itemType> *p);
	void InOrder(Node<itemType> *p);

	Node<itemType> *&GetTree() {return myTree;}
	int GetNumNodes() {return numNodes;}
	int GetHeight() {return Height;}

private:
	Node<itemType> *myTree;
	int numNodes;
	int Height;
};
#include "BST.cpp"
#endif
