//#include "bool.h"
#include "apstack.h"
#include "apvector.cpp"
#include "apstack.cpp"
#include "apstring.h"
#include "apstring.cpp"
#include <iostream.h>

template <class Item>
void Print(const apstack<Item> & s)
{
    apstack<Item> copy(s);

    while (! copy.isEmpty())
    {
        cout << copy.top() << endl;
        copy.pop();
    }
    cout << "----------" << endl;
}

template <class Item>
void DPrint(apstack<Item> & s)
{

    while (!s.isEmpty())
    {
        cout << s.top() << endl;
        s.pop();
    }
    cout << "dprint ----------" << endl;
    s.pop();
}


int main()
{
    apstring names[] = {
        "ken","don","chris","susanh","susanr",
        "cary","theresa","franh","gail","marks",
        "markw","owen","mike","henry","barbara",
        "allen","frant","ron"
    };
    int numNames = sizeof(names)/sizeof(apstring);

    apstack<int> istack;
    apstack<apstring> sstack;
    int k;

    for(k=0; k < numNames; k++)
    {
        sstack.push(names[k]);
        istack.push(k);
    }

    cout << "num names = " << numNames << endl;
    Print(istack);
    Print(sstack);
    
    apstack<int> istack2;

    istack2 = istack;
    Print(istack2);

    DPrint(sstack);
    DPrint(istack);
    
	return 0;
}
