// console.h
// contains functions to translate Borland C++
// console operations to Microsoft Visual C++
// console.h by Gary Frankenbery
// Grants Pass High School
// Grants Pass, OR
#include <windows.h> // for console operations
#include <stdlib.h> // for rand(), srand()
#include <time.h> // for time()
#include <conio.h> // for _getch() and _getche()

// gotoxy() Positions cursor relative to the upper
// left corner of the screen. In Borland's
// conio.h, the upper left corners is (1,1),
// while in Microsoft's
// SetConsoleCursorPosition()the coordinates
// of the upper left corner are (0,0). Note
// the adjustment to x and y below to use
// Borland's scheme.
void gotoxy(int x, int y)
{ HANDLE hdl;
COORD coords;
// get the console handle
hdl = GetStdHandle(STD_OUTPUT_HANDLE);
coords.X = x-1;
coords.Y = y-1; // set cursor position
SetConsoleCursorPosition(hdl, coords);
}

// clrscr() Clears the screen, and sets the cursor
// to position (1,1), the upper left
// corner.

// NOTE THIS IS THE OLD WAY AND HAS BEEN COMMENTED OUT
/* void clrscr() // clear screen
{ HANDLE hOutput; // console handle
DWORD cWritten; // number actually written
COORD coord; // coordinates of upper left
char chFillChar; // fill character
DWORD nLength; // number of cells to fill
// get the console handle
hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

coord.X = 0; // set coordinates of first cell
coord.Y = 0; // to upper left corner
chFillChar = ' '; // set the fill character to space
nLength = 80 * 50; // assume 80 by 50 character screen

// do the fill
FillConsoleOutputCharacter(hOutput, chFillChar, nLength,
coord, &cWritten);
gotoxy(1,1); // return the cursor to the upper
// left corner.
} */

// NEW WAY TO CLEAR SCREEN
void clrscr()
{ system("CLS");
}

void delay(long msecs) // delay 'msecs' milliseconds
{
clock_t now = clock(); // get current time
clock_t then = now +
CLOCKS_PER_SEC * (double)msecs / 1000.0;
while(now < then)
now = clock();
}

// randomize() Seeds the random number generator.
//
void randomize()
{ srand( (unsigned)time(NULL) );
}

// returns a random number in range 0 to num-1
int random(int num)
{
return rand() % num;
}

// Waits for and returns a keypress (no echo)
int getch()
{ int ch;
HANDLE hdl;
cout << flush;
ch = _getch();
hdl = GetStdHandle(STD_INPUT_HANDLE);
FlushConsoleInputBuffer(hdl);
return ch;
}

// Waits for and returns a keypress with echo
int getche()
{ int ch;
HANDLE hdl;
ch = _getche();
hdl = GetStdHandle(STD_INPUT_HANDLE);
FlushConsoleInputBuffer(hdl);
return ch;
}

