
include "openpic.t"
delay (1000)
cls
colourback (0)

%%%%%%%%%%%%%%%%%%%%%%%%%
% HUGE Declaration Zone %
%%%%%%%%%%%%%%%%%%%%%%%%%

var score1, score2, counta, countb, c5, st, et, tt, tt2, c6, ptot : int
var x1, x2, x3, x4, y1, y2, y3, y4, rad, xx, yy, speed, xch, ych : int
var choice, c1, c2, diff, points, x, y, a1, a2, rad2, count : int
var player : int := 1

var mode : string (50)
var name1, name2 : string (12)
var yn, moves : string (1)

var b, bb, p1win, p2win : boolean := false
var slope1, dist : real

var num : array 1 .. 20 of int := init (20, 1, 18, 4, 13, 6, 10, 15, 2, 17,
    3, 19, 7, 16, 8, 11, 14, 9, 12, 5)

var lrow : array 1 .. 20 of int := init (1, 2, 4, 7, 11, 15, 20, 24, 27, 29,
    30, 29, 27, 24, 20, 15, 11, 7, 4, 2)

var lcol : array 1 .. 20 of int := init (40, 51, 58, 64, 68, 70, 68, 64, 58,
    51, 41, 29, 23, 16, 13, 11, 12, 17, 22, 30)

var cursorpic : array 1 .. sizepic (0, 0, 2, 2) of int
var cursorpic2 : array 1 .. sizepic (0, 0, 2, 2) of int
var erasepic : array 1 .. sizepic (0, 0, 2, 2) of int
var c : array 1 .. 20 of int

x := maxx div 2
y := maxy div 2
score1 := 301
score2 := 301
counta := 0
countb := 0
tt2 := 0
ptot := 0
speed := 5
randomize

%%%%%%%%%%%%%%%%%%%%%%%%
% Initial Setup Screen %
%%%%%%%%%%%%%%%%%%%%%%%%

locate (1, 15)
put " What graphics mode would you like to run?:{ }"
locate (3, 25)
put " 1.Super VGA (256 colours)"
locate (4, 25)
put " 2.VGA (16 colours)"
loop
    locate (1, 59)
    get choice
    exit when choice > 0 and choice < 3
end loop
case choice of
    label 1 :
	mode := "graphics:svga,nocursor,noecho"
	c1 := 16
	c2 := 44
    label 2 :
	mode := "graphics:vga,nocursor,noecho"
	c1 := 0
	c2 := 14
end case
loop
    locate (6, 19)
    put repeat ("-", 37)
    locate (7, 20)
    put "[Select a difficulty level (1-10):  ]"
    locate (7, 54)
    get diff
    exit when diff > 0 and diff < 11
end loop
loop
    locate (9, 1)
    put "Player 1's name:!        !"
    locate (9, 18)
    get name1
    exit when length (name1) < 9
end loop
loop
    locate (10, 1)
    put "Player 2's name:!        !"
    locate (10, 18)
    get name2
    exit when length (name2) < 9
end loop

loop
    locate (12, 1)
    put "Would you like some instructions?(y/n)"
    get yn
    if yn = "y" then
	cls
	include "instruct.t"
    end if
    exit when yn = "y" or yn = "n"
end loop

setscreen (mode)

%%%%%%%%%%%%%%%%%%%%
% Draws dart board %
%%%%%%%%%%%%%%%%%%%%

setscreen (mode)
drawfillbox (0, 0, maxx, maxy, 1)

if choice = 1 then
    colourback (1)
end if
for i : 1 .. 20
    if i mod 2 = 0 then
	c (i) := c1
    else
	c (i) := c2
    end if
end for

procedure board
    count := 0
    drawoval (x, y, rad2, rad2, 7)
    for i : 9 .. 369 by 18
	count += 1
	a1 := i
	a2 := a1 + 18
	drawfillarc (x, y, rad2, rad2, i, i, 7)
	if count < 21 then
	    drawfillarc (x, y, rad2 - 1, rad2 - 1, a1, a2, c (count))
	end if
    end for
    for i : 9 .. 369 by 18
	drawfillarc (x, y, rad2, rad2, i, i, 7)
    end for
end board

drawfilloval (x, y, 222, 222, 7)
rad2 := 220
board
drawoval (x, y, 219, 219, c1)
for i : 1 .. 20
    if i mod 2 = 0 then
	c (i) := c2
    else
	c (i) := c1
    end if
end for
drawfilloval (x, y, 200, 200, 7)
rad2 := 198
board
drawoval (x, y, 201, 201, c1)
for i : 1 .. 20
    if i mod 2 = 0 then
	c (i) := c1
    else
	c (i) := c2
    end if
end for
drawfilloval (x, y, 120, 120, 7)
rad2 := 118
board
drawoval (x, y, 117, 117, c1)
for i : 1 .. 20
    if i mod 2 = 0 then
	c (i) := c2
    else
	c (i) := c1
    end if
end for
drawoval (x, y, 101, 101, c1)
drawfilloval (x, y, 100, 100, 7)
rad2 := 98
board
drawfilloval (x, y, 31, 31, 7)
drawfilloval (x, y, 29, 29, c1)
drawfilloval (x, y, 15, 15, 7)
drawfilloval (x, y, 13, 13, c1)
drawfilloval (x, y, 12, 12, 4)

procedure score
    locate (1, 1)
    colour (15)
    put "Current Score" ..
    put "" ..
    locate (2, maxcol - 8)
    colour (10)
    put name1 ..
    put "" ..
    locate (3, maxcol - 8)
    colour (13)
    put score1, " " ..
    put "" ..
    locate (maxrow - 2, maxcol - 8)
    colour (12)
    put name2 ..
    put "" ..
    locate (maxrow - 1, maxcol - 8)
    colour (13)
    put score2, " " ..
    put "" ..
    locate (maxrow - 1, 1)
    colour (15)
    put "Start" ..
    put "" ..
end score

score

procedure slope
    x1 := maxx div 2
    y1 := maxy div 2
    x2 := xx + 1
    y2 := yy + 1
    if xx + 1 = x then
	x2 := xx + 2
    end if
    slope1 := (y1 - y2) / (x1 - x2)
end slope

procedure distance
    dist := sqrt ( ( (xx - x) ** 2) + ( (yy - y) ** 2))
end distance

%%%%%%%%%%%%%%%%%%%%%%%%%
% puts numbers on board %
%%%%%%%%%%%%%%%%%%%%%%%%%

colour (15)
for i : 1 .. 20
    locate (lrow (i), lcol (i))
    colour (15)
    put num (i) ..
    put "" ..
end for

procedure cursor
    if whatdotcolour (xx + 1, yy + 1) = c1 then
	c6 := c2
    elsif whatdotcolour (xx + 1, yy + 1) = c2 then
	c6 := c1
    else
	c6 := 15
    end if
    takepic (xx, yy, xx + 2, yy + 2, erasepic)
    drawline (xx, yy, xx + 2, yy, c6) %bottom
    drawline (xx, yy, xx, yy + 2, c6) %left
    drawline (xx, yy + 2, xx + 2, yy + 2, c6) %top
    drawline (xx + 2, yy + 2, xx + 2, yy, c6) %right
    takepic (xx, yy, xx + 2, yy + 2, cursorpic)
    drawpic (xx, yy, erasepic, 0)
    randint (xch, - diff, diff)
    randint (ych, - diff, diff)
    if xx > 0 and xx < maxy and yy > 0 and yy < maxy then
	xx += xch
	yy += ych
    end if
    takepic (xx, yy, xx + 2, yy + 2, cursorpic2)
    drawpic (xx, yy, cursorpic, 0)
    drawpic (xx, yy, cursorpic2, 0)
end cursor

procedure distance2
    if dist > 99 and dist < 119 then
	points := points * 3
    elsif dist > 199 and dist < 221 then
	points := points * 2
	if player > 0 then
	    counta := 1
	elsif player < 0 then
	    countb := 1
	end if
    end if
end distance2

%%%%%%%%%%%%%
% Main Code %
%%%%%%%%%%%%%

loop
    if player > 0 then
	c5 := 10
	drawfillbox (560, maxy - 15, maxx, maxy - 48, 15)
	drawfillbox (560, 15, maxx, 48, 1)
	score
    elsif player < 0 then
	c5 := 12
	drawfillbox (560, 15, maxx, 48, 15)
	drawfillbox (560, maxy - 15, maxx, maxy - 48, 1)
	score
    end if
    for k : 1 .. 3
	xx := 20
	yy := 32
	rad := 1

	loop
	    clock (st)
	    cursor
	    if hasch then
		getch (moves)
		if ord (moves) = 43 then
		    speed += 1
		elsif ord (moves) = 45 then
		    speed -= 1
		end if
		if ord (moves) = 200 then
		    if yy < maxy - 5 then
			yy += speed
		    end if
		    cursor
		end if
		if ord (moves) = 208 then
		    if yy > 5 then
			yy -= speed
		    end if
		    cursor
		end if
		if ord (moves) = 203 then
		    if xx > 5 then
			xx -= speed
		    end if
		    cursor
		end if
		if ord (moves) = 205 then
		    if xx < maxx - 5 then
			xx += speed
		    end if
		    cursor
		end if
		if ord (moves) = 32 then
		    b := true
		    exit
		end if
		if ord (moves) = 27 then
		    exit
		end if
	    end if
	    clock (et)
	    tt := (et div 1000) - (st div 1000)
	    tt2 += tt
	    if tt2 >= 20 then
		b := true
		tt2 := 0
		exit
	    end if
	end loop
	if b then
	    drawline (xx, yy, xx + 2, yy, c5) %bottom
	    drawline (xx, yy, xx, yy + 2, c5) %left
	    drawline (xx, yy + 2, xx + 2, yy + 2, c5) %top
	    drawline (xx + 2, yy + 2, xx + 2, yy, c5) %right
	    locate (2, 1)
	    put "   " ..
	    put "" ..
	    tt2 := 0
	end if

	distance
	slope

	if slope1 <= - 6.22 or slope1 >= 6.35 then
	    points := 3
	    distance2
	end if
	if slope1 >= 2 and slope1 < 6.35 and xx > x then
	    points := 1
	    distance2
	end if
	if slope1 >= 1 and slope1 < 2 and xx > x then
	    points := 18
	    distance2
	end if
	if slope1 >= .5 and slope1 < 1 and xx > x then
	    points := 4
	    distance2
	end if
	if slope1 >= .16 and slope1 < .5 and xx > x then
	    points := 13
	    distance2
	end if
	if slope1 >= - .16 and slope1 < .16 and xx > x then
	    points := 6
	    distance2
	end if
	if slope1 >= - .5 and slope1 < - .16 and xx > x then
	    points := 10
	    distance2
	end if
	if slope1 >= - 1 and slope1 < - .5 and xx > x then
	    points := 15
	    distance2
	end if
	if slope1 >= - 2 and slope1 < - 1 and xx > x then
	    points := 2
	    distance2
	end if
	if slope1 >= - 6.22 and slope1 < - 2 and xx > x then
	    points := 17
	    distance2
	end if

	if slope1 >= 2 and slope1 < 6.35 and xx < x then
	    points := 19
	    distance2
	end if
	if slope1 >= 1 and slope1 < 2 and xx < x then
	    points := 7
	    distance2
	end if
	if slope1 >= .5 and slope1 < 1 and xx < x then
	    points := 16
	    distance2
	end if
	if slope1 >= .16 and slope1 < .5 and xx < x then
	    points := 8
	    distance2
	end if
	if slope1 >= - .16 and slope1 < .16 and xx < x then
	    points := 11
	    distance2
	end if
	if slope1 >= - .5 and slope1 < - .16 and xx < x then
	    points := 14
	    distance2
	end if
	if slope1 >= - 1 and slope1 < - .5 and xx < x then
	    points := 9
	    distance2
	end if
	if slope1 >= - 2 and slope1 < - 1 and xx < x then
	    points := 12
	    distance2
	end if
	if slope1 >= - 6.22 and slope1 < - 2 and xx < x then
	    points := 5
	    distance2
	end if

	distance

	if dist > 13 and dist <= 29 then
	    points := 25
	elsif dist <= 13 then
	    points := 50
	    if player > 0 then
		counta := 1
	    elsif player < 0 then
		countb := 1
	    end if
	end if
	if dist > 220 then
	    points := 0
	end if

	if points = 3 and yy > y then
	    points := 20
	elsif points = 6 and yy > y then
	    points := 40
	elsif points = 9 and yy > y then
	    points := 60
	end if

	if score1 < 41 then
	    if score1 mod 2 = 0 and player > 0 then
		if points = score1 and dist > 199 and dist < 221 then
		    p1win := true
		    exit
		end if
	    end if
	elsif score1 = 50 and points = 50 then
	    p1win := true
	end if
	if score2 < 41 then
	    if score2 mod 2 = 0 and player < 0 then
		if points = score2 and dist > 199 and dist < 221 then
		    p2win := true
		    exit
		end if
	    end if
	elsif score2 = 50 and points = 50 then
	    p2win := true
	end if
	if player > 0 and points >= score1 - 1 then
	    exit
	end if
	if player < 0 and points >= score2 - 1 then
	    exit
	end if
	ptot += points

	locate (2, 1)
	put ptot ..
	put "" ..
	if counta > 0 then
	    if player > 0 then
		score1 -= points
	    end if
	end if
	if countb > 0 then
	    if player < 0 then
		score2 -= points
	    end if
	end if
	score
    end for
    ptot := 0
    locate (2, 1)
    put "   " ..
    put "" ..
    player := player * - 1
    score
    exit when p1win or p2win
end loop
cls
locate (maxrow div 2, maxcol div 2 - 3)
if p1win then
    put name1, " Wins"
elsif p2win then
    put name2, " Wins"
end if
play ("8c8c8d8e8c8e8d8<g>8c8c8d8e4c8<b8g>8c8c8d8e8f8e8d8c8<b8g8a8b>4c4c")
delay (1000)
cls
include "closepic.t"
