%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                              %
%      Turing Font System      %
%     --------------------     %
%                              %
%   Include these procedures   %
%     your Turing programs     %
%                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Notes:
% ------
% This system uses files created with TFONT-ED.T, that is, .FNT files.
% If you don't have TFONT-ED.T, and/or any .FNT files, this file really
% isn't much use to you. :)

% To use these routines, either just copy them into your program, or
% use the line:
% include "TFONT.T"
% In your program. Without the %, of course. :)

% There are only two routines in this file:
% LoadFont (filename : string)
% - Loads a font
% FontPut (text : string, x, y : int)
% - Puts text on the screen

% You MUST load a font before you use FontPut, otherwise you'll get an error.
% For more info, see TFONTS.DOC.

% -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

% Variables
var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int

% Procedures

proc LoadFont (filename : string)
    var d : int := 0
    open : d, filename, get
    for cnt : 32 .. 126
	for t : 1 .. 8
	    for p : 1 .. 8
		get : d, font (cnt, p, t)
	    end for
	end for
    end for
end LoadFont

proc FontPut (text : string, x, y : int)
    var nx, ny : int := 0
    var temp : string
    nx := (x * 8) - 8
    ny := (y * 8) - 8
    for cnt : 32 .. 31 + length (text)
	for t : 1 .. 8
	    for p : 1 .. 8
		temp := text (cnt - 31)
		if font (ord (temp), t, p) not= 0 then
		    drawdot (nx + t, 192 - ny + (8 - p), font (ord (temp), 
			t, p))
		end if
	    end for
	end for
	nx := nx + 8
    end for
end FontPut
