%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                              %
%   Turing Color Font Editor   %
%  --------------------------  %
%                              %
%  Create new fonts to use in  %
%     your Turing programs     %
%                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Note: You will need TFONT.T to use the fonts created using this
%       editor. If you don't have that file, this program won't
%       be of much use to you. :) See TFONT.DOC for more info.

% -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

%  _______
% | Setup |
%  ~~~~~~~
setscreen ("graphics:mcga")
buttonchoose ("multibutton")

%  ____________
% | Procedures |
%  ~~~~~~~~~~~~

% Turn the cursor off
proc CursorOff
    setscreen ("nocursor,noecho")
end CursorOff

% Turn the cursor on
proc CursorOn
    setscreen ("cursor,echo")
end CursorOn

% Draw the borderlines around the screen
proc DrawBorders
    % Around the edit box
    color (7)
    locate (1, 1)
    put chr (201), repeat (chr (205), 8), chr (187) ..
    for t : 1 .. 8
	locate (t + 1, 1)
	put chr (186) ..
	locate (t + 1, 10)
	put chr (186) ..
    end for
    locate (10, 1)
    put chr (200), repeat (chr (205), 8), chr (188) ..
    % Around color box
    locate (16, 1)
    put repeat (chr (205), 40) ..
    locate (23, 1)
    put repeat (chr (205), 40) ..
end DrawBorders

% Setup lookup table for color values
proc CLookupSetup (var clookup : array 17 .. 23, 1 .. 40 of int)
    var count : int := 0
    for t : 17 .. 22
	for p : 1 .. 40
	    clookup (t, p) := count
	    count := count + 1
	end for
    end for
end CLookupSetup

% Show the colors at the bottom of the screen
proc ShowColors
    locate (17, 1)
    for t : 0 .. 239
	color (t)
	put chr (219) ..
    end for
end ShowColors

% Show the current letter
proc ShowLett (current : int)
    locate (1, 1)
    color (15)
    put chr (current) ..
end ShowLett

% Show the current color
proc ShowCurColor (col : int)
    locate (15, 1)
    color (44)
    put "Color: " ..
    color (27)
    put "[" ..
    color (col)
    put repeat (chr (219), 2) ..
    color (27)
    put "]" ..
end ShowCurColor

% Show the titles, menu, etc.
proc ShowTitle
    % Title
    locate (2, 15)
    color (44)
    put "Turing 256 Font Editor" ..
    locate (3, 15)
    color (42)
    put repeat (chr (196), 22) ..
    % Menu
    % Line one
    locate (6, 13)
    color (25)
    put "<" ..
    color (29)
    put "Load" ..
    color (25)
    put ">    <" ..
    color (29)
    put "Save" ..
    color (25)
    put ">    <" ..
    color (29)
    put "Help" ..
    color (25)
    put ">" ..
    % Line two
    locate (8, 13)
    color (25)
    put "<" ..
    color (29)
    put "Clear current" ..
    color (25)
    put "> <" ..
    color (29)
    put "New font" ..
    color (25)
    put ">" ..
    % Line three
    locate (10, 13)
    put "<" ..
    color (29)
    put "See entire set" ..
    color (25)
    put ">   <" ..
    color (29)
    put "Quit!" ..
    color (25)
    put ">" ..
    % Draw the preview box
    locate (12, 1)
    color (28)
    put "Preview: "
    drawbox (70, 102, 81, 113, 10)
    % Put my nick ^_^
    locate (15, 25)
    color (40)
    put "emmzee '97"
end ShowTitle

% Clear the font array
proc ClearFont (var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int)
    for f : 32 .. 126
	for t : 1 .. 8
	    for p : 1 .. 8
		font (f, t, p) := 0
	    end for
	end for
    end for
end ClearFont

% Show editing window
proc ShowEditWindow (var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int,
	current : int)
    for t : 1 .. 8
	for p : 1 .. 8
	    locate (t + 1, p + 1)
	    color (font (current, p, t))
	    put chr (219) ..
	end for
    end for
end ShowEditWindow

% Show preview window
proc ShowPreviewWindow (var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int,
	current : int)
    for t : 1 .. 8
	for p : 1 .. 8
	    drawdot (t + 71, p + 103, font (current, t, 9 - p))
	end for
    end for
end ShowPreviewWindow

% Ask if user is sure
proc Ask (var sure : boolean)
    var dummy : string (1)
    mousehide
    locate (12, 17)
    color (9)
    put "Are you sure? <Y/N>" ..
    getch (dummy)
    if dummy = "Y" or dummy = "y" then
	sure := true
    else
	sure := false
    end if
    locate (12, 17)
    put ""
    mouseshow
end Ask

% Clear just current letter
proc ClearCurrent (var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int,
	current : int)
    for t : 1 .. 8
	for p : 1 .. 8
	    font (current, t, p) := 0
	end for
    end for
end ClearCurrent

% Save the font!
proc SaveFont (font : array 32 .. 126, 1 .. 8, 1 .. 8 of int)
    var d : int := 0
    var filename : string := ""
    mousehide
    CursorOn
    locate (12, 14)
    color (32)
    put "File to save:" ..
    locate (13, 14)
    put "> " ..
    color (35)
    get filename : *
    filename := filename + ".fnt"
    color (32)
    locate (12, 14)
    put "Please wait ..."
    locate (13, 14)
    put ""
    if filename not= ".fnt" then
	open : d, filename, put
	for cnt : 32 .. 126
	    for t : 1 .. 8
		for p : 1 .. 8
		    if font (cnt, p, t) < 10 then
			put : d, "00" ..
		    elsif font (cnt, p, t) < 100 then
			put : d, "0" ..
		    end if
		    put : d, font (cnt, p, t), " " ..
		end for
		put : d, ""
	    end for
	end for
	close : d
    end if
    locate (12, 14)
    put ""
    mouseshow
    CursorOff
end SaveFont

% Load a font!!!
proc LoadFont (var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int, var
	current : int)
    var d : int := 0
    var filename, dummy : string := ""
    mousehide
    CursorOn
    locate (12, 14)
    color (32)
    put "File to load:" ..
    locate (13, 14)
    put "> " ..
    color (35)
    get filename : *
    filename := filename + ".fnt"
    color (32)
    locate (12, 14)
    put "Please wait ..."
    locate (13, 14)
    put ""
    if filename not= ".fnt" then
	open : d, filename, get
	for cnt : 32 .. 126
	    for t : 1 .. 8
		for p : 1 .. 8
		    get : d, font (cnt, p, t)
		end for
	    end for
	end for
	current := 65
	ShowLett (current)
	ShowEditWindow (font, current)
	ShowPreviewWindow (font, current)
	close : d
    end if
    locate (12, 14)
    put ""
    mouseshow
    CursorOff
end LoadFont

% Show the whole font on a new screen
proc ShowWholeFont (font : array 32 .. 126, 1 .. 8, 1 .. 8 of int)
    var xpos, ypos : int := 0
    var dummy : string (1)
    ypos := 190
    mousehide
    cls
    color (40)
    locate (5, 1)
    put " Please wait, drawing font ..."
    for cr : 32 .. 126
	for t : 1 .. 8
	    for p : 1 .. 8
		drawdot (t + xpos, ypos + p, font (cr, t, 9 - p))
	    end for
	end for
	if xpos > 304 then
	    xpos := 0
	    ypos := ypos - 8
	else
	    xpos := xpos + 8
	end if
    end for
    locate (5, 1)
    put " Press any key to go back"
    getch (dummy)
    mouseshow
end ShowWholeFont

% The fairly lame help screen
proc Help
    var dummy : string (1)
    cls
    color (44)
    locate (1, 1)
    put " Help!!!!!"
    color (43)
    put repeat (chr (196), 40)
    put ""
    color (32)
    put "Welcome to the TFONT editor. To edit"
    put "a character, simply use the mouse. Left"
    put "button plots a pixel, right button grabs"
    put "a color. To change the current char-"
    put "acter, either type the character you"
    put "want to edit, or use the left and right"
    put "arrow keys. Remember that the color (0),"
    put "black, is `transparent'. See TFONT.DOC"
    put "for more detailed help. :)"
    put ""
    color (43)
    put repeat (chr (196), 40)
    color (48)
    put " Press any key to return"
    getch (dummy)
end Help

%  ___________
% | Variables |
%  ~~~~~~~~~~~

var font : array 32 .. 126, 1 .. 8, 1 .. 8 of int
var clookup : array 17 .. 23, 1 .. 40 of int
var key : string (1)
var current : int := 65
var col : int := 15
var x, y, btn, mx, my : int := 0
var sure, quitprog : boolean := false

%  ______________
% | Main program |
%  ~~~~~~~~~~~~~~

% Startup
CursorOff
ClearFont (font)
CLookupSetup (clookup)
ShowTitle
DrawBorders
ShowLett (current)
ShowEditWindow (font, current)
ShowColors
ShowCurColor (col)
% Main loop begins
loop
    mousewhere (x, y, btn)
    x := x div 8 + 1
    y := 25 - (y div 8)
    if mx not= x or my not= y then
	mx := x
	my := y
	locate (13, 2)
	color (35)
	put "(", mx : 2, ",", my : 2, ")" ..
    end if
    if hasch then
	getch (key)
	% Hotkey char switching
	if ord (key) >= 32 and ord (key) <= 126 then
	    current := ord (key)
	    ShowLett (current)
	    ShowEditWindow (font, current)
	    ShowPreviewWindow (font, current)
	end if
	% Arrows to change char
	if key = chr (203) then
	    if current = 32 then
		current := 126
	    else
		current := current - 1
	    end if
	    ShowLett (current)
	    ShowEditWindow (font, current)
	    ShowPreviewWindow (font, current)
	elsif key = chr (205) then
	    if current = 126 then
		current := 32
	    else
		current := current + 1
	    end if
	    ShowLett (current)
	    ShowEditWindow (font, current)
	    ShowPreviewWindow (font, current)
	end if
    end if
    % --------------------
    % Mouse check routines
    % --------------------
    % -Left button-
    if btn = 1 then
	% Change color
	if my > 16 and my < 23 then
	    col := clookup (my, mx)
	    ShowCurColor (col)
	end if
	% Change pixel
	if mx > 1 and mx < 10 and my > 1 and my < 10 then
	    color (col)
	    locate (my, mx)
	    put chr (219) ..
	    font (current, mx - 1, my - 1) := col
	    drawdot (mx + 70, 16 - my + 97, col)
	end if
	% Clear current
	if my = 8 and mx > 12 and mx < 28 then
	    Ask (sure)
	    if sure then
		ClearCurrent (font, current)
		ShowEditWindow (font, current)
		ShowPreviewWindow (font, current)
	    end if
	    sure := false
	end if
	% Clear *ALL*
	if my = 8 and mx > 28 and mx < 38 then
	    Ask (sure)
	    if sure then
		ClearFont (font)
		current := 65
		ShowLett (current)
		ShowEditWindow (font, current)
		ShowPreviewWindow (font, current)
	    end if
	    sure := false
	end if
	% Save the font
	if my = 6 and mx > 22 and mx < 29 then
	    SaveFont (font)
	end if
	% Load a font
	if my = 6 and mx > 12 and mx < 19 then
	    LoadFont (font, current)
	end if
	% Show the entire font
	if my = 10 and mx > 12 and mx < 29 then
	    ShowWholeFont (font)
	    cls
	    DrawBorders
	    ShowTitle
	    ShowLett (current)
	    ShowEditWindow (font, current)
	    ShowColors
	    ShowCurColor (col)
	end if
	% Show help screen
	if my = 6 and mx > 32 and mx < 39 then
	    Help
	    cls
	    DrawBorders
	    ShowTitle
	    ShowLett (current)
	    ShowEditWindow (font, current)
	    ShowColors
	    ShowCurColor (col)
	end if
	% Quit?
	if my = 10 and mx > 31 and mx < 39 then
	    Ask (sure)
	    if sure then
		quitprog := true
	    end if
	    sure := false
	end if
    end if
    % -Right button-
    if btn = 100 then
	if mx > 1 and mx < 10 and my > 1 and my < 10 then
	    col := font (current, mx - 1, my - 1)
	    ShowCurColor (col)
	end if
    end if
    % The quit statement ...
    exit when quitprog
end loop

cls
setscreen ("text")
color (7)
put " Thanks for using the Turing Font Editor!"
put " [ emmzee '97 ]" ..
