%  /~~~~~~~~~~~~~~~~\
% |  Turing 3D Maze  |
%  \________________/

% emmzee '97
% Be afraid. Be very afraid.
% I programmed this is 10 minutes ..... joking! :)
% All routines / graphics are by me, so don't rip 'em.

% Notes:
% var `facing': 0=north 1=south 2=east 3=west

% ============================================================================

% ***********
% *  Setup  *
% ***********

setscreen ("graphics:maxcolor")
setscreen ("nocursor")
setscreen ("noecho")

% Variables
var map : array 1 .. 19, 1 .. 19 of int
var px, py, file, facing, redraw : int := 0
var key : string (1)
var up, down, left, right, dummy : string
redraw := 1

% Constants
up := chr (200)
down := chr (208)
left := chr (203)
right := chr (205)

% ============================================================================

% ***********
% *  Procs  *
% ***********

% Show the funky title screen
proc TitleScreen
    cls
    for t : 16 .. 31
	locate (9, 11)
	color (t)
	put chr (4), " Turing 3D Maze ", chr (4)
	delay (100)
    end for
    delay (1000)
    color (40)
    locate (11, 15)
    dummy := "emmzee '97"
    for p : 1 .. 10
	put dummy (p) ..
	delay (200)
    end for
    delay (900)
    for t : 16 .. 26
	locate (13, 7)
	color (t)
	put "- Press any key to begin -"
	delay (100)
    end for
    dummy := "- Press any key to begin -"
    loop
	for t : 1 .. length (dummy)
	    if hasch then
		exit
	    end if
	    color (30)
	    locate (13, t + 6)
	    put dummy (t) ..
	    delay (1)
	    color (26)
	    locate (13, t + 6)
	    put dummy (t) ..
	end for
	if hasch then
	    exit
	end if
    end loop
    cls
end TitleScreen

% Load the mapfile
proc LoadMap
    open : file, "T3DMAZE.MAP", get
    assert file > 0
    for t : 1 .. 19
	for p : 1 .. 19
	    get : file, map (t, p)
	    if map (t, p) = 2 then
		py := t
		px := p
		map (t, p) := 0
	    end if
	end for
    end for
end LoadMap

% Draw boxes, outline, etc.
proc DrawGeneral
    % Edge
    drawfillbox (58, 70, 258, 199, 216)
    drawbox (58, 70, 258, 199, 15)
    % Middle (blank)
    drawfillbox (138, 120, 178, 149, 18)
    % Size boxes
    % Left (smallest-largest)
    drawfillbox (115, 119, 137, 150, 27)
    drawfillbox (89, 106, 115, 163, 29)
    drawfillbox (58, 89, 88, 180, 31)
    % Right (smallest-largest)
    drawfillbox (179, 119, 200, 150, 27)
    drawfillbox (200, 106, 228, 163, 29)
    drawfillbox (228, 89, 258, 180, 31)
end DrawGeneral

% Small "Plate"
proc SmallPlate
    drawfillbox (138, 119, 178, 150, 27)
    drawline (138, 119, 138, 150, 25)
    drawline (178, 119, 178, 150, 25)
end SmallPlate

% Medium "Plate"
proc MediumPlate
    drawfillbox (116, 106, 199, 163, 29)
    drawline (116, 106, 116, 163, 27)
    drawline (199, 106, 199, 163, 27)
end MediumPlate

% Large "Plate"
proc LargePlate
    drawfillbox (89, 89, 227, 180, 31)
    drawline (89, 89, 89, 180, 29)
    drawline (227, 89, 227, 180, 29)
    % Note: /~ That line fixes a bug ... I'm not sure why I need it, but ...
    drawline (88, 89, 88, 180, 31)
end LargePlate

% Left Large Sidewall
proc LeftLargeSidewall
    drawline (59, 198, 87, 180, 31)
    drawline (59, 198, 59, 72, 31)
    drawline (60, 72, 87, 89, 31)
    drawline (87, 180, 87, 89, 31)
    drawfill (62, 190, 31, 31)
    drawfill (62, 80, 31, 31)
end LeftLargeSidewall

% Left Medium Sidewall
proc LeftMediumSidewall
    drawline (88, 180, 115, 163, 29)
    drawline (88, 180, 88, 90, 29)
    drawline (88, 89, 115, 106, 29)
    drawline (115, 106, 115, 163, 29)
    drawfill (95, 170, 29, 29)
    drawfill (95, 100, 29, 29)
end LeftMediumSidewall

% Left Small Sidewall
proc LeftSmallSidewall
    drawline (116, 163, 137, 150, 27)
    drawline (116, 163, 116, 106, 27)
    drawline (116, 106, 137, 119, 27)
    drawline (137, 120, 137, 150, 27)
    drawfill (120, 155, 27, 27)
    drawfill (120, 110, 27, 27)
end LeftSmallSidewall

% Right Large Sidewall
proc RightLargeSidewall
    drawline (257, 198, 228, 180, 31)
    drawline (257, 198, 257, 71, 31)
    drawline (257, 71, 228, 89, 31)
    drawline (228, 180, 228, 89, 31)
    drawfill (235, 182, 31, 31)
    drawfill (255, 75, 31, 31)
end RightLargeSidewall

% Right Medium Sidewall
proc RightMediumSidewall
    drawline (227, 180, 200, 163, 29)
    drawline (227, 180, 227, 90, 29)
    drawline (227, 89, 200, 106, 29)
    drawline (200, 106, 200, 163, 29)
    drawfill (215, 170, 29, 29)
    drawfill (215, 100, 29, 29)
end RightMediumSidewall

% Right Small Sidewall
proc RightSmallSidewall
    drawline (199, 163, 179, 150, 27)
    drawline (199, 163, 199, 106, 27)
    drawline (199, 106, 179, 119, 27)
    drawline (179, 120, 179, 150, 27)
    drawfill (189, 155, 27, 27)
    drawfill (195, 110, 27, 27)
end RightSmallSidewall

% -- The map-reading routines begin here --

% Check routine for player facing NORTH
proc FacingNorth
    if map (py, px - 1) = 1 then
	LeftLargeSidewall
    end if
    if map (py - 1, px - 1) = 1 then
	LeftMediumSidewall
    end if
    if map (py - 2, px - 1) = 1 then
	LeftSmallSidewall
    end if
    if map (py, px + 1) = 1 then
	RightLargeSidewall
    end if
    if map (py - 1, px + 1) = 1 then
	RightMediumSidewall
    end if
    if map (py - 2, px + 1) = 1 then
	RightSmallSidewall
    end if
    if map (py - 1, px) = 1 then
	LargePlate
    elsif map (py - 2, px) = 1 then
	MediumPlate
    elsif map (py - 3, px) = 1 then
	SmallPlate
    end if
end FacingNorth

% Check routine for player facing SOUTH
proc FacingSouth
    if map (py, px + 1) = 1 then
	LeftLargeSidewall
    end if
    if map (py + 1, px + 1) = 1 then
	LeftMediumSidewall
    end if
    if map (py + 2, px + 1) = 1 then
	LeftSmallSidewall
    end if
    if map (py, px - 1) = 1 then
	RightLargeSidewall
    end if
    if map (py + 1, px - 1) = 1 then
	RightMediumSidewall
    end if
    if map (py + 2, px - 1) = 1 then
	RightSmallSidewall
    end if
    if map (py + 1, px) = 1 then
	LargePlate
    elsif map (py + 2, px) = 1 then
	MediumPlate
    elsif map (py + 3, px) = 1 then
	SmallPlate
    end if
end FacingSouth

% Check routine for player facing EAST
proc FacingEast
    if map (py - 1, px) = 1 then
	LeftLargeSidewall
    end if
    if map (py - 1, px + 1) = 1 then
	LeftMediumSidewall
    end if
    if map (py - 1, px + 2) = 1 then
	LeftSmallSidewall
    end if
    if map (py + 1, px) = 1 then
	RightLargeSidewall
    end if
    if map (py + 1, px + 1) = 1 then
	RightMediumSidewall
    end if
    if map (py + 1, px + 2) = 1 then
	RightSmallSidewall
    end if
    if map (py, px + 1) = 1 then
	LargePlate
    elsif map (py, px + 2) = 1 then
	MediumPlate
    elsif map (py, px + 3) = 1 then
	SmallPlate
    end if
end FacingEast

% Check routine for player facing WEST
proc FacingWest
    if map (py + 1, px) = 1 then
	LeftLargeSidewall
    end if
    if map (py + 1, px - 1) = 1 then
	LeftMediumSidewall
    end if
    if map (py + 1, px - 2) = 1 then
	LeftSmallSidewall
    end if
    if map (py - 1, px) = 1 then
	RightLargeSidewall
    end if
    if map (py - 1, px - 1) = 1 then
	RightMediumSidewall
    end if
    if map (py - 1, px - 2) = 1 then
	RightSmallSidewall
    end if
    if map (py, px - 1) = 1 then
	LargePlate
    elsif map (py, px - 2) = 1 then
	MediumPlate
    elsif map (py, px - 3) = 1 then
	SmallPlate
    end if
end FacingWest

% -- The movement/turning routines begin here --

% Move: Player facing NORTH
proc MoveNorth
    if key = up and map (py - 1, px) = 0 then
	py := py - 1
	redraw := 1
    elsif key = down and map (py + 1, px) = 0 then
	py := py + 1
	redraw := 1
    elsif key = left then
	facing := 3
	redraw := 1
    elsif key = right then
	facing := 2
	redraw := 1
    end if
end MoveNorth

% Move: Player facing SOUTH
proc MoveSouth
    if key = up and map (py + 1, px) = 0 then
	py := py + 1
	redraw := 1
    elsif key = down and map (py - 1, px) = 0 then
	py := py - 1
	redraw := 1
    elsif key = left then
	facing := 2
	redraw := 1
    elsif key = right then
	facing := 3
	redraw := 1
    end if
end MoveSouth

% Move: Player facing EAST
proc MoveEast
    if key = up and map (py, px + 1) = 0 then
	px := px + 1
	redraw := 1
    elsif key = down and map (py, px - 1) = 0 then
	px := px - 1
	redraw := 1
    elsif key = left then
	facing := 0
	redraw := 1
    elsif key = right then
	facing := 1
	redraw := 1
    end if
end MoveEast

% Move: Player facing WEST
proc MoveWest
    if key = up and map (py, px - 1) = 0 then
	px := px - 1
	redraw := 1
    elsif key = down and map (py, px + 1) = 0 then
	px := px + 1
	redraw := 1
    elsif key = left then
	facing := 1
	redraw := 1
    elsif key = right then
	facing := 0
	redraw := 1
    end if
end MoveWest

% Draws the compass! Wow.
proc DrawCompass
    color (6)
    locate (19, 20)
    put chr (24) ..
    locate (20, 19)
    put chr (27), " ", chr (26) ..
    locate (21, 20)
    put chr (25) ..
    color (43)
    if facing = 0 then
	locate (19, 20)
	put chr (24) ..
	locate (20, 20)
	put "N" ..
    elsif facing = 1 then
	locate (21, 20)
	put chr (25) ..
	locate (20, 20)
	put "S" ..
    elsif facing = 2 then
	locate (20, 21)
	put chr (26) ..
	locate (20, 20)
	put "E" ..
    elsif facing = 3 then
	locate (20, 19)
	put chr (27) ..
	locate (20, 20)
	put "W" ..
    end if
end DrawCompass

% ============================================================================

% *************************
% *  Main program begins  *
% *************************

TitleScreen
LoadMap
locate (23, 7)
color (32)
put "Turing 3D Maze" ..
color (34)
put " - " ..
color (35)
put "emmzee '97"
key := ""

loop
    % This `if' runs a different proc depending on which dir the
    % player is facing
    if redraw = 1 then
	DrawGeneral
	DrawCompass
	if facing = 0 then
	    FacingNorth
	elsif facing = 1 then
	    FacingSouth
	elsif facing = 2 then
	    FacingEast
	else
	    FacingWest
	end if
    end if
    locate (20, 1)
    loop
	getch (key)
	exit when key = "q" or key = "Q"
	% These 4 lines check if the arrow keys are pressed
	exit when key = up
	exit when key = down
	exit when key = left
	exit when key = right
	% It only updates when the player moves/turns
    end loop
    exit when key = "q" or key = "Q"
    % These branch off to the move/turn routines, again depending on
    % which dir the player is facing
    redraw := 0
    if facing = 0 then
	MoveNorth
    elsif facing = 1 then
	MoveSouth
    elsif facing = 2 then
	MoveEast
    elsif facing = 3 then
	MoveWest
    end if
end loop

% End routine
cls
for t : 33 .. 100
    locate (7, 5)
    color (t)
    put "Thank you for playing this game"
    locate (8, 9)
    color (t + 1)
    put "Written by: emmzee '97"
    delay (100)
end for
delay (1000)
dummy := "-= Press Enter to end =-"
locate (10, 8)
for t : 20 .. 31
    color (t)
    put dummy (t - 19) ..
end for
dummy := "-= dne ot retnE sserP =-"
for decreasing t : 31 .. 20
    color (t)
    put dummy (t - 19) ..
end for
color (0)
