%****************************************************************************************************************************************
%* PROGRAMMER: PETER FRISELLA                                                                                                             *
%* FILENAME: GAME.T                                                                                                                       *
%* ASSIGNMENT: YEAR END PROJECT                                                                                                           *
%* DESCRIPTION:  THE SIMON GAME- A SQUARE IS DISPLAYED BY THE COMPUTER, THE USER WILL REPEAT THAT SQUARE, THEN THE COMPUTER WILL          *
%* DISPLAY TWO SQUARE INCLUDEING THE FIRST SQUARE IT CHOSE AGAIN. THEN THE USER WILL HAVE TO REPEAT THOSE TWO SQUARES IN THE SAME ORDER. *
%* THEN THREE SQUARE ARE DISPLAYED INCLUDING THE TWO SQUARE FROM BEFORE AND THE USER MUST REPEAT THOSE THREE AND SO ON UNTIL             *
%* THE USER MAKES A MISTAKE. IF THE USER GET'S A HIGHSCORE HIS/HER NAME WILL BE ASKED FOR, TO BE PUT IN THE 'HALL OF FAME'               *
%------DOCUMENTATION NOTE!---------------------
%on most code the documentation follows the code.
%*****************************************************************************************************************************************
include "C:\mike\nhl\scrnfl2.t"
var flag : int := 0
% Determines whether the user's game is over 0 is clear, 1 is loss

%******************************************
%*      HALL OF FAME PROCEDURE            *
%******************************************
procedure HallOfFame (var score : int)
    var famescore : array 1 .. 10 of int
    %variable to hole the current hall of fame scores

    var famename : array 1 .. 10 of string (30)
    %variable to hold the names of the current hall of famers

    var highflag, filenum, counttemp, tempscore : int := 0
    %highflag becomes 1 if player has a high score

    var highname, tempname : string (30)
    open : filenum, "hallfame.apr", get
    %open's hall of fame file to get information

    assert filenum > 0
    %for loop to read in names in scores of current hall of famers
    for counter : 1 .. 10
	get : filenum, famescore (counter)
	get : filenum, famename (counter) : *
    end for
    close : filenum
    filenum := 0
    highflag := 0 %sets flag for a high score to 0
    cls
    %for loop compares player's score to hall of fame scores
    for counter : 1 .. 10
	if score >= famescore (counter) then
	    FileToScreen (0, 115, "high.tm2")
	    %displays 'You Got A High Score'
	    color (10)
	    locate (25, 1)
	    put "Your Score: ", score
	    locate (26, 1)
	    put "Please Enter Your Name: " ..
	    get highname : * %get's players name for the hall of fame
	    counttemp := counter
	    %keeps track of number the player will be put into hall of fame
	    tempscore := famescore (counter)
	    %places score from famehall into temp variable
	    tempname := famename (counter)
	    %places name from famehall into temp variable
	    famescore (counter) := score
	    %replaces score from famehall with player score
	    famename (counter) := highname
	    %replaces name from famehall with player name
	    highflag := 1 %value of one means player has a high score
	    exit
	end if
    end for
    %opens hall of fame file to input information
    if highflag = 1 then %and counttemp not= 10 then
	open : filenum, "hallfame.apr", put
	assert filenum > 0
	for count : 1 .. counttemp - 1
	    put : filenum, famescore (count)
	    put : filenum, famename (count)
	end for
	put : filenum, famescore (counttemp)
	put : filenum, famename (counttemp)
	if counttemp not= 10 then
	    for count : counttemp + 1 .. 10
		put : filenum, famescore (count)
		put : filenum, famename (count)
	    end for
	end if
	close : filenum %close hall of fame file
    end if

end HallOfFame
%*****************************************
%*****************************************
%*       USER CHOICE PROCEDURE           *
%*****************************************
%procedure to allow user to atttempt to repeat the squares that have been already shown by procedure display
procedure choice (var pattern : array 1 .. * of int, highest_square :
	int,
	squaresound : string (3))
    %Variable highest_square is how many squares the user has to repeat. It is variable current_square from the main program
    mouseshow %show mouse to allow choice of square
    var score, x, y, btn, btnupdown, choice, current_square, clockstart,
	currentclock : int := 0
    %score-keeps score,x-x coordinate,y-y coordinate,btn-which button pressed,btnupdown-value for button pressed or released
    %choice-keeps which square user chose,current_square-is how many squares the user has done
    flag := 0
    loop
	clock (clockstart)
	current_square := current_square + 1
	%increase how many squares the user has chosen correctly by 1 each pass
	loop
	    %loop
	    %    clock (currentclock)
	    %    if buttonmoved ("down") = true then
	    %        exit
	    %    end if
	    %    if currentclock - clockstart > 5000 then
	    %        flag := 1
	    %        exit
	    %    end if
	    %end loop
	    %if flag not= 1 then
	    %    mousewhere (x, y, btn)
	    %end if
	    buttonwait ("down", x, y, btn, btnupdown)
	    %waits for button to be clicked to make a choice, keeps coordinates
	    %wait for user to make a choice
	    %Square Legend: 1-Blue,2-Green,3-Cyan,4-Red,5-Purple,7-Grey
	    if x >= 210 and x <= 300 and y >= 310 and y <= 400 then
		%if square 1 (blue) was chosen then
		choice := 1 %store the square number in choice
		drawfillbox (210, 400, 300, 310, 9)
		%changes color of box to lighter blue
		if squaresound = "ON" then %if sound on then play else don't
		    play ("a")
		end if
		delay (400) %wait a secon until switching back color
		drawfillbox (210, 400, 300, 310, 1)
		%switch back color of box 1 to dark blue
		exit %exit the loop
	    elsif x >= 310 and x <= 400 and y >= 310 and y <= 400 then
		%if box 2(green) is chosen then
		choice := 2 %store box number in choice
		drawfillbox (310, 400, 400, 310, 10)
		%change color of box 2 to light green
		if squaresound = "ON" then
		    %if sound is on then play else don't
		    play ("b")
		end if
		delay (400)
		drawfillbox (310, 400, 400, 310, 2)
		%change color back to dark red
		exit %exit loop
	    elsif x >= 210 and x <= 300 and y >= 210 and y <= 300 then
		choice := 3
		drawfillbox (210, 300, 300, 210, 11)
		if squaresound = "ON" then
		    play ("c")
		end if
		delay (400)
		drawfillbox (210, 300, 300, 210, 3)
		exit
	    elsif x >= 310 and x <= 400 and y >= 210 and y <= 300 then
		choice := 4
		drawfillbox (310, 300, 400, 210, 12)
		if squaresound = "ON" then
		    play ("d")
		end if
		delay (400)
		drawfillbox (310, 300, 400, 210, 4)
		exit
	    elsif x >= 210 and x <= 300 and y >= 110 and y <= 200 then
		choice := 5
		drawfillbox (210, 200, 300, 110, 13)
		if squaresound = "ON" then
		    play ("e")
		end if
		delay (400)
		drawfillbox (210, 200, 300, 110, 5)
		exit
	    elsif x >= 310 and x <= 400 and y >= 110 and y <= 200 then
		choice := 6
		drawfillbox (310, 200, 400, 110, 15)
		if squaresound = "ON" then
		    play ("f")
		end if
		delay (400)
		drawfillbox (310, 200, 400, 110, 7)
		exit
	    elsif flag = 1 then
		exit
	    end if
	end loop
	if choice not= pattern (current_square) then
	    %if square user chose is not correct then
	    flag := 1 %set flag to 1 meaning user has chosen incorrectly
	end if
	exit when flag = 1 or current_square = highest_square
	%exit procedure if flag is 1 meaning an incorrect choice or
	%when the user has chosen all correctly and the current_square is the same as the highest_square the game is currently at.
    end loop
end choice

%**************************************************
%            SQUARE DISPLAY PROCEDURE             *
%**************************************************
procedure display (var pattern : array 1 .. * of int, highest_square,
	speed
	: int, squaresound : string (3))
    mousehide %hide the mouse
    var current_square : int := 0
    %current_square is the square the computer has to currently show according to the square pattern
    %highest_square is the currently highest_sqaure the game has reached according to how many choices the user has correctly made
    flag := 0 %set flag to zero to clear an incorrect choice
    loop
	current_square := current_square + 1
	%increases the current square the computer has to display by one
	delay (speed) %delay between switching of colors of squares
	case pattern (current_square) of
		%label depends on what square number is stored at pattern(x)
	    label 1 : %if square 1 then
		drawfillbox (210, 400, 300, 310, 9)
		%change square color to lighter color
		if squaresound = "ON" then %if sound on then play else don't
		    play ("a")
		end if
		delay (speed) %delay between switching colors
		drawfillbox (210, 400, 300, 310, 1)
		%switch color back to darker one
	    label 2 :
		drawfillbox (310, 400, 400, 310, 10)
		if squaresound = "ON" then
		    play ("b")
		end if
		delay (speed)
		drawfillbox (310, 400, 400, 310, 2)
	    label 3 :
		drawfillbox (210, 300, 300, 210, 11)
		if squaresound = "ON" then
		    play ("c")
		end if
		delay (speed)
		drawfillbox (210, 300, 300, 210, 3)
	    label 4 :
		drawfillbox (310, 300, 400, 210, 12)
		if squaresound = "ON" then
		    play ("d")
		end if
		delay (speed)
		drawfillbox (310, 300, 400, 210, 4)
	    label 5 :
		drawfillbox (210, 200, 300, 110, 13)
		if squaresound = "ON" then
		    play ("e")
		end if
		delay (speed)
		drawfillbox (210, 200, 300, 110, 5)
	    label 6 :
		drawfillbox (310, 200, 400, 110, 15)
		if squaresound = "ON" then
		    play ("f")
		end if
		delay (speed)
		drawfillbox (310, 200, 400, 110, 7)
	end case
	exit when current_square = highest_square
	%exit when the current_square the computer displayed is as the same as the highest_game the user has reached to.
    end loop
end display
%**************************************************
%**************************************************
%                   MAIN PROGRAM                  *
%**************************************************
%***
setscreen ("graphics:vga,nocursor")
var squaresound : string (3) := "ON"
%variable to control whether sound will be on or off
loop
    flag := 0
    %clears flag. A value of 1 means player made a mistake in game.
    var choose : string (1) %is the total length of the pattern
    cls
    %MENU START
    FileToScreen (0, 0, "menu.tm2")
    %put menu picture on screen (file: menu.tm2)
    locate (14, 44) %location for the 'ON' and 'OFF' for sound
    color (4) %changes color to red
    put squaresound %puts the status of sound. either 'ON' or 'OFF'
    color (7) %changes color back to white
    getch (choose) %get players choice from options on menu
    case choose of
	    %*****%If user Chooses 'Play Game' which is option 1*****************
	label "1" :
	    cls
	    locate (12, 30)
	    put "HIT ANY KET TO START"
	    var key_to_start : string (1)
	    %variable for getch to accept key from keyboard to start
	    getch (key_to_start) %wait's for an input from user to start game
	    cls
	    color (2)
	    locate (1, 1)
	    put "Squares Done:"
	    %*****
	    %DRAWING OF SQUARES
	    %Initialize Boxes For First View
	    drawfillbox (210, 400, 300, 310, 1) %top left square 1(Blue)
	    drawfillbox (310, 400, 400, 310, 2) %top right square 2(Green)

	    drawfillbox (210, 300, 300, 210, 3) %middle left square 3(Cyan)
	    drawfillbox (310, 300, 400, 210, 4) %middle right square 4(Red)

	    drawfillbox (210, 200, 300, 110, 5) %bottom left square 5(Purple)
	    drawfillbox (310, 200, 400, 110, 7) %bottom right square 6(Grey)

	    %pattern = array to hold all the square numbers for the current game (the pattern)
	    var pattern : array 1 .. 100 of int
	    var current_square, speed : int := 0
	    %current_square is the square which the game is currently on going from 1 - 100
	    %speed- is the speed at which the square should be displayed
	    %for loop generates 100 square numbers represented by the numbers 1-6 and stores in array pattern
	    randomize
	    for x : 1 .. 100
		randint (pattern (x), 1, 6)
	    end for
	    speed := 400 %set sqaure display speed at 400
	    loop
		current_square := current_square + 1
		%increases game to next square in variable pattern
		%the if statements increase speed of game according to how many squares(current_square) the user had guessed correctly.
		if speed > 20 then
		    %if speed is not less then 20 the decrease speed
		    if current_square >= 3 and current_square <= 5 then
			speed := (speed - 7)
		    elsif current_square >= 5 and current_square <= 8 then
			speed := (speed - 7)
		    elsif current_square >= 8 and current_square <= 11 then
			speed := (speed - 7)
		    elsif current_square >= 11 and current_square <= 14 then
			speed := (speed - 7)
		    elsif current_square >= 14 and current_square <= 17 then
			speed := (speed - 7)
		    elsif current_square > 18 then
			speed := speed - 3
		    end if
		else %else keep speed at 20
		    speed := 20
		end if

		%procedure to display squares
		display (pattern, current_square, speed, squaresound)

		%procedure to let user choose squares
		choice (pattern, current_square, squaresound)

		if flag = 1 then
		    %when flag is 1 then user has made a mistake and game will end
		    cls
		    color (2) %change color to green
		    locate (12, 33)
		    put "INCORRECT"
		    if squaresound = "ON" then %if sound in on the play
			play ("ge4")
		    end if
		    delay (250) %wait a second
		    %for loop to cause game over to flash
		    for s : 1 .. 5
			for k : 1 .. maxcolor
			    color (k)
			    locate (11, 33)
			    put "GAME OVER"
			    locate (12, 33)
			    put "GAME OVER"
			    locate (13, 33)
			    put "GAME OVER"
			end for
		    end for
		    current_square := (current_square - 1)
		    %take away 1 from current square count sine user never reached that high since mistake was on that turn
		    %Hall Of Fame Procedure to decide whether the score was high or not
		    HallOfFame (current_square)
		    exit %exit game loop which will go to main menu
		end if
		delay (500)
		%plays a beep to signal to user that he/she rpeated all square correctly
		if squaresound = "ON" then %if sound on the play
		    play ("8>a<4")
		end if
		delay (500)
		locate (1, 15)
		put current_square
		%update screen how many squares have been repeated correctly
	    end loop

	    %*******If user chooses 'View Hall of Fame' which is option 2********************
	label "2" :

	    var score, filenum : int := 0
	    %score of player, and file number
	    var name : string (25) %Name of Player
	    cls
	    FileToScreen (160, 430, "fame.tm2")
	    %Displays Hall Of Fame Header
	    FileToScreen (20, 200, "trophy.tm2")
	    %Display Left side trophy
	    color (2)
	    locate (6, 26)
	    put "NAME"
	    locate (7, 22)
	    put "-----------------------------------"
	    locate (6, 51)
	    put "SCORE"
	    open : filenum, "hallfame.apr", get %opens Hall of fame file
	    for getfame : 1 .. 10
		get : filenum, score
		%gets score from file and stores in var score
		get : filenum, name : *
		%gets name from file and stores in var name
		locate (8 + getfame, 22)
		put getfame, ".  ", name : 5
		locate (8 + getfame, 51)
		put score : 5
	    end for
	    FileToScreen (500, 200, "trophy.tm2")
	    %Displays trophy on right side
	    close : filenum
	    filenum := 0 %resets file number
	    loop
		exit when hasch
		%Waits until user hit's a key to continue to main menu
	    end loop

	    %if user chooses 'Exit'
	    %*********%if user chooses 'Sound' which is option 3***********
	label "3" :
	    %if sound is on then turn it off and vice versa
	    if squaresound = "ON" then
		squaresound := "OFF"
	    else
		squaresound := "ON"
	    end if
	label "4" :
	    cls
	    color (10)
	    put " How To Play Simon:"
	    put "--------------------"
	    color (2)
	    put "The game SIMON goes as follows: "
	    put ""
	    put "-There are six different squares.Each different colors."
	    put ""
	    put "-To start off, one square will light up"
	    put " and then the mouse will appear."
	    put ""
	    put "-You must click on the one square you saw."
	    put ""
	    put "-If you choose the correct square which was"
	    put " displayed the game will beep, and will continue on."
	    put ""
	    put "-Then two squares will light up consecutively,"
	    put " including the first square which was displayed beforehand."
	    put ""
	    put "-You must then click those two squares in the same order,"
	    put " and if you correctly choose the two you will continue on."
	    put ""
	    put "-The game will continue in this fashion going on to"
	    put " three squares, then four and so on."
	    put ""
	    put "-If you make an error your game will be over. If you have"
	    put " a High Score then you will be asked for your name and you"
	    put " will be put in the Hall of Fame."
	    loop
		exit when hasch
	    end loop
	label "5" : %if user chooses 'Exit Game' which is option 4
	    exit %Exit program
	label :
    end case
end loop
%**************************************************
