var pic_x1, pic_y1, pic_x2, pic_y2 : int
var lwr, uppr, right, left : array 1 .. 800 of int
var messageBuffer : array 1 .. 4000 of int
var version : int
var bufferSize : int
var paletteUsed : int
var numColours : int := 0
var red, green, blue : array 1 .. 256 of int
var screenWidth, screenHeight, screenColors : int
var screenMode : string (11)
var pictureBorderColour : int
var cropperBorderColour : int
var mouseCursorColour : int
var fln, textColour : int
var filename : string
put "input the filename"
get filename
procedure DrawThickBox (restore : boolean, ox1, oy1, ox2, oy2, clr : int)
    const x1 : int := min (ox1, ox2)
    const y1 : int := min (oy1, oy2)
    const x2 : int := max (ox1, ox2)
    const y2 : int := max (oy1, oy2)
    if restore then
	drawpic (x1 - 3, y1 - 3, lwr, 0)
	drawpic (x1 - 3, y2 + 1, uppr, 0)
	drawpic (x1 - 3, y1, left, 0)
	drawpic (x2 + 1, y1, right, 0)
    else
	takepic (x1 - 3, y1 - 3, x2 + 3, y1 - 1, lwr)
	takepic (x1 - 3, y2 + 1, x2 + 3, y2 + 3, uppr)
	takepic (x1 - 3, y1, x1 - 1, y2, left)
	takepic (x2 + 1, y1, x2 + 3, y2, right)
	drawbox (x1 - 1, y1 - 1, x2 + 1, y2 + 1, clr)
	drawbox (x1 - 2, y1 - 2, x2 + 2, y2 + 2, clr)
	drawbox (x1 - 3, y1 - 3, x2 + 3, y2 + 3, clr)
    end if
end DrawThickBox


function GetClosestColour (r, g, b : int) : int
    var closestColour : int
    var distance, closestMatch : int := 2000000000
    for cnt : 1 .. numColours
	distance := (r - red (cnt)) ** 2 + (g - green (cnt)) ** 2 +
	    (b - blue (cnt)) ** 2
	if distance < closestMatch then
	    closestColour := cnt - 1
	    closestMatch := distance
	end if
    end for
    result closestColour
end GetClosestColour


procedure DetermineTheColoursUsed
    if numColours = 0 then
	pictureBorderColour := 12
	cropperBorderColour := 11
	mouseCursorColour := 13
	textColour := 15
    else
	pictureBorderColour := GetClosestColour (255, 85, 85)
	cropperBorderColour := GetClosestColour (85, 255, 255)
	mouseCursorColour := GetClosestColour (85, 255, 85)
	textColour := GetClosestColour (255, 255, 255)
    end if
end DetermineTheColoursUsed


function GetLine (row, col : int) : string
    var line : string := ""
    var charNum : int := 0

    locate (row, col)
    var ch : string (1)
    loop
	getch (ch)
	if ord (ch) = 27 then
	    result ""
	end if
	exit when ord (ch) = 10
	if " " <= ch and ch <= "~" then
	    if col + charNum < maxcol then
		line += ch
		charNum += 1
		put ch ..
	    end if
	end if
	if ord (ch) = 8 then
	    if charNum > 0 then
		locate (row, col + charNum - 1)
		line := line (1 .. charNum - 1)
		charNum -= 1
		put " " ..
		locate (row, col + charNum)
	    end if
	end if
    end loop
    result line
end GetLine
procedure PlaceInLimits (var x, y : int)
    if x < pic_x1 then
	x := pic_x1
    end if
    if x > pic_x2 then
	x := pic_x2
    end if
    if y < pic_y1 then
	y := pic_y1
    end if
    if y > pic_y2 then
	y := pic_y2
    end if
end PlaceInLimits

function WaitForButtonPush : boolean
    var x, y, lastx, lasty, btn : int
    var quitting : boolean := false

    setscreen ("xor")

    mousewhere (lastx, lasty, btn)
    drawline (lastx - 5, lasty, lastx + 5, lasty, mouseCursorColour)
    drawline (lastx, lasty - 5, lastx, lasty + 5, mouseCursorColour)

    loop
	if hasch then
	    var ch : string (1)
	    getch (ch)
	    if ch = "Q" or ch = "q" then
		quitting := true
		exit
	    end if
	end if

	exit when buttonmoved ("down")
	mousewhere (x, y, btn)
	if (x not= lastx) or (y not= lasty) then
	    drawline (lastx - 5, lasty, lastx + 5, lasty, mouseCursorColour)
	    drawline (lastx, lasty - 5, lastx, lasty + 5, mouseCursorColour)

	    lastx := x
	    lasty := y
	    drawline (lastx - 5, lasty, lastx + 5, lasty, mouseCursorColour)
	    drawline (lastx, lasty - 5, lastx, lasty + 5, mouseCursorColour)
	end if
    end loop

    drawline (lastx - 5, lasty, lastx + 5, lasty, mouseCursorColour)
    drawline (lastx, lasty - 5, lastx, lasty + 5, mouseCursorColour)

    setscreen ("noxor")

    result quitting
end WaitForButtonPush


procedure MyFileToScreen (fileName : string)
    var xSize, ySize : int % The size of the picture
    var fs : int % The file stream of the file

    open : fs, fileName, read
    if fs <= 0 then
	put "Unable to open file \"", fileName, "\" for reading."
	return
    end if
    read : fs, version
    if version not= 4661 then
	put "\"", fileName, "\" is not a legal TM2 file!"
	close : fs
	return
    end if

    read : fs, bufferSize

    read : fs, xSize, ySize

    read : fs, screenWidth, screenHeight, screenColors, screenMode

    setscreen ("graphics:" + screenMode)
    pic_x1 := (screenWidth - xSize) div 2
    pic_y1 := 2 * (screenHeight - ySize) div 3
    pic_x2 := pic_x1 + xSize - 1
    pic_y2 := pic_y1 + ySize - 1

    read : fs, paletteUsed
    if paletteUsed = 1 then
	read : fs, numColours
	if maxcolour not= numColours - 1 then
	    put "The image contains a palette with ", numColours
	    put "colours, while the current graphics mode supports "
	    put maxcolour + 1, " colours.  You are probably in a"
	    put "different graphics mode from the one that this"
	    put "picture was created in."
	    close : fs
	    return
	end if

	for cnt : 1 .. numColours
	    read : fs, red (cnt), green (cnt), blue (cnt)
	end for

	% Change the colour map
	setcolourmap (red, green, blue, numColours)
    end if

    /************************************************************************/
    /*                          Display the Picture!                        */
    /************************************************************************/
    % The picture has been saved in chunks of "buffersize" integers.
    % We declare the picture buffer here.
    var pic : array 1 .. bufferSize of int
    var bytesToRead, bytesRead : int % This is used to determine how many
    % bytes to read and whether the read
    % succeeded
    var currentY : int % Each chunk must be displayed at its
    % particular Y location starting from
    % the top of the image.
    currentY := ySize + pic_y1
    loop
	exit when eof (fs)
	read : fs, bytesToRead
	read : fs, pic : bytesToRead : bytesRead
	if bytesToRead not= bytesRead then
	    put "\"", fileName, "\" ended in the middle of an image.  This"
	    put "probably means the image was damaged."
	    return
	end if
	currentY -= pic (1) + 1 % Adjust the current Y location
	drawpic (pic_x1, currentY, pic, 0) % Draw this chunk to the screen
    end loop
    close : fs
end MyFileToScreen
%if textColour=19746 then
/****************************************************************************/
/* ScreenToFile: Procedure to save a portion of the screen to a "TM2" file  */
/****************************************************************************/
procedure MyScreenToFile (x1, y1, x2, y2 : int, fileName : string)
    var xSize, ySize : int % The size of the picture
    var fs : int % The file stream of the file

    % Create the file and return an error message if it failed.
    open : fs, fileName, write
    if fs <= 0 then
	put "Unable to creat file \"", fileName, "\"."
	return
    end if

    % Write the version number (assigned when picture read in)
    write : fs, version

    % Write the size of the picture buffer (assigned when picture read in)
    write : fs, bufferSize

    % Write the size of the picture
    xSize := abs (x2 - x1) + 1
    ySize := abs (y2 - y1) + 1
    write : fs, xSize, ySize

    % Read information about the screen (size, number of colors, mode)
    % (assigned when picture read in)
    write : fs, screenWidth, screenHeight, screenColors, screenMode

    % Write out whether a palette is used (size, number of colors, mode)
    write : fs, paletteUsed

    % If there's a palette, write it out
    if paletteUsed = 1 then
	write : fs, numColours

	for cnt : 1 .. numColours
	    write : fs, red (cnt), green (cnt), blue (cnt)
	end for
    end if

    /************************************************************************/
    /*                          Save the Picture!                           */
    /************************************************************************/
    % The picture has to be saved in chunks of "actualBufferSize" integers.
    % We declare the picture buffer here.
    var pic : array 1 .. bufferSize of int
    var bytesToWrite, bytesWritten : int % This is used to determine how
    % many bytes to write and whether
    % the write succeeded
    var currentY : int % Each chunk must be displayed at
    % its particular Y location
    % starting from the top.
    var numRowsInChunk : int % This is the number of rows that
    % fit into a single chunk.
    const topRow := max (y1, y2) % The top row in the picture
    const bottomRow := min (y1, y2) % The bottom row in the picture

    numRowsInChunk := (bufferSize - 3) div sizepic (x1, 1, x2, 1)
    currentY := topRow + 1
    loop
	% Exit if the rest of the picture fits into a chunk.
	exit when currentY - numRowsInChunk <= bottomRow

	currentY -= numRowsInChunk % Adjust the current Y location

	% Load the chunk with the image
	takepic (x1, currentY, x2, currentY + numRowsInChunk - 1, pic)

	% picSize = number of bytes in the current chunk
	bytesToWrite := sizepic (x1, 0, x2, numRowsInChunk - 1) * 4

	% A chunk is the number of bytes followed by the image portion
	write : fs, bytesToWrite
	write : fs, pic : bytesToWrite
    end loop

    % Load the chunk with the image
    takepic (x1, bottomRow, x2, currentY - 1, pic)

    % bytesToWrite = number of bytes in the current chunk
    bytesToWrite := sizepic (x1, bottomRow, x2, currentY - 1) * 4

    % A chunk is the number of bytes followed by the image portion
    write : fs, bytesToWrite
    write : fs, pic : bytesToWrite

    close : fs
end MyScreenToFile

%
% Main Program
%

% Read in the filename (adding .TM2 if necessary)
var fileName : string
put "Enter the name of the TM2 file to load: " ..
get fileName
if index (fileName, ".") = 0 then
    fileName += ".TM2"
end if

% Read in and display the file
MyFileToScreen (fileName)

% Determine the colours to be used
DetermineTheColoursUsed

% Set the text colour to bright white
colour (textColour)

% Draw a border around the picture


DrawThickBox (false, pic_x1, pic_y1, pic_x2, pic_y2, pictureBorderColour)

setscreen ("noecho")
var origx, origy, lastx, lasty, x, y, btn, b2 : int
loop
    exit when WaitForButtonPush
    buttonwait ("down", origx, origy, btn, b2)
    PlaceInLimits (origx, origy)
    x := origx
    y := origy
    lastx := origx
    lasty := origy

    % Draw new box
    DrawThickBox (false, origx, origy, x, y, cropperBorderColour)


    color (12)
    %    setscreen ("graphics:" + screenMode)
    put screenMode
    drawbox (266, 343, 377, 268, 12)
    var aq : array 1 .. sizepic (263, 291, 374, 215) of int

    takepic (266, 343, 377, 268, aq)
    open : fln, filename, put
    for j : 1 .. sizepic (267, 290, 376, 216)
	locate (15, 36)
	color (12)
	put "SAVING"
	put : fln, aq (j)
    end for
    close : fln

    %include"aqfr.t"


    loop
	exit when btn = 0
	if (x not= lastx) or (y not= lasty) then
	    % Erase previous box
	    DrawThickBox (true, origx, origy, lastx, lasty,
		cropperBorderColour)

	    % Draw new box
	    DrawThickBox (false, origx, origy, x, y, cropperBorderColour)

	    lastx := x
	    lasty := y
	end if
	mousewhere (x, y, btn)
	PlaceInLimits (x, y)
    end loop

    const charHeight : int := (maxy + 1) div maxrow



    takepic (0, maxy - ( (maxrow - 1) * charHeight), maxx, maxy - (maxrow *
	charHeight) + 1,
	messageBuffer)
    locate (maxrow, 1)
    put
	"Press ENTER to save the cropped image, Q to quit, anything else to continue "
	..
    var ch : string (1)
    getch (ch)
    % Erase the message
    drawpic (0, maxy - (maxrow * charHeight) + 1, messageBuffer, 0)
    exit when ch = "Q" or ch = "q"
    if ord (ch) = 10 then
	% Get the file name
	var croppedFileName : string
	locate (maxrow, 1)
	put "  Enter filename to save cropped image as: " ..
	croppedFileName := GetLine (maxrow, 44)
	if index (croppedFileName, ".") = 0 then
	    croppedFileName += ".TM2"
	end if

	% Erase the message
	drawpic (0, maxy - (maxrow * charHeight) + 1, messageBuffer, 0)

	% Save the cropped image
	if fileName not= "" then
	    MyScreenToFile (origx, origy, lastx, lasty, croppedFileName)
	    locate (1, 1)
	    put "Cropped image saved as ", croppedFileName
	    exit
	end if
    end if
    % Erase previous box
    DrawThickBox (true, origx, origy, lastx, lasty, cropperBorderColour)
end loop

locate (1, 1)
%end if
