%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*                     Chris's Paintbrush Ver. 8.0                          */
/*                                                                          */
/* Created by: Chris Woodford                                               */
/* Date begun: June 20/98                                                   */
/* Date Finished:                                                           */
/*                                                                          */
/*                                                                          */
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* procedures */

procedure writehelpfile

    var z : int

    open : z, "ins.hlp", put
    assert z > 0

    put : z, "Welcome to Chris's Paint Ver. 8.0"
    put : z, "1. Click the left mouse on any shape or colour."
    put : z, "2. Then use the left mouse button to draw."
    put : z,
	"3. If you would like to erase what you did, just click on the box"
    put : z,
	"with the red E in it, then use the left mouse button to erase."
    put : z,
	"4. If you would like to change the background color then just"
    put : z,
	"left click on the colour you would like and then right click"
    put : z,
	"in the paint area."
    put : z, "See its as easy as that!!"
    put : z,
	"Press both mouse buttons at once at anytime to quit"
    put : z, "I hope you enjoy Chris's Paint!"
    put : z, "Chris Woodford:1998 e-mail: merlin31@hotmail.com"

    close : z

end writehelpfile

procedure openhelpfile

    setscreen ("nocursor")

    var z : int := 0
    var help : string := ""
    var ch : string (1) := " "

    colorback (0)
    color (15)

    open : z, "ins.hlp", get
    assert z > 0

    loop

	exit when eof (z)

	get : z, help
	put help, " " ..

	if help = "colour." or help = "draw." or help =
		"erase." or help = "that!!" or help = "Woodford:1998" then
	    put " "
	elsif help = "8.0" or help = "area." or help = "quit" or
		help = "Paint!" then
	    put " "
	    put " "
	end if

    end loop

    close : z

    put " "
    put " "
    put "Press Any Key To Continue"

    loop
	getch (ch)
	exit
    end loop

end openhelpfile

procedure colour_pallette

    for a : 1 .. 15
	drawfillbox (595, 488 - 30 * a, maxx - 5, 455 - 30 * a, a)
    end for

    drawfillbox (595, 10, maxx - 5, 5, 0)

end colour_pallette

procedure outer_boxes

    drawbox (1, 1, 590, maxy, 15)
    drawbox (1, 1, 590, 40, 15)
    drawline (1, 460, maxx, 460, 15)

end outer_boxes

procedure bottom_boxes

    var b : int := 1
    var c : int := 60

    loop

	b := c
	c := c + 59
	exit when c >= 590
	drawbox (b, 1, c, 40, 15)

    end loop

end bottom_boxes

procedure left_boxes

    var b : int
    var c : int := 40

    loop

	b := c
	c := c + 39
	exit when c >= 460
	drawbox (1, b, 60, c, 15)

    end loop

    drawline (60, 400, 60, 460, 15)

end left_boxes

procedure menu

    drawfillbox (2, 461, maxx - 1, maxy - 1, 7)

    locatexy (30, 480)
    colour (15)
    put "F" ..
    colour (7)
    put "ile" ..

    locatexy (115, 480)
    colour (15)
    put "E" ..
    colour (7)
    put "dit" ..

    locatexy (200, 480)
    colour (4)
    put "H" ..
    colour (7)
    put "elp" ..

end menu

procedure draw_shapes

    drawfillarc (29, 15, 14, 14, 0, 180, 15)
    drawfillstar (75, 10, 105, 35, 15)
    drawfillmapleleaf (133, 8, 163, 35, 15)
    drawfilloval (206, 20, 14, 14, 15)
    drawfillbox (250, 9, 280, 33, 15)

end draw_shapes

procedure left_shapes

    var randy, randx : int := 0

    drawarc (29, 55, 13, 13, 0, 180, 15)
    drawstar (15, 87, 43, 112, 15)
    drawmapleleaf (15, 123, 43, 151, 15)
    drawoval (29, 177, 14, 14, 15)
    drawbox (15, 202, 43, 228, 15)

    for a : 1 .. 15
	randint (randx, 5, 55)
	randint (randy, 240, 270)
	drawdot (randx, randy, 15)
    end for

    drawline (10, 295, 48, 295, 15)
    drawline (10, 340, 27, 325, 15)
    drawline (27, 325, 48, 340, 15)

end left_shapes

procedure set_colour (x, y, btn : int, var clr : int)

    for a : 1 .. 15

	if btn = 1 and y <= 488 - 30 * a and y > 455 - 30 * a and x >=
		595 then
	    clr := a
	end if

    end for

end set_colour

procedure set_shape (x, y, btn : int, var shape : int)

    var b : int := 1
    var c : int := 60

    for a : 1 .. 10

	if btn = 1 and x >= b and x < c and y < 40 then
	    shape := a
	end if

	b := c
	c := c + 59

	exit when x >= 595

    end for

    b := 40
    c := 79

    for a : 11 .. 18

	if btn = 1 and y >= b and y < c and x < 60 then
	    shape := a
	end if

	b := c
	c := c + 39

    end for

end set_shape

procedure file_down (var new_game, exit_game : boolean)

    var x, y, btn : int := 0
    exit_game := false
    new_game := false

    drawbox (30, 460, 130, 310, 4)
    drawfill (50, 350, 7, 4)

    colour (15)
    locatexy (45, 440)
    put "New" ..

    drawline (31, 425, 129, 425, 4)

    locatexy (45, 400)
    put "Open" ..

    drawline (31, 390, 129, 390, 4)

    locatexy (45, 370)
    put "Save" ..
    locatexy (45, 360)
    put "Save As" ..

    drawline (31, 340, 129, 340, 4)

    locatexy (45, 320)
    colour (4)
    put "Exit" ..

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x >= 40 and x <= 70 and y >= 320 and y <= 335 then
	    exit_game := true
	    exit
	elsif btn = 1 and x >= 40 and x <= 65 and y >= 430 and y <= 445 then
	    new_game := true
	    exit
	elsif btn = 100 then
	    exit
	end if

    end loop

end file_down

procedure edit_down

    drawbox (115, 460, 215, 310, 1)
    drawfill (150, 350, 7, 1)

end edit_down

procedure help_down (var help : boolean)

    var x, y, btn : int := 0
    help := false

    drawbox (205, 460, 325, 410, 4)
    drawfill (250, 450, 7, 4)

    colour (15)
    locatexy (215, 440)
    put "Read Help File" ..

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 205 and y > 410 and y < 460 and x < 325 then
	    help := true
	    exit
	elsif btn = 100 then
	    exit
	end if

    end loop

    if help then
	cls
	openhelpfile
	cls
    end if

end help_down

procedure vara (x, y : int, var count, x1, y1 : int)

    count := count + 1

    if count = 1 then

	x1 := x
	y1 := y

    end if

end vara

procedure oval (shape, clr : int)

    var x, y, btn, x1, y1, x2, y2, midx, midy, l, w, bclr, count : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 66 and y > 40 and x <= 582 and y <=
		454 then

	    vara (x, y, count, x1, y1)

	    midx := x - ( (x - x1) div 2)
	    midy := y - ( (y - y1) div 2)
	    l := midx - x1
	    w := midy - y1

	    drawoval (midx, midy, l, w, clr)
	    delay (1)
	    bclr := whatdotcolour (midx, midy)
	    drawoval (midx, midy, l, w, bclr)
	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y
	    exit

	end if

    end loop

    midx := x2 - ( (x2 - x1) div 2)
    midy := y2 - ( (y2 - y1) div 2)
    l := midx - x1
    w := midy - y1

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	if shape = 4 then
	    drawfilloval (midx, midy, l, w, clr)
	elsif shape = 14 then
	    drawoval (midx, midy, l, w, clr)
	end if
    end if

end oval

procedure star (shape, clr : int)

    var bclr, x, y, x1, y1, x2, y2, count, btn : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 61 and y > 40 and x <= 585 and y <=
		458 then

	    vara (x, y, count, x1, y1)

	    drawstar (x1, y1, x, y, clr)
	    delay (1)
	    bclr := whatdotcolour (x + 1, y + 1)

	    drawstar (x1, y1, x, y, bclr)

	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y
	    exit

	end if

    end loop

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	if shape = 2 then
	    drawfillstar (x1, y1, x2, y2, clr)
	elsif shape = 12 then
	    drawstar (x1, y1, x2, y2, clr)
	end if
    end if

end star

procedure leaf (shape, clr : int, var x, y, x1, y1, x2, y2, count, btn
	: int)

    var bclr : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 61 and y > 41 and x <= 587 and y <=
		455 then

	    vara (x, y, count, x1, y1)

	    drawmapleleaf (x1, y1, x, y, clr)
	    delay (1)
	    bclr := whatdotcolour (x + 1, y + 1)
	    drawmapleleaf (x1, y1, x, y, bclr)
	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y
	    exit

	end if

    end loop

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	if shape = 3 then
	    drawfillmapleleaf (x1, y1, x2, y2, clr)
	elsif shape = 13 then
	    drawmapleleaf (x1, y1, x2, y2, clr)
	end if
    end if

end leaf

procedure box (shape, clr : int)

    var bclr, x, y, x1, y1, x2, y2, count, btn : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 60 and y > 40 and x <= 585 and y <= 458 then

	    vara (x, y, count, x1, y1)

	    drawbox (x1, y1, x, y, clr)
	    delay (1)
	    bclr := whatdotcolour (x + 1, y + 1)
	    drawbox (x1, y1, x, y, bclr)
	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y
	    exit

	end if

    end loop

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	if shape = 5 then
	    drawfillbox (x1, y1, x2, y2, clr)
	elsif shape = 15 then
	    drawbox (x1, y1, x2, y2, clr)
	end if
    end if

end box

procedure draw_line (var x1, x2, y1, y2, clr : int)

    var bclr, x, y, count, btn : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 60 and y > 40 and x <= 585 and y <=
		458 then

	    vara (x, y, count, x1, y1)

	    drawline (x1, y1, x, y, clr)
	    delay (1)
	    bclr := whatdotcolour (x + 1, y + 1)
	    drawline (x1, y1, x, y, bclr)
	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y

	    exit

	end if

    end loop

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	drawline (x1, y1, x2, y2, clr)
    end if

end draw_line

procedure bend_line (x1, x2, y1, y2, clr : int)

    var bclr, x, y, btn : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 60 and y > 40 and x <= 585 and y <=
		458 then

	    drawline (x1, y1, x, y, clr)
	    drawline (x, y, x2, y2, clr)
	    delay (1)
	    bclr := whatdotcolour (x + 1, y + 1)
	    drawline (x1, y1, x, y, bclr)
	    drawline (x, y, x2, y2, bclr)
	    btn := 0

	elsif btn not= 1 and y > 41 then
	    exit
	end if

    end loop

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40
	    and y1 < 458 and y2 > 40 and y < 458 then
	drawline (x1, y1, x, y, clr)
	drawline (x, y, x2, y2, clr)
    end if

end bend_line

procedure arc (shape, clr : int)

    var bclr, x, y, x1, y1, x2, y2, midx, midy, l, w, btn, count : int := 0

    loop

	mousewhere (x, y, btn)

	if btn = 1 and x > 66 and y > 40 and x <= 582 and y <=
		454 then

	    vara (x, y, count, x1, y1)

	    midx := x - ( (x - x1) div 2)
	    midy := y - ( (y - y1) div 2)
	    l := midx - x1
	    w := midy - y1

	    drawarc (midx, midy, l, w, 0, 180, clr)

	    if shape = 1 then
		drawline (midx - l, midy, midx + l, midy, clr)
	    end if

	    delay (1)
	    if shape = 1 then
		bclr := whatdotcolour (midx, midy + 1)
	    else
		bclr := whatdotcolour (midx, midy)
	    end if
	    drawarc (midx, midy, l, w, 0, 180, bclr)

	    if shape = 1 then
		drawline (midx - l, midy, midx + l, midy, bclr)
	    end if

	    btn := 0

	elsif btn not= 1 and y > 41 then

	    x2 := x
	    y2 := y

	    exit

	end if

    end loop

    midx := x2 - ( (x2 - x1) div 2)
    midy := y2 - ( (y2 - y1) div 2)
    l := midx - x1
    w := midy - y1

    if x1 > 60 and x1 < 590 and x2 > 60 and x2 < 590 and y1 > 40 and y1 <
	    458 and y2 > 40 and y < 458 then
	if shape = 1 then
	    drawfillarc (midx, midy, l, w, 0, 180, clr)
	elsif shape = 11 then
	    drawarc (midx, midy, l, w, 0, 180, clr)
	end if
    end if

end arc

procedure text (var x, y, btn : int, var word : string (1), clr : int)

    setscreen ("cursor,echo")

    var count : int := 0

    loop

	mousewhere (x, y, btn)

	colour (clr)

	if btn = 1 and x > 60 and y > 40 and x < 590 and y <
		450 then
	    locatexy (x, y)
	end if

	getch (word)

	if ord (word) = 10 then
	    exit
	end if

	if ord (word) not= 8 then
	    count += 6
	end if

	exit when count + x >= 585

    end loop

end text

/* setscreens */

setscreen ("graphics:vga")
setscreen ("noecho,nocursor")
buttonchoose ("multibutton")
randomize

/* declaration */

var x, y, x1, y1, x2, y2, btn, clr, shape, n, count, bclr, size, midx, midy,
    midi, l, w : int := 0
var ans, input, word : string (1)
var help, exit_game, new_game, line : boolean := false

open : n, "ins.hlp", get

if n = 0 then
    writehelpfile
end if

loop

    cls
    help := false
    new_game := false
    clr := 15
    bclr := 0

    /* Draws outer box */
    drawbox (1, 1, maxx, maxy, 15)

    /* draws the colour pallette */
    colour_pallette

    /* Draws all outer boxes */
    outer_boxes

    /* Bottom Boxes */
    bottom_boxes

    /* left side boxes */
    left_boxes

    /* Menu Bar */
    menu

    /* Draws Shapes */
    draw_shapes
    left_shapes

    /* Text */
    colour (4)
    locatexy (370, 16)
    put "TEXT" ..

    /* Background Change */
    locatexy (438, 16)
    put "BG " ..

    /* Erase */
    locatexy (485, 16)
    put "ERASE" ..

    /* Fill */
    locatexy (315, 16)
    put "FILL" ..

    /* Black */
    locatexy (550, 16)
    put "BLACK" ..

    /* Program */

    loop

	mousewhere (x, y, btn)
	set_shape (x, y, btn, shape)
	set_colour (x, y, btn, clr)

	count := 0

	if y > 40 and x <= 585 and y <= 460 and x > 60 then

	    if btn = 1 and (shape = 4 or shape = 14) and y > 40 and x < 583
		    and y < 454 and x > 66 then

		oval (shape, clr)
		line := false

	    elsif btn = 1 and (shape = 1 or shape = 11) and y > 43 and x <
		    571 and y < 444 and x > 75 then

		arc (shape, clr)
		line := false

	    elsif btn = 1 and (shape = 2 or shape = 12) and y > 40 and x
		    < 577 and y < 458 and x > 60 then

		star (shape, clr)
		line := false

	    elsif btn = 1 and (shape = 3 or shape = 13) and y > 40 and x
		    < 577 and y < 458 and x > 60 then

		leaf (shape, clr, x, y, x1, y1, x2, y2, count, btn)
		line := false

	    elsif btn = 1 and (shape = 5 or shape = 15) and y > 40 and x
		    < 577 and y < 458 and x > 60 then

		box (shape, clr)
		line := false

	    elsif btn = 1 and shape = 17 and y > 41 and x < 590 and y <
		    458 and x > 61 then

		draw_line (x1, x2, y1, y2, clr)
		line := true

	    elsif btn = 1 and shape = 6 and y > 56 and x < 575 and y <
		    458 and x > 74 then

		%FILL

	    elsif btn = 1 and shape = 9 and y > 50 and x > 70 and y <
		    448 and x <= 580 then

		drawfillbox (x - 10, y - 10, x + 10, y + 10, bclr)
		line := false

	    elsif btn = 1 and shape = 7 and y > 40 and x > 60 and y <
		    460 and x < 590 then

		text (x, y, btn, word, clr)
		line := false

	    elsif btn = 1 and shape = 16 and y > 40 and y < 458 and x >
		    60 and x < 590 then

		drawdot (x, y, clr)
		line := false

	    elsif btn = 1 and shape = 18 and y > 40 and y < 458 and x >
		    60 and x < 590 and line then

		drawline (x1, y1, x2, y2, bclr)
		bend_line (x1, x2, y1, y2, clr)

		line := false

	    elsif btn = 1 and shape = 10 then

		clr := 0
		line := false

	    elsif btn = 100 and clr not= 15 and shape = 8 then

		drawfill (x, y, clr, 15)
		bclr := clr
		line := false

	    end if

	end if

	if btn = 1 and x >= 25 and y >= 462 and y <= maxy - 1 and x <= 55
		then
	    file_down (new_game, exit_game)
	elsif btn = 1 and x >= 110 and y >= 462 and y <= maxy - 1 and x
		<= 140 then
	    edit_down
	elsif btn = 1 and x >= 195 and y >= 462 and y <= maxy - 1 and x
		<= 230 then
	    help_down (help)
	end if

	exit when help or exit_game or new_game
    end loop

    cls
    exit when exit_game

end loop
