%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5%%%
% Vampire Dungeon                                                            %
%----------------                                                            %
% Written by: Paul Halupka                                                   %
% School: Mother Teresa C.S.S. Scarborough Ont.                              %
% Teacher: Tony Laferrara                                                    %
% Completed: April 27, 1993                                                  %
%                                                                            %
% This program is the editor for Vampire dungeon. This program allows you    %
% to load,save,view and edit any maze that can be played in "maze.gam".      %
% Note: This is the second part of two programs working together. The other  %$
%       program is called "maze.gam"  and is used to play the mazes this     %
%       program creates.                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                                            %
var ok : boolean := false
var boxsize : int % size of the building boxes
var size : int % size of the maze
var cursize : int % cursor size while in the editor
var move : string (1) % Stores key presses in both the editor and menus
var flname : string % Stores the name of the file you're working on
var link : string := "none" % Stores the name of the file the current maze is
			    % linked to.
var curx, cury : int % Stores the location of the cursor
var ec : int % Stores the existing color of the box you're in so that you can
	     % toggle between wall and passageway
var file : int % used to open files
var col : string % Used to transfer the map to a file.
var x : int := 190 % Used for movement in the menus
var y : int := 267 % Used for movement in the menus
% This procedure draws a "button" given the lower left corner (x,y), the upper
% right corner (padbx,padby) and three colors. (pc1,pc2,pc3)
procedure button (x, y, padbx, padby, pc1, pc2, pc3 : int) %the button
    drawbox (x, y, padbx, padby, 0)
    drawbox (x + 5, y + 5, padbx - 5, padby - 5, 0)
    drawline (x, y, x + 5, y + 5, 0)
    drawline (x, padby, x + 5, padby - 5, 0)
    drawline (padbx, y, padbx - 5, y + 5, 0)
    drawline (padbx, padby, padbx - 5, padby - 5, 0)
    drawfill (x + 7, y + 7, pc1, 0)
    drawfill (x + 2, ( (padby - y) div 2) + y, pc2, 0)
    drawfill ( ( (padbx - x) div 2) + x, padby - 2, pc2, 0)
    drawfill ( ( (padbx - x) div 2) + x, y + 2, pc3, 0)
    drawfill (padbx - 2, ( (padby - y) div 2) + y, pc3, 0)
end button
% This procedure draws an empty maze mesh given the size of the maze and the
% bow size.
procedure drawmesh
    for j : 0 .. size
	drawline (0, j * boxsize, boxsize * size, j * boxsize, 15)
    end for
    for j : 0 .. size
	drawline (j * boxsize, 0, j * boxsize, size * boxsize, 15)
	drawfill (j * boxsize - 1, 1, 7, 15)
    end for
    for j : 0 .. size - 1
	drawfill (1, j * boxsize + 1, 7, 15)
	drawfill (size * boxsize - 1, j * boxsize + 1, 7, 15)
    end for
    drawfill (600, 1, 7, 15)
    button (493, 180, 632, 470, 0, 7, 8)
    color (11)
    locate (2, 65)
    put "KEYS"
    locate (3, 65)
    put "----"
    locate (5, 65)
    color (7)
    put "SPACEBAR"
    locate (6, 65)
    put "-Build/Unbuild"
    locate (7, 65)
    put " wall"
    locate (9, 65)
    color (2)
    put "S"
    locate (10, 65)
    put "-Mark Starting"
    locate (11, 65)
    put " Point"
    color (4)
    locate (13, 65)
    put "ESC"
    locate (14, 65)
    put "-Exit/Save"
    color (5)
    locate (16, 65)
    put "This file is"
    locate (17, 65)
    put "linked to:"
    locate (18, 65)
    put link
    color (15)
end drawmesh
setscreen ("graphics:m256")
include "scrnfile.t"
% Displays the title
ScreenFile.fileToScreen (0, 0, "edit.tim", ok)
getch (move)
setscreen ("text")
setscreen ("graphics:v16")
% This loop creates and controls the button menu
loop
    y := 267
    setscreen ("noecho")
    cls
    drawfill (0, 0, 7, 7)
    button (190, 267, 410, 297, 0, 7, 8)
    button (190, 235, 410, 265, 0, 7, 8)
    button (190, 203, 410, 233, 0, 7, 8)
    locate (13, 31)
    put "BUILD NEW MAZE"
    locate (15, 29)
    put "EDIT EXISTING MAZE"
    locate (17, 32)
    put "QUIT EDITOR"
    % This loop monitors movement and highlights the appropriate buttons
    loop
	button (x, y, x + 220, y + 30, 9, 11, 1)
	getch (move)
	if move = chr (200) then
	    button (x, y, x + 220, y + 30, 0, 7, 8)
	    y := y + 32
	    if y > 267 then
		y := 203
	    end if
	elsif move = chr (208) then
	    button (x, y, x + 220, y + 30, 0, 7, 8)
	    y := y - 32
	    if y < 203 then
		y := 267
	    end if
	elsif move = chr (10) then
	    exit
	else
	end if
    end loop
   % This if statement determains what choice was made in the button menu and
   % takes the appropriate action.
    if y = 235 then
	setscreen ("echo")
	button (100, 105, 400, 135, 0, 7, 8)
	locate (23, 15)
	put "Enter name of maze: " ..
	get flname

	%%%%This part of the program checks whether or not the user has entered%%%%%
	%%%%the "mze" extension to the filename and adds it if it wasn't entered%%%%

	if index (flname, ".mze") = 0 then
	    flname := flname + ".mze"
	end if

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	cls
      % This part of the program retrieves a save file and displays it on the
      % screen for editing.
	open : file, flname, get
	get : file, size, skip
	get : file, link, skip
	drawmesh
	for decreasing i : size .. 1
	    get : file, col
	    for j : 1 .. size
		if col (j) = "1" then
		    drawfill (j * boxsize - 1, i * boxsize - 1, 7,
			15)
		elsif col (j) = "S" then
		    drawfill (j * boxsize - 1, i * boxsize - 1, 2,
			15)
		else
		    drawfill (j * boxsize - 1, i * boxsize - 1, 0,
			15)
		end if
	    end for
	    get : file, skip
	end for
    elsif y = 267 then
	link := "none"
	% This sets up the menu which determains the size of a new maze
	setscreen ("noecho")
	cls
	drawfill (0, 0, 7, 7)
	button (190, 361, 410, 391, 0, 7, 8)
	button (190, 299, 410, 329, 0, 7, 8)
	button (190, 267, 410, 297, 0, 7, 8)
	button (190, 235, 410, 265, 0, 7, 8)
	button (190, 203, 410, 233, 0, 7, 8)
	locate (7, 27)
	put "Choose size of maze:"
	locate (11, 35)
	put "8 X 8"
	locate (13, 34)
	put "16 X 16"
	locate (15, 34)
	put "32 X 32"
	locate (17, 34)
	put "64 X 64"
	loop
	    button (x, y, x + 220, y + 30, 9, 11, 1)
	    getch (move)
	    if move = chr (200) then
		button (x, y, x + 220, y + 30, 0, 7, 8)
		y := y + 32
		if y > 299 then
		    y := 203
		end if
	    elsif move = chr (208) then
		button (x, y, x + 220, y + 30, 0, 7, 8)
		y := y - 32
		if y < 203 then
		    y := 299
		end if
	    elsif move = chr (10) then
		exit
	    else
	    end if
	end loop
	if y = 299 then
	    size := 8
	    boxsize := 60
	elsif y = 267 then
	    size := 16
	    boxsize := 30
	elsif y = 235 then
	    size := 32
	    boxsize := 15
	elsif y = 203 then
	    size := 64
	    boxsize := 7
	else
	end if
	cls
	drawmesh
    else
	exit
    end if
    % places cursor in the botton left position
    cury := boxsize + 1
    curx := boxsize + 1

    setscreen ("noecho")
    % This loop contains all movements and changes in the construction of the
    % maze.
    loop
	ec := whatdotcolor (curx, cury)
	drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
	    2), 4)
	drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
	    2), 4)
	getch (move)
	if move = chr (200) and cury + boxsize < size * boxsize then
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	    cury := cury + boxsize
	elsif move = chr (208) and cury - boxsize > boxsize then
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	    cury := cury - boxsize
	elsif move = chr (205) and curx + boxsize < size * boxsize -
		boxsize
		then
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	    curx := curx + boxsize
	elsif move = chr (203) and curx - boxsize > boxsize then
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	    curx := curx - boxsize
	elsif move = "s" or move = "S" then
	    drawfill (curx, cury, 2, 15)
	elsif move = chr (32) then
	    if ec = 0 then
		drawfill (curx, cury, 7, 15)
	    else
		drawfill (curx, cury, 0, 15)
	    end if
	elsif move = chr (27) then
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	    ok := false
	    for decreasing i : size .. 1
		for j : 1 .. size
		    if whatdotcolor (j * boxsize - 1, i * boxsize - 1) =
			    2 then
			ok := true
		    end if
		end for
	    end for
	   % This if statement checks if a starting position has been marked
	   % on the maze
	    if ok = false then
		drawfill (499, 186, 7, 15)
		button (493, 180, 632, 470, 0, 7, 8)
		color (14)
		locate (2, 65)
		put "Please mark"
		locate (3, 65)
		put "starting "
		locate (4, 65)
		put "point by"
		locate (5, 65)
		put "pressing S at"
		locate (6, 65)
		put "the desired"
		locate (7, 65)
		put "location."
		locate (9, 65)
		put "Press any key"
		locate (10, 65)
		put "to return to"
		locate (11, 65)
		put "editor."
		color (15)
		getch (move)
		drawfill (499, 186, 7, 15)
		drawmesh
	    else
		exit
	    end if
	else
	    drawline (curx, cury, curx + (boxsize - 2), cury + (boxsize -
		2), ec)
	    drawline (curx + (boxsize - 2), cury, curx, cury + (boxsize -
		2), ec)
	end if
    end loop
    setscreen ("echo")
    % This loop saves the file if required and/or exits the editing screen.
    loop
	drawfill (499, 186, 7, 15)
	button (493, 180, 632, 470, 0, 7, 8)

	locate (2, 65)
	put "Save? (y/N)" ..
	getch (move)

	if move = "y" or move = "Y" then
	    locate (3, 65)
	    put "Save as?"
	    locate (4, 65)
	    put "(8 characters"
	    locate (5, 65)
	    put "only please)"
	    locate (6, 65)
	    get flname
	    open : file, flname + ".mze", put
	    assert file > 0
	    locate (9, 65)
	    put "Would you "
	    locate (10, 65)
	    put "like to link"
	    locate (11, 65)
	    put "this maze to"
	    locate (12, 65)
	    put "another maze?"
	    locate (13, 65)
	    put "(y/n)" ..
	    getch (move)

	    if move = "y" or move = "Y" then
		locate (14, 65)
		put "Enter name of"
		locate (15, 65)
		put "maze to follow"
		locate (16, 65)
		put "this one:"
		locate (17, 65)
		get link
		if length (link) > 8 then
		    link := link (1 .. 8)
		end if
		put : file, size, skip
		put : file, link, skip
	    else
		put : file, size, skip
		put : file, "none "
	    end if

	    for decreasing i : size .. 1

		for j : 1 .. size

		    if whatdotcolor (j * boxsize - 1, i * boxsize - 1) =
			    7
			    then
			put : file, "1" ..
		    elsif whatdotcolor (j * boxsize - 1, i * boxsize -
			    1) = 2
			    then
			put : file, "S" ..
		    else
			put : file, "0" ..
		    end if

		end for
		put : file, "\N"

	    end for
	    close : file
	    exit

	else
	    exit
	end if
    end loop
end loop
