%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5%%%
% Vampire Dungeon                                                            %
%----------------                                                            %
% Written by: Paul Halupka                                                   %
% School: Mother Teresa C.S.S. Scarborough Ont.                              %
% Teacher: Tony Laferrara                                                    %
% Completed: April 27, 1993                                                  %
%                                                                            %
% This program is a game which you try to find your way out of a three       %
% dimentional maze. The maze may be the already created vampire dungeons     %
% or a custom maze created with medit.t                                      %
% Note: This is the first part of two programs working together. The other   %$
%       program is called "medit.t" and is also on this disk                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                                            %

include "setup.t" % This program sets up the graphics for the walls of the
% maze.
var move_key : string (1) % Variable used to monitor your movements while in
% the maze.
var location_x : int % Stores the x value of your location in the maze.
var location_y : int % Stores the y value of your location in the maze.
var help : int := 0 %stores whether or not the player is a novice
% or experts
var direction : int := 1 % Stores the direction you're facing in the maze.
% N=1 E=2 S=3 W=4.
var col : string % Used to trasfer info from file to the mazemap array.
var link : string := "none" % Used to monitor the maze that follows the
% current maze.
var size : int % Used to store the size of the maze
var flname : string (12) % Stores the name of a maze to be loaded.
var file : int %Used to open the file
var format : string (11) := "00000000000" % Used to store the format of the
% Walls in front of the user. The
% first three digits store the
% front three spaces (0 for wall
% 1 for no wall). The next three
% three digits stand for the next
% row of locations in front of the
% user an so on.

var mazemap : array 1 .. 72, 1 .. 72 of string (1) % This stores the maze
% itself.
var move : string (1)
% This stores various key movements prior to entering of
% maze.
getch (move)
% The following procedure checks the area in front of the user by first
% reading the given x and y location as well as the direction. All info is
% stored in the variable "format" and is passed on to the procedure "drawalls"
% which draws the appropriate graphics for your location.
procedure mm (x, y, d : int)
    case d of
	label 1 :
	    format := mazemap (x - 1, y) + format (2 .. 11)
	    format := format (1) + mazemap (x, y + 1) + format (3 ..
		11)
	    format := format (1 .. 2) + mazemap (x + 1, y) + format
		(4
		.. 11)
	    format := format (1 .. 3) + mazemap (x - 1, y + 1) +
		format
		(5
		.. 11)
	    format := format (1 .. 4) + mazemap (x, y + 2) + format
		(6
		.. 11)
	    format := format (1 .. 5) + mazemap (x + 1, y + 1) +
		format
		(7
		.. 11)
	    format := format (1 .. 6) + mazemap (x - 1, y + 2) +
		format
		(8
		.. 11)
	    format := format (1 .. 7) + mazemap (x, y + 3) + format
		(9
		.. 11)
	    format := format (1 .. 8) + mazemap (x + 1, y + 2) +
		format
		(10
		.. 11)
	    format := format (1 .. 9) + mazemap (x - 1, y + 3) +
		format
		(11)
	    format := format (1 .. 10) + mazemap (x + 1, y + 3)
	label 2 :
	    format := mazemap (x, y + 1) + format (2 .. 11)
	    format := format (1) + mazemap (x + 1, y) + format (3 .. 11)
	    format := format (1 .. 2) + mazemap (x, y - 1) + format (4 .. 11)
	    format := format (1 .. 3) + mazemap (x + 1, y + 1) + format (5
		.. 11)
	    format := format (1 .. 4) + mazemap (x + 2, y) + format (6 .. 11)
	    format := format (1 .. 5) + mazemap (x + 1, y - 1) + format (7
		.. 11)
	    format := format (1 .. 6) + mazemap (x + 2, y + 1) + format (8
		.. 11)
	    format := format (1 .. 7) + mazemap (x + 3, y) + format (9 .. 11)
	    format := format (1 .. 8) + mazemap (x + 2, y - 1) + format (10
		.. 11)
	    format := format (1 .. 9) + mazemap (x + 3, y + 1) + format (11)
	    format := format (1 .. 10) + mazemap (x + 3, y - 1)
	label 3 :
	    format := mazemap (x + 1, y) + format (2 .. 11)
	    format := format (1) + mazemap (x, y - 1) + format (3 ..
		11)
	    format := format (1 .. 2) + mazemap (x - 1, y) + format
		(4
		.. 11)
	    format := format (1 .. 3) + mazemap (x + 1, y - 1) +
		format
		(5
		.. 11)
	    format := format (1 .. 4) + mazemap (x, y - 2) + format
		(6
		.. 11)
	    format := format (1 .. 5) + mazemap (x - 1, y - 1) +
		format
		(7
		.. 11)
	    format := format (1 .. 6) + mazemap (x + 1, y - 2) +
		format
		(8
		.. 11)
	    format := format (1 .. 7) + mazemap (x, y - 3) + format
		(9
		.. 11)
	    format := format (1 .. 8) + mazemap (x - 1, y - 2) +
		format
		(10
		.. 11)
	    format := format (1 .. 9) + mazemap (x + 1, y - 3) +
		format
		(11)
	    format := format (1 .. 10) + mazemap (x - 1, y - 3)
	label 4 :
	    format := mazemap (x, y - 1) + format (2 .. 11)
	    format := format (1) + mazemap (x - 1, y) + format (3 ..
		11)
	    format := format (1 .. 2) + mazemap (x, y + 1) + format
		(4
		.. 11)
	    format := format (1 .. 3) + mazemap (x - 1, y - 1) +
		format
		(5
		.. 11)
	    format := format (1 .. 4) + mazemap (x - 2, y) + format
		(6
		.. 11)
	    format := format (1 .. 5) + mazemap (x - 1, y + 1) +
		format
		(7
		.. 11)
	    format := format (1 .. 6) + mazemap (x - 2, y - 1) +
		format
		(8
		.. 11)
	    format := format (1 .. 7) + mazemap (x - 3, y) + format
		(9
		.. 11)
	    format := format (1 .. 8) + mazemap (x - 2, y + 1) +
		format
		(10
		.. 11)
	    format := format (1 .. 9) + mazemap (x - 3, y - 1) +
		format
		(11)
	    format := format (1 .. 10) + mazemap (x - 3, y + 1)
    end case
end mm
% The following procedure uses what's stored in the variable "format" and
% determains which walls should be drawn on the screen.
procedure drawalls (var setup : string (11))
    if setup (11) = "1" and setup (9) = "0" then
	drawpic (100, 140, smwall3, 0)
	drawpic (141, 140, srwall30, 0)
    elsif setup (9) = "1" then
	drawpic (100, 128, srwall31, 0)
    else
    end if

    if setup (10) = "1" and setup (7) = "0" then
	drawpic (6, 140, srwall30, 0)
	drawpic (17, 140, smwall3, 0)
    elsif setup (7) = "1" then
	drawpic (46, 128, slwall31, 0)
    else
    end if

    if setup (8) = "1" then
	drawpic (59, 140, smwall3, 0)
    else
    end if

    if setup (6) = "0" and setup (9) = "1" then
	drawpic (114, 127, srwall20, 0)
	drawpic (134, 127, srwall20, 0)
    elsif setup (6) = "1" then
	drawpic (113, 108, srwall21, 0)
    else
    end if

    if setup (4) = "0" and setup (7) = "1" then
	drawpic (25, 128, slwall20, 0)
	drawpic (5, 128, slwall20, 0)
    elsif setup (4) = "1" then
	drawpic (26, 108, slwall21, 0)
    else
    end if

    if setup (5) = "1" then
	drawpic (46, 128, smwall2, 0)
    else
    end if

    if setup (3) = "0" and setup (6) = "1" then
	drawpic (133, 107, srwall10, 0)
    elsif setup (3) = "1" then
	drawpic (133, 93, srwall11, 0)
    else
    end if

    if setup (1) = "0" and setup (4) = "1" then
	drawpic (5, 108, slwall10, 0)
    elsif setup (1) = "1" then
	drawpic (5, 94, slwall11, 0)
    else
    end if
    if setup (2) = "1" then
	drawpic (26, 108, smwall1, 0)
    else
    end if
end drawalls
% The following draws the main menu of the game allowing you to enter vampire
% dungeon, enter a custom maze (created in medit.t) or to quit
cls
setscreen ("text")
setscreen ("graphics:v16,noecho")
locate (10, 33)
put "MAIN MENU"
locate (13, 27)
put "1. ENTER VAMPIRE DUNGEON"
locate (15, 27)
put "2. ENTER CUSTOM MAZE"
locate (17, 27)
put "3. QUIT GAME"
getch (move)
% This loop decides what to do depending on the choice made in the main menu.
loop
    if move = "1" then
	cls
	locate (10, 33)
	put "CHOOSE DIFFICULTY"
	locate (13, 33)
	put "1. MAZE VIRGIN"
	locate (15, 33)
	put "2. MAZE MASTER"
	getch (move)
	loop
	    if move = "1" then
		help := 1
		exit
	    elsif move = "2" then
		help := 0
		exit
	    end if
	end loop
	flname := "vampire0"
	exit
    elsif move = "2" then
	setscreen ("echo")
	locate (21, 20)
	put "ENTER NAME OF MAZE (NO EXTENSION): " ..
	get flname
	cls
	locate (10, 33)
	put "CHOOSE DIFFICULTY"
	locate (13, 33)
	put "1. MAZE VIRGIN"
	locate (15, 33)
	put "2. MAZE MASTER"
	getch (move)
	loop
	    if move = "1" then
		help := 1
		exit
	    elsif move = "2" then
		help := 0
		exit
	    end if
	end loop
	exit
    elsif move = "3" then
	flname := "quit"
	exit
    end if
end loop
% This if statement makes sure the name of the file isn't too long and adds
% the "MZE" extension.
if length (flname) < 9 then
    flname := flname + repeat (" ", 8 - length (flname)) + ".mze"
else
    flname := flname (1 .. 8) + ".mze"
end if
loop
    exit when flname = "quit    .mze"
    cls
    setscreen ("text")
    setscreen ("graphics:m256,noecho")
    open : file, flname, get
    assert file > 0
    get : file, size, skip
    get : file, link, skip
    % This for statement initailizes the whole mazemap array with 0's
    for decreasing i : 72 .. 1
	for j : 1 .. 72
	    mazemap (j, i) := "0"
	end for
    end for
    % This for statement loads the maze into the mazemap array four spaces
    % away from the borders just in case the computer tries to read past the
    % existing wall parrtern.
    for decreasing i : size .. 1
	get : file, col
	for decreasing j : size .. 1
	    mazemap (j + 4, i + 4) := col (j)
	    if mazemap (j + 4, i + 4) = "S" then
		location_x := j + 4
		location_y := i + 4
		mazemap (j + 4, i + 4) := "0"
	    end if
	end for
	get : file, skip
    end for

    % Sets up starting spot in the maze
    drawbox (3, 92, 155, 195, 4)
    mm (location_x, location_y, direction)
    drawalls (format)
    for i : 0 .. 5
	drawline (60 + i, 25, 60 + i, 60, 2)
	drawline (60 + i, 60, 95 + i, 25, 2)
	drawline (95 + i, 25, 95 + i, 60, 2)
    end for
    drawdot (location_x + 200, location_y + 10, 4 * help)
    locate (2, 23)
    put "USE"
    locate (4, 23)
    put "Up/Down arrow keys"
    locate (5, 23)
    put "to move forward"
    locate (6, 23)
    put "and back in the"
    locate (7, 23)
    put "maze"
    locate (9, 23)
    put "Left/Right arrow"
    locate (10, 23)
    put "keys to turn"
    locate (11, 23)
    put "left/right in maze"
    locate (15, 27)
    color (1*help)
    put "MAP"
    color (15)
    % This loop waits for your move in the maze and modifies your location and
    % the surrounding graphics according to your particular move.
    loop
	getch (move_key)
	drawdot (location_x + 200, location_y + 10, 14 * help)
	if move_key = chr (200) then
	    case direction of
		label 1 :
		    location_y := location_y + 1
		label 2 :
		    location_x := location_x + 1
		label 3 :
		    location_y := location_y - 1
		label 4 :
		    location_x := location_x - 1
		label :
	    end case
	elsif move_key = chr (208) then
	    case direction of
		label 1 :
		    location_y := location_y - 1
		label 2 :
		    location_x := location_x - 1
		label 3 :
		    location_y := location_y + 1
		label 4 :
		    location_x := location_x + 1
		label :
	    end case
	elsif move_key = chr (205) then
	    direction := direction + 1
	    if direction > 4 then
		direction := 1
	    end if
	elsif move_key = chr (203) then
	    direction := direction - 1
	    if direction < 1 then
		direction := 4
	    end if
	else
	end if
	% This if statement checks if you've run into a wall and moves you
	% back to your original spot if you've done so.
	if mazemap (location_x, location_y) = "1" then
	    if move_key = chr (200) then
		case direction of
		    label 1 :
			location_y := location_y - 1
		    label 2 :
			location_x := location_x - 1
		    label 3 :
			location_y := location_y + 1
		    label 4 :
			location_x := location_x + 1
		    label :
		end case
	    end if
	    if move_key = chr (208) then
		case direction of
		    label 1 :
			location_y := location_y + 1
		    label 2 :
			location_x := location_x + 1
		    label 3 :
			location_y := location_y - 1
		    label 4 :
			location_x := location_x - 1
		    label :
		end case
	    end if
	elsif location_y > size + 4 then
	    exit
	else
	    % Clears out previous walls
	    drawpic (4, 93, blank, 0)
	    drawpic (4, 143, blank, 0)
	    drawpic (79, 93, blank, 0)
	    drawpic (79, 143, blank, 0)
	    %Draws in new walls
	    mm (location_x, location_y, direction)
	    drawalls (format)
	    drawdot (location_x + 200, location_y + 10, 4 * help)
	    % Draw the direction on the screen.
	    if direction = 1 then
		drawpic (60, 25, blank, 0)
		for i : 0 .. 5
		    drawline (60 + i, 25, 60 + i, 60, 2)
		    drawline (60 + i, 60, 95 + i, 25, 2)
		    drawline (95 + i, 25, 95 + i, 60, 2)
		end for
	    elsif direction = 2 then
		drawpic (60, 25, blank, 0)
		for i : 0 .. 5
		    drawline (60 + i, 60 + i, 95 + i, 60 + i, 2)
		    drawline (60 + i, 60 + i, 60 + i, 25 + i, 2)
		    drawline (60 + i, 25 + i, 95 + i, 25 + i, 2)
		    drawline (60 + i, 42 + i, 77 + i, 42 + i, 2)
		end for
	    elsif direction = 3 then
		drawpic (60, 25, blank, 0)
		for i : 0 .. 5
		    drawline (60 + i, 60 + i, 95 + i, 60 + i, 2)
		    drawline (60 + i, 60 + i, 60 + i, 42 + i, 2)
		    drawline (60 + i, 42 + i, 95 + i, 42 + i, 2)
		    drawline (95 + i, 42 + i, 95 + i, 25 + i, 2)
		    drawline (95 + i, 25 + i, 60 + i, 25 + i, 2)
		end for
	    elsif direction = 4 then
		drawpic (60, 25, blank, 0)
		for i : 0 .. 5
		    drawline (60 + i, 25 + i, 60 + i, 60 + i, 2)
		    drawline (60 + i, 25 + i, 75 + i, 42 + i, 2)
		    drawline (75 + i, 42 + i, 95 + i, 25 + i, 2)
		    drawline (95 + i, 25 + i, 95 + i, 60 + i, 2)
		end for
	    end if
	end if
    end loop
    setscreen ("text,echo")
    cls
    % This if statement checks if the maze is linked to another maze. If it is
    % then it proceeds to load that maze, otherwise it ends the game.
    if link not= "none" then
	flname := link + ".mze"
	put "Thou hath progressed to the next level."
	getch (move)
    else
	put "You open the door of the dungeon and see..."
	exit
    end if
end loop
