%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NAME      : Drive v1.0 (SIMPLE GAME)                                     %
% BY        : Robinson Sathaseevan (roby@lords.com)                        %
% STARTED   : December 30, 1997                                            %
% FINISHED  : December 30, 1997 (THE SAME DAY!)                            %
% OJBECTIVE : A simple driveing Game. A Player has to stay on the track    %
%             and avoid hitting mines. The mines are moving on the track!  %
%             The Track scrolls down and randomlly turns.                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* SET SCREEN TO TEXT MODE - NO CURSOR AND NO ECHO OF INPUT KEYS */
setscreen ("text,nocursor,noecho")

/* ENABLE RANDOM NUMBERS */
randomize

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% VARIABLES, CONSTANTS, ARRAYS AND RECORDS <- ASSIGNMENTS AND DECLARATIONS %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* SIMPLE VARIABLES AND ARRAYS */
% PROGRAM VARIALBES
var ExitProgram : boolean := false
var key : string (1)
var Level : int := 10
var StartedTime : int
var ElapsedTime : int
% CAR & TRACK INFORMATION
var carx, oldcarx : int := 37
var cary, oldcary : int := 22
var track : array 1 .. maxrow of int
var Trapx : array 1 .. 2 of int
var Trapy : array 1 .. 2 of int
% BACKGROUND VARIABLES
var tree1x : int
var tree1y : int
var bush1x : int
var bush1y : int
var tree2x : int
var tree2y : int
var bush2x : int
var bush2y : int
% VARIABLE PICKS WHAT TO DO
var WhatToDo : int
% VARIABLES FOR TURNS
var HowFar : int

/* ASSIGN THE TRACK TO START OUT RIGHT IN THE MIDDLE */
for i : 1 .. maxrow
    track (i) := 25
end for

/* VARIABLES THAT HOLD THE INFO ABOUT THE BACKGROUND OF CAR */
/* THIS IS LIKE DECLARING 6000 VARIABLES!!!!! */
var back : array 1 .. maxrow of
    record
	xbgclr : array 1 .. 80 of int
	xtxtclr : array 1 .. 80 of int
	xchr : array 1 .. 80 of string (1)
    end record

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            PROGRAM PROCEDURES                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* PROCEDURE USED IN TAKEING IN THE BACKGROUND OF AN AREA */
procedure TakeBackground (y, x, y2, x2 : int)
    for row : y .. y2
	for clm : x .. x2
	    locate (row, clm)
	    back (row).xbgclr (clm) := whattextcolorback
	    back (row).xtxtclr (clm) := whattextcolor
	    back (row).xchr (clm) := whattextchar
	end for
    end for
end TakeBackground

/* PROCEDURE: THAT DISPLAYS HOW MUCH TIME HAS ELAPSED */
procedure CheckTime
    clock (ElapsedTime)
    ElapsedTime := ElapsedTime - StartedTime
    locate (maxrow, 1)
    colorback (0)
    color (15)
    % MINUITES
    if ElapsedTime div 100000 < 10 then
	put "0", ElapsedTime div 100000 ..
    else
	put ElapsedTime div 100000 ..
    end if
    put ":" ..
    % SECONDS
    if ElapsedTime div 1000 < 10 then
	put "0", ElapsedTime div 1000, "." ..
    else
	put ElapsedTime div 1000, "." ..
    end if
    % MILLESECONDS
    put ElapsedTime mod 1000 ..
    colorback (2)
    put "  " ..
end CheckTime

/* PROCEDURE: ERASES ALL THE SCENARIO */
procedure EraseAllBack
    for row : tree1y - 1 .. tree1y + 2
	locate (row, tree1x - 2)
	color (2)
	put repeat (chr (219), 5) ..
    end for
    for row : tree2y - 1 .. tree2y + 2
	locate (row, tree2x - 2)
	color (2)
	put repeat (chr (219), 5) ..
    end for
    for row : bush1y - 1 .. bush1y + 2
	locate (row, bush1x - 2)
	color (2)
	put repeat (chr (219), 5) ..
    end for
    for row : bush2y - 1 .. bush2y + 2
	locate (row, bush2x - 2)
	color (2)
	put repeat (chr (219), 5) ..
    end for
end EraseAllBack

/* PROCEDURE: PUTS A SCENARIO: TREE */
procedure PutTree (y, x : int)
    % BARK
    for row : 0 .. 2
	locate (y + row, x)
	color (6)
	put chr (219) ..
    end for
    % LEAVES
    color (10)
    locate (y - 1, x - 1)
    put repeat (chr (219), 3) ..
    locate (y, x - 2)
    put repeat (chr (219), 5) ..
    locate (y + 1, x - 1)
    put repeat (chr (219), 3) ..
end PutTree

/* PROCEDURE: PUTS A SCENARIO: BUSH */
procedure PutBush (y, x : int)
    color (10)
    locate (y - 1, x - 1)
    put repeat (chr (219), 3) ..
    locate (y, x - 2)
    put repeat (chr (219), 5) ..
    locate (y + 1, x - 1)
    put repeat (chr (219), 3) ..
end PutBush

/* PROCEDURE: ANIMATES TREES AND BUSHES */
procedure CheckScenario
    EraseAllBack
    if tree1y = maxrow - 3 then
	tree1y := 2
	randint (tree1x, 4, 13)
    else
	tree1y += 1
    end if
    if tree2y = maxrow - 3 then
	tree2y := 2
	randint (tree2x, 70, 77)
    else
	tree2y += 1
    end if
    if bush1y = maxrow - 3 then
	bush1y := 2
	randint (bush1x, 4, 13)
    else
	bush1y += 1
    end if
    if bush2y = maxrow - 3 then
	bush2y := 2
	randint (bush2x, 70, 77)
    else
	bush2y += 1
    end if
    PutTree (tree1y, tree1x)
    PutTree (tree2y, tree2x)
    PutBush (bush1y, bush1x)
    PutBush (bush2y, bush2x)
end CheckScenario

/* PROCEDURE: PUTS A TRAP */
procedure PutTrap (y, x : int)
    color (12)
    locate (y - 1, x - 1)
    put repeat (chr (219), 3) ..
    locate (y, x - 2)
    put repeat (chr (219), 5) ..
    locate (y + 1, x - 1)
    put repeat (chr (219), 3) ..
end PutTrap

/* PROCEDURE: SCROLLS THE TRAPS */
procedure CheckTrap
    if Trapy (1) = maxrow - 2 then
	Trapy (1) := 2
	randint (Trapx (1), track (2) + 5, track (2) + 15)
    else
	Trapy (1) += 1
    end if
    if Trapy (2) = maxrow - 2 then
	Trapy (2) := 2
	randint (Trapx (2), track (2) + 15, track (2) + 25)
    else
	Trapy (2) += 1
    end if
    PutTrap (Trapy (1), Trapx (1))
    PutTrap (Trapy (2), Trapx (2))
end CheckTrap

/* PROCEDURE: PUTS THE ENTIRE VISIBLE TRACK ON THE SCREEN */
procedure PutTrack
    % TRACK
    color (8)
    for i : 1 .. maxrow
	% ERASE THE OLD PART OF TRACK OF TRACK
	color (2)
	% ERASE LEFT SIDE OF TRACK
	locate (i, track (i) - 1)
	put repeat (chr (219), 1) ..
	locate (i, track (i) + 30)
	% ERASE RIGHT SIDE OF TRACK
	put repeat (chr (219), 1) ..
	% DRAW THE NEW PART OF TRACK
	color (8)
	locate (i, track (i))
	put repeat (chr (219), 30) ..
	locate (i, track (i) + 14)
	color (15)
	put chr (219) ..
    end for
    % SCENARIO
    CheckScenario
    CheckTrap
    CheckTime
end PutTrack

/* PROCEDURE: PUTS THE CAR ON THE DESIRED LOCATION (carx, cary) */
procedure PutCar (row, clm : int)
    TakeBackground (cary, carx, cary + 2, carx + 4)
    % RED BODY OF CAR
    for i : row .. row + 2
	locate (i, clm)
	color (4)
	put repeat (chr (219), 5) ..
    end for
    color (0)
    % TIRE - TOP LEFT
    locate (row, clm)
    put chr (219) ..
    % TIRE - TOP RIGHT
    locate (row, clm + 4)
    put chr (219) ..
    % TIRE - BOTTOM LEFT
    locate (row + 2, clm)
    put chr (219) ..
    % TIRE - BOTTOM RIGHT
    locate (row + 2, clm + 4)
    put chr (219) ..
    % WINDOW
    locate (row + 1, clm + 2)
    color (1)
    put chr (219) ..
end PutCar

/* PROCEDURE: THAT CHECKS IF A KEY WAS PRESSED AND ACTS ACCORDINGLY */
procedure GetKeys
    if hasch then
	getch (key)
	case ord (key) of
	    label 27 :
		ExitProgram := true % ESC
		return
	    label 200 :
		if cary not= 1 then
		    % IF CAR NOT AT TOP OF SCREEN
		    cary -= 1 % UP
		end if
	    label 205 :
		carx += 1 % RIGHT
	    label 208 :
		if cary not= 22 then
		    % IF CAR NOT ON BOTTOM OF SCREEN (UP BY 1 ROW)
		    cary += 1 % DOWN
		end if
	    label 203 :
		carx -= 1 % LEFT
	    label 201 :
		carx += 1 % PAGE UP
		if cary not= 1 then
		    % IF CAR NOT AT TOP OF SCREEN
		    cary -= 1 % UP
		end if
	    label 209 :
		carx += 1 % PAGE DOWN
		if cary not= 22 then
		    % IF CAR NOT ON BOTTOM OF SCREEN (UP BY 1 ROW)
		    cary += 1 % DOWN
		end if
	    label 199 :
		carx -= 1 % HOME
		if cary not= 1 then
		    % IF CAR NOT AT TOP OF SCREEN
		    cary -= 1 % UP
		end if
	    label 207 :
		carx -= 1 % END
		if cary not= 22 then
		    % IF CAR NOT ON BOTTOM OF SCREEN (UP BY 1 ROW)
		    cary += 1 % DOWN
		end if
	end case
    end if
    PutCar (cary, carx)
end GetKeys

/* PROCEDURE: CHECKS IF THE PLAYER CRASHED INTO ANYTHING OR */
/* DROVE ON THE GRASS */
procedure CheckCarCrash
    for row : cary .. cary + 2
	for clm : carx .. carx + 4
	    if back (row).xtxtclr (clm) = 2 then
		% GRASS
		locate (maxrow, 29)
		colorback (4)
		color (14)
		put "YOU RUINED YOUR TIRES!" ..
		locate (1, 1)
		ExitProgram := true
		return
	    elsif back (row).xtxtclr (clm) = 12 then
		% MINE
		locate (maxrow, 30)
		colorback (4)
		color (14)
		put "BOOM GOES THE MINE!" ..
		locate (1, 1)
		ExitProgram := true
		return
	    end if
	end for
    end for
end CheckCarCrash

/* PROCEDURE: MOVES THE TRACK DOWN (FOR ANIMATION) */
procedure MoveTrackDown
    for decreasing i : maxrow .. 2
	track (i) := track (i - 1)
    end for
end MoveTrackDown

/* PROCEDURE: TURNS THE TRACK LEFT */
procedure TurnLeft
    randint (HowFar, 4, 10)
    % DO THE LEFT CURVE
    for i : 1 .. HowFar
	MoveTrackDown
	track (1) -= 1
	PutTrack
	GetKeys
	CheckCarCrash
	if ExitProgram = true then
	    return
	end if
    end for
    % DO THE RIGHT CURVE BACK TO CENTER
    for decreasing i : HowFar .. 1
	MoveTrackDown
	track (1) += 1
	PutTrack
	GetKeys
	CheckCarCrash
	if ExitProgram = true then
	    return
	end if
    end for
end TurnLeft

/* PROCEDURE: TURNS THE TRACK RIGHT */
procedure TurnRight
    randint (HowFar, 4, 10)
    % DO THE LEFT CURVE
    for i : 1 .. HowFar
	MoveTrackDown
	track (1) += 1
	PutTrack
	GetKeys
	CheckCarCrash
	if ExitProgram = true then
	    return
	end if
    end for
    % DO THE RIGHT CURVE BACK TO CENTER
    for decreasing i : HowFar .. 1
	MoveTrackDown
	track (1) -= 1
	PutTrack
	GetKeys
	CheckCarCrash
	if ExitProgram = true then
	    return
	end if
    end for
end TurnRight

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                          MAIN PROGRAM EXECUTION                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

locate (1, 1)
colorback (4)
color (15)
put ""
locate (1, 35)
put "Drive v1.0"
colorback (0)
color (7)
put ""
put "Loading Game..."

delay (1000)

clock (StartedTime)

% STARTING LOCATIONS OF BACKGROUNDS
tree1y := 5
tree1x := 4
tree2y := 20
tree2x := 71
bush1y := 18
bush1x := 8
bush2y := 7
bush2x := 72

% STARTING LOCATIONS OF TRAPS
Trapy (1) := 3
Trapx (1) := 35
Trapy (2) := 9
Trapx (2) := 45

delay (1000)

% GRASS
colourback (2)
cls
PutTrack
locate (maxrow, 1)
colorback (2)
put "                   " ..
locate (1, 1)
colorback (0)
color (15)
put "Press ENTER to start..."
loop
    getch (key)
    exit when ord (key) = 10
end loop
colourback (2)
cls
PutTrack

loop
    PutTrack
    GetKeys
    CheckCarCrash
    if ExitProgram = true then
	locate (1, 1)
	colorback (0)
	color (15)
	put "Press ENTER to exit..."
	loop
	    getch (key)
	    if ord (key) = 10 then
		return
	    end if
	end loop
    end if
    randint (WhatToDo, 1, Level)
    if WhatToDo = 1 then
	TurnLeft
    elsif WhatToDo = 2 then
	TurnRight
    else
	MoveTrackDown
	PutTrack
    end if
end loop
