procedure Center (MESSAGE : string, ROW : int)
    const MIDDLE := 40
    const LENGTH := length (MESSAGE)
    const COLUMN := (MIDDLE - (LENGTH / 2)) div 1
    loop
	if ROW > 24 or ROW < 1 then
	    put "An invalid row has been entered."
	    exit
	end if
	if LENGTH > 78 then
	    put
		"A line longer than 78 characters cannot be centered on a 80 column screen."
	    exit
	end if
	locate (ROW, COLUMN)
	put MESSAGE ..
	exit
    end loop
end Center
procedure DRAW_A_BORDER (X1, Y1, X2, Y2, COLOUR : int)
    var Ori_Col := whatcolour
    colour (COLOUR)
    locate (Y1, X1)
    put chr (201) .. % Top left corner
    for Count : X1 + 1 .. X2 - 1
	locate (Y1, Count)
	put chr (205) ..
    end for
    locate (Y1, X2)
    put chr (187) ..
    locate (Y2, X1)
    put chr (200) ..
    for Count : X1 + 1 .. X2 - 1
	locate (Y2, Count)
	put chr (205) ..
    end for
    locate (Y2, X2)
    put chr (188) ..
    for Count : Y1 + 1 .. Y2 - 1
	locate (Count, X1)
	put chr (186) ..
	locate (Count, X2)
	put chr (186) ..
    end for
    colour (Ori_Col)
end DRAW_A_BORDER
setscreen ("graphics:e16")
randomize
var No_Of_Numbers : int
var KeY : string (1)
var ChoiCe : int
var Response : string (1)
loop
    cls
    DRAW_A_BORDER (10, 4, 70, 20, 2)
    DRAW_A_BORDER (20, 5, 60, 7, 3)
    colour (4)
    Center ("M E N U", 6)
    colour (5)
    Center ("1.   Ice Rink                ", 9)
    Center ("2.   Test                    ", 11)
    Center ("3.                           ", 13)
    Center ("4.                           ", 15)
    Center ("5.   Exit                    ", 17)
    colour (6)
    Center ("Please enter the number corresponding to your choice.", 19)
    colour (7)
    setscreen ("noecho,nocursor")
    loop
	loop
	    getch (Response)
	    exit when index ("12345", Response) not= 0
	end loop
	ChoiCe := strint (Response)
	DRAW_A_BORDER (24, ChoiCe * 2 + 6, 26, ChoiCe * 2 + 8, 2)
	colour (7)
	Center ("       Press <ENTER> to confirm your choice.         ",
	    19)
	getch (Response)
	exit when ord (Response) = 10
	colour (6)
	Center ("Please enter the number corresponding to your choice.",
	    19)
	colour (7)
	DRAW_A_BORDER (24, ChoiCe * 2 + 6, 26, ChoiCe * 2 + 8,
	    whatcolourback)
    end loop
    setscreen ("cursor,echo")
    case ChoiCe of
	label 1 :
	    cls
	    getch (KeY)
	label 2 :
	    cls
	    getch (KeY)
	label 3 :
	    cls
	    getch (KeY)
	label 4 :
	    cls
	    getch (KeY)
	label 5 :
	    exit
    end case
end loop

