procedure Draw_A_Border (x1, y1, x2, y2, Colour : int)
    const TOPLEFT := chr (201)
    const TOPRIGHT := chr (187)
    const BOTTOMLEFT := chr (200)
    const BOTTOMRIGHT := chr (188)
    const TOP := chr (205)
    const SIDE := chr (186)
    color (Colour)
    locate (x1, y1)
    put TOPLEFT ..
    for run : y1 + 1 .. y2 - 1
	locate (x1, run)
	put TOP ..
    end for
    locate (x1, y2)
    put TOPRIGHT ..
    for run : x1 + 1 .. x2 - 1
	locate (run, y2)
	put SIDE ..
    end for
    locate (x2, y2)
    put BOTTOMRIGHT ..
    for decreasing run : y2 - 1 .. y1 + 1
	locate (x2, run)
	put TOP ..
    end for
    locate (x2, y1)
    put BOTTOMLEFT ..
    for decreasing run : x2 - 1 .. x1 + 1
	locate (run, y1)
	put SIDE ..
    end for
end Draw_A_Border

procedure Border (x1, y1, x2, y2, Colour : int)
    drawbox (x1, 349 - y1, x2, 349 - y2, Colour)
    drawbox (x1 + 2, 349 - y1 - 2, x2 - 2, 349 - y2 + 2, Colour)
end Border

procedure Centre (Word : string, Row : int)
    var Length, Column : int
    Length := length (Word)
    Column := (80 - Length) div 2
    locate (Row, Column)
    put Word ..
end Centre

procedure Get_Input (var Input : string (1), Limitations : string)
    screen ( - 2)
    screen ( - 3)
    var Flag := false
    loop
	getch (Input)
	if index (Limitations, Input) not= 0 then
	    Flag := true
	end if
	exit when Flag
    end loop
    screen (2)
    screen (3)
end Get_Input

procedure Erase_Line (Row : int)
    locate (Row, 1)
    for x : 1 .. 79
	put " " ..
    end for
    locate (Row, 1)
end Erase_Line

procedure Highlight (x : int, Word : string)
    locate (9 + x, 23)
    colorback (1)
    color (7)
    put Word ..
    locate (9 + x, 63)
    colorback (0)
    put "" ..
end Highlight

procedure Lowlight (x : int, Word : string)
    locate (9 + x, 23)
    colorback (0)
    color (7)
    put Word ..
end Lowlight

var Blank : array 1 .. 150 of int
var Valid := true
var Word : array 1 .. 4 of string (40)
var Line := 1
var Input : string (1)
var Character : int
var Pattern := 1
var Exit_Flag := false
var Quit := false
Word (1) := "1. Start Game  "
Word (2) := "2. Lemieux vs. Gretzky  "
Word (3) := "3. Help     "
Word (4) := "4. Exit    "
loop
    Quit := false
    Exit_Flag := false
    Line := 1
    Valid := true
    setscreen ("text")
    Draw_A_Border (1, 1, 4, 79, 7)
    Draw_A_Border (7, 15, 15, 63, 7)
    color (7)
    for x : 1 .. 4
	locate (9 + x, 23)
	put Word (x) ..
    end for
    Centre ("NHL Trivia", 2)
    Centre ("By : Most Outrageous Games", 3)
    Centre ("M A I N   M E N U", 8)
    Centre ("Use the cursor keys " + chr (23) + " to select item", 22)
    Centre ("Use the cursor keys " + chr (27) + chr (26) +
	" to change values", 23)
    Highlight (Line, Word (Line))
    setscreen ("nocursor,noecho")
    loop
	% Start of the Main - Menu
	getch (Input)
	Character := ord (Input)
	exit when Character = 27
	Lowlight (Line, Word (Line))
	case Character of
	    label 200 :
		if Line > 1 then
		    Line -= 1
		else
		    Line := 4
		end if
	    label 208 :
		if Line < 4 then
		    Line += 1
		else
		    Line := 1
		end if
	    label 203 :
		if Line = 1 then
			
		elsif Line = 2 then
		    if Pattern > 1 then
			Pattern := Pattern - 1
		    end if
		end if
	    label 205 :
		if Line = 1 then
			
		elsif Line = 2 then
		    if Pattern < 2 then
			Pattern := Pattern + 1
		    end if
		end if
	    label 10 :
		if Line = 3 then
	       cls
color (6)
locate (2, 25)
put "Help"
put ""
color (9)
put "   When making spaces, you have to use the _ symbol. "
put "example=mario_lemieux or detroit_red_wings or montreal_canadiens"
put "Please keep all the Files of this game in ONE directory or else"
put "the game will not work properly, especially the .tm2 files.Thanx"
put "Hope You Have Fun Playing NHL Trivia by: Most Outrageous Games"
var ech : string (1)
getch (ech)
setscreen ("graphics:v16,noecho,nocursor")
cls
		    Exit_Flag := true
		elsif Line = 4 then
		    Exit_Flag := true
		    Quit := true
		end if
	    label :
		play ("<<8f+>>")
	end case
	Word (1) := "1. Start Game  "
	Word (2) := "2. Lemieux vs. Gretzky  "
	Highlight (Line, Word (Line))
	exit when Exit_Flag
    end loop
    exit when Quit
    setscreen ("graphics:e16")
    takepic (78, 132, 200, 139, Blank)
    cls
    Border (1, 5, 639, 45, 7)
    Centre ("Help", 2)
    Centre ("NHL Trivia", 3)
setscreen ("text")
Centre ("Thank You For Playing NHL Trivia", 12)
end loop
