/* Simple graphics demo
   Ric Holt  ---   May 92

   A stick with ends at (x1, y1) and (x2, y2) is bounced off the edges of
   the screen.  Vertical and horizontal reflections of the stick are drawn.

   The stick's color is determined by its x1 location.

*/

setscreen("graphics:e16,noecho,nocursor")
var dx1 := 3
var dy1 := 4
var dx2 := 5
var dy2 := 6
var x1, y1, x2, y2 := 25

proc flipIfOutOfBounds (var delta : int, z, bound: int)
	if z < 0 or z > bound then delta := -delta end if
end flipIfOutOfBounds

for i: 1 .. 250
	flipIfOutOfBounds (dx1, x1, maxx)
	flipIfOutOfBounds (dy1, y1, maxy)
	flipIfOutOfBounds (dx2, x2, maxx)
	flipIfOutOfBounds (dy2, y2, maxy)

	x1 += dx1
	y1 += dy1
	x2 += dx2
	y2 += dy2

	const Color := (x1 div 30) mod maxcolour + 1
	drawline (x1, y1, x2, y2, Color)
	drawline (maxx - x1, y1, maxx - x2, y2, Color)
	drawline (x1, maxy - y1, x2, maxy - y2, Color)
	drawline (maxx - x1, maxy - y1, maxx - x2, maxy - y2, Color)
end for

