setscreen ("graphics:svga")
const initspeed : real := ( (sqrt (.25 + 20 * maxy) - .5) / 10) - 0.2
const mintime : int := round (10 * initspeed + 1)
const maxtime : int := 2 * mintime - 5
const intro : string := "    FireWorks!"
const start : int := max (1, floor ( (maxcol - length (intro)) / 2))
const moveDelay := 0
const explodeDelay := 0
const endDelay := 0
procedure explosion (x, y : int)
    var clr : int
    randint (clr, maxcolour div 2 + 2, maxcolour)
    sound (10 + y div 2, 200)
    drawdot (x, y + 1, clr)
    drawdot (x + 1, y + 1, clr)
    drawdot (x + 1, y - 1, clr)
    drawdot (x, y - 1, clr)
    drawdot (x - 1, y, clr)
    drawdot (x - 1, y + 1, clr)
    delay (explodeDelay)
    drawdot (x, y + 2, clr)
    drawdot (x + 2, y + 2, clr)
    drawdot (x + 2, y - 2, clr)
    drawdot (x, y - 2, clr)
    drawdot (x - 2, y, clr)
    drawdot (x - 2, y + 2, clr)
    delay (explodeDelay)
    drawdot (x, y + 3, clr)
    drawdot (x + 3, y + 3, clr)
    drawdot (x + 3, y - 3, clr)
    drawdot (x, y - 3, clr)
    drawdot (x - 3, y, clr)
    drawdot (x - 3, y + 3, clr)
    delay (explodeDelay)
    drawdot (x + 4, y - 4, clr)
    drawdot (x, y - 4, clr)
    drawdot (x + 4, y + 3, clr)
    drawdot (x + 4, y - 5, clr)
    drawdot (x, y - 5, clr)
    drawdot (x - 4, y - 1, clr)
    drawdot (x - 4, y + 3, clr)
    delay (explodeDelay)
    drawdot (x + 5, y - 6, clr)
    drawdot (x, y - 6, clr)
    drawdot (x, y + 4, clr)
    drawdot (x + 5, y + 3, clr)
    drawdot (x + 5, y - 7, clr)
    drawdot (x, y - 7, clr)
    drawdot (x - 5, y - 2, clr)
    drawdot (x - 5, y + 3, clr)
    delay (explodeDelay)
    drawdot (x + 6, y - 8, clr)
    drawdot (x, y - 8, clr)
    drawdot (x + 6, y + 2, clr)
    drawdot (x + 6, y - 9, clr)
    drawdot (x, y - 9, clr)
    drawdot (x - 6, y - 3, clr)
    drawdot (x - 6, y + 2, clr)
    delay (explodeDelay)
    drawdot (x + 6, y - 10, clr)
    drawdot (x, y - 10, clr)
    drawdot (x + 7, y - 11, clr)
    drawdot (x, y - 11, clr)
    drawdot (x + 7, y + 2, clr)
    drawdot (x + 7, y - 12, clr)
    drawdot (x, y - 12, clr)
    drawdot (x - 7, y - 4, clr)
    drawdot (x - 7, y + 2, clr)
    delay (explodeDelay)
end explosion
var ang, fusetime : int
var clr : int := 1
var x, y, vx, vy, nx, ny : real
randomize
loop
    cls
    locate (1, start)
    put intro ..
    clr := clr mod maxcolour + 1
    drawline (0, 0, maxx, 0, clr)
    clr := clr mod maxcolour + 1
    rand (x)
    x := x * maxx
    y := 0
    loop
	exit when hasch
	randint (ang, 70, 110)
	vx := cosd (ang) * initspeed
	vy := sind (ang) * initspeed
	randint (fusetime, mintime, maxtime)
	const finalx := x + (vx * fusetime)
	exit when 5 < finalx and finalx < maxx - 5 and ang not= 90
    end loop
    for : 1 .. fusetime
	exit when hasch
	delay (moveDelay)
	nx := x + vx
	ny := y + vy
	drawline (round (x), round (y), round (nx), round (ny), clr)
	vy -= 0.1
	x := nx
	y := ny
	exit when x < 0 or x > maxx
    end for
    var num : int
    randint (num, 1, 3)
    explosion (round (x), round (y))
    if num > 1 then
	explosion (round (x + 20), round (y - 20))
    end if
    if num > 2 then
	explosion (round (x - 20), round (y - 20))
    end if
    exit when hasch
    delay (endDelay)
end loop

