%******************************************************************************
% Programmer: Jeff Nosal                                                      *
% Date Due: January, 21, 1998                                                 *
% File Name: BJ!!!                                                            *
% Problem: Create Your Own Game - Black Jack                                  *
% Purpose: To create a version of the popular card game Black Jack in turing  *
% Limitations : The limitations to this game are that the cards don't get     *
%               dealt from player to dealer to player to dealer, they go all  *
%               player then all dealer. This program isn't able to be run     *
%               the keyboard.                                                 *
%******************************************************************************

setscreen ("graphics:vga")
setscreen ("nocursor")
mouseshow

% ***********************************

procedure Instructions
    % Calls on Instruction's located in another file and displays them line by line
    var fn : int
    var line : string (85)
    open : fn, "instruct.txt", get
    assert fn > 0
    loop
	exit when eof (fn)
	get : fn, line : *
	put line
	delay (1000)
    end loop
    close : fn
end Instructions


procedure drawcards_user (cards : int, value : string)
    % Accepts the card value the user's card has and how many cards the
    % user has and draws the card accordingly
    colour (7)
    case cards of
	label 1 : % First card - user
	    drawbox (304, 468, 424, 316, 4)
	    locate (2, 40)
	    put value ..
	    if value = "10" then
		locate (10, 51)
		put value ..
	    else
		locate (10, 52)
		put value ..
	    end if

	label 2 : % Second card - user
	    drawbox (280, 468, 304, 316, 4)
	    locate (2, 37)
	    put value ..

	label 3 : % Third card - user
	    drawbox (256, 468, 280, 316, 4)
	    locate (2, 34)
	    put value ..

	label 4 : % Fourth card - user
	    drawbox (232, 468, 256, 316, 4)
	    locate (2, 31)
	    put value ..

	label 5 : % Fifth card - user
	    drawbox (208, 468, 232, 316, 4)
	    locate (2, 28)
	    put value ..

	label 6 : % Sixth card - user
	    drawbox (184, 468, 208, 316, 4)
	    locate (2, 25)
	    put value ..
    end case
end drawcards_user


procedure drawcards_dealer (cards : int, value : string)
    % Accepts the card value the dealer's card has and how many cards the
    % dealer has and draws the card accordingly
    colour (7)
    case cards of
	label 1 : % First card - dealer
	    drawbox (304, 164, 424, 12, 4)
	    if value = "10" then
		locate (29, 51)
	    else
		locate (29, 52)
	    end if
	    put value ..
	    locate (21, 40)
	    put value ..

	label 2 : % Second card - dealer
	    drawbox (280, 164, 304, 12, 4)
	    locate (21, 37)
	    put value ..

	label 3 : % Third card - dealer
	    drawbox (256, 164, 280, 12, 4)
	    locate (21, 34)
	    put value ..

	label 4 : % Fourth card - dealer
	    drawbox (232, 164, 256, 12, 4)
	    locate (21, 31)
	    put value ..

	label 5 : % Fifth card - dealer
	    drawbox (208, 164, 232, 12, 4)
	    locate (21, 28)
	    put value ..

	label 6 : % Sixth card - dealer
	    drawbox (184, 164, 208, 12, 4)
	    locate (21, 25)
	    put value ..
    end case
end drawcards_dealer

procedure drawplayers (player : string, choice : int)
    % Determines which player the user has selected and draws them
    % Each label represents a different character with a different appearance
    var dealershift : int

    if player = "dealer" then
	dealershift := 316
    else
	dealershift := 0
    end if
    case choice of
	label 1 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfillbox (517, 430 - dealershift, 577, 450 - dealershift, 6)
	    % hair
	    drawfilloval (547, 395 - dealershift, 42, 50, 8) % head
	    drawfilloval (537, 410 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 410 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 410 - dealershift, 4, 7, 0) % right eye
	    drawfilloval (531, 410 - dealershift, 4, 7, 0) % left eye
	    drawfilloval (547, 385 - dealershift, 5, 15, 4) % nose
	    drawfilloval (547, 360 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 365 - dealershift, 15, 5, 8) % mouth
	    drawfilloval (503, 400 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 400 - dealershift, 5, 15, 8) % right ear
	    drawfillbox (517, 442 - dealershift, 577, 450 - dealershift, 6)
	    % hair

	label 2 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfilloval (547, 400 - dealershift, 42, 50, 6) % hair
	    drawfilloval (547, 392 - dealershift, 42, 50, 8) % head
	    drawfilloval (537, 407 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 407 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 407 - dealershift, 4, 7, 0) % right eye
	    drawfilloval (531, 407 - dealershift, 4, 7, 0) % left eye
	    drawfilloval (547, 357 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 365 - dealershift, 15, 6, 8) % mouth
	    drawfilloval (547, 385 - dealershift, 5, 15, 4) % nose
	    drawfilloval (503, 397 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 397 - dealershift, 5, 15, 8) % right ear
	    drawfilloval (547, 435 - dealershift, 50, 10, 3) % hat
	    drawfilloval (532, 450 - dealershift, 15, 7, 3) % hat
	    drawfilloval (562, 450 - dealershift, 15, 7, 3) % hat
	    drawfillbox (517, 435 - dealershift, 577, 450 - dealershift, 11)
	    % hat

	label 3 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfilloval (547, 412 - dealershift, 42, 45, 14) % hair
	    drawfillbox (507, 422 - dealershift, 587, 347 - dealershift, 14)
	    % hair
	    drawfilloval (547, 392 - dealershift, 42, 50, 8) % head
	    for x : 523 .. 543 by 3 % left eye lashes
		drawline (537, 407 - dealershift, x, 427 - dealershift, 0)
	    end for
	    for decreasing x : 571 .. 551 by 3 % right eye lashes
		drawline (557, 407 - dealershift, x, 427 - dealershift, 0)
	    end for
	    drawfilloval (537, 407 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 407 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 407 - dealershift, 4, 7, 1) % right eye
	    drawfilloval (531, 407 - dealershift, 4, 7, 1) % left eye
	    drawfilloval (547, 357 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 365 - dealershift, 15, 6, 8) % mouth
	    drawfilloval (547, 384 - dealershift, 5, 13, 4) % nose
	    drawfilloval (503, 397 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 397 - dealershift, 5, 15, 8) % right ear
	    drawfillbox (527, 439 - dealershift, 567, 447 - dealershift, 14)
	    % hair

	label 4 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfilloval (547, 410 - dealershift, 47, 50, 4) % hair
	    drawfilloval (547, 391 - dealershift, 42, 50, 8) % head
	    drawfilloval (537, 406 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 406 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 406 - dealershift, 4, 7, 1) % right eye
	    drawfilloval (531, 406 - dealershift, 4, 7, 1) % left eye
	    drawfilloval (547, 382 - dealershift, 5, 15, 4) % nose
	    drawfilloval (547, 356 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 361 - dealershift, 15, 5, 8) % mouth
	    drawfilloval (503, 396 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 396 - dealershift, 5, 15, 8) % right ear
	    drawfillbox (515, 435 - dealershift, 579, 445 - dealershift, 4)
	    % hair

	label 5 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfilloval (547, 392 - dealershift, 42, 50, 8) % head
	    drawfilloval (537, 407 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 407 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 407 - dealershift, 4, 7, 0) % right eye
	    drawfilloval (531, 407 - dealershift, 4, 7, 0) % left eye
	    drawfilloval (547, 357 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 362 - dealershift, 15, 5, 8) % mouth
	    if dealershift = 0 then
		var x : array 1 .. 8 of int := init (547, 538, 530, 538, 547,
		    556, 564, 556) % mustache
		var y : array 1 .. 8 of int := init (379, 369, 374, 362, 364,
		    362, 374, 369) % mustache
		drawfillpolygon (x, y, 8, 0) % mustache
	    elsif dealershift = 316 then
		var x : array 1 .. 8 of int := init (547, 538, 530, 538, 547,
		    556, 564, 556) % mustache
		var y : array 1 .. 8 of int := init (63, 53, 58, 46, 48,
		    46, 58, 53) % mustache
		drawfillpolygon (x, y, 8, 0) % mustache
	    end if
	    drawfilloval (547, 382 - dealershift, 5, 15, 4) % nose
	    drawfilloval (503, 397 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 397 - dealershift, 5, 15, 8) % right ear
	    drawfillbox (517, 429 - dealershift, 577, 447 - dealershift, 7)
	    drawfilloval (547, 447 - dealershift, 18, 10, 7)
	    drawfilloval (524, 447 - dealershift, 18, 10, 7)
	    drawfilloval (570, 447 - dealershift, 18, 10, 7)

	label 6 :
	    drawbox (490, 328 - dealershift, 604, 468 - dealershift, 9)
	    drawfilloval (534, 412 - dealershift, 29, 37, 6) % hair
	    drawfilloval (560, 412 - dealershift, 29, 37, 6) % hair
	    drawfillbox (507, 422 - dealershift, 587, 350 - dealershift, 6)
	    % hair
	    drawfilloval (547, 392 - dealershift, 42, 50, 8) % head
	    for x : 523 .. 543 by 3 % left eye lashes
		drawline (537, 407 - dealershift, x, 427 - dealershift, 0)
	    end for
	    for decreasing x : 571 .. 551 by 3 % right eye lashes
		drawline (557, 407 - dealershift, x, 427 - dealershift, 0)
	    end for
	    drawfilloval (537, 407 - dealershift, 10, 15, 7) % left eye
	    drawfilloval (557, 407 - dealershift, 10, 15, 7) % right eye
	    drawfilloval (551, 407 - dealershift, 4, 7, 1) % right eye
	    drawfilloval (531, 407 - dealershift, 4, 7, 1) % left eye
	    drawfilloval (547, 357 - dealershift, 15, 5, 7) % mouth
	    drawfilloval (547, 365 - dealershift, 15, 6, 8) % mouth
	    drawfilloval (547, 384 - dealershift, 5, 13, 4) % nose
	    drawfilloval (503, 397 - dealershift, 5, 15, 8) % left ear
	    drawfilloval (591, 397 - dealershift, 5, 15, 8) % right ear
	    drawfillbox (527, 439 - dealershift, 567, 443 - dealershift, 6)
	    % hair
    end case
end drawplayers

procedure Draw_Suit_User (suit : int)
    % Distinguishes which suit the card is and draws the suit
    case suit of
	label 1 : % Clubs
	    drawfilloval (364, 412, 18, 18, 8)
	    drawfilloval (380, 383, 18, 18, 8)
	    drawfilloval (348, 383, 18, 18, 8)
	    drawfillbox (361, 405, 367, 355, 8)

	label 2 : % Hearts
	    drawfilloval (348, 407, 19, 19, 4)
	    drawfilloval (380, 407, 19, 19, 4)
	    var x : array 1 .. 4 of int := init (330, 364, 398, 364)
	    var y : array 1 .. 4 of int := init (398, 359, 398, 414)
	    drawfillpolygon (x, y, 4, 4)

	label 3 : % Spades
	    var x : array 1 .. 4 of int := init (335, 364, 393, 364)
	    var y : array 1 .. 4 of int := init (398, 388, 398, 429)
	    drawfillpolygon (x, y, 4, 8)
	    drawfilloval (377, 388, 18, 20, 8)
	    drawfilloval (351, 388, 18, 20, 8)
	    drawfillbox (362, 388, 366, 356, 8)

	label 4 : % Diamonds
	    var x : array 1 .. 4 of int := init (334, 364, 392, 364)
	    var y : array 1 .. 4 of int := init (392, 352, 392, 432)
	    drawfillpolygon (x, y, 4, 4)
    end case
end Draw_Suit_User

procedure Draw_Suit_Dealer (suit : int)
    % Distinguishes which suit the card is and then draws the suit
    case suit of
	label 1 : % Clubs
	    drawfilloval (364, 108, 18, 18, 8)
	    drawfilloval (380, 79, 18, 18, 8)
	    drawfilloval (348, 79, 18, 18, 8)
	    drawfillbox (361, 101, 367, 47, 8)

	label 2 : % Hearts
	    drawfilloval (348, 103, 19, 19, 4)
	    drawfilloval (380, 103, 19, 19, 4)
	    var x : array 1 .. 4 of int := init (330, 364, 398, 364)
	    var y : array 1 .. 4 of int := init (94, 55, 94, 110)
	    drawfillpolygon (x, y, 4, 4)

	label 3 : % Spades
	    var x : array 1 .. 4 of int := init (335, 364, 393, 364)
	    var y : array 1 .. 4 of int := init (94, 84, 94, 125)
	    drawfillpolygon (x, y, 4, 8)
	    drawfilloval (377, 84, 18, 20, 8)
	    drawfilloval (351, 84, 18, 20, 8)
	    drawfillbox (362, 84, 366, 52, 8)

	label 4 : % Diamonds
	    var x : array 1 .. 4 of int := init (334, 364, 392, 364)
	    var y : array 1 .. 4 of int := init (88, 48, 88, 128)
	    drawfillpolygon (x, y, 4, 4)
    end case
end Draw_Suit_Dealer


procedure Border % Draws border of suits for opening screen
    var heart, diamond, spade, club : string (1)
    heart := chr (3)
    diamond := chr (4)
    club := chr (5)
    spade := chr (6)
    colour (4)
    locate (1, 1)
    put repeat (heart, 80)
    locate (29, 1)
    put repeat (heart, 80)
    colour (8)
    locate (2, 2)
    put repeat (club, 78)
    locate (28, 2)
    put repeat (club, 78)
    colour (4)
    locate (3, 3)
    put repeat (diamond, 76)
    locate (27, 3)
    put repeat (diamond, 76)
    colour (8)
    locate (4, 4)
    put repeat (spade, 74)
    locate (26, 4)
    put repeat (spade, 74)
    colour (4)
    for x : 2 .. 28
	locate (x, 1)
	put heart ..
	locate (x, 80)
	put heart ..
    end for
    colour (8)
    for x : 3 .. 27
	locate (x, 2)
	put club ..
	locate (x, 79)
	put club ..
    end for
    colour (4)
    for x : 4 .. 26
	locate (x, 3)
	put diamond ..
	locate (x, 78)
	put diamond ..
    end for
    colour (8)
    for x : 5 .. 25
	locate (x, 4)
	put spade ..
	locate (x, 77)
	put spade ..
    end for
end Border


procedure Draw_B % Draws B in Black jack
    drawfillbox (54, 189, 74, 289, 6)
    drawfilloval (74, 264, 20, 25, 6)
    drawfilloval (74, 214, 20, 25, 6)
    drawfilloval (76, 264, 5, 9, 0)
    drawfillbox (66, 255, 79, 273, 0)
    drawfilloval (76, 214, 5, 9, 0)
    drawfillbox (66, 205, 79, 223, 0)
end Draw_B


procedure Draw_L % Draws L in bLack jack
    drawfillbox (96, 189, 108, 289, 6)
    drawfillbox (96, 189, 132, 205, 6)
end Draw_L


procedure Draw_A % Draws A in blAck jack
    drawfillbox (134, 189, 174, 259, 6)
    drawfilloval (154, 259, 20, 30, 6)
    drawfilloval (154, 259, 4, 14, 0)
    drawfillbox (150, 245, 158, 259, 0)
    drawfillbox (150, 189, 158, 223, 0)
end Draw_A


procedure Draw_C % Draws C in blaCk jack
    drawfilloval (196, 239, 20, 50, 6)
    drawfilloval (196, 239, 4, 34, 0)
    drawfillbox (196, 227, 216, 251, 0)
end Draw_C


procedure Draw_K % Draws K in blacK jack
    drawfillbox (218, 189, 230, 289, 6)
    var x : array 1 .. 7 of int := init (230, 246, 258, 238, 258, 246,
	230)
    var y : array 1 .. 7 of int := init (251, 289, 289, 239, 189, 189,
	227)
    drawfillpolygon (x, y, 7, 6)
end Draw_K


procedure Draw_J % Draws J in black Jack
    drawfilloval (427, 219, 20, 30, 6)
    drawfilloval (427, 219, 4, 14, 0)
    drawfillbox (407, 227, 432, 289, 0)
    drawfillbox (432, 227, 447, 289, 6)
end Draw_J


procedure Draw_a % Draws A in black jAck
    drawfillbox (449, 189, 489, 259, 6)
    drawfilloval (469, 259, 20, 30, 6)
    drawfilloval (469, 259, 4, 14, 0)
    drawfillbox (465, 245, 473, 259, 0)
    drawfillbox (465, 189, 473, 223, 0)
end Draw_a


procedure Draw_c % Draws C in black jaCk
    drawfilloval (511, 239, 20, 50, 6)
    drawfilloval (511, 239, 4, 34, 0)
    drawfillbox (511, 227, 531, 251, 0)
end Draw_c


procedure Draw_k % Draws K in black jacK
    drawfillbox (533, 189, 545, 289, 6)
    var x : array 1 .. 7 of int := init (545, 561, 573, 553, 573, 561,
	545)
    var y : array 1 .. 7 of int := init (251, 289, 289, 239, 189, 189,
	227)
    drawfillpolygon (x, y, 7, 6)
end Draw_k


procedure Title_Cards % Draws Cards for opening screen
    drawbox (280, 320, 400, 158, 4)
    drawfilloval (340, 260, 20, 20, 8)
    drawfilloval (358, 230, 20, 20, 8)
    drawfilloval (322, 230, 20, 20, 8)
    drawfillbox (337, 230, 343, 198, 8)

    colour (7)
    locate (11, 37)
    put "A" ..
    locate (20, 49)
    put "A" ..

    drawline (265, 178, 265, 340, 4)
    drawline (265, 178, 280, 178, 4)
    drawline (265, 340, 385, 340, 4)
    drawline (385, 340, 385, 320, 4)

    locate (10, 35)
    put "J" ..
end Title_Cards


procedure Title_Extras
    % puts to the screen all the title extras like the instructions box and creator
    var x, y, button : int
    colour (1)
    locate (20, 53)
    put "Made By: Jeff Nosal" ..
    drawbox (408, 85, 600, 120, 13)
    colour (12)
    locate (24, 53)
    put "CLICK HERE TO CONTINUE" ..
    drawbox (40, 85, 270, 120, 13)
    locate (24, 7)
    put "CLICK HERE FOR INSTRUCTIONS" ..
end Title_Extras


procedure Title_Screen
    % calls on all the procedures needed for opening screen
    Title_Cards
    Draw_B
    Draw_L
    Draw_A
    Draw_C
    Draw_K
    Draw_J
    Draw_a
    Draw_c
    Draw_k
    Border
    Title_Extras
end Title_Screen


procedure Main_Screen
    drawfillbox (12, 173, 126, 325, 15) % Draws Hit Box
    drawfillmapleleaf (22, 202, 116, 296, 4)
    drawbox (12, 173, 126, 325, 4)
    drawbox (13, 174, 125, 324, 4)
    drawline (14, 171, 128, 171, 4)
    drawline (16, 169, 130, 169, 4)
    drawline (18, 167, 132, 167, 4)
    drawline (20, 165, 134, 165, 4)
    drawline (22, 163, 136, 163, 4)
    drawline (24, 161, 138, 161, 4)
    drawline (26, 159, 140, 159, 4)
    drawline (128, 323, 128, 171, 4)
    drawline (130, 321, 130, 169, 4)
    drawline (132, 319, 132, 167, 4)
    drawline (134, 317, 134, 165, 4)
    drawline (136, 315, 136, 163, 4)
    drawline (138, 313, 138, 161, 4)
    drawline (140, 311, 140, 159, 4)
    drawline (12, 173, 26, 159, 4)
    drawline (126, 325, 140, 311, 4)

    drawfillbox (12, 150, 140, 12, 4) % Draws Stay Box
    drawfillstar (22, 22, 130, 140, 1)
    drawfillstar (32, 32, 120, 130, 2)
    drawfillstar (42, 42, 110, 120, 3)
    drawfillstar (52, 52, 100, 110, 5)
    drawfillstar (62, 62, 90, 100, 6)

    drawbox (10, 346, 145, 472, 9) % Draws Chip box
    drawbox (9, 345, 146, 473, 9)
    drawline (10, 440, 145, 440, 9)
    drawline (10, 409, 145, 409, 9)
    drawline (10, 378, 145, 378, 9)
    drawline (83, 347, 83, 472, 9)
    drawline (82, 347, 82, 472, 9)

    drawfilloval (46, 422, 25, 8, 4) % Draws Chips
    drawfilloval (46, 426, 25, 8, 12)
    drawfilloval (46, 391, 25, 8, 1)
    drawfilloval (46, 395, 25, 8, 9)
    drawfilloval (46, 360, 25, 8, 3)
    drawfilloval (46, 364, 25, 8, 11)

    colour (7) % puts labels on chip box
    locate (2, 5)
    put "Chip" ..
    locate (2, 13)
    put "Value" ..
    locate (4, 13)
    put "$1000" ..
    locate (6, 13)
    put "$100" ..
    locate (8, 13)
    put "$10" ..

    drawbox (450, 190, 620, 290, 1) % Draws What's Next box
    locate (13, 61)
    put "What's Next" ..
    locate (14, 61)
    put "-----------" ..

    drawbox (200, 170, 400, 310, 1)
    % Draws box containing information about the game
    locate (12, 33)
    put "Game Status" ..
    locate (13, 28)
    put "----------------------" ..
    locate (15, 28)
    put "Your Wallet: $" ..
    locate (16, 28)
    put "Current Wager: $" ..
    locate (17, 28)
    put "Your Score: " ..
    locate (18, 28)
    put "Dealer's Score: " ..
end Main_Screen

procedure clear_whatsnext % This cleans out the What's Next box
    for y : 15 .. 18
	locate (y, 58)
	put repeat (" ", 20) ..
    end for
end clear_whatsnext

%******************************************************************************
%************************* Main Program ***************************************
%******************************************************************************

% variables
var card_value, card_suit, user_score, dealer_score, ace_flag, fn : int
var card_count, hand_count, money, wager, user, dealer, user_cardcount : int
var deck : array 1 .. 4, 1 .. 13 of string % contains cards
var check : array 1 .. 4, 1 .. 13 of int
% array checks whether the card has already been used
var hitme : boolean
var x, y, button : int % variables for mousewhere

%*****************************************************************************

hand_count := 0
card_count := 0
wager := 0
money := 5000 % Initializes the amount of money you get
open : fn, "cards.jef", get % opens the file containing the cards
assert fn > 0

for suit : 1 .. 4
    for card : 1 .. 13
	get : fn, deck (suit, card)
    end for
end for


randomize

Title_Screen % Brings up the title screen
loop
    % Decides whether you want to go straight to the game or read the instructions first
    mousewhere (x, y, button)
    if x >= 408 and x <= 600 and y >= 85 and y <= 120 and button = 1 then
	exit
    elsif x >= 40 and x <= 270 and y >= 85 and y <= 120 and button = 1 then
	colour (7)
	cls
	Instructions % Calls up instruction file
	loop
	    % Allows you to go to the game when you are ready by clicking the mouse button
	    mousewhere (x, y, button)
	    exit when button = 1
	end loop
	exit
    end if
end loop
cls

% ***Player Selection % Let's you choose which player you wish to be
user := 1
dealer := 1

% User Selection
locate (1, 1)
put "Please Select A Player To Be You" ..
drawbox (20, 250, 300, 400, 2) % Draws OK box
locate (10, 20)
put "OK" ..
drawbox (20, 200, 300, 50, 2) % Draws NEXT box
locate (23, 19)
put "NEXT" ..
drawplayers ("user", 1) % Draws first user option

loop % Determines which player you wish to be
    mousewhere (x, y, button)
    if x > 20 and x <= 300 and y >= 250 and y <= 400 and button = 1 then
	user := user
	delay (200)
	exit
    elsif x >= 20 and x <= 300 and y <= 200 and y >= 50 and button = 1 then
	drawfillbox (490, 328, 604, 468, 0) % covers up previous selection
	user := user + 1
	if user = 7 then
	    user := 1
	end if
	drawplayers ("user", user)
	delay (200)
    end if
end loop

% Dealer Selection
locate (1, 1)
put "Please Select A Player To Be The Dealer" ..
drawbox (20, 250, 300, 400, 2) % Draws OK box
locate (10, 20)
put "OK" ..
drawbox (20, 200, 300, 50, 2) % Draws NEXT box
locate (23, 19)
put "NEXT" ..
drawplayers ("user", user) % Draws the player the user chose to be
drawplayers ("dealer", 1) % Draws first dealer option

loop % Determines which player you want the dealer to be
    mousewhere (x, y, button)
    if x > 20 and x <= 300 and y >= 250 and y <= 400 and button = 1 then
	dealer := dealer
	delay (200)
	exit
    elsif x >= 20 and x <= 300 and y <= 200 and y >= 50 and button = 1 then
	drawfillbox (490, 12, 604, 152, 0) % covers up previous selection
	dealer := dealer + 1
	if dealer = 7 then
	    dealer := 1
	end if
	drawplayers ("dealer", dealer)
	delay (200)
    end if
end loop

% **** Playing The Game Begins Here ***************************************
cls
loop

    % This re-sets the check to 0 so the cards can be played again
    for suit : 1 .. 4
	for card : 1 .. 13
	    check (suit, card) := 0
	end for
    end for
    delay (200)

    loop
	wager := 0 % re-sets values to 0
	user_score := 0
	ace_flag := 0
	card_count := 1 % indicates this is your first card

	Main_Screen
	drawplayers ("user", user) % draws you
	drawplayers ("dealer", dealer) % draws dealer
	locate (15, 43) % Puts the amount of money you have to the screen
	put money ..

	locate (15, 58) % Tells user what to do next (make wager)
	put "Click chip box to" ..
	locate (16, 58)
	put "make a WAGER" ..
	locate (17, 58)
	put "Click here when done" ..
	locate (18, 58)
	put "(no wager to QUIT)" ..

	loop % Gets your wager
	    mousewhere (x, y, button)
	    if button = 1 then
		if x >= 10 and x <= 145 then
		    if y > 346 and y < 378 then
			wager := wager + 10
		    elsif y > 378 and y < 409 then
			wager := wager + 100
		    elsif y > 409 and y < 440 then
			wager := wager + 1000
		    end if
		    if wager > 2000 then
			wager := 2000
		    elsif wager > money then
			wager := money
		    end if
		    locate (16, 45)
		    put wager ..
		    delay (200)
		elsif x > 450 and x < 620 and y > 190 and y < 290 then
		    exit
		end if
	    end if
	end loop
	clear_whatsnext 
	    % clears what's next box so new information can go in it
	exit when wager = 0

	locate (15, 58) % tells the user what to do next
	put "To take a hit click" ..
	locate (16, 58)
	put "the deck" ..
	locate (17, 58)
	put "To stay hit the star" ..
	locate (18, 58)
	put "(Far left of screen)" ..

	loop
	    loop
		randint (card_value, 1, 13)
		randint (card_suit, 1, 4)
		exit when check (card_suit, card_value) < 3
	    end loop
	    delay (200)
	    if card_count > 2 then
		loop % gets hit or stay from user
		    mousewhere (x, y, button)
		    exit when x > 12 and x < 126 and y > 173 and y < 325
			and button = 1 or x > 12 and x < 140 and y > 12 and
			y < 150 and button = 1
		end loop
		exit when x > 12 and x < 140 and y > 12 and y < 150 and
		    button = 1 
			% ends user turn if user is satisfied with cards
		if y > 173 and y < 325 and x > 12 and x < 140 and button
			= 1 then

		    drawcards_user (card_count, deck (card_suit,
			card_value)) % draws user's next card

		    check (card_suit, card_value) := check (card_suit,
			card_value) + 1 
			    % indicates that the user's card has now been used

		    card_count := card_count + 1 
			% increases the card count by 1
		end if
	    else
		drawcards_user (card_count, deck (card_suit, card_value))
		% draws user's next card
		if card_count = 1 then
		    Draw_Suit_User (card_suit)
		end if
		card_count := card_count + 1 % increases card count by 1
	    end if


	    if card_value = 1 then 
		% adds 11 points to the score and marks down that you have an ace
		user_score := user_score + 11
		ace_flag := ace_flag + 1
	    elsif card_value >= 10 then
		% if you have a 10 or a face card this adds 10 to your total
		user_score := user_score + 10
	    else
		% adds value of card to the score
		user_score := user_score + card_value
	    end if
	    if user_score > 21 and ace_flag >= 1 then
		% determines if your score is over 21 and you have an ace
		% and if you do it takes 10 away from your total
		user_score := user_score - 10
		ace_flag := ace_flag - 1
	    end if
	    locate (17, 40)
	    put user_score .. % puts your score to the screen
	    user_cardcount := card_count
	    if user_score >= 21 or user_cardcount = 7 then % exits if you have 21 or busted
		exit
	    end if

	    delay (200)
	end loop

	clear_whatsnext % clears what's next box and tells you what to do
	locate (16, 58)
	put "Please wait while" ..
	locate (17, 58)
	put "dealer plays hand" ..

	% Dealer's Hand
	dealer_score := 0
	card_count := 1
	ace_flag := 0

	loop
	    if user_score > 21 and card_count = 3 or dealer_score > 16
		    % ends dealers turn if user busted and dealer has 2 cards
		    % or if the dealer has a score over 16
		    then exit
	    end if

	    loop % generates a card that hasn't been played
		randint (card_value, 1, 13) 
		randint (card_suit, 1, 4)
		exit when check (card_suit, card_value) < 3
	    end loop
	    delay (1000)
	    if card_count > 2 then % determines whether the dealer Hits or Stays
		drawcards_dealer (card_count, deck (card_suit,
		    card_value))
		check (card_suit, card_value) := check (card_suit,
		    card_value) + 1 % indicates card has been played
		card_count := card_count + 1 % increases card count by 1
	    else % gives dealer first two cards
		drawcards_dealer (card_count, deck (card_suit,
		    card_value))
		if card_count = 1 then
		    Draw_Suit_Dealer (card_suit)
		end if

		card_count := card_count + 1
	    end if

	    if card_value = 1 then
		% adds 11 points to the dealer's score and marks down that dealer has an ace
		dealer_score := dealer_score + 11
		ace_flag := ace_flag + 1
	    elsif card_value >= 10 then
		% if dealer has a 10 or a face card this adds 10 to their total
		dealer_score := dealer_score + 10
	    else
	       % adds value of card to the score
		dealer_score := dealer_score + card_value
	    end if
	    if dealer_score > 21 and ace_flag >= 1 then
		% determines if dealer's score is over 21 and if the dealer
		% has an ace and if dealer does it takes 10 away from the
		% dealer's total
		dealer_score := dealer_score - 10
		ace_flag := ace_flag - 1
	    end if
	    locate (18, 44)
	    put dealer_score .. % puts dealer's score to the screen
	    if dealer_score >= 21 or card_count = 7 then % ends dealer's turn if dealer has 21 or busted
		exit
	    end if
	end loop

	% Outputs winner and determines if you gained cash or lost cash
	clear_whatsnext
	locate (15, 58)
	if user_score > 21 then
	    put "Dealer Wins" ..
	    locate (16, 58)
	    put "You Lose $", wager ..
	    money := money - wager
	elsif dealer_score > 21 then
	    put "You Win" ..
	    locate (16, 58)
	    put "You Won $", wager ..
	    money := money + wager
	elsif user_cardcount = 7 then
	    put "You Win" ..
	    locate (16, 58)
	    put "You Won $", wager ..
	    money := money + wager
	elsif user_score > dealer_score then
	    put "You Win" ..
	    locate (16, 58)
	    put "You Won $", wager ..
	    money := money + wager
	else
	    put "Dealer Wins" ..
	    locate (16, 58)
	    put "You Lose $", wager ..
	    money := money - wager
	end if

	locate (15, 43) % puts your new money total to the screen
	put money ..

	locate (17, 58) % fills in What's Next box
	put "Click mouse button" ..
	locate (18, 58)
	put "to continue" ..

	loop % waits till you click the mouse button then exits
	    mousewhere (x, y, button)
	    exit when button = 1
	end loop

	cls
	exit when money = 0 % exits loop if you are out of money
	hand_count := hand_count + 1 %increases hand total
	exit when hand_count = 15
	% exits loop to re-shuffle the deck after 15 hands
    end loop
    exit when wager = 0 or money = 0
    % exits game if you are out of money or chose to quit (no wager - 0)
end loop

% Displays end comment(s)
cls
colour (14)
locate (1, 1)
put "THANK YOU FOR PLAYING BLACK JACK BY JEFF NOSAL"
if money = 0 then
    colour (12)
    put
	"HOWEVER, I SUGGEST THAT YOU DON'T TRY YOUR LUCK AT A REAL CASINO!!!"
end if
close : fn % closes the open file (cards.jef)
