%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                         CHEMISTRY TUTORIAL  V1.0                          %
%                              ATOMIC THEORY                                %
%                                                                           %
%              PROGRAMMERS:  STEPHEN  DEVITO  AND  EDWARD  LAM              %
%              SOFTWARE:     TURING V6.0                                    %
%              HARDWARE:     IBM OR IBM COMPATIBLE COMPUTER                 %
%              DATE:         JANUARY 14, 1993                               %
%                                                                           %
% PURPOSE OF CHEMISTRY TUTORIAL V1.0: TO REVIEW  ATOMIC THEORIES COVERED IN %
%                THE GRADE 11 CHEMISTRY COURSE.  THE UNDERSTANDING OF THESE %
%                THEORIES FORMS THE BASIS  FOR UNDERSTANDING OTHER BRANCHES %
%                OF CHEMISTRY SUCH AS NUCLEAR OR ORGANIC CHEMISTRY.         %
%                                                                           %
% PURPOSE OF 'MAIN' PROGRAM:  HOLDS  ALL  OF  THE PROCEDURES THAT ARE USED  %
%         BY  MORE  THAN  ONE  OF THE  INCLUDE  FILES.  I.E.  'DRAW KEYS',  %
%         'CLOSE OPTION', 'DRAW PAGE' ETC ...  ALSO HOLDS THE MAIN MENU OF  %
%         THE PROGRAM AND CALLS UP ALL THE INCLUDE FILES.                   %
%                                                                           %
% VARIABLE LIST                                                             %
% -------------                                                             %
% reply= keeps track of what key user enters in options (Pgup, PgDn, etc...)%  %
% ch= keeps track of what key is entered by user in options                 %
% menu_reply= only used in the main program to keep track of what reply     %
%             user enters in main menu (i.e. up arrow, down arrow or return)%
% x,x1,x2,y,y2,y3,y4,y5=  integer variables to hold x and y co-ordinates    %
%                         of the screen for the specific program in which   %
%                         they are used.                                    %
% flag= variable that checks whether a certain condition is true or false   %
% check= performs same operation as flag variable.  Two variables of this   %
%        sort were needed in this program.                                  %
% option= used to keep track of which option was last entered by the user,  %
%         available options are 1-8 corresponding to the main menu.         %
% r1,r2,c1,c2=  integer variables that hold x and y co-ordinates on the     %
%               screen.  These are used in different procedures than the    %
%               previously stated x and y variables.                        %
% num, num2= variables used in the randint function to store the random     %
%            numbers generated by the function                              %
% pagenum= keeps track of what page number is being displayed for each      %
%          option.                                                          %
% row, row2= keeps track of the rows in the screen for 'test' program       %
% yi-yiv, xi-xiv= keeps track of x and y values in 'test' program           %
% count, count2= simple counter variables                                   %
% questions (array)= holds all twenty questions in 'test' program           %
% answers (array)= holds all twenty answers to the questions in 'test' prg  %
% letters (array)= lower case letters a,b,c that correspond to the answers  %
%                  in answers (array)                                       %
% letters2 (array)= upper case letters A,B,C that correspond to the answers %
%                   in the answers (array)                                  %
%                                                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
setscreen ("graphics:e16")
setscreen ("noecho,nocursor")
var reply, ch, menu_reply, helpreply : string (1)
var x, x1, x2, y, y1, y2, y3, y4, y5, flag, check, option : int
var r1, r2, c1, c2, counter, helpoption, pagenum, num, num2 : int

% clears character stored in the buffer
procedure flush
    loop
	exit when not hasch
	getch (ch)
    end loop
end flush

% graphical procedure in the main menu for the small spinning atoms
procedure spinning_atoms
    y3 := 233
    y4 := 228
    y3 := y3 - (option * 14)
    y4 := y4 - (option * 14)
    if option = 1 then
	y5 := 217
    elsif option = 2 then
	y5 := 203
    elsif option = 3 then
	y5 := 189
    elsif option = 4 then
	y3 := 170
	y4 := 165
	y5 := 168
    elsif option = 5 then
	y3 := 149
	y4 := 144
	y5 := 147
    elsif option = 6 then
	y3 := 136
	y4 := 130
	y5 := 133
    elsif option = 7 then
	y3 := 121
	y4 := 116
	y5 := 119
    elsif option = 8 then
	y3 := 107
	y4 := 102
	y5 := 105
    elsif option = 9 then
	y3 := 93
	y4 := 88
	y5 := 91
    end if
    loop % spinning atoms in menu.  The following draws and erases small
	% circles representing electrons in different places on the atom
	% to give the effect of electrons spinning around the atom
	% left atom
	drawoval (195, y3, 1, 1, 14)
	drawfill (195, y3, 14, 14)
	delay (100)
	drawfill (195, y3, 0, 0)
	drawoval (192, y5, 4, 4, 11)

	% right atom
	drawoval (441, y3, 1, 1, 14)
	drawfill (441, y3, 14, 14)
	delay (100)
	drawfill (441, y3, 0, 0)
	drawoval (438, y5, 4, 4, 11)
	exit when hasch

	% left atom
	drawoval (194, y4, 1, 1, 14)
	drawfill (194, y4, 14, 14)
	delay (100)
	drawfill (194, y4, 0, 0)
	drawoval (192, y5, 4, 4, 11)

	% right atom
	drawoval (440, y4, 1, 1, 14)
	drawfill (440, y4, 14, 14)
	delay (100)
	drawfill (440, y4, 0, 0)
	drawoval (438, y5, 4, 4, 11)
	exit when hasch

	% left atom
	drawoval (190, y4, 1, 1, 14)
	drawfill (190, y4, 14, 14)
	delay (100)
	drawfill (190, y4, 0, 0)
	drawoval (192, y5, 4, 4, 11)

	% right atom
	drawoval (436, y4, 1, 1, 14)
	drawfill (436, y4, 14, 14)
	delay (100)
	drawfill (436, y4, 0, 0)
	drawoval (438, y5, 4, 4, 11)
	exit when hasch

	% left atom
	drawoval (189, y3, 1, 1, 14)
	drawfill (189, y3, 14, 14)
	delay (100)
	drawfill (189, y3, 0, 0)
	drawoval (192, y5, 4, 4, 11)

	% right atom
	drawoval (435, y3, 1, 1, 14)
	drawfill (435, y3, 14, 14)
	delay (100)
	drawfill (435, y3, 0, 0)
	drawoval (438, y5, 4, 4, 11)
	exit when hasch
    end loop
end spinning_atoms

procedure open_mainmenu_screen % procedure opens box main menu after
    % the help option has been selected.
    x := 315
    x1 := 315
    y := 175
    y1 := 175
    for i : 1 .. 63
	x := x - 2
	x1 := x1 + 2
	if i > 52 then
	    y := y - 2
	    y1 := y1 + 2
	else
	    y := y - 1
	    y1 := y1 + 1
	end if
	drawbox (x, y, x1, y1, 2)
	drawbox (x, y, x1, y1, 2)
	drawbox (x, y, x1, y1, 2)
	drawbox (x, y, x1, y1, 2)
	drawbox (x, y, x1, y1, 0)
    end for
    drawbox (170, 76, 460, 260, 10)
    drawbox (173, 79, 457, 257, 10)
end open_mainmenu_screen

% procedure creates opening screen effect for each option
procedure open_option
    colorback (1)
    x1 := maxx div 2
    x2 := x1
    y := maxy div 2
    y2 := y
    drawbox (x1, y, x1, y, 0)
    for decreasing i : 160 .. 1
	x1 := x1 - 2
	x2 := x2 + 2
	y := y - 1
	y2 := y2 + 1
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 2)

	drawbox (x1, y, x2, y2, 0)
	drawbox (x1 + 1, y, x2 - 1, y2, 0)
    end for
    colorback (1)
end open_option

% procedure creates closing screen effect when user wishes to quit option
procedure close_option
    drawbox (0, 0, maxx, maxy, 2)
    x1 := 0
    x2 := maxx
    y := 0
    y2 := maxy
    for i : 1 .. 160
	x1 := x1 + 2
	x2 := x2 - 2
	y := y + 1
	y2 := y2 - 1
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 0)
	drawbox (x1 + 1, y, x2 - 1, y2, 0)
    end for
    locate (16, 50)
    put "         "
    locate (17, 50)
    put "         "
    locate (18, 50)
    put "         "
end close_option

% procedure gives illusion of box opening page for information on the model
% chosen by the user
procedure openpage
    x1 := 410
    x2 := x1
    y := 120
    y2 := 143
    drawbox (x1, y, x1, y, 0)
    for decreasing i : 100 .. 1
	x1 := x1 - 2
	x2 := x2 + 2
	y := y - 1
	y2 := y2 + 1
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 0)
	drawbox (x1 + 1, y, x2 - 1, y2, 0)
    end for
    drawbox (200, 20, 620, 243, 2)
end openpage

% procedure gives effect of box closing page of information to go to next
% desired page of info.
procedure close_page
    x1 := 199
    x2 := 619
    y := 21
    y2 := 242
    for i : 1 .. 100
	if i = 2 then
	    drawbox (201, 21, 619, 242, 0)
	    drawbox (202, 22, 618, 241, 0)
	end if
	x1 := x1 + 2
	x2 := x2 - 2
	y := y + 1
	y2 := y2 - 1
	drawbox (x1, y, x2, y2, 2)
	drawbox (x1, y, x2, y2, 0)
	drawbox (x1 + 1, y, x2 - 1, y2, 0)
    end for
    locate (15, 50)
    put "         "
    locate (16, 50)
    put "         "
    locate (17, 50)
    put "         "
    locate (18, 50)
    put "         "
    drawbox (201, 21, 619, 242, 0)
    drawbox (202, 22, 618, 241, 0)
    drawbox (200, 20, 620, 243, 2)
end close_page

% page procedure draws box where information will be displayed.
procedure drawpage
    x1 := 200
    x2 := 620
    drawbox (200, 20, 620, 243, 2)
    for i : 1 .. 104
	x1 := x1 + 2
	x2 := x2 - 2
	drawline (x1, 20, x1, 243, 2)
	drawline (x2, 20, x2, 243, 2)
	drawbox (200, 20, 620, 243, 2)
    end for
    for decreasing i : 105 .. 1
	x1 := x1 + 2
	x2 := x2 - 2
	drawline (x1, 20, x1, 243, 0)
	drawline (x2, 20, x2, 243, 0)
	drawbox (200, 20, 620, 243, 2)
    end for
end drawpage

% Following procedure checks to see what key the user has inputed for the
% Dalton, Rutherford, Thomson, and Wave Mechanical options.  It then gives
% the effect of that button being pushed down.
procedure pgup_pgdn
    % flag variable used to check what key has been inputted by user
    flag := 0
    loop
	if option = 2 or option = 4 or option = 5 then
	    exit when not hasch
	end if
	getch (ch)
	if ch = chr (201) then % if user enters pgup key
	    if option = 2 or option = 3 or option = 4 then
		if pagenum = 1 then
		    pagenum := 5
		else
		    pagenum := pagenum - 1
		end if
	    elsif option = 5 then
		if pagenum = 1 then
		    pagenum := 7
		else
		    pagenum := pagenum - 1
		end if
	    elsif option = 6 then
		if pagenum = 1 then
		    pagenum := 6
		else
		    pagenum := pagenum - 1
		end if
	    end if
	    drawfill (44, 93, 0, 0)
	    drawbox (48, 96, 62, 102, 5)
	    drawfill (49, 97, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (49, 97, 0, 0)
	    drawbox (43, 91, 67, 107, 13)
	    drawfill (44, 93, 13, 13)
	    delay (100)
	    if option = 5 then
		flag := 3
	    else
		flag := 1
	    end if
	elsif ch = chr (209) then % if user enters pgdn key
	    if option = 2 or option = 3 or option = 4 then
		if pagenum = 5 then
		    pagenum := 1
		else
		    pagenum := pagenum + 1
		end if
	    elsif option = 5 then
		if pagenum = 7 then
		    pagenum := 1
		else
		    pagenum := pagenum + 1
		end if
	    elsif option = 6 then
		if pagenum = 6 then
		    pagenum := 1
		else
		    pagenum := pagenum + 1
		end if
	    end if
	    drawfill (44, 43, 0, 0)
	    drawbox (48, 41, 62, 47, 5)
	    drawfill (49, 42, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (49, 42, 0, 0)
	    drawbox (43, 36, 67, 52, 13)
	    drawfill (44, 43, 13, 13)
	    delay (100)
	    flag := 1
	elsif ch = "m" or ch = "M" then % if user has inputted 'M' key
	    drawfill (105, 65, 0, 0)
	    drawbox (108, 69, 122, 75, 5)
	    drawfill (109, 70, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (109, 70, 0, 0)
	    drawbox (103, 64, 127, 80, 13)
	    drawfill (105, 65, 13, 13)
	    delay (100)
	    flag := 2
	else % if user has not entered any of the above keys
	    sound (100, 10)
	    flag := 0
	end if
	exit when flag = 1 or flag = 2 or flag = 3
    end loop
end pgup_pgdn

% Procedure checks what key was inputted by the user in Rutherford's model
% and Bohr's model.  It then gives the effect of that certain button being
% pressed downward.
procedure across_keys
    loop
	getch (reply)
	if reply = chr (209) then % if pgdn is entered
	    drawfill (100, 43, 0, 0)
	    drawbox (100, 44, 120, 56, 5)
	    drawfill (101, 45, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (101, 45, 0, 0)
	    drawbox (98, 42, 122, 58, 13)
	    drawfill (99, 43, 13, 13)
	    delay (200)
	    if option = 4 then
		pagenum := 5
	    elsif option = 5 then
		if pagenum = 7 then
		    pagenum := 1
		else
		    pagenum := pagenum + 1
		end if
	    end if
	    flag := 1
	    cls
	elsif reply = chr (201) then % if pgup is entered
	    drawfill (42, 43, 0, 0)
	    drawbox (43, 44, 63, 56, 5)
	    drawfill (44, 45, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (44, 45, 0, 0)
	    drawbox (41, 42, 65, 58, 13)
	    drawfill (42, 43, 13, 13)
	    delay (200)
	    if option = 4 then
		pagenum := 3
	    elsif option = 5 then
		if pagenum = 1 then
		    pagenum := 7
		else
		    pagenum := pagenum - 1
		end if
	    end if
	    if option = 5 then
		flag := 3
	    else
		flag := 1
	    end if
	elsif reply = "m" or reply = "m" then % if 'M' key is entered
	    drawfill (157, 43, 0, 0)
	    drawbox (157, 44, 177, 56, 5)
	    drawfill (158, 45, 5, 5)
	    sound (500, 100)
	    delay (200)
	    drawfill (158, 45, 0, 0)
	    drawbox (155, 42, 179, 58, 13)
	    drawfill (157, 43, 13, 13)
	    delay (200)
	    flag := 2
	else % if none of the above keys are entered
	    sound (100, 100)
	    flag := 0
	end if
	exit when flag = 1 or flag = 2 or flag = 3
    end loop
end across_keys

% Procedure draws the 'pgup', 'pgdn', and 'm' buttons for use with
% Bohr and Rutherford
procedure draw_keys_across
    % page up button
    color (14)
    drawbox (38, 39, 68, 61, 5)
    drawbox (41, 42, 65, 58, 13)
    drawfill (42, 43, 13, 13)
    locate (24, 6)
    put "PgUp"

    % page down button
    drawbox (95, 39, 125, 61, 5)
    drawbox (98, 42, 122, 58, 13)
    drawfill (100, 43, 13, 13)
    locate (24, 13)
    put "PgDn"

    % mainmenu button
    drawbox (152, 39, 182, 61, 5)
    drawbox (155, 42, 179, 58, 13)
    drawfill (157, 43, 13, 13)
    locate (24, 19)
    put "Main Menu (M)"
end draw_keys_across

% Procedure draws the 'pgup', 'pgdn', and 'm' buttons for use with
% Dalton, Thomson, Bohr, and Rutherford models.
procedure draw_keys
    % page up button
    color (14)
    drawbox (40, 88, 70, 110, 5)
    drawbox (43, 91, 67, 107, 13)
    drawfill (44, 93, 13, 13)
    locate (20, 6)
    put "PgUp"

    % page down button
    drawbox (40, 33, 70, 55, 5)
    drawbox (43, 36, 67, 52, 13)
    drawfill (44, 43, 13, 13)
    locate (24, 6)
    put "PgDn"

    % mainmenu button
    drawbox (100, 61, 130, 83, 5)
    drawbox (103, 64, 127, 80, 13)
    drawfill (105, 65, 13, 13)
    locate (22, 12)
    put "Main Menu (M)"
end draw_keys

% checks to see where the cursor is on the main menu, and draws the two atoms
% that are used as pointers on  the  main  menu  screen  so that the computer
% will know which option the user is choosing.
procedure menu_option
    drawbox (170, 76, 460, 260, 10)
    drawbox (173, 79, 457, 257, 10)
    if option = 1 then
	if menu_reply = chr (208) then
	    locate (19, 24)
	    put "  "
	    locate (19, 55)
	    put "  "
	    color (10)
	    locate (19, 38)
	    put "Quit"
	else
	    locate (11, 24)
	    put "  "
	    locate (11, 55)
	    put "  "
	    locate (11, 33)
	    color (10)
	    put "Dalton's Model"
	end if
	color (2)
	locate (10, 34)
	put "Greek  Model"
	% atoms for "greek model"
	drawoval (192, 217, 4, 4, 11)
	drawoval (192, 217, 1, 1, 4)
	drawfill (192, 217, 4, 4)

	drawoval (438, 217, 4, 4, 11)
	drawoval (438, 217, 1, 1, 4)
	drawfill (438, 217, 4, 4)
    elsif option = 2 then
	if menu_reply = chr (208) then
	    locate (10, 24)
	    put "  "
	    locate (10, 55)
	    put "  "
	    locate (10, 34)
	    color (10)
	    put "Greek  Model"
	else
	    locate (12, 24)
	    put "  "
	    locate (12, 55)
	    put "  "
	    locate (12, 32)
	    color (10)
	    put "Thomson's  Model"
	end if
	locate (11, 33)
	color (2)
	put "Dalton's Model"
	% atoms for "dalton model"
	drawoval (192, 203, 4, 4, 11)
	drawoval (192, 203, 1, 1, 4)
	drawfill (192, 203, 4, 4)

	drawoval (438, 203, 4, 4, 11)
	drawoval (438, 203, 1, 1, 4)
	drawfill (438, 203, 4, 4)

    elsif option = 3 then
	if menu_reply = chr (208) then
	    locate (11, 24)
	    put "  "
	    locate (11, 55)
	    put "  "
	    locate (11, 33)
	    color (10)
	    put "Dalton's Model"
	else
	    locate (14, 24)
	    put "  "
	    locate (14, 55)
	    put "  "
	    locate (13, 24)
	    put "  "
	    locate (13, 55)
	    put "  "
	    color (10)
	    locate (13, 28)
	    put "Rutherford's  Experiment"
	    locate (14, 33)
	    put "and his  Model"
	end if
	locate (12, 32)
	color (2)
	put "Thomson's  Model"
	% atoms for "thomson model"
	drawoval (192, 189, 4, 4, 11)
	drawoval (192, 189, 1, 1, 4)
	drawfill (192, 189, 4, 4)

	drawoval (438, 189, 4, 4, 11)
	drawoval (438, 189, 1, 1, 4)
	drawfill (438, 189, 4, 4)

    elsif option = 4 then
	if menu_reply = chr (208) then
	    locate (12, 24)
	    put "  "
	    locate (12, 55)
	    put "  "
	    locate (12, 32)
	    color (10)
	    put "Thomson's  Model"
	else
	    locate (15, 24)
	    put "  "
	    locate (15, 55)
	    put "  "
	    color (10)
	    locate (15, 34)
	    put "Bohr's Model"
	end if
	color (2)
	locate (13, 28)
	put "Rutherford's  Experiment"
	locate (14, 33)
	put "and his  Model"
	% atoms for "Rutherford  Experiment"
	drawoval (192, 168, 4, 4, 11)
	drawoval (192, 168, 1, 1, 4)
	drawfill (192, 168, 4, 4)

	drawoval (438, 168, 4, 4, 11)
	drawoval (438, 168, 1, 1, 4)
	drawfill (438, 168, 4, 4)

    elsif option = 5 then
	if menu_reply = chr (208) then
	    locate (14, 24)
	    put "  "
	    locate (14, 55)
	    put "  "
	    locate (13, 24)
	    put "  "
	    locate (13, 55)
	    put "  "
	    color (10)
	    locate (13, 28)
	    put "Rutherford's  Experiment"
	    locate (14, 33)
	    put "and his  Model"
	else
	    locate (16, 24)
	    put "  "
	    locate (16, 55)
	    put "  "
	    color (10)
	    locate (16, 29)
	    put "Wave Mechanical  Model"
	end if
	locate (15, 34)
	color (2)
	put "Bohr's Model"
	% atoms for "Bohr Model"
	drawoval (192, 147, 4, 4, 11)
	drawoval (192, 147, 1, 1, 4)
	drawfill (192, 147, 4, 4)

	drawoval (438, 147, 4, 4, 11)
	drawoval (438, 147, 1, 1, 4)
	drawfill (438, 147, 4, 4)

    elsif option = 6 then
	if menu_reply = chr (208) then
	    locate (15, 24)
	    put "  "
	    locate (15, 55)
	    put "  "
	    color (10)
	    locate (15, 34)
	    put "Bohr's Model"
	else
	    locate (17, 24)
	    put "  "
	    locate (17, 55)
	    put "  "
	    color (10)
	    locate (17, 38)
	    put "Test"
	end if
	locate (16, 29)
	color (2)
	put "Wave Mechanical  Model"
	% atoms for "Wave Model"
	drawoval (192, 133, 4, 4, 11)
	drawoval (192, 133, 1, 1, 4)
	drawfill (192, 133, 4, 4)

	drawoval (438, 133, 4, 4, 11)
	drawoval (438, 133, 1, 1, 4)
	drawfill (438, 133, 4, 4)

    elsif option = 7 then
	if menu_reply = chr (208) then
	    locate (16, 24)
	    put "  "
	    locate (16, 55)
	    put "  "
	    color (10)
	    locate (16, 29)
	    put "Wave Mechanical  Model"
	else
	    locate (18, 24)
	    put "  "
	    locate (18, 55)
	    put "  "
	    color (10)
	    locate (18, 38)
	    put "Help"
	end if
	locate (17, 38)
	color (2)
	put "Test"
	% atoms for "test"
	drawoval (192, 119, 4, 4, 11)
	drawoval (192, 119, 1, 1, 4)
	drawfill (192, 119, 4, 4)

	drawoval (438, 119, 4, 4, 11)
	drawoval (438, 119, 1, 1, 4)
	drawfill (438, 119, 4, 4)

    elsif option = 8 then
	if menu_reply = chr (208) then
	    locate (17, 24)
	    put "  "
	    locate (17, 55)
	    put "  "
	    color (10)
	    locate (17, 38)
	    put "Test"
	else
	    locate (19, 24)
	    put "  "
	    locate (19, 55)
	    put "  "
	    locate (19, 38)
	    color (10)
	    put "Quit"
	end if
	color (2)
	locate (18, 38)
	put "Help"
	% atoms for "Help"
	drawoval (192, 105, 4, 4, 11)
	drawoval (192, 105, 1, 1, 4)
	drawfill (192, 105, 4, 4)

	drawoval (438, 105, 4, 4, 11)
	drawoval (438, 105, 1, 1, 4)
	drawfill (438, 105, 4, 4)
    elsif option = 9 then
	if menu_reply = chr (208) then
	    locate (18, 24)
	    put "  "
	    locate (18, 55)
	    put "  "
	    color (10)
	    locate (18, 38)
	    put "Help"
	else
	    locate (10, 24)
	    put "  "
	    locate (10, 55)
	    put "  "
	    locate (10, 34)
	    color (10)
	    put "Greek  Model"
	end if
	color (2)
	locate (19, 38)
	put "Quit"
	% atoms for "Quit"
	drawoval (192, 91, 4, 4, 11)
	drawoval (192, 91, 1, 1, 4)
	drawfill (192, 91, 4, 4)

	drawoval (438, 91, 4, 4, 11)
	drawoval (438, 91, 1, 1, 4)
	drawfill (438, 91, 4, 4)
    end if
end menu_option

%  Since  all the modules for this program that are not in this main file
%  are  all separate  procedures,  they  must be included and thus stored
%  into memory before the actual program begins since all procedures must
%  be called up before the program begins.

include "dalton"
include "thomson"
include "ruthrfrd"
include "bohr"
include "wave"
include "test"
include "help"
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

option := 1
menu_reply := " "
flag := 0
loop
    colorback (1)
    drawbox (0, 0, maxx, maxy, 2)

    if option not= 8 then % Checks  to  see  if  the  last option the user
	delay (500) % chose  was  not  the  'Help'  option.  If this
    end if % is the case, the computer delays for a moment.

    locate (3, 28)
    color (15)
    put "CHEMISTRY TUTORIAL V1.0!"
    locate (4, 33)
    put "ATOMIC THEORY"
    open_mainmenu_screen

    drawbox (170, 76, 460, 260, 10) % draws boxes for main menu
    drawbox (173, 79, 457, 257, 10)

    if flag > 0 and option > 1 then % if program has just been started up,
	menu_option % this 'if' statement will darken the
	color (10) % 'Greek Model' option, and place the
	locate (10, 34) % 'atom' pointers on this option.
	put "Greek  Model"
    else
	color (2)
	locate (10, 34)
	put "Greek  Model"
	drawoval (192, 217, 1, 1, 4)
	drawfill (192, 217, 4, 4)
	drawoval (438, 217, 1, 1, 4)
	drawfill (438, 217, 4, 4)
    end if

    color (15)
    locate (8, 35)
    put "MAIN MENU"
    if option not= 2 then
	colour (10)
	locate (11, 33)
	put "Dalton's Model"
    end if
    if option not= 3 then
	colour (10)
	locate (12, 32)
	put "Thomson's  Model"
    end if
    if option not= 4 then
	locate (13, 28)
	put "Rutherford's  Experiment"
	locate (14, 33)
	put "and his  Model"
    end if
    if option not= 5 then
	locate (15, 34)
	put "Bohr's Model"
    end if
    locate (16, 29)
    if option not= 6 then
	put "Wave Mechanical  Model"
    end if
    locate (17, 38)
    if option not= 7 then
	put "Test"
    end if
    locate (18, 38)
    if option not= 8 then
	put "Help"
    end if
    locate (19, 38)
    if option not= 9 then
	put "Quit"
    end if
    loop
	loop
	    spinning_atoms
	    flush
	    menu_reply := ch
	    flush

	    % The following 'if' statements keep track of what option the
	    % 'atom' cursors in the main menu are on.
	    if menu_reply = chr (200) then
		sound (500, 100)
		if option = 1 then
		    option := 9
		    flag := 1
		else
		    option := option - 1
		    flag := 1
		end if
	    elsif menu_reply = chr (208) then
		sound (500, 100)
		if option = 9 then
		    option := 1
		    flag := 1
		else
		    option := option + 1
		    flag := 1
		end if
	    elsif menu_reply = chr (10) then
		flag := 2
	    else
		sound (200, 100)
	    end if
	    exit when flag = 1 or flag = 2
	end loop
	menu_option
	exit when menu_reply = chr (10)
    end loop

    % The following if statements check to see which option was chosen by
    % the user and calls up the corresponding procedure for that option.
    if option = 1 and menu_reply = chr (10) then
	delay (500)
	close_option
	open_option
	include "greek"
	delay (500)
	close_option
	flush
	open_option
    elsif option = 2 then
	delay (500)
	close_option
	open_option
	dalt_main
	delay (500)
	close_option
	open_option
    elsif option = 3 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	thom_main
	delay (500)
	close_option
	open_option
    elsif option = 4 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	ruther_main
	delay (500)
	close_option
	open_option
    elsif option = 5 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	bohr_main
	delay (500)
	close_option
	open_option
    elsif option = 6 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	wave_main
	delay (500)
	close_option
	open_option
    elsif option = 7 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	test
	delay (500)
	close_option
	open_option
    elsif option = 8 then
	delay (500)
	helpoption := 1
	enter_help
	drawbox (130, 275, 497, 47, 10)
	drawbox (132, 273, 495, 49, 10)
	helpmain
	exit_help
	drawbox (0, 0, maxx, maxy, 2)
	delay (500)
    elsif option = 9 then
	delay (500)
	close_option
	open_option
	drawbox (0, 0, maxx, maxy, 2)
	cls
	colorback (0)
	exit
    end if
end loop
cls
