setscreen ("graphics:ega")
%By: Alan Esaagoolian
randomize
var com : string (1) := "1"
var fntbck, x, y, btn, move, rocklr, place, rockhight, score, life, diff,
    scenea, sceneb, nofmeteors, nofmissmeteors, StarSpeed : int := 0
var rockdead, mouse, done : boolean := false

var NumOfStars : int := 100

type StarPos :
    record
	x_pos : real
	y_pos : real
    end record
var AllStars : array 1 .. NumOfStars of StarPos

% GROUND
const mapsize : int := 2500
const linelength : int := 50
var moveg : int := 0
var map : array 1 .. mapsize of int

for a : 1 .. mapsize by linelength
    randint (map (a), 2, 25)
end for

proc ERASEMAP (var move_p : int)
    var temp, temp2 : int := map (1)
    for a : 1 .. mapsize by linelength
	drawline (a - move_p, map (a), temp2 - move_p, temp, 0)
	temp := map (a)
	temp2 := a
    end for
    drawfill (1, 1, 0, 3)
end ERASEMAP

proc DRAWMAP (var move_p : int)
    var temp, temp2 : int := map (1)
    for a : 1 .. mapsize by linelength
	drawline (a - move_p, map (a), temp2 - move_p, temp, 6)
	temp := map (a)
	temp2 := a
    end for
    drawfill (1, 1, 6, 6)
end DRAWMAP

proc refreshscreen
    locate (1, 1)
    put "Life: "
    drawbox (40, maxy - 2, 240, maxy - 12, 15) %40, 347, 240, 337, 15
    drawfillbox (41, maxy - 3, life, maxy - 11, 2) %346,    , 336
    locate (2, 1)
    put "Score: ", score
    locate (3, 1)
    put "Press [Esc] to exit" ..
end refreshscreen

proc drawplane (hight : int, var hori : int)
    %WINGS
    drawline (35 + hori, 116 + hight, 45 + hori, 116 + hight, 15)
    drawline (35 + hori, 116 + hight, 35 + hori, 118 + hight, 15)
    %BODY
    drawline (49 + hori, 115 + hight, 39 + hori, 113 + hight, 15)
    drawline (39 + hori, 118 + hight, 49 + hori, 115 + hight, 15)
    drawline (39 + hori, 113 + hight, 10 + hori, 116 + hight, 15)
    drawline (39 + hori, 118 + hight, 10 + hori, 116 + hight, 15)
    drawline (10 + hori, 116 + hight, 10 + hori, 122 + hight, 15)
    drawline (10 + hori, 122 + hight, 18 + hori, 118 + hight, 15)
end drawplane

proc eraseplane (var hight : int, var hori : int)
    %WINGS
    drawline (35 + hori, 116 + hight, 45 + hori, 116 + hight, 0)
    drawline (35 + hori, 116 + hight, 35 + hori, 118 + hight, 0)
    %BODY
    drawline (49 + hori, 115 + hight, 39 + hori, 113 + hight, 0)
    drawline (39 + hori, 118 + hight, 49 + hori, 115 + hight, 0)
    drawline (39 + hori, 113 + hight, 10 + hori, 116 + hight, 0)
    drawline (39 + hori, 118 + hight, 10 + hori, 116 + hight, 0)
    drawline (10 + hori, 116 + hight, 10 + hori, 122 + hight, 0)
    drawline (10 + hori, 122 + hight, 18 + hori, 118 + hight, 0)
end eraseplane

proc drawrocks (var hight : int, var lr : int)
    drawline (620 - lr, 15 + hight, 600 - lr, 40 + hight, 3)
    drawline (600 - lr, 40 + hight, 620 - lr, 60 + hight, 3)
    drawline (620 - lr, 60 + hight, 655 - lr, 40 + hight, 3)
    drawline (655 - lr, 40 + hight, 620 - lr, 15 + hight, 3)
    drawfill (620 - lr, 40 + hight, 7, 3)
end drawrocks

proc eraserocks (var hight : int, var lr : int)
    drawfill (620 - lr, 40 + hight, 0, 3)
    drawline (620 - lr, 15 + hight, 600 - lr, 40 + hight, 0)
    drawline (600 - lr, 40 + hight, 620 - lr, 60 + hight, 0)
    drawline (620 - lr, 60 + hight, 655 - lr, 40 + hight, 0)
    drawline (655 - lr, 40 + hight, 620 - lr, 15 + hight, 0)
end eraserocks

proc INTRO
    setscreen ("graphics:ega")
    var angle, xxx, r, yyy : real
    var originx : int := maxx div 2
    var originy : int := maxy div 2
    var col : int := 1
    var size : real := 20
    var sizeone : real := .1
    angle := 0
    r := 120
    var oldx, oldy : real := 0
    var speed : real := .1

    loop
	if col >= 7 then
	    col := 3
	end if
	size += sizeone
	put "Astroids"
	if size > 50 or size < 0 then
	    sizeone := - sizeone
	end if
	angle := angle + speed
	yyy := (sin (angle) * r) + originy
	xxx := (cos (angle) * r) + originx
	col := col + 1
	drawdot (round (oldx), round (oldy), col)
	drawdot (round (oldx) + 3, round (oldy) + 3, col)
	drawdot (round (oldx) + 5, round (oldy) + 5, col)
	oldx := xxx
	oldy := yyy
	if hasch then
	    getch (com)
	end if
	exit when com = " "
    end loop
end INTRO

proc STARTUP
    setscreen ("echo")
    setscreen ("cursor")
    var temp, temp2 : string (1)
    put "ASTROIDS"
    put "By: Born.2.be.wild"
    put "Press [Space] to continue"
    loop
	exit when hasch
    end loop
    %     put "Edit options? (y/n)"
    %     getch (temp2)
    %     %exit when temp2 = ""
    %     if temp2 = "y" then
    %         put "How fast would you like to go?: (Max 100)" ..
    %         get move
    %         put "How fast do you want the meteor?: (Max 100)" ..
    %         get diff
    %         put "How dense do you want the stars?: (Max 1000)" ..
    %         get NumOfStars
    %         put "Would you like to play with a mouse?: (y/n)" ..
    %         getch (temp)
    %         if temp = "y" then
    %             mouse := true
    %         else
    %             mouse := false
    %         end if
    %     else
    move := 14
    diff := 18
    mouse := false
    StarSpeed := 6
    NumOfStars := 100
    %    end if
end STARTUP

for a : 1 .. NumOfStars
    var tempx, tempy : int
    randint (tempx, 1, maxx)
    randint (tempy, 1, maxy)
    AllStars (a).x_pos := tempx
    AllStars (a).y_pos := tempy
end for

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  1 = up                4 = left
%%%%  2 = down              5 = virtical
%%%%  3 = right             6 = horizontal
%%%%                7 = all

proc Stars (type_p, speed_p : int)
    var StarSpeed : real := 10
    for a : 1 .. NumOfStars
	drawdot (round (AllStars (a).x_pos), round (AllStars (a).y_pos), 0)
	StarSpeed := a / speed_p

	% MAKES STARS GO LEFT/RIGHT
	if type_p = 7 or type_p = 6 then
	    if AllStars (a).x_pos > maxx div 2 then
		AllStars (a).x_pos += StarSpeed
	    elsif AllStars (a).x_pos < maxx div 2 then
		AllStars (a).x_pos -= StarSpeed
	    end if
	end if

	if type_p = 4 then
	    AllStars (a).x_pos -= StarSpeed
	elsif type_p = 3 then
	    AllStars (a).x_pos += StarSpeed
	end if

	% MAKES STARS GO UP/DOWN
	if type_p = 7 or type_p = 5 then
	    if AllStars (a).y_pos > maxy div 2 then
		AllStars (a).y_pos += StarSpeed
	    elsif AllStars (a).y_pos < maxy div 2 then
		AllStars (a).y_pos -= StarSpeed
	    end if
	end if

	if type_p = 1 then
	    AllStars (a).y_pos += StarSpeed
	elsif type_p = 2 then
	    AllStars (a).y_pos -= StarSpeed
	end if

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	if type_p = 7 or type_p = 6 then
	    if AllStars (a).x_pos > maxx or AllStars (a).x_pos < 0 then
		var temp, temp2 : int := 0
		randint (temp, 1, maxy)
		loop
		    randint (temp2, - 1, 1)
		    exit when temp2 not= 0
		end loop
		AllStars (a).y_pos := temp
		AllStars (a).x_pos := (maxx div 2) + temp2
	    end if
	end if

	if type_p = 4 then
	    if AllStars (a).x_pos < 0 then
		var temp : int := 0
		randint (temp, 1, maxy)
		AllStars (a).y_pos := temp
		AllStars (a).x_pos := maxx
	    end if
	elsif type_p = 3 then
	    if AllStars (a).x_pos > maxx then
		var temp : int := 0
		randint (temp, 1, maxy)
		AllStars (a).y_pos := temp
		AllStars (a).x_pos := 0
	    end if
	end if

	if type_p = 7 or type_p = 5 then
	    if AllStars (a).y_pos > maxy or AllStars (a).y_pos < 0 then
		var temp, temp2 : int := 0
		randint (temp, 1, maxx)
		loop
		    randint (temp2, - 1, 1)
		    exit when temp2 not= 0
		end loop
		AllStars (a).x_pos := temp
		AllStars (a).y_pos := (maxy div 2) + temp2
	    end if
	end if

	if type_p = 2 then
	    if AllStars (a).y_pos < 0 then
		var temp : int := 0
		randint (temp, 1, maxx)
		AllStars (a).x_pos := temp
		AllStars (a).y_pos := maxy
	    end if
	elsif type_p = 1 then
	    if AllStars (a).y_pos > maxy then
		var temp : int := 0
		randint (temp, 1, maxx)
		AllStars (a).x_pos := temp
		AllStars (a).y_pos := 0
	    end if
	end if

	drawdot (round (AllStars (a).x_pos), round (AllStars (a).y_pos), 15)
    end for
end Stars


INTRO
cls
STARTUP
loop
    setscreen ("noecho")
    setscreen ("nocursor")
    life := 239
    nofmeteors := 0
    nofmissmeteors := 0
    score := 0
    rockdead := true
    moveg := 0
    %    put "Press any key to play"
    %    getch (com)

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %                      GAME                      %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    cls
    drawplane (place, fntbck)
    refreshscreen
    DRAWMAP (moveg)
    locate (maxrow div 2, maxcol div 2)
    put "Ready" ..
    delay (1000)
    locate (maxrow div 2, maxcol div 2)
    put " Set " ..
    delay (1000)
    locate (maxrow div 2, maxcol div 2)
    put " Go " ..
    delay (250)
    cls
    com := "1"
    loop
	Stars (4, StarSpeed)

	drawrocks (rockhight, rocklr)
	eraseplane (place, fntbck)
	eraserocks (rockhight, rocklr)
	drawline (52, 115 + place, maxx, 115 + place, 0)
	drawline (52, 115 + place + move, maxx, 115 + place + move, 0)
	if mouse = false then
	    if hasch then
		getch (com)
	    end if
	    if com = chr (32) then %               GUNS
		drawplane (place, fntbck)
		drawline (52 + fntbck, 115 + place, maxx, 115 + place, 15)
	    elsif com = chr (200) then %            UP
		drawline (52, 115 + place, maxx, 115 + place, 0)
		if place >= maxy - 175 then
		else
		    place += move
		end if
		drawplane (place, fntbck)
	    elsif com = chr (208) then %             DOWN
		drawline (52, 115 + place, maxx, 115 + place, 0)
		if place >= - 50 then
		    %else
		    place -= move
		end if
		drawplane (place, fntbck)
	    elsif com = chr (205) then %             FRONT
		drawline (52, 115 + place, maxx, 115 + place, 0)
		if fntbck > maxx - 100 then
		else
		    fntbck += move
		end if
		drawplane (place, fntbck)
	    elsif com = chr (203) then %              BACK
		drawline (52, 115 + place, maxx, 115 + place, 0)
		if fntbck < 10 then
		else
		    fntbck -= move
		end if
		drawplane (place, fntbck)
	    elsif com = chr (27) then
		done := true
	    else
		drawplane (place, fntbck)
	    end if
	else
	    if hasch then
		var c : string (1)
		getch (c)
		if c = chr (27) then
		    done := true
		end if
	    end if
	    mousewhere (x, y, btn)
	    %                 drawbox (200, 100, 440, 250, 14)
	    %                 drawbox (0, 0, 200, 100, 13) %bottom left
	    %                 drawbox (0, maxy, 200, 250, 13) %top left
	    %                 drawbox (maxx, 0, 440, 100, 13) %bottom right
	    %                 drawbox (maxx, maxy, 440, 250, 13) %top right
	    %                 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	    if y > 250 then %            UP
		if place >= maxy - 175 then
		else
		    place += move
		end if
		drawplane (place, fntbck)
	    elsif y < 100 then %             DOWN
		if place <= maxy - 450 then %-50
		else
		    place -= move
		end if
		drawplane (place, fntbck)
	    else
		drawplane (place, fntbck)
	    end if
	    if btn = 1 then %               GUNS
		drawplane (place, fntbck)
		drawline (52 + fntbck, 115 + place, maxx, 115 + place, 15)
		eraseplane (place, fntbck)
	    else
		drawplane (place, fntbck)
	    end if
	    eraseplane (place, fntbck)
	    if x > 440 then %             FRONT
		if fntbck > maxx - 100 then
		else
		    fntbck += move
		end if
		drawplane (place, fntbck)
	    elsif x < 200 then %              BACK
		if fntbck < 10 then
		else
		    fntbck -= move
		end if
		drawplane (place, fntbck)
	    else
		drawplane (place, fntbck)
	    end if
	end if
	drawplane (place, fntbck)

	% SHOOT THE ASTROID
	for erase : 50 .. 105
	    if place + erase = rockhight and 660 - rocklr > fntbck + 8 and
		    com = chr (32) or place + erase = rockhight and 660 -
		    rocklr > fntbck + 8 and btn = 1 then
		rockdead := true
		score += 10
		nofmeteors += 1
		exit
	    end if
	end for
	% HIT BY ASTROID
	for hit2 : 0 - move .. move
	    if 600 - rocklr + hit2 = fntbck + 55 then % fntbck + 70
		for hit : 110 .. 124
		    if place + hit > rockhight + 15 and place + hit <
			    rockhight + 60 then
			% place + hit = rockhight
			life -= 50
			rockdead := true
			exit
		    end if
		    %   %           back        top           front      bottom
		    %   drawbox (fntbck + 8, place + 124, fntbck + 55, place + 110, 14)
		    %   %            back            top          front         bottom
		    %   drawbox (660 - rocklr, rockhight + 60, 600 - rocklr, rockhight + 15, 13)
		    %   drawrocks (rockhight, rocklr)
		    %   delay (1)
		end for
	    end if
	end for

	%MISSED METEOR?
	if rocklr >= 560 then
	    rockdead := true
	    score -= 10
	    nofmissmeteors += 1
	end if

	%ANOTHER ROCK?
	if rockdead = true then
	    rocklr := 0
	    randint (rockhight, 10, maxy - 100)
	    rockdead := false
	else
	    rocklr += diff
	    drawrocks (rockhight, rocklr)
	end if

	drawrocks (rockhight, rocklr)
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%        DRAWMAP (moveg)
	%        delay (1)
	%        ERASEMAP (moveg)

	if moveg >= mapsize - linelength - maxx then
	    ERASEMAP (moveg)
	    moveg := 0
	end if

	moveg += 5
	%if temp2 = "" then
	%    done := true
	%end if

	refreshscreen
	exit when life <= 45 or score <= - 100 or done = true
	%        end for
	exit when life <= 45 or score <= - 100 or done = true
    end loop
    life := 41
    refreshscreen
    %    put ""
    locate (3, 1)
    put "You hit ", nofmeteors, " meteors. " ..
    locate (4, 1)
    put "You missed ", nofmissmeteors, " meteors." ..
    locate (5, 1)
    put "Press [Space] to continue" ..
    loop
	var temp3 : string (1) := "1"
	if hasch then
	    getch (temp3)
	end if
	exit when temp3 = " "
    end loop
    exit when done = true

end loop
