setscreen ("graphics:e16")
setscreen ("nocursor")
%GLOBAL VARIABLES
var theta : int := 0
var theta2 : int := 0
var theta3 : int := 5
var theta4 : int := 0
var theta5 : int := 90
var D : real
var R : real := 15
var j, k, p1, q1, p2, q2 : int
var Xmax, Ymax, Xmin, Ymin : int
Xmax := 15
Ymax := 15
const xc := maxx div 2
const yc := maxy div 2
var Rz : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
Rz (1, 1) := cosd (theta3)
Rz (1, 2) := - sind (theta3)
Rz (2, 1) := sind (theta3)
Rz (2, 2) := cosd (theta3)
var Rx : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
Rx (2, 2) := cosd (theta3)
Rx (2, 3) := - sind (theta3)
Rx (3, 2) := sind (theta3)
Rx (3, 3) := cosd (theta3)
var Ry : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
Ry (1, 1) := cosd (theta3)
Ry (1, 3) := - sind (theta3)
Ry (3, 1) := sind (theta3)
Ry (3, 3) := cosd (theta3)
var Cz, Cx, Cy : array 1 .. 2, 1 .. 8 of real
var M : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
M (1, 1) := 1.05
M (2, 2) := 1.05
M (3, 3) := 1.05
var D2 : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
D2 (1, 1) := .95
D2 (2, 2) := .95
D2 (3, 3) := .95
var RR : array 1 .. 4, 1 .. 4 of real := init
    (1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1)
var t : string (1)
var E : array 1 .. 2, 1 .. 221 of int := init
    (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 19,
    20, 21, 22, 23, 24, 31, 32, 21, 20, 33, 34, 27, 26, 31, 32, 21, 20, 35,
    36, 37, 38, 39, 40, 41, 42, 35, 36, 37, 38, 43, 44, 45, 46, 47, 48, 49,
    50, 43, 44, 45, 46, 51, 52, 53, 54, 55, 56, 57, 58, 51, 52, 53, 54, 59,
    60, 61, 62, 63, 64, 43, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
    77, 73, 74, 69, 80, 60, 81, 82, 82, 84, 84, 77, 85, 76, 86, 69, 78, 69,
    87, 88, 89, 87, 88, 89, 90, 90, 91, 92, 93, 91, 92, 93, 94, 90, 95, 96,
    96, 95, 97, 98, 97 100, 99, 100, 69, 69, 101, 102, 103, 104, 105, 106,
    107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 118, 119, 117, 120,
    121, 123, 122, 127, 124, 125, 126, 124, 125, 126, 131, 128, 129, 130,
    128, 129, 130, 99, 132, 133, 132, 133, 134, 126, 130, 134, 135, 136,
    137, 138, 139, 143, 142, 141, 69, 101, 102, 103, 104, 105, 106, 77, 140,

    2, 3, 4, 5, 6, 7, 8, 9, 1, 11, 12, 13, 14, 15, 16, 17, 18, 10, 10, 11,
    12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 19, 26, 27, 28, 29, 30,
    25, 25, 26, 27, 28, 29, 30, 32, 21, 20, 31, 34, 27, 26, 33, 33, 34, 27,
    26, 36, 37, 38, 35, 40, 41, 42, 39, 39, 40, 41, 42, 44, 45, 46, 43, 48,
    49, 50, 47, 47, 48, 49, 50, 52, 53, 54, 51, 56, 57, 58, 55, 55, 56, 57,
    58, 60, 61, 59, 63, 64, 62, 65, 66, 51, 65, 66, 70, 71, 72, 73, 74, 75,
    76, 77, 78, 67, 68, 80, 79, 81, 70, 71, 43, 83, 78, 85, 52, 86, 51, 59,
    62, 87, 88, 89, 90, 70, 71, 72, 73, 91, 92, 93, 94, 74, 75, 76, 77, 95,
    96, 91, 98, 97, 98, 100, 99, 99, 90, 91, 78, 101, 102, 103, 104, 105,
    106, 78, 108, 109, 110, 111, 112, 113, 114, 115, 107, 118, 119, 117,
    116, 121, 123, 122, 120, 124, 125, 126, 90, 87, 88, 89, 128, 129, 130,
    91, 94, 93, 92, 132, 133, 100, 134, 135, 135, 134, 135, 107, 115, 137,
    138, 139, 143, 142, 141, 140, 136, 137, 138, 139, 143, 142, 141, 140,
    136)

var C4, WW, WW3, WW4, WW5 : array 1 .. 4, 1 .. 143 of real
var D3, WW2, WW6, WW7, WW8 : array 1 .. 2, 1 .. 143 of real
var PEZa, PEZa1, PEZa2, PEZa3 : array 1 .. 2, 1 .. 143 of real
var PEZ : array 1 .. 4, 1 .. 143 of real := init
    (10, 10, 10, 10, 10, 10, 10, 10, 10, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5,
    9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 0, 0, 0, 0, 0, 0, 9.5, 9.5, 0,
    0, 9.5, 9.5, 9.5, 9.5, 0, 0, 0, 0, 0, - 1, - 1, 0, 0, - 1, - 1, 0, 0, -
    1, - 1, 0, 0, - 1, - 1, 0, - 3, - 1, - 1, - 3, - 1, - 1, 0, 0, - 1, - 1,
    - 3, - 2, - 1.7, - 1.6, - 2, - 2, - 1.6, - 1.7, - 2, - 3, - 1.7, - 2.5, -
    1.5, - 1.2, - 1.7, - 2.5, - 1.5, - 1.2, - 2.5, - 2.6, - 2.9, - 3.1, -
    3.1, - 2.9, - 2.6, - 2.5, - 3.5, - 3.5, - 3.6, - 3.6, - 3.2, - 3.2, - 4,
    - 5, - 6, - 6, - 5, - 4, - 3.3, - 4.5, - 5.5, - 5.5, - 4.9, - 5.5, -
    5.5, - 4.5, - 3.3, - 3.6, - 3.6, - 4.3, - 4.3, - 3.6, - 3.6, - 4.3, -
    4.3, - 3, - 3, - 3.5, - 3, - 3, - 3, - 3.5, - 3, - 3.7, - 3.7, - 3.4, -
    3.4, - 3, - 4, - 5, - 6, - 3, - 4, - 5, - 6,

    - 2, - 1.5, - 0.5, 0, 0.5, 1.5, 2, 2, - 2, - 2, - 1.5, - 0.5, 0, 0.5,
    1.5, 2, 2, - 2, - 1.5, - 0.5, 0.5, 1.5, 1.5, - 1.5, - 1.5, - 0.5, 0.5,
    1.5, 1.5, - 1.5, - 0.5, 0.5, - 0.5, 0.5, - 0.5, 0.5, 0.5, - 0.5, - 0.5,
    0.5, 0.5, - 0.5, - 1, - 1.5, - 1.5, - 1.5, - 2, - 2, - 2, - 2, 1, 1.5,
    1.5, 1.5, 2, 2, 2, 2, - 1.5, - 1.5, - 1.5, 1.5, 1.5, 1.5, - 0.5, 0.5, -
    0.5, 0.5, - 1.5, - 1.8, - 1.6, - 0.9, - 0.5, 0.5, 0.9, 1.6, 1.8, 1.5, -
    1.5, - 1.8, - 2, - 1.8, 1.5, 1.8, 2, 1.8, - 2, - 2.3, - 2, - 0.5, 0.5,
    2, 2.3, 2, - 0.3, 0.3, - 0.3, 0.3, - 0.5, 0.5, - 1.5, - 1, - 0.5, 0.5,
    1, 1.5, - 1.3, - 1, - 0.3, - 0.2, 0, 0.2, 0.3, 1, 1.3, - 0.5, - 0.2, -
    0.5, - 0.2, 0.5, 0.2, 0.5, 0.2, - 2, - 2.1, - 1.8, - 1.5, 2, 2.1, 1.8,
    1.5, - 0.7, 0.7, - 0.9, 0.9, - 1.5, - 1.5, - 1, - 0.5, 1.5, 1.5, 1, 0.5,

    2.5, 3, 3, 2.5, 3, 3, 2.5, - 3, - 3, 2.5, 3, 3, 2.5, 3, 3, 2.5, - 3, -
    3, 1.6, 1.6, 1.6, 1.6, - 1.6, - 1.6, 1.7, 1.7, 1.7, 1.7, - 1.7, - 1.7,
    2, 2, 2, 2, - 1.7, - 1.7, - 2.2, - 2.2, - 1.7, - 1.7, - 2.2, - 2.2, 1.6,
    1, - 1.7, - 1.7, 1.6, 1, - 1.7, - 1.7, 1.6, 1, - 1.7, - 1.7, 1.6, 1, -
    1.7, - 1.7, - 1.5, 1, - 1.7, - 1.5, 1, - 1.7, 3, 3, 3.5, 3.5, 0.5, 1, 2,
    3, 4, 4, 3, 2, 1, 0.5, 0.2, 0.35, 1, 2, 0.2, 0.35, 1, 2, 1, 2, 3, 5, 5,
    3, 2, 1, 5.8, 5.8, 5.4, 5.4, 4.5, 4.5, 0.3, 0.2, 0.5, 0.5, 0.2, 0.3,
    0.8, 0.5, 0.4, 0.4, 0.6, 0.4, 0.4, 0.5, 0.8, 0.8, 0.8, 0.7, 0.7, 0.8,
    0.8, 0.7, 0.7, 1, 2, 3, 0.3, 1, 2, 3, 0.3, 3, 3, 2.7, 2.7, - 2, - 2, -
    2, - 2, - 2, - 2, - 2, - 2,

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
var PEZ1 : array 1 .. 4, 1 .. 143 of real := init
    (10, 10, 10, 10, 10, 10, 10, 10, 10, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5,
    9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 9.5, 0, 0, 0, 0, 0, 0, 9.5, 9.5, 0,
    0, 9.5, 9.5, 9.5, 9.5, 0, 0, 0, 0, 0, - 1, - 1, 0, 0, - 1, - 1, 0, 0, -
    1, - 1, 0, 0, - 1, - 1, 0, - 3, - 1, - 1, - 3, - 1, - 1, 0, 0, - 1, - 1,
    - 3, - 2, - 1.7, - 1.6, - 2, - 2, - 1.6, - 1.7, - 2, - 3, - 1.7, - 2.5, -
    1.5, - 1.2, - 1.7, - 2.5, - 1.5, - 1.2, - 2.5, - 2.6, - 2.9, - 3.1, -
    3.1, - 2.9, - 2.6, - 2.5, - 3.5, - 3.5, - 3.6, - 3.6, - 3.2, - 3.2, - 4,
    - 5, - 6, - 6, - 5, - 4, - 3.3, - 4.5, - 5.5, - 5.5, - 4.9, - 5.5, -
    5.5, - 4.5, - 3.3, - 3.6, - 3.6, - 4.3, - 4.3, - 3.6, - 3.6, - 4.3, -
    4.3, - 3, - 3, - 3.5, - 3, - 3, - 3, - 3.5, - 3, - 3.7, - 3.7, - 3.4, -
    3.4, - 3, - 4, - 5, - 6, - 3, - 4, - 5, - 6,

    - 2, - 1.5, - 0.5, 0, 0.5, 1.5, 2, 2, - 2, - 2, - 1.5, - 0.5, 0, 0.5,
    1.5, 2, 2, - 2, - 1.5, - 0.5, 0.5, 1.5, 1.5, - 1.5, - 1.5, - 0.5, 0.5,
    1.5, 1.5, - 1.5, - 0.5, 0.5, - 0.5, 0.5, - 0.5, 0.5, 0.5, - 0.5, - 0.5,
    0.5, 0.5, - 0.5, - 1, - 1.5, - 1.5, - 1.5, - 2, - 2, - 2, - 2, 1, 1.5,
    1.5, 1.5, 2, 2, 2, 2, - 1.5, - 1.5, - 1.5, 1.5, 1.5, 1.5, - 0.5, 0.5, -
    0.5, 0.5, - 1.5, - 1.8, - 1.6, - 0.9, - 0.5, 0.5, 0.9, 1.6, 1.8, 1.5, -
    1.5, - 1.8, - 2, - 1.8, 1.5, 1.8, 2, 1.8, - 2, - 2.3, - 2, - 0.5, 0.5,
    2, 2.3, 2, - 0.3, 0.3, - 0.3, 0.3, - 0.5, 0.5, - 1.5, - 1, - 0.5, 0.5,
    1, 1.5, - 1.3, - 1, - 0.3, - 0.2, 0, 0.2, 0.3, 1, 1.3, - 0.5, - 0.2, -
    0.5, - 0.2, 0.5, 0.2, 0.5, 0.2, - 2, - 2.1, - 1.8, - 1.5, 2, 2.1, 1.8,
    1.5, - 0.7, 0.7, - 0.9, 0.9, - 1.5, - 1.5, - 1, - 0.5, 1.5, 1.5, 1, 0.5,

    2.5, 3, 3, 2.5, 3, 3, 2.5, - 3, - 3, 2.5, 3, 3, 2.5, 3, 3, 2.5, - 3, -
    3, 1.6, 1.6, 1.6, 1.6, - 1.6, - 1.6, 1.7, 1.7, 1.7, 1.7, - 1.7, - 1.7,
    2, 2, 2, 2, - 1.7, - 1.7, - 2.2, - 2.2, - 1.7, - 1.7, - 2.2, - 2.2, 1.6,
    1, - 1.7, - 1.7, 1.6, 1, - 1.7, - 1.7, 1.6, 1, - 1.7, - 1.7, 1.6, 1, -
    1.7, - 1.7, - 1.5, 1, - 1.7, - 1.5, 1, - 1.7, 3, 3, 3.5, 3.5, 0.5, 1, 2,
    3, 4, 4, 3, 2, 1, 0.5, 0.2, 0.35, 1, 2, 0.2, 0.35, 1, 2, 1, 2, 3, 5, 5,
    3, 2, 1, 5.8, 5.8, 5.4, 5.4, 4.5, 4.5, 0.3, 0.2, 0.5, 0.5, 0.2, 0.3,
    0.8, 0.5, 0.4, 0.4, 0.6, 0.4, 0.4, 0.5, 0.8, 0.8, 0.8, 0.7, 0.7, 0.8,
    0.8, 0.7, 0.7, 1, 2, 3, 0.3, 1, 2, 3, 0.3, 3, 3, 2.7, 2.7, - 2, - 2, -
    2, - 2, - 2, - 2, - 2, - 2,

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
%PROCEDURES
proc drawCube (W : array 1 .. *, 1 .. * of real, c : int, x, y : int)
    for i : 1 .. upper (E, 2)
	j := E (1, i)
	k := E (2, i)
	p1 := x + round (xc * W (1, j) / Xmax)
	q1 := y + round (yc * W (2, j) / Ymax)
	p2 := x + round (xc * W (1, k) / Xmax)
	q2 := y + round (yc * W (2, k) / Ymax)
	drawline (p1, q1, p2, q2, c)
    end for
end drawCube
procedure projObject (V : array 1 .. *, 1 .. * of real, var W : array 1 ..
	*, 1 .. * of real)
    for j : 1 .. upper (V, 2)
	D := 1 - (V (1, j) * cosd (theta2) * cosd (theta) + V (2, j) * cosd
	    (theta2) * sind (theta) + V (3, j) * sind (theta)) / R
	W (1, j) := (V (2, j) * cosd (theta) - V (1, j) * sind (theta)) / D
	W (2, j) := (V (3, j) * cosd (theta2) - V (2, j) * sind (theta2) *
	    sind (theta) - V (1, j) * sind (theta2) * cosd (theta)) / D
    end for
end projObject
procedure projObject2 (V : array 1 .. *, 1 .. * of real, var W : array 1 ..
	*, 1 .. * of real)
    for j : 1 .. upper (V, 2)
	D := 1 - (V (1, j) * cosd (theta5) * cosd (theta4) + V (2, j) * cosd
	    (theta5) * sind (theta4) + V (3, j) * sind (theta4)) / R
	W (1, j) := (V (2, j) * cosd (theta4) - V (1, j) * sind (theta4)) / D
	W (2, j) := (V (3, j) * cosd (theta5) - V (2, j) * sind (theta5) *
	    sind (theta4) - V (1, j) * sind (theta5) * cosd (theta4)) / D
    end for
end projObject2
procedure multMatrix (var A, B, C : array 1 .. *, 1 .. * of real)
    for i : 1 .. upper (A, 1)
	for j : 1 .. upper (B, 2)
	    C (i, j) := 0
	    for r : 1 .. upper (A, 2)
		C (i, j) := C (i, j) + A (i, r) * B (r, j)
	    end for
	end for
    end for
end multMatrix
%MAIN PROGRAM
color (15)
colorback (1)
locate (10, 25)
put "This is my 3-D Project" ..
locate (11, 30)
put "By Ken Black" ..
locate (maxrow - 2, maxcol - 15)
put "copyright 1998"
projObject2 (PEZ1, PEZa)
drawbox (maxx - 5, 25, maxx - 140, 45, 9)
delay (5000)
cls
loop
    colorback (1)
    drawfillbox (0, maxy, maxx - 345, maxy - 170, 9)
    drawbox (maxx - 345, maxy, maxx, maxy - 270, 9)
    locate (2, 2)
    put "Type X to rotate on the X-Axis" ..
    locate (3, 2)
    put "Type Y to rotate on the Y-Axis" ..
    locate (4, 2)
    put "Type Z to rotate on the Z-Axis" ..
    locate (5, 2)
    put "Type M to Magnify the image" ..
    locate (6, 2)
    put "Type D to De-Magnify the image" ..
    locate (7, 2)
    put "Type any of the arrow keys to" ..
    locate (8, 2)
    put "move in the corresponding direction" ..
    locate (9, 2)
    put "Type S to Stop the image" ..
    locate (10, 2)
    put "Type B to go back to Menu" ..
    locate (11, 2)
    put "Type Q to Quit" ..
    locate (maxrow - 2, maxcol - 15)
    put "copyright 1998"
    projObject2 (PEZ1, PEZa)
    drawbox (maxx - 5, 25, maxx - 140, 45, 9)
    loop
	WW2 := PEZa
	multMatrix (Rx, PEZ1, WW)
	projObject2 (WW, PEZa)
	PEZ1 := WW
	exit when hasch
	drawline (maxx - 170, maxy, maxx - 170, maxy - 270, 9)
	drawline (maxx, maxy - 125, maxx - 345, maxy - 125, 9)
	drawCube (WW2, 1, maxx - 175, maxy - 100)
	drawCube (PEZa, 15, maxx - 175, maxy - 100)
    end loop
    loop
	getch (t)
	cls
	if t = "z" or t = "Z" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (Rz, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "y" or t = "Y" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (Ry, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "x" or t = "X" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (Rx, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	    % UP
	elsif t = "" then
	    colorback (1)
	    RR (3, 4) := 0.5
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (RR, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	    % LEFT
	elsif t = "" then
	    colorback (1)
	    RR (2, 4) := - 0.5
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (RR, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	    % RIGHT
	elsif t = "" then
	    colorback (1)
	    RR (2, 4) := 0.5
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (RR, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "" then
	    colorback (1)
	    RR (3, 4) := - 0.5
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (RR, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "m" or t = "M" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (M, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "d" or t = "D" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    loop
		D3 := PEZa
		multMatrix (D2, PEZ, C4)
		exit when hasch
		projObject (C4, PEZa)
		PEZ := C4
		drawCube (D3, 0, maxx div 2, maxy div 2)
		drawCube (PEZa, 15, maxx div 2, maxy div 2)
	    end loop
	elsif t = "s" or t = "S" then
	    colorback (1)
	    projObject (PEZ, PEZa)
	    drawCube (PEZa, 15, maxx div 2, maxy div 2)
	elsif t = "b" or t = "B" then
	    exit
	elsif t = "q" or t = "Q" then
	    colorback (1)
	    exit
	else
	    var Ur, Ur2 : int
	    locate (12, 25)
	    put "Danger : Everything Went Retarded"
	    loop
		randint (Ur, 0, 0)
		drawfillbox (5, 5, 100, 100, Ur)
		drawfillbox (5, maxy - 5, 100, maxy - 100, Ur)
		drawfillbox (maxx - 5, 5, maxx - 100, 100, Ur)
		drawfillbox (maxx - 5, maxy - 5, maxx - 100, maxy - 100, Ur)
		delay (100)
		randint (Ur2, 14, 14)
		drawfillbox (5, 5, 100, 100, Ur2)
		drawfillbox (5, maxy - 5, 100, maxy - 100, Ur2)
		drawfillbox (maxx - 5, 5, maxx - 100, 100, Ur2)
		drawfillbox (maxx - 5, maxy - 5, maxx - 100, maxy - 100, Ur2)
		delay (100)
		exit when hasch
	    end loop
	end if
    end loop
    exit when t = "q"
    exit when t = "Q"
end loop
