// FILENAME:      OV_SnowValley.cs adapted to OV_City_on_the_Edge.cs
// AUTHORS:       {RR}_Gen. Spawne32, [OF] Pincushion. Adapted by Bumpy Carrot
// VERSION:       3.5
// LAST UPDATED:  Mar. 17, 2000
// DESCRIPTION:
// This is an Overrun mission.  It requires multiplayer/OVStdLib.cs.
// Wave after wave of attackers will try to destroy your turrets, your
// generators, your radar, and you.  The object: survive.
// See http://www.geocities.com/SoHo/Nook/9351/maps/index.html for more info.
// E-mail Bumpy Carrot at:bumpy_carrot@mailcity.com
//------------------------------------------------------------------------------

$missionName = "OV_City_on_the_Edge";

exec("multiplayerStdLib.cs");
exec("OVStdLib.cs");
//exec("AIQCstdlib.cs");

//Setup some pilots

Pilot Bonesnap
{
   id = 32;
   
   name = "Bonesnap";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Tigress
{
   id = 29;
   
   name = "Tigress";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot DeltaSix
{
   id = 30;
   
   name = "Delta Six";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot HellFire
{
   id = 31;
   
   name = "Hellfire";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

//Finished with pilots

function onMissionStart()
{
	marsSounds();
	OVMissionStart();
//Get those hercs movin!!!!!
	order( $Tigress, guard, getObjectId( "MissionGroup/Patrols/HeavyA" ) );
	order( $DeltaSix, guard, getObjectId( "MissionGroup/Patrols/HeavyB" ) );
	order( $Bonesnap, guard, getObjectId( "MissionGroup/Patrols/MediumA" ) );
	order( $Hellfire, guard, getObjectId( "MissionGroup/Patrols/MediumB" ) );
}

function onMissionLoad()
{
	cdAudioCycle("Watching", "Cyberntx", "Cloudburst"); 

	// AI Attackers: 1 = Cybrid, 2 = Human, 3 = mixed.
	$OVattackerTech = 1;

	// Drop zones. Set an entry to 0 to disable drops from that direction.
	// Non-zero integer values indicate relative frequency.
	// Eg. setting $OVdz[0]=3 $OVdz[4]=1 and all the rest to 0 will cause
	// 3 out of 4 drops to be north of the base.
	// 0=N, 1=NE, 2=E, 3=SE, 4=S, 5=SW, 6=W, 7=NW
	$OVdz[0]=1; $OVdz[1]=1; $OVdz[2]=1; $OVdz[3]=1;
	$OVdz[4]=1; $OVdz[5]=1; $OVdz[6]=1; $OVdz[7]=1;

	OVMissionLoad();

	$Tigress = getObjectId( "MissionGroup/Guards/Tigress" );
	$DeltaSix = getObjectId( "MissionGroup/Guards/Delta Six" );
	$Bonesnap = getObjectId( "MissionGroup/Guards/Bonesnap" );
	$Hellfire = getObjectId( "MissionGroup/Guards/HellFire" );
}