// FILENAME:	DOE_Water_Rights.cs
//
// AUTHORS:  	=DOE= Ditto
//------------------------------------------------------------------------------

$missionName = "DOE_Water_Rights";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	temperateSounds();
}

function player::onAdd(%player)
{

    say(%this, 0, "Welcome to Hunting Grounds. This map was made" @
       " by =DOE= Ditto. sure to have fun, watch the language and visit us " @
       " at www.clhnexus.com. ");
}   


function vehicle::onAdd(%vehicleId)
{
  %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
  %player.name = getHUDName(%vehicleId);

  %color = getTeam(%vehicleId);
  if(%color == *IDSTR_TEAM_BLUE) %player.color = "BLUE";
  if(%color == *IDSTR_TEAM_RED) %player.color = "RED";
}


function onMissionLoad()
{
   cdAudioCycle("Purge", "Mechsoul", "SS3"); 
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\B1\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\B1\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\B1\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\B1\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\B1\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\B1\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\Extras\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\Extras\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\Extras\\Splash3"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\Extras\\WaterTower4")){
		setShapeVisibility(getObjectId("MissionGroup\\Extras\\Splash4"), true);
		playAnimSequence(getObjectId("MissionGroup\\Extras\\Splash4"), 0, true);
	}
		else if(%this == getObjectId("MissionGroup\\Extras\\WaterTower5")){
		setShapeVisibility(getObjectId("MissionGroup\\Extras\\Splash5"), true);
		playAnimSequence(getObjectId("MissionGroup\\Extras\\Splash5"), 0, true);
	}
		else if(%this == getObjectId("MissionGroup\\B2\\WaterTower6")){
		setShapeVisibility(getObjectId("MissionGroup\\B2\\Splash6"), true);
		playAnimSequence(getObjectId("MissionGroup\\B2\\Splash6"), 0, true);
	}
            else if(%this == getObjectId("MissionGroup\\B2\\WaterTower7")){
		setShapeVisibility(getObjectId("MissionGroup\\B2\\Splash7"), true);
		playAnimSequence(getObjectId("MissionGroup\\B2\\Splash7"), 0, true);
	}

}




