// FILENAME: DOE_Sahara_Showdown.cs
//
// AUTHORS:   =DOE= Ditto

$missionName = "DOE_Sahara_Showdown";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");


function setDefaultMissionOptions(){
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

	$server::disableTeamRed = false;
	$server::disableTeamBlue = false;
	$server::disableTeamYellow = true;
	$server::disableTeamPurple = true;
}

function onMissionStart(){
	dessertSounds();
}


function player::onAdd(%this)
{
   player::onAddLog(%this);
      say(%this,0, "Welcome to the Sahara Showdown! "@
      "This map was created by =DOE= Ditto. "@
      "Enjoy your stay! "@
      "Visit =DOE= at www.clhnexus.com");
}

function onMissionLoad()
{
   cdAudioCycle("Purge", "Mechsoul", "SS3"); 
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\City\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash3"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower4")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash4"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash4"), 0, true);
	}
		else if(%this == getObjectId("MissionGroup\\City\\WaterTower5")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash5"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash5"), 0, true);
	}
		else if(%this == getObjectId("MissionGroup\\City\\WaterTower6")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash6"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash6"), 0, true);
	}

}

//If someone shoots =DOE= HQ, retribution is soon to follow.
//------------------------------------------------
function tur1::turret::onAdd(%this)
{
	$turret1=%this;
	order($turret1,ShutDown,true);
}
function tur2::turret::onAdd(%this)
{
	$turret2=%this;
	order($turret2,ShutDown,true);
}
function tur3::turret::onAdd(%this)
{
	$turret3=%this;
	order($turret3,ShutDown,true);
}

function HQ::structure::onAttacked(%attacked,%attacker)
{

	order($turret1,ShutDown,false);
	order($turret1, Attack, %attacker);
	order($turret2,ShutDown,false);
	order($turret2, Attack, %attacker);
	order($turret3,ShutDown,false);
	order($turret3, Attack, %attacker);
	say(%this, 0, "Infidel! Begone!.", "sfx_siren.wav");
}