// FILENAME:	DOE_Ruins.cs
//
// AUTHORS:  	Bandit
//------------------------------------------------------------------------------

$missionName = "DOE_Ruins";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to the =DOE= ROCKS server. No profanity or flaming while you are here please. To join DOE, go to http://www.clhnexus.com. To find out about our Mechwarrior league (WNL), go to http://www.mech-league.com. This map kindly provided by |OF|Bandit. Have fun and enjoy!");
}


function onMissionStart()
{
	$healRate = 10000;   
	$ammoRate = 10000;
   	$padWaitTime = 30;
  	$zenWaitTime = 30;

	titanSounds();	
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

//If someone shoots frosty, his houses blow up revealing a nasty surprise
//------------------------------------------------
function tur1::turret::onAdd(%this)
{
	$turret1=%this;
	order($turret1,ShutDown,true);
}
function tur2::turret::onAdd(%this)
{
	$turret2=%this;
	order($turret2,ShutDown,true);
}
function Frosty::structure::onAttacked(%attacked,%attacker)
{
	%bang1=getObjectId("MissionGroup\\extra\\frosty's house\\house1");
	healObject(%bang1,-30000);
	order($turret1,ShutDown,false);
	order($turret1, Attack, %attacker);
	%bang2=getObjectId("MissionGroup\\extra\\frosty's house\\house2");
	healObject(%bang2,-30000);
	order($turret2,ShutDown,false);
	order($turret2, Attack, %attacker);
}
