// FILENAME:	DOE_New_Jack_City.cs
//
// AUTHORS:  	=DOE= Ditto
//------------------------------------------------------------------------------

$missionName = "DOE_New_Jack_City";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

	$server::disableTeamRed = false;
   	$server::disableTeamBlue = false;
   	$server::disableTeamYellow = true;
   	$server::disableTeamPurple = true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Watching", "Mechsoul"); 
}

function onMissionStart()
{
	temperateSounds();	
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to New Jack City. This map was made by =DOE= Ditto. Have fun and please watch the language.", "sfx_thunder2.WAV");
}


// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\City\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash3"), 0, true);
	}
}
// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function BlueZen::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function BlueZen::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $blueZenHealRate, $blueZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%object)){
		if(%object != $lastVehicleOnBlueZen){
			$lastVehicleOnBlueZen = %object;
			$secondsToGainBlueZen = 1;
		}
		else{
			$secondsToGainBlueZen = $secondsToGainBlueZen + 1;
		}
		if($secondsToGainBlueZen >= 5)
			giveBlueTurretsToThisGuy(%object);
	}
}

function RedZen::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function RedZen::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $redZenHealRate, $redZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%object)){
		if(%object != $lastVehicleOnRedZen){
			$lastVehicleOnRedZen = %object;
			$secondsToGainRedZen = 1;
		}
		else{
			$secondsToGainRedZen = $secondsToGainRedZen + 1;
		}
		if($secondsToGainRedZen >= 5)
			giveRedTurretsToThisGuy(%object);
	}
}
// Turret Code
// -----------------------------------------------------------------------------------


function giveBlueTurretsToThisGuy(%vehicleId){
	%team = getTeam(%vehicleId);
	setTeam("MissionGroup\\B1\\T1", %team);
	setTeam("MissionGroup\\B1\\T2", %team);
	order("MissionGroup\\B1", Shutdown, false);	
}

function giveRedTurretsToThisGuy(%vehicleId){
	%team = getTeam(%vehicleId);
	setTeam("MissionGroup\\B2\\T1", %team);
	setTeam("MissionGroup\\B2\\T2", %team);
	order("MissionGroup\\B2", Shutdown, false);	
}

//If someone shoots =DOE= HQ, retribution is soon to follow.
//------------------------------------------------
function tur1::turret::onAdd(%this)
{
	$turret1=%this;
	order($turret1,ShutDown,true);
}
function tur2::turret::onAdd(%this)
{
	$turret2=%this;
	order($turret2,ShutDown,true);
}


function HQ::structure::onAttacked(%attacked,%attacker)
{

	order($turret1,ShutDown,false);
	order($turret1, Attack, %attacker);
	order($turret2,ShutDown,false);
	order($turret2, Attack, %attacker);
	say(%this, 0, "You Have Desecrated Hallowed Ground, Prepare to Die.", "sfx_thunder1.WAV");
}

function warning::trigger::onEnter()
{
	say(0, 0, "Warning! You are entering =DOE= controlled territory.", "cyb_nex02.WAV");
}
