// FILENAME:	DOE_Metropolis.cs
//
// AUTHORS:  	=DOE= Ditto
//------------------------------------------------------------------------------

$missionName = "DOE_Metropolis";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = false;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

	$server::disableTeamRed = false;
   	$server::disableTeamBlue = true;
   	$server::disableTeamYellow = true;
   	$server::disableTeamPurple = true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Watching", "Mechsoul"); 
}

function onMissionStart()
{
	temperateSounds();	
}

function vehicle::onAdd(%vehicle) 
{ 
%player = playerManager::vehicleIdToPlayerNum(%vehicle); 
if( %player ) 
setTeam(%vehicle, *IDSTR_TEAM_NEUTRAL); 
}



// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\City\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\City\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\City\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\City\\Splash3"), 0, true);
	}
}

function Teleporter::trigger::onEnter(%this, %vehicleId)
{
	setPosition(%vehicleId, 541, 577, 800);
}

function warning::trigger::onEnter()
{
	say(0, 0, "Join =DOE Today! Just go to www.clhnexus.com and sign up.", "sfx_siren.wav");
}

function Beck::structure::onAttacked(%attacked, %attacker)
{
	healObject(%attacker, -10000);
	say(0, 0, "What Is Your Major Malfunction, Son!?.", "MH_G4.WAV");
}

function Beck::structure::onScan()
{
	say(0, 0, "I Joined =DOE= Because Chicks Love Rebels Ya Know.", "MH_G5.WAV");
}