// FILENAME:      DOE_Gimme_Shelter.cs
//
// AUTHOR:  	=DOE= Ditto
//------------------------------------------------------------------------------

$missionName = "DOE_Gimme_Shelter";



exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	initGlobalVars();
  
	

	$lastVehicleOnBlueZen = "";
	$secondsToGain = 0;
	$secondsToGainBlueZen = 0;
	
	titanSounds();
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Cyberntx", "Yougot"); 
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to Gimme Shelter. This map was made by =DOE= Ditto. Please have fun and watch the language.");
}

function vehicle::onAdd(%vehicleId)
{
%vehicleId.name = getHUDName(%vehicleId);
}


// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function BlueZen::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function BlueZen::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $blueZenHealRate, $blueZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%object)){
		if(%object != $lastVehicleOnBlueZen){
			$lastVehicleOnBlueZen = %object;
			$secondsToGainBlueZen = 1;
		}
		else{
			$secondsToGainBlueZen = $secondsToGainBlueZen + 1;
		}
		if($secondsToGainBlueZen >= 10)
			giveBlueTurretsToThisGuy(%object);
	}
}

// Turret Code
// -----------------------------------------------------------------------------------


function giveBlueTurretsToThisGuy(%vehicleId){
	%team = getTeam(%vehicleId);
	setTeam("MissionGroup\\CenterStructures\\T5", %team);
	setTeam("MissionGroup\\CenterStructures\\T6", %team);
	setTeam("MissionGroup\\CenterStructures\\T7", %team);
	setTeam("MissionGroup\\CenterStructures\\T8", %team);
	setTeam("MissionGroup\\CenterStructures\\NavZenBlue", %team);
	order("MissionGroup\\CenterStructures", Shutdown, false);	
}


