// FILENAME:	DOE_Earth_Base.cs
//
// AUTHORS:  	Bandit
//------------------------------------------------------------------------------

$missionName = "DOE_Earth_Base";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Newtech", "Cyberntx"); 
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to the =DOE= ROCKS server. No profanity or flaming while you are here please. To join DOE, go to http://www.clhnexus.com. To find out about our Mechwarrior league (WNL), go to http://www.mech-league.com. This map kindly provided by |OF|Bandit. Have fun and enjoy!");
}


// move the map
$server::HudMapViewOffsetX = -1500;
$server::HudMapViewOffsetY = 2500;

function onMissionStart()
{
	$healRate = 300;   
	$ammoRate = 300;
   	$padWaitTime = 20;
  	$zenWaitTime = 20;
	
	temperateSounds();
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}
