// FILENAME:	DOE_Colosseum.cs
//
// AUTHORS:  	
//------------------------------------------------------------------------------

$missionName = "DOE_Colosseum";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
   cdAudioCycle("Galeckzi", "Cyberntx", "Xolox"); 
}
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to The Colosseum. This map was made by =DOE= Ditto. Please visit us on the web at www.clhnexus.com.");
}

function vehicle::onAdd(%vehicleId)
{
%vehicleId.name = getHUDName(%vehicleId);
}

function turret::onAdd(%this)
{
	if($server::TeamPlay == false)
	{
		setTeam(%this, *IDSTR_TEAM_NEUTRAL);
	}
}

// Transporter Functionality
// --------------------------------------------------------------------------
function YellowTransporter::trigger::onEnter(%this, %vehicleId){
	%teamName = getTeam(%vehicleId);
	
	if(%teamName == *IDSTR_TEAM_RED){
			setPosition(%vehicleId, -16, 842, 99);
	}
	else if(%teamName == *IDSTR_TEAM_BLUE){
			setPosition(%vehicleId, -18, -912, 99);
	}
	
   

}
function BlueTransporter::trigger::onEnter(%this, %vehicleId){
			setPosition(%vehicleId, -142, -68, 99);

}
function RedTransporter::trigger::onEnter(%this, %vehicleId){
			setPosition(%vehicleId, 172, -75, 99);
}













