// FILENAME:	DM_Cold_Titan_Night.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DOE_Cold_Comfort";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;


  	$server::disableTeamRed = false;
  	$server::disableTeamBlue = false;
   	$server::disableTeamYellow = true;
   	$server::disableTeamPurple = true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "SS4", "Watching"); 
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to Cold Comfort. This map was made by =DOE= Ditto. Have fun and please watch the language.");
}

function onMissionStart()
{
	$healRate = 100;   
	$ammoRate = 3;
   	$padWaitTime = 30;
  	$zenWaitTime = 60;

	titanSounds();	
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

//If someone shoots frosty, his houses blow up revealing a nasty surprise
//------------------------------------------------
function tur1::turret::onAdd(%this)
{
	$turret1=%this;
	order($turret1,ShutDown,true);
}
function tur2::turret::onAdd(%this)
{
	$turret2=%this;
	order($turret2,ShutDown,true);
}
function Frosty::structure::onAttacked(%attacked,%attacker)
{
	%bang1=getObjectId("MissionGroup\\extra\\frosty's house\\house1");
	healObject(%bang1,-30000);
	order($turret1,ShutDown,false);
	order($turret1, Attack, %attacker);
	%bang2=getObjectId("MissionGroup\\extra\\frosty's house\\house2");
	healObject(%bang2,-30000);
	order($turret2,ShutDown,false);
	order($turret2, Attack, %attacker);
}
