// FILENAME:	Wedge_Winter_War.cs
//
// AUTHOR:  	Wedge
//------------------------------------------------------------------------------

$missionName = "Wedge_Winter_War";

exec("multiplayerStdLib.cs");

///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$gen1Destroyed = 0;
$gen2Destroyed = 0;
$gen3Destroyed = 0;
$gen4Destroyed = 0;
$gen5Destroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;

$BlueHerc1Path = "MissionGroup/BlueGuardPath1";
$BlueHerc2Path = "MissionGroup/BlueGuardPath2";
$BlueHerc3Path = "MissionGroup/BlueGuardPath3";

$PurpleHerc1Path = "MissionGroup/purpleBase/PurpleHercPath1";
$PurpleHerc2Path = "MissionGroup/purpleBase/PurpleHercPath2";
$PurpleHerc3Path = "MissionGroup/purpleBase/PurpleHercPath3";

$yellowHqDestroyed = false;
$redHqDestroyed = false;

///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 10;
$respawnDelayNoHq = 60;
$BUILDINGS_TO_DESTROY = 6;

///////////////////////////////////////////////////////////////////////////////////////////////////
// our base defender attributes
//
// The jump from 0.9 to 1.0 is a big one. At skill 1.0 and accuracy 1.0 the AI units will aim 
// first for the weapons, then the legs. A little too much for this mission.
//
///////////////////////////////////////////////////////////////////////////////////////////////////
Pilot YellowPilot
{
   id = 28;
   
   name = "Blue Base Defender";
   
   skill = 2.9;
   accuracy = 2.9;
   aggressiveness = 3.0;
   activateDist = 1150.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot RedPilot
{
   id = 29;
   
   name = "Purple Base Defender";
   
   skill = 2.9;
   accuracy = 2.9;
   aggressiveness = 3.0;
   activateDist = 1150.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
		%player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}

function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = false;
}

function setDefaultMissionItems()
{
   allowComponent(        830, TRUE  );      //Chameleon
   allowComponent(        831, TRUE  );      //Cuttlefish cloak
   allowComponent(        840, TRUE  );      //Shield Modulator
   allowComponent(        914, TRUE  );      //UAP
}

function onMissionLoad()
{
   cdAudioCycle("SS3", "Gnash", "Cloudburst"); 

   // get the original ID for each AI Herc ( for use later when we clone them )
   // I didn't rename these, just used red and yellow  - Wedge
   $yellowHerc1 = getObjectId( "MissionGroup/BlueHerc1/herc1" );
   $yellowHerc2 = getObjectId( "MissionGroup/BlueHerc2/herc1" );
   $yellowHerc3 = getObjectId( "MissionGroup/BlueHerc3/herc1" );

   $redHerc1 = getObjectId( "MissionGroup/PurpleHerc1/herc1" );
   $redHerc2 = getObjectId( "MissionGroup/PurpleHerc2/herc1" );
   $redHerc3 = getObjectId( "MissionGroup/PurpleHerc3/herc1" );


   %rules = "<tIDMULT_WAR_GAMETYPE>"      @        
            "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName                  @  
            "<tIDMULT_WAR_OBJECTIVES_1>"  @
            timeDifference($respawnDelay, 0)       @
            "<tIDMULT_WAR_OBJECTIVES_2>"  @
            timeDifference($respawnDelayNoHq, 0)   @
            "<tIDMULT_WAR_OBJECTIVES_3>"  @
            "<tIDMULT_WAR_OBJECTIVES_4>"  @
            $BUILDINGS_TO_DESTROY         @
            "<tIDMULT_WAR_OBJECTIVES_5>"  @
            "<tIDMULT_WAR_SCORING_1>"     @
            "<tIDMULT_WAR_SCORING_2>"     @
            "<tIDMULT_STD_ITEMS>"         @
            "<tIDMULT_WAR_HQ>"            @
            "<tIDMULT_WAR_GENERATORS>"    @
            "<tIDMULT_WAR_TURRETS>"       @
            "<tIDMULT_WAR_FLAGS>"         @
            "<tIDMULT_WAR_GLOW>"          @
            "<tIDMULT_STD_HEAL>"          @
            "<tIDMULT_STD_RELOAD_1>"      @
            $PadWaitTime                  @
            "<tIDMULT_STD_RELOAD_2>";
   
   setGameInfo(%rules);
}


//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to Wedge's Winter War!  To comment on this mission, send email to bdu_wedge@go.com ");
}

function vehicle::onAdd(%this)
{
   // see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
      schedule( "order( $yellowHerc1, guard, $BlueHerc1Path );", 1);
      schedule( "order( $yellowHerc2, guard, $BlueHerc2Path );", 1);
      schedule( "order( $yellowHerc3, guard, $BlueHerc3Path );", 1);

      schedule( "order( $redHerc1, guard, $PurpleHerc1Path );", 1);
      schedule( "order( $redHerc2, guard, $PurpleHerc2Path );", 1);
      schedule( "order( $redHerc3, guard, $PurpleHerc3Path );", 1);

      schedule( "order( $yellowHerc1, speed , high );", 1);
      schedule( "order( $yellowHerc2, speed , high );", 1);
      schedule( "order( $yellowHerc3, speed , high );", 1);

      schedule( "order( $redHerc1, speed , high );", 1);
      schedule( "order( $redHerc2, speed , high );", 1);
      schedule( "order( $redHerc3, speed , high );", 1);

      return;
   }
   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );

}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_BLUE )
   {
      setNavMarker( "MissionGroup/purpleBase/navPoint", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/BlueBase/navPoint", true, %this );
   }
}


function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam( %this ) == *IDSTR_TEAM_PURPLE )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }
   
   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------
   if( %this == $yellowHerc1 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", -384, -728, 141);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", -384, -728, 141);", $respawnDelayNoHq);
      }
   }
   if( %this == $yellowHerc2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 104, -922, 126);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 104, -922, 126);", $respawnDelayNoHq);
      }
   }
   if( %this == $yellowHerc3 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", 6, -1136, 160);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", 6, -1136, 160);", $respawnDelayNoHq);
      }
   }


   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -581, 1096, 120);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -581, 1096, 120);", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", 101, 1061, 121);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", 101, 1061, 121);", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -220, 1283, 138);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -220, 1283, 138);", $respawnDelayNoHq);
      }
   }

  
   // left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

   // rules enforcement
   if(
      (getTeam(%this) == getTeam(%destroyer)) &&
      (%this != %destroyer)
   )
   {
      antiTeamKill(%destroyer);
   }
}

function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Kills";
	$ScoreBoard::PlayerColumnHeader3 = "Buildings Destroyed";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Structures Remaining";
   $ScoreBoard::TeamColumnHeader2 = "Total Kills";
   $ScoreBoard::TeamColumnFunction1 = "getRemainingStructures";
   $ScoreBoard::TeamColumnFunction2 = "getTeamKills";
 
   serverInitScoreBoard();
}

function getTeam2(%player)
{
   if( getTeam( %player ) == *IDSTR_TEAM_BLUE )
   {
      return *IDMULT_BLUE;
   }
   else
   {
      return *IDMULT_PURPLE;
   }
}

function getKills(%player)
{
   if( %player.numKills != "")
      return %player.numKills;
      
   return "0";
}

function getTeamKills(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_BLUE )
   {
      return $yellowKills;
   }
   else
   {
      return $redKills;
   }   
}

function getRemainingStructures(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_BLUE )
   {
      return $BUILDINGS_TO_DESTROY - $yellowBuildingsDestroyed;
   }
   else
   {
      return $BUILDINGS_TO_DESTROY - $redBuildingsDestroyed;
   }   
}

function getBuildingsDestroyed(%player)
{
   if( %player.buildingsDestroyed != "")
      return %player.buildingsDestroyed;
   
   return "0";
}

function redGen1::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
damageObject("MissionGroup/Pcannon1", 250000);
 // order( "MissionGroup/redBase/t1", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;
  }

  %txt = "<F5>" @ getHUDName(%who) @ " shot up Purple team's #1 Generator reeeeal good";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " shot up Purple team's #1 Generator reeeeal good";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
}

function redGen2::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
damageObject("MissionGroup/Pcannon2", 250000);
 // order( "MissionGroup/redBase/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " obliterated Purple team's #2 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " obliterated Purple team's #2 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
}

function redGen3::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 damageObject("MissionGroup/Pcannon3", 250000);
  //order( "MissionGroup/redBase/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " hammered Purple team's #3 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " hammered Purple team's #3 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
}

function redGen4::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
damageObject("MissionGroup/Pcannon4", 250000);
 // order( "MissionGroup/redBase/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " annihilated Purple team's #4 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " annihilated Purple team's #4 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
}

function redGen5::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

damageObject("MissionGroup/Pcannon5", 250000);
 // order( "MissionGroup/redBase/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " demolished Purple team's #5 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " demolished Purple team's #5 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen1::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  $gen1Destroyed = 1;
  checkForWin();

  //order( "MissionGroup/blueBase/cannon1", shutdown, True );
  damageObject("MissionGroup/cannon1", 250000); 

  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " hammered Blue team's #1 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " hammered Blue team's #1 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen2::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  $gen2Destroyed = 1;

  checkForWin();
   damageObject("MissionGroup/cannon2", 250000);

 // order( "MissionGroup/yellowBase/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " blew the hell out of Blue team's #2 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " blew the hell out of Blue team's #2 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen3::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  $gen3Destroyed = 1;
  checkForWin();

  damageObject("MissionGroup/cannon3", 250000);

 // order( "MissionGroup/yellowBase/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " demolished Blue team's #3 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " demolished Blue team's #3 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen4::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  $gen4Destroyed = 1;

  checkForWin();

  damageObject("MissionGroup/cannon4", 250000);

 // order( "MissionGroup/yellowBase/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " obliterated Blue team's #4 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " obliterated Blue team's #4 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen5::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  $gen5Destroyed = 1;

  checkForWin();
damageObject("MissionGroup/cannon5", 250000);


 // order( "MissionGroup/yellowBase/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " destroyed Blue team's #5 Generator";
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " destroyed Blue team's #5 Generator";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}

function redHQ::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  $redHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ " destroyed Purple team's Headquarters";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    
  say(IDSTR_TEAM_PURPLE, 1234, %txt, "friend_struct_des.wav");    
  say(0, 1234, "<F5>" @ "Purple Team's Headquarters destroyed! Purple team AI respawn time set to " @ timeDifference($respawnDelayNoHq, 0) @ "." );
}


function yellowHQ::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();


  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $yellowHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ " destroyed Blue team's Headquarters";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_PURPLE, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ "Blue Team's Headquarters destroyed! Blue team AI respawn time set to " @ timeDifference($respawnDelayNoHq, 0) @ "." );
}


function onMissionStart()
{
	$healRate = 100;   
	$ammoRate = 3;
 	$padWaitTime = 45;

windSounds();
	iceSounds();	

   initGlobalVars();
   
   order( $yellowHerc1, guard, $BlueHerc1Path );
   order( $yellowHerc2, guard, $BlueHerc2Path );
   order( $yellowHerc3, guard, $BlueHerc3Path );

   order( $redHerc1, guard, $PurpleHerc1Path );
   order( $redHerc2, guard, $PurpleHerc2Path );
   order( $redHerc3, guard, $PurpleHerc3Path );

order( $yellowHerc1, speed , high );
order( $yellowHerc2, speed , high );
order( $yellowHerc3, speed , high );

order( $redHerc1, speed , high );
order( $redHerc2, speed , high );
order( $redHerc3, speed , high );

}

function checkForWin()
{
   if( $yellowBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Purple team wins!";
      messageBox(0, %txt);
   }
   else if( $redBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Blue team wins!";
      messageBox(0, %txt);
   }   
}


// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}
 
function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}


