// FILENAME:	
//------------------------------------------------------------------------------

$missionName = "War Sear Strip";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

$yellowHerc1Path = "MissionGroup/yellowHerc1Path";
$yellowHerc2Path = "MissionGroup/yellowHerc2Path";
$yellowHerc3Path = "MissionGroup/yellowHerc3Path";
$yellowHerc4Path = "MissionGroup/yellowHerc4Path";

$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";
$redHerc4Path = "MissionGroup/redHerc4Path";


///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;

$yellowHqDestroyed = false;
$redHqDestroyed = false;

///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 60;
$respawnDelayNoHq = 120;

$Red_BUILDINGS_TO_DESTROY = 7;
$Yellow_BUILDINGS_TO_DESTROY = 6;



Pilot YellowPilot
{
   id = 28;
   name = *IDMULT_WAR_YELLOW_DEFENDER;
   skill = 2.0;
   accuracy = 1.5;
   aggressiveness = 2.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 0.3;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

Pilot RedPilot
{
   id = 29;   
   name = *IDMULT_WAR_RED_DEFENDER;
   skill = 2.0;
   accuracy = 1.0;
   aggressiveness = 2.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 0.3;
   trackFreq = 0.1;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 0.1;
};

function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
      %player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}


function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

}

function setDefaultMissionItems()
{
   allowWeapon(    150,FALSE); //SMARTGun

}

function onMissionLoad()
{
   cdAudioCycle("Gnash", "Cloudburst", "Cyberntx"); 


   $transportExit1 = getObjectId( "MissionGroup/transporterExit/exit1" );
   $transportExit2 = getObjectId( "MissionGroup/transporterExit/exit2" );
   $transportExit3 = getObjectId( "MissionGroup/transporterExit/exit3" );


   $redReload = getObjectId( "MissionGroup/redHercs/reloadPath/redReload" );

   $yellowReload = getObjectId( "MissionGroup/yellowHercs/reloadPath/yellowReload" );


// get the original ID for each AI Herc ( for use later when we clone them )
   $yellowHerc1 = getObjectId( "MissionGroup/yellowHercs/h1" );
   $yellowHerc2 = getObjectId( "MissionGroup/yellowHercs/h2" );
   $yellowHerc3 = getObjectId( "MissionGroup/yellowHercs/h3" );
   $yellowHerc4 = getObjectId( "MissionGroup/yellowHercs/h4" );

   $redHerc1 = getObjectId( "MissionGroup/redHercs/h1" );
   $redHerc2 = getObjectId( "MissionGroup/redHercs/h2" );

  $aiMade = false;

    deleteObject( "MissionGroup/yellowHercs/h1" );
    deleteObject( "MissionGroup/yellowHercs/h2" );
    deleteObject( "MissionGroup/yellowHercs/h3" );
    deleteObject( "MissionGroup/yellowHercs/h4" );

    deleteObject( "MissionGroup/redHercs/h1" );
    deleteObject( "MissionGroup/redHercs/h2" );

   %rules = "<tIDMULT_WAR_GAMETYPE>"      @        
            "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName                  @  
" \nThe defending AI are randomly picked from the players.\n\n" @
"One team has three Weapons cache that counts as buildings\n\n" @
"The regular WAR rules apply.";

   setGameInfo(%rules);

}

function onMissionStart()
{
	// Keep tracks of hercs near a door
	$HercsAtDoor1 = 0;
	$HercsAtDoor2 = 0;
	$HercsAtDoor3 = 0;
	$HercsAtDoor4 = 0;
	$HercsAtDoor5 = 0;
	$HercsAtDoor6 = 0;
	$HercsAtDoor7 = 0;
	$HercsAtDoor8 = 0;
	$HercsAtDoor9 = 0;


	$healRate = 100;   
	$ammoRate = 3;
   	$padWaitTime = 45;
  	$zenWaitTime = 90;
	
	europaSounds();


}

//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, *IDMULT_WAR_WELCOME);
}

function vehicle::onAdd(%this)
{
   // see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );

  if ( $aiMade == false )
   {
     $aiMade = true;
     schedule ("makeAIguards();", 45);
   }

}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
      setNavMarker( "MissionGroup/nav/redNav", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/nav/yellowNav", true, %this );
   }
}

function vehicle::onDestroyed( %this, %destroyer )
{
echo ("start of vehicle destroyed");

   if( getTeam( %this ) == *IDSTR_TEAM_RED )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

echo ("before award player kill");

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }
echo ("after award player kill");
   
   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------

   if( %this == $yellowHerc1 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", 1808, -1390, 75);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ",  1808, -1390, 75);", $respawnDelayNoHq);
      }
   }
   if( %this == $yellowHerc2 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 1824, -1359, 75);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 1824, -1359, 75);", $respawnDelayNoHq);
      }
   }
   if( %this == $yellowHerc3 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ",  1822, -1327, 75);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ",  1822, -1327, 75);", $respawnDelayNoHq);
      }
   }

   if( %this == $yellowHerc4 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc4\", " @ %this @ ",  1822, -1327, 75);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc4\", " @ %this @ ",  1822, -1327, 75);", $respawnDelayNoHq);
      }
   }




   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", 203, 471, 200);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ",   203, 471, 200);", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", 161, 450, 195);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ",  161, 450, 195);", $respawnDelayNoHq);
      }
   }

///////////
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", 155, 455, 195);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ",  155, 455, 195);", $respawnDelayNoHq);
      }
   }

   if( %this == $redHerc4 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc4\", " @ %this @ ", 166, 445, 195);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc4\", " @ %this @ ",  166, 445, 195);", $respawnDelayNoHq);
      }
   }

//////////////





   // left over from missionStdLib.cs
//   vehicle::onDestroyedLog(%this, %destroyer);

// give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

}


//--------------------------- structure destroyed -------------------
function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Kills";
	$ScoreBoard::PlayerColumnHeader3 = "Buildings Destroyed";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Structures Remaining";
   $ScoreBoard::TeamColumnHeader2 = "Total Kills";
   $ScoreBoard::TeamColumnFunction1 = "getRemainingStructures";
   $ScoreBoard::TeamColumnFunction2 = "getTeamKills";
 
   serverInitScoreBoard();
}

function getTeam2(%player)
{
   if( getTeam( %player ) == *IDSTR_TEAM_YELLOW )
   {
      return *IDMULT_YELLOW;
   }
   else
   {
      return *IDMULT_RED;
   }
}

function getKills(%player)
{
   if( %player.numKills != "")
      return %player.numKills;
      
   return "0";
}

function getTeamKills(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $yellowKills;
   }
   else
   {
      return $redKills;
   }   
}

function getRemainingStructures(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $BUILDINGS_TO_DESTROY - $yellowBuildingsDestroyed;
   }
   else
   {
      return $BUILDINGS_TO_DESTROY - $redBuildingsDestroyed;
   }   
}

function getBuildingsDestroyed(%player)
{
   if( %player.buildingsDestroyed != "")
      return %player.buildingsDestroyed;
   
   return "0";
}


function cache1::structure::onDestroyed( %this, %who )
{

//say (0,0, "DEBUG: blast " @ %this @" who " @ %who );


  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    



  blast ( %this, 125, 10000, 0 );

  $redBuildingsDestroyed++;
  checkForWin();
}

function cache2::structure::onDestroyed( %this, %who )
{

//say (0,0, "BDEBUG: blast " @ %this @" who " @ %who );


  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    


  blast ( %this, 128, 10000, 0 );

  $redBuildingsDestroyed++;
  checkForWin();
}

function cache3::structure::onDestroyed( %this, %who )
{

//say (0,0, "BDEBUG: blast " @ %this @" who " @ %who );

  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ "Weapons cache#3 destroyed";
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    

  blast ( %this, 128, 10000, 0 );

  $redBuildingsDestroyed++;
  checkForWin();
}

function redGen1::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/Turrets/t1", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen2::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/Turrets/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen3::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  order( "MissionGroup/redBase/Turrets/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen4::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/Turrets/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen5::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/Turrets/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen1::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/Turrets/t1", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen2::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/Turrets/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen3::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/Turrets/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen4::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/Turrets/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen5::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/Turrets/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function redHQ::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  $redHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_RED_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}


function yellowHQ::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $yellowHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_YELLOW_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}

//- ---------------------- Win Condition ------------------
function checkForWin()
{
   if( $yellowBuildingsDestroyed >= $Yellow_BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Red team wins!";
      messageBox(0, %txt);
   }
   else if( $redBuildingsDestroyed >= $Red_BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Yellow team wins!";
      messageBox(0, %txt);
   }   
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}
 
function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}



//-------------------------- Door Stuff --------------------------------------------

function door1::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door1"), 0, true);
	}
	$hercsAtDoor1 = $hercsAtDoor1 + 1;
}
function door1::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtDoor1 = $hercsAtDoor1 - 1;
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door1"), 0, false);
	}
}
function door2::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\Door2"), 0, true);
	}
	$hercsAtDoor2 = $hercsAtDoor2 + 1;
}
function door2::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtDoor2 = $hercsAtDoor2 - 1;
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door2"), 0, false);
	}
}

function door3::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor3 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door3"), 0, true);
	}
	$hercsAtdoor3 = $hercsAtdoor3 + 1;
}

function door3::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor3 = $hercsAtdoor3 - 1;
	if($hercsAtdoor3 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door3"), 0, false);
	}
}

function door4::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor4 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door4"), 0, true);
	}
	$hercsAtdoor4 = $hercsAtdoor4 + 1;
}
function door4::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor4 = $hercsAtdoor4 - 1;
	if($hercsAtdoor4 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door4"), 0, false);
	}
}

function door5::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor5 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door5"), 0, true);
	}
	$hercsAtdoor5 = $hercsAtdoor5 + 1;
}
function door5::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor5 = $hercsAtdoor5 - 1;
	if($hercsAtdoor5 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door5"), 0, false);
	}
}

function door6::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor6 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door6"), 0, true);
	}
	$hercsAtdoor6 = $hercsAtdoor6 + 1;
}
function door6::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor6 = $hercsAtdoor6 - 1;
	if($hercsAtdoor6 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door6"), 0, false);
	}
}

function door7::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor7 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door7"), 0, true);
	}
	$hercsAtdoor7 = $hercsAtdoor7 + 1;
}
function door7::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor7 = $hercsAtdoor7 - 1;
	if($hercsAtdoor7 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door7"), 0, false);
	}
}

function door8::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor8 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door8"), 0, true);
	}
	$hercsAtdoor8 = $hercsAtdoor8 + 1;
}
function door8::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor8 = $hercsAtdoor8 - 1;
	if($hercsAtdoor8 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door8"), 0, false);
	}
}

function door9::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtdoor9 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door9"), 0, true);
	}
	$hercsAtdoor9 = $hercsAtdoor9 + 1;
}
function door9::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtdoor9 = $hercsAtdoor9 - 1;
	if($hercsAtdoor9 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Doors\\door9"), 0, false);
	}
}

//------------------------- Transporter ----------------------------------------

function transporter1::trigger::onEnter(%this, %vehicleId )
{
   %playerNum = playerManager::vehicleIdToPlayerNum ( %vehicleId );

// so we don't try to transport into another player
   %exit1Safe = true;
   %exit2Safe = true;
   %exit3Safe = true;

   %count = playerManager::getPlayerCount();
   for(%i = 0; %i < %count; %i = %i + 1)
      {
       %curPlayerNum = playerManager::getPlayerNum(%i);
       %curVehicle = playerManager::playerNumToVehicleId(%curPlayerNum);

       %curDist = getDistance ( $transportExit1, %curVehicle );

//say (0,0, "DEBUG: curdist = " @ %curDist );

      if ( %curDist < 15 ) %exit1Safe = false;

       %curDist = getDistance ( $transportExit2, %curVehicle );

//say (0,0, "DEBUG: curdist = " @ %curDist );

      if ( %curDist < 15 ) %exit2Safe = false;

       %curDist = getDistance ( $transportExit3, %curVehicle );

//say (0,0, "DEBUG: curdist = " @ %curDist );

      if ( %curDist < 15 ) %exit3Safe = false;

     } // end for loop


// if the exits are safe, do the transport

   if ( %exit1Safe == true )
     {

// play a sound at both locations
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
//   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);
   
   fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
   schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 1.2);

   schedule(strcat("warp (", %vehicleId, ",",$transportExit1, ");"), 1.0);
     }
    else if ( %exit2Safe == true )
     {

// play a sound at both locations
      playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
//      playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);

      fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
      schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 1.2);

      schedule(strcat("warp (", %vehicleId , ",",$transportExit2, ");"), 1.0);
     }
    else if ( %exit3Safe == true )
     {

// play a sound at both locations
      playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
//      playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);

      fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
      schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 1.2);

      schedule(strcat("warp (", %vehicleId , ",",$transportExit3, ");"), 1.0);
     }

//  randomTransport( %vehicleId, -383, 586, 0, 660); //%x1, %y1, %x2, %y2)
}

//------------------------ AI Heal Stuff ------------------------------
function AIherc::vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

//say (0,0, "DEBUG: this= "@ %this @ " message = "@ %message @ " _1= "@ %_1 );

  if (getTeam (%this) == *IDSTR_TEAM_RED)
   {
     repairReloadRed(%this);
   }
  else
   {
     repairReloadYellow(%this);
   }

}

function repairReloadRed (%this)
{
  order (%this, guard, $redReload);
}

function repairReloadYellow (%this)
{
  order (%this, guard, $yellowReload);
}

function AIherc::vehicle::onArrived (%who, %where)
{

//say (0,0, "DEBUG: who = " @ %who @ " where " @ %where );


  if (%where == $redReload )
    {
//say (0,0, "DEBUG: red Zen " );

      schedule ("order (" @ %who @ ", shutdown, true );", 1 );
      schedule ("order (" @ %who @ ", shutdown, false );", 5 );

     if ( %who == $redHerc1 )
      {
       order( %who, guard, $redHerc1Path );
      }

     if ( %who == $redHerc2 )
      {
       order( %who, guard, $redHerc2Path );
      }

     if ( %who == $redHerc3 )
      {
       order( %who, guard, $redHerc3Path );
      }


    }

  if (%where == $yellowReload )
    {

//say (0,0, "DEBUG: Yellow ZEN " );

      schedule ("order (" @ %who @ ", shutdown, true );", 1 );
      schedule ("order (" @ %who @ ", shutdown, false );", 5 );


     if ( %who == $yellowHerc1 )
      {
       order( %who, guard, $yellowHerc1Path );
      }

     if ( %who == $yellowHerc2 )
      {
       order( %who, guard, $yellowHerc2Path );
      }

     if ( %who == $yellowHerc3 )
      {
       order( %who, guard, $yellowHerc3Path );
      }

     if ( %who == $yellowHerc4 )
      {
       order( %who, guard, $yellowHerc4Path );
      }

    }

}


function AIZen::trigger::onEnter(%this, %object)
{
// keep humans from using the fast zen
   %player = playerManager::vehicleIdToPlayerNum(%object);
   if(%player != 0) 
      return;

   	Zen::onEnter(%this, %object, "", true, true);  
}

function AIZen::trigger::onContact(%this, %object)
{
// keep humans from using the fast zen
   %player = playerManager::vehicleIdToPlayerNum(%object);
   if(%player != 0) 
      return;

     Zen::work(%this, %object, 1000, 1000, 0, true); 
}

//-----------------------------------------------------------------------------
function pickPlayer ()
{
// do 100 just to make sure we get a player that is in the game
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if ( %playerVeh != "" )
       {
         return %playerVeh;
       }
     }
  return 0;

}

function makeAIguards()
{

   %playerVeh = pickPlayer ();

 if (%playerVeh > 1000)
   {
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 29);
   setTeam (%herc, *IDSTR_TEAM_RED);
   addToSet( "MissionGroup/redHercs", %herc );

  setPOsition (%herc, 203, 471, 200);

  $redHerc1 = %herc;

   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 29);
   setTeam (%herc, *IDSTR_TEAM_RED);
   addToSet( "MissionGroup/redHercs", %herc );
  setPOsition (%herc, 161, 450, 195);

$redHerc2 = %herc;


   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 29);
   setTeam (%herc, *IDSTR_TEAM_RED);
   addToSet( "MissionGroup/redHercs", %herc );
  setPOsition (%herc, 155, 455, 195);

$redHerc3 = %herc;

   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 29);
   setTeam (%herc, *IDSTR_TEAM_RED);
   addToSet( "MissionGroup/redHercs", %herc );
  setPOsition (%herc, 166, 445, 195);

$redHerc4 = %herc;




   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 28);
   setTeam (%herc, *IDSTR_TEAM_YELLOW);
   addToSet( "MissionGroup/yellowHercs", %herc );

  setPOsition (%herc, 1808, -1390, 75);

$yellowHerc1 = %herc;

   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 28);
   setTeam (%herc, *IDSTR_TEAM_YELLOW);
   addToSet( "MissionGroup/yellowHercs", %herc );
$yellowHerc2 = %herc;

  setPOsition (%herc, 1824, -1359, 75);



   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 28);
   setTeam (%herc, *IDSTR_TEAM_YELLOW);
   addToSet( "MissionGroup/yellowHercs", %herc );
$yellowHerc3 = %herc;

  setPOsition (%herc, 1822, -1327, 75);

   %playerVeh = pickPlayer ();
   %herc = cloneVehicle(%playerVeh);
   SetPilotId( %herc, 28);
   setTeam (%herc, *IDSTR_TEAM_YELLOW);
   addToSet( "MissionGroup/yellowHercs", %herc );
$yellowHerc4 = %herc;

  setPOsition (%herc, 1815, -1327, 80);


schedule ("orderguard();", 5);

  }
  else
  {
  schedule ("makeAIguards();", 40);
  }

}


function orderguard()
{

   order( $yellowHerc1, guard, $yellowHerc1Path );
   order( $yellowHerc2, guard, $yellowHerc2Path );
   order( $yellowHerc3, guard, $yellowHerc3Path );
   order( $yellowHerc4, guard, $yellowHerc4Path );

   order( $redHerc1, guard, $redHerc1Path );
   order( $redHerc2, guard, $redHerc2Path );
   order( $redHerc3, guard, $redHerc3Path );
   order( $redHerc4, guard, $redHerc4Path );
}


