// FILENAME:	missiontest.cs
//
// AUTHORS:  	Dolf Kooz
//------------------------------------------------------------------------------

$missionName = "tnf";

exec("multiplayerStdLib.cs");
//exec("DMstdLib.cs");


say(0,0, "starting mission");

//exec("vanilla.cs");



///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 60;
$respawnDelayNoHq = 120;
$BUILDINGS_TO_DESTROY = 8;


$blueKills = 0;
$yellowKills = 0;

$yellowBuildingsDestroyed = 0;
$blueBuildingsDestroyed = 0;

$yellowHqDestroyed = false;
$blueHqDestroyed = false;

//$blueRespawnpoint = "MissionGroup/blueHerc/point";

$blueHerc1t = "MissionGroup/blueHerc/hercGroup1";
$bluePath1t = "MissionGroup/blueHerc/path1";

$blueHerc2t = "MissionGroup/blueHerc/hercGroup2";
$bluePath2t = "MissionGroup/blueHerc/path2";

$blueHerc3t = "MissionGroup/blueHerc/hercGroup3";
$bluePath3t = "MissionGroup/blueHerc/path3";


$yellowHerc1t = "MissionGroup/yellowHerc/hercGroup1";
$yellowPath1t = "MissionGroup/yellowHerc/path1";

$yellowHerc2t = "MissionGroup/yellowHerc/hercGroup2";
$yellowPath2t = "MissionGroup/yellowHerc/path2";

$yellowHerc3t = "MissionGroup/yellowHerc/hercGroup3";
$yellowPath3t = "MissionGroup/yellowHerc/path3";

$blueHQt = "MissionGroup/blueBuilding/blueHQ";
$yellowHQt = "MissionGroup/yellowBuilding/yellowHQ";

// starting path

$bluePathCntr = 1;
$yellowPathCntr = 1;


//$yellowGen1t = "MissionGroup/yellowGen/yellowGen1";
// gens not used

$yellowTurret1t = "MissionGroup/yellowTurret/yellowTurret1";
$yellowTurret2t = "MissionGroup/yellowTurret/yellowTurret2";
$yellowTurret3t = "MissionGroup/yellowTurret/yellowTurret3";
$yellowTurret4t = "MissionGroup/yellowTurret/yellowTurret4";
$yellowTurret5t = "MissionGroup/yellowTurret/yellowTurret5";
$yellowTurret6t = "MissionGroup/yellowTurret/yellowTurret6";
$yellowTurret7t = "MissionGroup/yellowTurret/yellowTurret7";

$blueTurret1t = "MissionGroup/blueTurret/blueTurret1";
$blueTurret2t = "MissionGroup/blueTurret/blueTurret2";
$blueTurret3t = "MissionGroup/blueTurret/blueTurret3";
$blueTurret4t = "MissionGroup/blueTurret/blueTurret4";
$blueTurret5t = "MissionGroup/blueTurret/blueTurret5";
$blueTurret6t = "MissionGroup/blueTurret/blueTurret6";
$blueTurret7t = "MissionGroup/blueTurret/blueTurret7";

// Where we drop respawned AI hercs

$blueDrop1 = "-158, -1405, 35";
$blueDrop2 = "10, -1501, 40";
$blueDrop3 = "-123, -1587, 35";
$blueDrop4 = "-191, -1162, 40";

$yellowDrop1 = "9, 1529, 30";
$yellowDrop2 = "119, 1630, 45";
$yellowDrop3 = "-107, 1819, 40";
$yellowDrop4 = "151, 1841, 40";

// debug stuff

$yellowPath4t = "MissionGroup/yellowHerc/path4";


// general patrol herc
Pilot Chaos
{
   id = 28;
   
   name = Chaos;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot X
{
   id = 29;
   
   name = X;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Raven
{
   id = 30;
   
   name = Raven;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Dolf
{
   id = 31;
   
   name = Dolf;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Midnight
{
   id = 32;
   
   name = Midnight;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Nasty
{
   id = 33;
   
   name = Nasty;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot CaveMan
{
   id = 34;
   
   name = CaveMan;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot TimberWulfe
{
   id = 35;
   
   name = TimberWolfe;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot WarHawk
{
   id = 36;
   
   name = WarHawk;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Lucky
{
   id = 37;
   
   name = Lucky;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Tarasque
{
   id = 38;
   
   name = Tarasque;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Zippy
{
   id = 39;
   
   name = Zippy;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot BlackHawk
{
   id = 40;
   
   name = BlackHawk;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Lisa
{
   id = 41;
   
   name = Lisa;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot PaleHorse
{
   id = 42;
   
   name = PaleHorse;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Beagle
{
   id = 43;
   
   name = Beagle;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot QhariNa
{
   id = 44;
   
   name = QhariNa;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot BlueMax
{
   id = 45;
   
   name = BlueMax;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Qxygen
{
   id = 46;
   
   name = Qxygen;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot SteelFire
{
   id = 47;
   
   name = SteelFire;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 750.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 1.0;
   fireFreq = 0.5;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
function setDefaultMissionOptions()
{
//say(0,0, "DEBUG:setDefaultMissionOptions() ");


	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

}
///////////////////////////////////////////////////////////////////////////////////////////////////
function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
		%player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
      setNavMarker( "MissionGroup/NavPoints/NavBlue", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/NavPoints/NavYellow", true, %this );
   }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function setDefaultMissionItems() 
{

//say(0,0,"DEBUG:on setDefaultMissionItems() ");

//allowWeapon (150, FALSE);//SMARTGun

}
///////////////////////////////////////////////////////////////////////////////////////////////////
function onMissionLoad()
{

//say(0,0,"DEBUG:on onMissionLoad() ");


   cdAudioCycle("Purge", "Terror", "Watching"); 

$gameType = "Multiplayer";

   %rules = "<tIDMULT_WAR_GAMETYPE>"      @        
            "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName                  @  
            "<tIDMULT_WAR_OBJECTIVES_1>"  @
            timeDifference($respawnDelay, 0)       @
            "<tIDMULT_WAR_OBJECTIVES_2>"  @
            timeDifference($respawnDelayNoHq, 0)   @
            "<tIDMULT_WAR_OBJECTIVES_3>"  @
            "<tIDMULT_WAR_OBJECTIVES_4>"  @
            $BUILDINGS_TO_DESTROY         @
            "<tIDMULT_WAR_OBJECTIVES_5>"  @
            "<tIDMULT_WAR_SCORING_1>"     @
            "<tIDMULT_WAR_SCORING_2>"     @
            "<tIDMULT_STD_ITEMS>"         @
            "<tIDMULT_WAR_HQ>"            @
            "<tIDMULT_WAR_GENERATORS>"    @
            "<tIDMULT_WAR_TURRETS>"       @
            "<tIDMULT_WAR_FLAGS>"         @
            "<tIDMULT_WAR_GLOW>"          @
            "<tIDMULT_STD_HEAL>"          @
            "<tIDMULT_STD_RELOAD_1>"      @
            $PadWaitTime                  @
            "<tIDMULT_STD_RELOAD_2>";

   setGameInfo(%rules);

//get the object IDs for all the hercs and paths

   $blueHerc1 = getObjectId( $blueHerc1t );
   $bluePath1 = getObjectId( $bluePath1t );

   $blueHerc2 = getObjectId( $blueHerc2t );
   $bluePath2 = getObjectId( $bluePath2t );

   $blueHerc3 = getObjectId( $blueHerc3t );
   $bluePath3 = getObjectId( $bluePath3t );

   $yellowHerc1 = getObjectId( $yellowHerc1t );
   $yellowPath1 = getObjectId( $yellowPath1t );

   $yellowHerc2 = getObjectId( $yellowHerc2t );
   $yellowPath2 = getObjectId( $yellowPath2t );

   $yellowHerc3 = getObjectId( $yellowHerc3t );
   $yellowPath3 = getObjectId( $yellowPath3t );

   $blueHQ = getObjectId( $blueHQt );
   $yellowHQ = getObjectId( $yellowHQt );

}
///////////////////////////////////////////////////////////////////////////////////////////////////
function onMissionStart()
{
//say(0,0,"DEBUG:on mission start");

//   temperateSounds();

//	marsSounds();

	$healRate = 100;   
	$ammoRate = 3;
 	$padWaitTime = 45;

   initGlobalVars();


   order( $blueHerc1, Guard, $bluePath1 );
   order( $blueHerc1, speed, high );

   order( $blueHerc2, Guard, $bluePath2 );
   order( $blueHerc2, speed, high );

   order( $blueHerc3, Guard, $bluePath3 );
   order( $blueHerc3, speed, high );

   order( $yellowHerc1, Guard, $yellowPath1 );
   order( $yellowHerc1, speed, high );

   order( $yellowHerc2, Guard, $yellowPath2 );
   order( $yellowHerc2, speed, high );

   order( $yellowHerc3, Guard, $yellowPath3 );
   order( $yellowHerc3, speed, high );

}
///////////////////////////////////////////////////////////////////////////////////////////////////
function player::onAdd(%this)
{
   say(%this, 0, *IDMULT_WAR_WELCOME);
say (0,0, "You need to download the mission to play");
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function vehicle::onAdd(%this)
{
   // see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

//   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

//say(0,0, "path " @ %globalVarName);
//say (0,0, "clone " @%clone );

//   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %globalVarName @ " );", 1 );
   schedule( "order( " @ %clone @ ", speed, high );", 2 );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam( %this ) == *IDSTR_TEAM_BLUE )
   {
      $yellowKills++;
   }
   else
   {
      $blueKills++;
   }

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }

// left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
// give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

// rules enforcement
   if(
      (getTeam(%this) == getTeam(%destroyer)) &&
      (%this != %destroyer)
   )
   {
      antiTeamKill(%destroyer);
   }

// see if it is a player, if so we are done
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player != 0) 
      return;

//----------------------------------------------------------------
// If any of our AI hercs die, give a message and re-clone/drop them
//----------------------------------------------------------------

   if( getTeam( %this ) == *IDSTR_TEAM_BLUE )
   {

// rotate the blue aAI herc drops, so they don't land on top of each other

   if ($bluePathCntr == 1)
    {
     $blueLoc = $blueDrop1;
    }

   if ($bluePathCntr == 2)
    {
     $blueLoc = $blueDrop2;
    }

   if ($bluePathCntr == 3)
    {
     $blueLoc = $blueDrop3;
    }

//say (0,0, "blue loc=" @ $blueLoc);
schedule( "trevorsCloneVehicle(\"$bluePath" @ $bluePathCntr @ "\", " @ %this @ ", " @ $blueLoc @ ");", $respawnDelay);

$bluePathCntr++;
if ($bluePathCntr > 3)
 {
  $bluePathCntr = 1;
 }

   }

   if( getTeam( %this ) == *IDSTR_TEAM_YELLOW )
   {

// rotate the yellow aAI herc drops, so they don't land on top of each other

   if ($yellowPathCntr == 1)
    {
     $yellowLoc = $yellowDrop1;
    }

   if ($yellowPathCntr == 2)
    {
     $yellowLoc = $yellowDrop2;
    }

   if ($yellowPathCntr == 3)
    {
     $yellowLoc = $yellowDrop3;
    }

      $yellowHercsDestroyed++;

//say (0,0, "yellow loc=" @ $yellowLoc);
schedule( "trevorsCloneVehicle(\"$yellowPath" @ $yellowPathCntr @ "\", " @ %this @ ", " @ $yellowLoc @ ");", $respawnDelay);

$yellowPathCntr++;
if ($yellowPathCntr > 3)
 {
  $yellowPathCntr = 1;
 }
   }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen1::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret1t , shutdown, True );

  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen2::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret2t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen3::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret3t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen4::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret4t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen5::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret5t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen6::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $yellowTurret6t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowGen7::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin(%this, %who);

  order( $yellowTurret7t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function yellowHQ::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $yellowHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_BLUE, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_YELLOW_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen1::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret1t , shutdown, True );

  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen2::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret2t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen3::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret3t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen4::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret4t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen5::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret5t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen6::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;

  checkForWin(%this, %who);

  order( $blueTurret6t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueGen7::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;
  checkForWin(%this, %who);

  order( $blueTurret7t , shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function blueHQ::structure::onDestroyed( %this, %who )
{
  $blueBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $blueHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ " Destroyed a Blue Structure.";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ "Blue Headquarters Destroyed. AI Respawn time set to " @ timeDifference($respawnDelayNoHq, 0) @ "." );
}

///////////////////////////////////////////////////////////////////////////////////////////////////
function checkForWin()
{
   if( $yellowBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 2.0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Blue team wins!";
      messageBox(0, %txt);
   }
   else if( $blueBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "Yellow team wins!";
      messageBox(0, %txt);
   }   
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Kills";
	$ScoreBoard::PlayerColumnHeader3 = "Buildings Destroyed";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Structures Remaining";
   $ScoreBoard::TeamColumnHeader2 = "Total Kills";
   $ScoreBoard::TeamColumnFunction1 = "getRemainingStructures";
   $ScoreBoard::TeamColumnFunction2 = "getTeamKills";
 
   serverInitScoreBoard();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function getTeam2(%player)
{
   if( getTeam( %player ) == *IDSTR_TEAM_YELLOW )
   {
      return *IDMULT_YELLOW;
   }
   else
   {
      return *IDMULT_BLUE;
   }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function getKills(%player)
{
   if( %player.numKills != "")
      return %player.numKills;
      
   return "0";
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function getTeamKills(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $yellowKills;
   }
   else
   {
      return $blueKills;
   }   
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function getRemainingStructures(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $BUILDINGS_TO_DESTROY - $yellowBuildingsDestroyed;
   }
   else
   {
      return $BUILDINGS_TO_DESTROY - $blueBuildingsDestroyed;
   }   
}
///////////////////////////////////////////////////////////////////////////////////////////////////
function getBuildingsDestroyed(%player)
{
   if( %player.buildingsDestroyed != "")
      return %player.buildingsDestroyed;
   
   return "0";
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//	ZenAll should behave as follows:
//	- Announce it has been entered
//	- Reloads object at normal rate; shut-down is necessary
//	- no reset time
//---------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}

function ZenAll::trigger::onContact(%this, %object)
{
   // one hundred points of loading
   // five percent reloading
//   Zen::work(%this, %object, 100, 5, 0, true); 
     Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// Debug Stuff //////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
function vehicle::onScan(%scanned, %scanner, %string)
{
//say(0,0, "DEBUG:scanning " @ %scanned);

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%scanned);
   if(%player != 0) 
      return;

   order( %scanned, Guard, %scanner );
   order( %scanned, speed, high );
}
/////////////////////////////////////////////////////////////////
function blueHQ::structure::onScan(%this, %scanner, %string)
{
//say(0,0, "DEBUG: " @ $yellowHQt );
//say(0,0, "DEBUG: " @ $yellowHQ );


//say(0,0, "DEBUG: " @ $blueHerc1 );
//say(0,0, "DEBUG: " @ $blueHerc2 );
//say(0,0, "DEBUG: " @ $blueHerc3 );

   order( $blueHerc1, Attack, $yellowHQ );
   order( $blueHerc1, speed, high );

   order( $blueHerc2, Attack, $yellowHQ  );
   order( $blueHerc2, speed, high );

   order( $blueHerc3,Attack, $yellowHQ  );
   order( $blueHerc3, speed, high );

   order( $yellowHerc1, Guard, getObjectid ($yellowPath4t) );
   order( $yellowHerc1, speed, high );

   order( $yellowHerc2, Guard, getObjectid ($yellowPath4t) );
   order( $yellowHerc2, speed, high );

   order( $yellowHerc3, Guard, getObjectid ($yellowPath4t) );
   order( $yellowHerc3, speed, high );

}

