$missionName = "WAR_Antipode";

exec("multiplayerStdLib.cs");

$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHqDestroyed = false;
$redHqDestroyed = false;

$respawnDelay = 30;
$respawnDelayNoHq = 120;
$BUILDINGS_TO_DESTROY = 10;

Pilot Maria
{
   id = 52;   
   name = "Maria Wolfe";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 800.0;
   deactivateBuff = 100.0;
   targetFreq = 5.0;
   trackFreq = 0.2;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

Pilot Xenogears
{
   id = 25;   
   name = "Xenogears";
   skill = 0.8;
   accuracy = 1.0;
   aggressiveness = 0.4;
   activateDist = 1000.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.3;
   orderFreq = 1.0;    
};

Pilot Delithita
{
   id = 26;   
   name = "Delithita";
   skill = 1.0;
   accuracy = 0.8;
   aggressiveness = 1.0;
   activateDist = 500.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 1.0;    
};

Pilot Icey
{
   id = 27;   
   name = "Icey";
   skill = 0.8;
   accuracy = 0.8;
   aggressiveness = 0.5;
   activateDist = 800.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Wolfe
{
   id = 28;   
   name = "Wolfe";
   skill = 1.0;
   accuracy = 0.6;
   aggressiveness = 0.6;
   activateDist = 500.0;
   deactivateBuff = 100.0;
   targetFreq = 1.0;
   trackFreq = 0.3;
   fireFreq = 0.3;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Rosa
{
   id = 29;   
   name = "Rosalia";
   skill = 1.0;
   accuracy = 0.5;
   aggressiveness = 1.0;
   activateDist = 800.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Grizzle
{
   id = 30;   
   name = "Grizzle";
   skill = 0.5;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 600.0;
   deactivateBuff = 100.0;
   targetFreq = 5.0;
   trackFreq = 0.2;
   fireFreq = 0.3;
   LOSFreq = 0.3;
   orderFreq = 2.0;
};

Pilot Redneck
{
   id = 31;   
   name = "Redneck";
   skill = 0.8;
   accuracy = 0.8;
   aggressiveness = 0.8;
   activateDist = 600.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.3;
   orderFreq = 1.0;    
};

Pilot Snot
{
   id = 32;   
   name = "Snot";
   skill = 0.2;
   accuracy = 0.4;
   aggressiveness = 0.8;
   activateDist = 600.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.4;
   fireFreq = 0.4;
   LOSFreq = 0.2;
   orderFreq = 1.0;    
};

Pilot Rockhammer
{
   id = 33;   
   name = "Rockhammer";
   skill = 0.9;
   accuracy = 0.8;
   aggressiveness = 1.0;
   activateDist = 700.0;
   deactivateBuff = 100.0;
   targetFreq = 6.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Pattycake
{
   id = 34;   
   name = "Pattycake";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.1;
   activateDist = 300.0;
   deactivateBuff = 100.0;
   targetFreq = 1.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Hawg
{
   id = 35;   
   name = "Hawg";
   skill = 1.0;
   accuracy = 0.5;
   aggressiveness = 1.0;
   activateDist = 600.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 0.3;
   fireFreq = 0.4;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
		%player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}

function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}

function onMissionLoad()
{
   cdAudioCycle("Purge", "Watching", "Mechsoul"); 

   $Maria   = getObjectId( "MissionGroup/Ghosts/Maria/Herc1" );
   $Del     = getObjectId( "MissionGroup/Ghosts/Del/Herc1" );
   $Icey    = getObjectId( "MissionGroup/Ghosts/Icey/Herc1" );
   $Xeno    = getObjectId( "MissionGroup/Ghosts/Xeno/Herc1" );
   $Wolfe   = getObjectId( "MissionGroup/Ghosts/Wolfe/Herc1" );
   $Rosa    = getObjectId( "MissionGroup/Ghosts/Rosa/Herc1" );
   $Maria2  = getObjectId( "MissionGroup/Ghosts/Maria/Tank1" );
   $Del2    = getObjectId( "MissionGroup/Ghosts/Del2/Herc1" );
   $Icey2   = getObjectId( "MissionGroup/Ghosts/Icey2/Herc1" );
   $Xeno2   = getObjectId( "MissionGroup/Ghosts/Xeno2/Herc1" );
   $Wolfe2  = getObjectId( "MissionGroup/Ghosts/Wolfe/Tank1" );
   $Rosa2   = getObjectId( "MissionGroup/Ghosts/Rosa/Tank1" );
   $Grizzle     = getObjectId( "MissionGroup/Miners/Grizzle/Tank1" );
   $Grizzle2    = getObjectId( "MissionGroup/Miners/Grizzle/Herc1" );
   $Redneck     = getObjectId( "MissionGroup/Miners/Redneck/Tank1" );
   $Redneck2    = getObjectId( "MissionGroup/Miners/Redneck/Herc1" );
   $Snot        = getObjectId( "MissionGroup/Miners/Snot/Tank1" );
   $Snot2       = getObjectId( "MissionGroup/Miners/Snot/Herc1" );
   $Rockhammer  = getObjectId( "MissionGroup/Miners/Rockhammer/Tank1" );
   $Rockhammer2 = getObjectId( "MissionGroup/Miners/Rockhammer/Herc1" );
   $Pattycake   = getObjectId( "MissionGroup/Miners/Pattycake/Tank1" );
   $Pattycake2  = getObjectId( "MissionGroup/Miners/Pattycake/Herc1" );
   $Hawg 	    = getObjectId( "MissionGroup/Miners/Hawg/Tank1" );
   $Hawg2	    = getObjectId( "MissionGroup/Miners/Hawg/Herc1" );



   %rules = "<tIDMULT_WAR_GAMETYPE>"      @        
            "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName                  @  
            "<tIDMULT_WAR_OBJECTIVES_1>"  @
            timeDifference($respawnDelay, 0)       @
            "<tIDMULT_WAR_OBJECTIVES_2>"  @
            timeDifference($respawnDelayNoHq, 0)   @
            "<tIDMULT_WAR_OBJECTIVES_3>"  @
            "<tIDMULT_WAR_OBJECTIVES_4>"  @
            $BUILDINGS_TO_DESTROY         @
            "<tIDMULT_WAR_OBJECTIVES_5>"  @
            "<tIDMULT_WAR_SCORING_1>"     @
            "<tIDMULT_WAR_SCORING_2>"     @
            "<tIDMULT_STD_ITEMS>"         @
            "<tIDMULT_WAR_HQ>"            @
            "<tIDMULT_WAR_GENERATORS>"    @
            "<tIDMULT_WAR_TURRETS>"       @
            "<tIDMULT_WAR_FLAGS>"         @
            "<tIDMULT_WAR_GLOW>"          @
            "<tIDMULT_STD_HEAL>"          @
            "<tIDMULT_STD_RELOAD_1>"      @
            $PadWaitTime                  @
            "<tIDMULT_STD_RELOAD_2>";
   
   setGameInfo(%rules);


    order( "MissionGroup/Ghosts" , guard, "MissionGroup/Ghosts/Path" );
    order( "MissionGroup/Ghosts" , speed, medium );

    order( "MissionGroup/Miners" , guard, "MissionGroup/Miners/Path" );
    order( "MissionGroup/Miners" , speed, medium );
}

function player::onAdd(%this)
{
   say(%this, 0, *IDMULT_WAR_WELCOME);
}

function vehicle::onAdd(%this)
{
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );
}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
      setNavMarker( "MissionGroup/RedBase/navigaionMarker1", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/yellowBase/navigaionMarker1", true, %this );
   }
}

function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam( %this ) == *IDSTR_TEAM_RED )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }
   
   if( %this == $Grizzle )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Grizzle\", " @ %this @ ", 3000, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Grizzle\", " @ %this @ ", 3000, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Redneck )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Redneck\", " @ %this @ ", 3000, -3100, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Redneck\", " @ %this @ ", 3000, -3100, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Snot )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Snot\", " @ %this @ ", 3100, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Snot\", " @ %this @ ", 3100, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Rockhammer )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Rockhammer\", " @ %this @ ", 3000, -2900, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Rockhammer\", " @ %this @ ", 3000, -2900, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Pattycake )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Pattycake\", " @ %this @ ", 2900, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Pattycake\", " @ %this @ ", 2900, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Hawg )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Hawg\", " @ %this @ ", 2850, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Hawg\", " @ %this @ ", 2850, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Grizzle2 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Grizzle2\", " @ %this @ ", 3050, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Grizzle2\", " @ %this @ ", 3050, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Redneck2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Redneck2\", " @ %this @ ", 3000, -3050, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Redneck2\", " @ %this @ ", 3000, -3050, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Snot2 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Snot2\", " @ %this @ ", 3000, -2950, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Snot2\", " @ %this @ ", 3000, -2950, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Rockhammer2 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Rockhammer2\", " @ %this @ ", 2950, -3000, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Rockhammer2\", " @ %this @ ", 2950, -3000, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Pattycake2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Pattycake2\", " @ %this @ ", 2950, -2950, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Pattycake2\", " @ %this @ ", 2950, -2950, 412);", $respawnDelayNoHq);
      }
   }
   if( %this == $Hawg2 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Hawg2\", " @ %this @ ", 3050, -3050, 412);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Hawg2\", " @ %this @ ", 3050, -3050, 412);", $respawnDelayNoHq);
      }
   }

   if( %this == $Maria )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Maria\", " @ %this @ ", 0, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Maria\", " @ %this @ ", 0, 0, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Del )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Del\", " @ %this @ ", 50, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Del\", " @ %this @ ", 50, 0, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Icey )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Icey\", " @ %this @ ", 100, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Icey\", " @ %this @ ", 100, 0, 338);", $respawnDelayNoHq);
      }
   }

   if( %this == $Xeno )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Xeno\", " @ %this @ ", -100, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Xeno\", " @ %this @ ", -100, 0, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Wolfe )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Wolfe\", " @ %this @ ", -50, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Wolfe\", " @ %this @ ", -50, 0, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Rosa )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Rosa\", " @ %this @ ", -150, 0, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Rosa\", " @ %this @ ", -150, 0, 338);", $respawnDelayNoHq);
      }
   }

   if( %this == $Maria2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Maria2\", " @ %this @ ", 0, 50, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Maria2\", " @ %this @ ", 0, 50, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Del2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Del2\", " @ %this @ ", 0, 100, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Del2\", " @ %this @ ", 0, 100, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Icey2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Icey2\", " @ %this @ ", 0, 150, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Icey2\", " @ %this @ ", 0, 150, 338);", $respawnDelayNoHq);
      }
   }

   if( %this == $Xeno2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Xeno2\", " @ %this @ ", 0, -50, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Xeno2\", " @ %this @ ", 0, -50, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Wolfe2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Wolfe2\", " @ %this @ ", 0, -100, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Wolfe2\", " @ %this @ ", 0, -100, 338);", $respawnDelayNoHq);
      }
   }
   if( %this == $Rosa2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$Rosa2\", " @ %this @ ", -50, 50, 338);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$Rosa2\", " @ %this @ ", -50, 50, 338);", $respawnDelayNoHq);
      }
   }

   vehicle::onDestroyedLog(%this, %destroyer);
   
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

   if(
      (getTeam(%this) == getTeam(%destroyer)) &&
      (%this != %destroyer)
   )
   {
      antiTeamKill(%destroyer);
   }
}

function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Kills";
	$ScoreBoard::PlayerColumnHeader3 = "Buildings Destroyed";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Structures Remaining";
   $ScoreBoard::TeamColumnHeader2 = "Total Kills";
   $ScoreBoard::TeamColumnFunction1 = "getRemainingStructures";
   $ScoreBoard::TeamColumnFunction2 = "getTeamKills";
 
   serverInitScoreBoard();
}

function getTeam2(%player)
{
   if( getTeam( %player ) == *IDSTR_TEAM_YELLOW )
   {
      return *IDMULT_YELLOW;
   }
   else
   {
      return *IDMULT_RED;
   }
}

function getKills(%player)
{
   if( %player.numKills != "")
      return %player.numKills;
      
   return "0";
}

function getTeamKills(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $yellowKills;
   }
   else
   {
      return $redKills;
   }   
}

function getRemainingStructures(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $BUILDINGS_TO_DESTROY - $yellowBuildingsDestroyed;
   }
   else
   {
      return $BUILDINGS_TO_DESTROY - $redBuildingsDestroyed;
   }   
}

function getBuildingsDestroyed(%player)
{
   if( %player.buildingsDestroyed != "")
      return %player.buildingsDestroyed;
   
   return "0";
}

function redGen1::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  damageObject( "MissionGroup/redBase/t1", 400000 );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed the eastern turret generator!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen2::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  damageObject( "MissionGroup/redBase/t2", 400000 );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed the southern turret generator!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red1::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red2::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red3::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red4::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red5::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red6::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red7::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red8::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function red9::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @  " has destroyed a Ghosts of the Antipode structure!";
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen1::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
      
  damageObject( "MissionGroup/yellowBase/t1", 400000 );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed the western turret generator!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen2::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  damageObject( "MissionGroup/yellowBase/t2", 400000 );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed the northern turret generator!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow1::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
  
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");
 
  schedule("setOrbitCamera($who);",1.0);
  schedule("setPlayerCamera();", 5.0);                   
}

function yellow2::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow3::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow4::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow5::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow6::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow7::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow8::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellow9::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ " has destroyed a Mining Guild structure!";
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function redHQ::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();


  schedule("setPlayerCamera();", 5.0);
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  $redHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_RED_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}


function yellowHQ::structure::onDestroyed( %this, %who )
{
  $yellowBuildingsDestroyed++;
  checkForWin();


  schedule("setPlayerCamera();", 5.0);
                
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $yellowHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_YELLOW_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}


function onMissionStart()
{
	$healRate = 300;   
	$ammoRate = 3;
 	$padWaitTime = 20;

   earthquakeSounds();

   initGlobalVars();
}

function checkForWin()
{
   if( $yellowBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
               
      %txt = "Red team wins!";
      messageBox(0, %txt);
   }
   else if( $redBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {
      fadeEvent( 0, out, 1.5, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 1.6 );
      
      %txt = "yellow team wins!";
      messageBox(0, %txt);
   }   

   if( $yellowBuildingsDestroyed >= 6 )
   {
    order( $Grizzle , attack, "MissionGroup/RedBase" );
    order( $Snot , attack, "MissionGroup/RedBase" );
    order( $Rockhammer , attack, "MissionGroup/RedBase" );
    order( $Redneck , attack, "MissionGroup/RedBase" );
    order( $Hawg , attack, "MissionGroup/RedBase" );
    order( $Pattycake , attack, "MissionGroup/RedBase" );
    order( $Grizzle2 , attack, "MissionGroup/RedBase" );
    order( $Snot2 , attack, "MissionGroup/RedBase" );
    order( $Rockhammer2 , attack, "MissionGroup/RedBase" );
    order( $Redneck2 , attack, "MissionGroup/RedBase" );
    order( $Hawg2 , attack, "MissionGroup/RedBase" );
    order( $Pattycake2 , attack, "MissionGroup/RedBase" );
    order( "MissionGroup/Miners" , speed, high );
    order( "MissionGroup/Miners" , cloak, true );
   }

   if( $redBuildingsDestroyed >= 6 )
   {
    order( $Maria , attack, "MissionGroup/YellowBase" );
    order( $Del , attack, "MissionGroup/YellowBase" );
    order( $Icey , attack, "MissionGroup/YellowBase" );
    order( $Xeno , attack, "MissionGroup/YellowBase" );
    order( $Wolfe , attack, "MissionGroup/YellowBase" );
    order( $Rosa , attack, "MissionGroup/YellowBase" );
    order( $Maria2 , attack, "MissionGroup/YellowBase" );
    order( $Del2 , attack, "MissionGroup/YellowBase" );
    order( $Icey2 , attack, "MissionGroup/YellowBase" );
    order( $Xeno2 , attack, "MissionGroup/YellowBase" );
    order( $Wolfe2 , attack, "MissionGroup/YellowBase" );
    order( $Rosa2 , attack, "MissionGroup/YellowBase" );
    order( "MissionGroup/Ghosts" , speed, high );
    order( "MissionGroup/Ghosts" , cloak, true );
   }
}

function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );
}