//
$AIversion = "1.0";
$missionName = "WAR_AI_ShakeUp";

exec("multiplayerStdLib.cs");

$assasinName = "Joe";
$assasinGroup = "MissionGroup/Assasin";

$enemyDropped = false;
$gameOver = true;

$orderDefendersTime = 120;
$maxOrderTime = 60;
$minOrderTime = 20;
$assasinOrderTime = 30;
$cloakInterval = 20;

// how many humans before AI assasins attack

$startAI = 4;
$maxHumansRatio = 2;          // Start adding MORE AI when ratio exceeded
$maxAI = 12;             // keep the AI lag down
$currentAICount = 0;     // AI in the game
///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;
$redHerc4RespawnTime = 0;


$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";
$redHerc4Path = "MissionGroup/redHerc4Path";


$yellowHqDestroyed = false;
$redHqDestroyed = false;

$orderTime = 60;

$AIDropPoint = 0;
$redHercDropGroup = "MissionGroup/DropPointGroup3";


///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 60;
$respawnDelayNoHq = 120;
$BUILDINGS_TO_DESTROY = 6;

///////////////////////////////////////////////////////////////////////////////////////////////////
// our base defender attributes
//
// The jump from 0.9 to 1.0 is a big one. At skill 1.0 and accuracy 1.0 the AI units will aim 
// first for the weapons, then the legs. A little too much for this mission.
//
///////////////////////////////////////////////////////////////////////////////////////////////////

$pilotNumber = 26;

Pilot YellowPilot1
{
   id = 26;
   
   name = "AI Attacker";
   
   skill = 2.0;
   accuracy = 0.9;
   aggressiveness = 2.0;
   activateDist = 1000.0;
   deactivateBuff = 300.0;
   targetFreq = 0.1;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};
Pilot YellowPilot2
{
   id = 27;
   
   name = "AI Attacker";
   
   skill = 2.0;
   accuracy = 0.9;
   aggressiveness = 2.0;
   activateDist = 500.0;
   deactivateBuff = 100.0;
   targetFreq = 0.5;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};
Pilot YellowPilot3
{
   id = 28;
   
   name = "AI Attacker";
   
   skill = 2.0;
   accuracy = 0.9;
   aggressiveness = 2.0;
   activateDist = 300.0;
   deactivateBuff = 30.0;
   targetFreq = 120.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 120.0;
};

Pilot YellowPilot
{
   id = 29;
   
   name = "Yellow Defender";
   
   skill = 1.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 30.0;
   targetFreq = 0.1;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot Zandar_SDS
{
   id = 31;
   
   skill = 1.0;
   accuracy = 0.8;
   aggressiveness = 1.0;
   activateDist = 1500.0;
   deactivateBuff = 100.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "Zandar_SDS";
};


Pilot Promie
{
   id = 32;
   
   skill = 1.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 1600.0;
   deactivateBuff = 300.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "Promie";
};

Pilot Special
{
id = 33;

   skill = 1.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 1600.0;
   deactivateBuff = 300.0;
   targetFreq = 0.1;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
name = $assasinName;
};



function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
      %player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}

function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}

function setDefaultMissionItems()
{
//   allowComponent(      830, FALSE  );      //Chameleon
//   allowComponent(    831, FALSE  );      //Cuttlefish cloak
//   allowComponent(     840, FALSE  );      //Shield Modulator
//   allowComponent(   914, FALSE  );      //UAP
}

function onMissionStart()
{
   $healRate = 100;   
   $ammoRate = 3;
   $padWaitTime = 45;

   windSounds();
   marsSounds();	

   initGlobalVars();
   $gameOver = true;
}

function onMissionLoad()
{


  deleteObject( "MissionGroup/Assasin" );
  newObject( "Assasin", SimGroup );
  addToSet( "MissionGroup", "Assasin" );


  deleteObject( "MissionGroup/redAttack" );
  newObject( "redAttack", SimGroup );
  addToSet( "MissionGroup", "redAttack" );

  deleteObject( "MissionGroup/redHercs" );
  newObject( "redHercs", SimGroup );
  addToSet( "MissionGroup", "redHercs" );


   cdAudioCycle("Purge", "Watching", "Mechsoul"); 

   // get the original ID for each AI Herc ( for use later when we clone them )

   $redHercGroup = getObjectId( "MissionGroup/redAttack" );
   $redNav = getObjectId( "MissionGroup/redBase/n1" ); // used for check boundary


   $AITarget[1] = getObjectId( "MissionGroup/YellowBase/gen1" );
   $AITarget[2] = getObjectId( "MissionGroup/YellowBase/gen4" );
   $AITarget[3] = getObjectId( "MissionGroup/PowerGenerators/YellowAmmoGenerator" );
   $AITarget[4] = getObjectId( "MissionGroup/YellowBase/gen3" );
   $AITarget[5] = getObjectId( "MissionGroup/YellowBase/gen2" );
   $AITarget[6] = getObjectId( "MissionGroup/PowerGenerators/YellowHealGenerator" );
   $AITarget[7] = getObjectId( "MissionGroup/YellowBase/gen5" );
   $AITarget[8] = getObjectId( "MissionGroup/YellowBase/YellowHQ" );
   $AITargetdestroyed[1] = False;
   $AITargetdestroyed[2] = False;
   $AITargetdestroyed[3] = False;
   $AITargetdestroyed[4] = False;
   $AITargetdestroyed[5] = False;
   $AITargetdestroyed[6] = False;
   $AITargetdestroyed[7] = False;
   $AITargetdestroyed[8] = False;

   $maxTargets = 8;

   $currentAITarget = $AITarget[1];

//MPcheckBoundary( "enter", $redNav, 1600, "orderDefenders", 10 );
MPcheckBoundary( "enter", $redNav, 1200, "orderAI", 5 );
MPcheckBoundary( "enter", $redNav, 1200, "orderAssasin", 5 );
MPcheckBoundary( "enter", $redNav, 1700, "makeAIguards", 10 );
//MPcheckBoundary( "enter", $redNav, 1900, "createAttackers", 20 );


   %rules = "<tIDMULT_WAR_GAMETYPE>"      @        
            "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName                  @  
            "<tIDMULT_WAR_OBJECTIVES_1>"  @
            timeDifference($respawnDelay, 0)       @
            "<tIDMULT_WAR_OBJECTIVES_2>"  @
            timeDifference($respawnDelayNoHq, 0)   @
            "<tIDMULT_WAR_OBJECTIVES_3>"  @
            "<tIDMULT_WAR_OBJECTIVES_4>"  @
            $BUILDINGS_TO_DESTROY         @
            "<tIDMULT_WAR_OBJECTIVES_5>"  @
            "<tIDMULT_WAR_SCORING_1>"     @
            "<tIDMULT_WAR_SCORING_2>"     @
            "<tIDMULT_STD_ITEMS>"         @
            "<tIDMULT_WAR_HQ>"            @
            "<tIDMULT_WAR_GENERATORS>"    @
            "<tIDMULT_WAR_TURRETS>"       @
            "<tIDMULT_WAR_FLAGS>"         @
            "<tIDMULT_WAR_GLOW>"          @
            "<tIDMULT_STD_HEAL>"          @
            "<tIDMULT_STD_RELOAD_1>"      @
            $PadWaitTime                  @
            "<tIDMULT_STD_RELOAD_2>";
   
   setGameInfo(%rules);
}


//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, *IDMULT_WAR_WELCOME @ "\n Game version " @ $AIversion);
}

//-------------------------------------------------------------
function vehicle::onAdd(%this)
{
   // see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);
    }

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );

echo("DEBUG: vehicleOnadd");

//  $gameOver = false;
  spawnAI(%this);
}

function spawnAI(%this)
{

  if ( $gameOver == true ) return;

   if ( $currentAICount > $maxAI ) 
      {
echo("debug:$currentAICount > $maxAI,,returning");
        return;
      }

   %playerCount = playerManager::getPlayerCount();

//say (0,0, "DEBUG:make new ai $currentAICount = " @ $currentAICount @ " maxAI " @  $maxAI @ " %playerCount=" @ %playerCount @ " $maxHumansRatio " @ $maxHumansRatio);
echo("(($currentAICount - $startAI) >= ($maxHumansRatio * %playerCount))="@ ($currentAICount - $startAI) @ " " @  ($maxHumansRatio * %playerCount));

   if (($currentAICount - $startAI) >= ($maxHumansRatio * %playerCount))
     {
echo("DEBUG: ($currentAICount - $startAI) >= ($maxHumansRatio * %playerCount), returning.....");
       return;
     }

echo( "DEBUG:make new assasin ");
   if ( %this != 0 )
    {
       %vehicleName = getVehicleName(%this);
       if (( %vehicleName ==  *IDVEH_TR_TALO ) ||
           ( %vehicleName ==  *IDVEH_KN_TALO ) ||
           ( %vehicleName ==  *IDVEH_CY_SEEK ) ||
           ( %vehicleName ==  *IDVEH_CY_GOAD ) ||
           ( %vehicleName ==  *IDVEH_MG_SEEK ) ||
           ( %vehicleName ==  *IDVEH_MG_GOAD ) ||
           ( %vehicleName ==  *IDVEH_RB_EMAN ) ||
           ( %vehicleName ==  *IDVEH_PI_EMAN )
          )
        {
         dropAssasin (%this);
        }
     }

// give preferential treatment to assasin herc
echo( "DEBUG:make new ai ");
     %playerVeh = pickPlayer();
     makeNewAIAttacker(%playerVeh);

}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
      setNavMarker( "MissionGroup/RedBase/n1", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/YellowBase/n1", true, %this );
   }
}


//-----------------------------------------------------------------------------
function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam( %this ) == *IDSTR_TEAM_RED )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }

   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------

  if  ($gameOver == false )
   {
   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;

      if ( $redHqDestroyed == false )
      {
         schedule( "makeGuard(1, " @ $redHerc1@ ");", $respawnDelay);
      }
      else
      {
        schedule( "makeGuard(1, " @ $redHerc1 @ ");", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "makeGuard(2, " @ $redHerc2 @ ");", $respawnDelay);
      }
      else
      {
         schedule( "makeGuard(2, " @ $redHerc2 @ ");", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "makeGuard(3, " @ $redHerc3 @ ");", $respawnDelay);
      }
      else
      {
         schedule( "makeGuard(3, " @ $redHerc3 @ ");", $respawnDelayNoHq);
      }
   }
   if( %this == $redHerc4 )
   {
      $redHercsDestroyed++;

      if( $redHqDestroyed == false )
      {
         schedule( "makeGuard(4, " @ $redHerc4  @ ");", $respawnDelay);
      }
      else
      {
         schedule( "makeGuard(4, " @ $redHerc4  @ ");", $respawnDelayNoHq);
      }
   }
 } // if ($gameOver == false )


   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
/////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
// mods here by dolf kooz
// spawn attacker

echo("DEBUG: vehicleOnDestroyed");

  spawnAI();

  if (getTeam (%this) == *IDSTR_TEAM_RED)
   {
   $currentAICount--;
    schedule( "deleteObject(" @ %this @ ");", 5 );
   }
}

//-----------------------------------------------------------------------------
function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Kills";
	$ScoreBoard::PlayerColumnHeader3 = "Buildings Destroyed";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Structures Remaining";
   $ScoreBoard::TeamColumnHeader2 = "Total Kills";
   $ScoreBoard::TeamColumnFunction1 = "getRemainingStructures";
   $ScoreBoard::TeamColumnFunction2 = "getTeamKills";
 
   serverInitScoreBoard();
}

function getTeam2(%player)
{
   if( getTeam( %player ) == *IDSTR_TEAM_YELLOW )
   {
      return *IDMULT_YELLOW;
   }
   else
   {
      return *IDMULT_RED;
   }
}

function getKills(%player)
{
   if( %player.numKills != "")
      return %player.numKills;
      
   return "0";
}

function getTeamKills(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $yellowKills;
   }
   else
   {
      return $redKills;
   }   
}

function getRemainingStructures(%team)
{
   if( getTeamNameFromTeamId(%team) == *IDSTR_TEAM_YELLOW )
   {
      return $BUILDINGS_TO_DESTROY - $yellowBuildingsDestroyed;
   }
   else
   {
      return $BUILDINGS_TO_DESTROY - $redBuildingsDestroyed;
   }   
}

function getBuildingsDestroyed(%player)
{
   if( %player.buildingsDestroyed != "")
      return %player.buildingsDestroyed;
   
   return "0";
}

function redGen1::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/t1", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_RED_BR_GEN_DESTROYED;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen2::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_RED_FR_GEN_DESTROYED;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen3::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
 
  order( "MissionGroup/redBase/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_RED_CEN_GEN_DESTROYED;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen4::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_RED_BL_GEN_DESTROYED;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function redGen5::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/redBase/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_RED_FL_GEN_DESTROYED;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen1::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/t1", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_YELLOW_FR_GEN_DESTROYED;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen2::structure::onDestroyed( %this, %who )
{
  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/t2", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_YELLOW_BR_GEN_DESTROYED;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen3::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/t3", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_YELLOW_CEN_GEN_DESTROYED;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen4::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/t4", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_YELLOW_BL_GEN_DESTROYED;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function yellowGen5::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();

  order( "MissionGroup/yellowBase/t5", shutdown, True );
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_YELLOW_BL_GEN_DESTROYED;
  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    
}

function redHQ::structure::onDestroyed( %this, %who )
{
  $redBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }

  $redHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_RED_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "ene_struct_dest.wav");    
  say(IDSTR_TEAM_RED, 1234, %txt, "friend_struct_des.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_RED_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}

function yellowHeal::structure::onDestroyed( %this, %who )
{
  redirectfire(%this);

}

function yellowAmmo::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

}


function yellowBuilding::structure::onDestroyed( %this, %who )
{

  redirectfire(%this);

}


function yellowHQ::structure::onDestroyed( %this, %who )
{
  redirectfire(%this);

  $yellowBuildingsDestroyed++;
  checkForWin();
  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)
  {
      %player.buildingsDestroyed++;     
  }
  
  $yellowHqDestroyed = true;

  %txt = "<F5>" @ getHUDName(%who) @ *IDMULT_WAR_DESTROYED_YELLOW_STRUCTURE;
  say(IDSTR_TEAM_YELLOW, 1234, %txt, "friend_struct_des.wav");    

  say(IDSTR_TEAM_RED, 1234, %txt, "ene_struct_dest.wav");    
  say(0, 1234, "<F5>" @ *IDMULT_WAR_YELLOW_HQ_DESTROYED @ timeDifference($respawnDelayNoHq, 0) @ "." );
}



function checkForWin()
{
   if (( $yellowBuildingsDestroyed >= $BUILDINGS_TO_DESTROY ) ||
       ( $redBuildingsDestroyed >= $BUILDINGS_TO_DESTROY ))
   {
     $orderDefendersTime = 15;
     $maxOrderTime = 15;
     $minOrderTime = 15;
     $orderTime = 15;
   }

   if( $yellowBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {

$orderDefendersTime = 1;
$maxOrderTime = 1;
$minOrderTime = 1;
$orderTime = 1;
flushConsoleScheduler();

      fadeEvent( 0, out, 1.0, 1.0, 0, 0 ); 
      schedule( "endTheGame();", 5 );
      $gameOver = true;
      %txt = "Red team wins!";
      messageBox(0, %txt);

   }
   else if( $redBuildingsDestroyed >= $BUILDINGS_TO_DESTROY )
   {

$orderDefendersTime = 1;
$maxOrderTime = 1;
$minOrderTime = 1;
$orderTime = 1;
flushConsoleScheduler();
      fadeEvent( 0, out, 1.0, 1.0, 1.0, 0 ); 
      schedule( "endTheGame();", 5 );
      $gameOver = true;
      %txt = "Yellow team wins!";
      messageBox(0, %txt);

   }   
}

function endTheGame()
{
  flushConsoleScheduler();

  fadeEvent( 0, in, 1.0, 1.0, 1.0, 0 ); 
  deleteObject( "MissionGroup/Assasin" );
  deleteObject( "MissionGroup/redAttack" );
  deleteObject( "MissionGroup/redHercs" );
  missionEndConditionMet();
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function getRandomAI()
{
   // check for valid ranges
   %i = RandomInt(1,56);


//say (0,0,"DEBUG: in drop ememy, i=" @ %i );

   if ( %i>8 && %i<10 )
      %i = RandomInt(1,8);
   if ( %i>17 && %i<20 )
      %i = RandomInt(20,28);

   if ( %i = 34  )
      %i = RandomInt(35,45);
   if ( %i>45 && %i<50 )
      %i = RandomInt(50,52);
   if ( %i>52 && %i<55 )
      %i = RandomInt(55,56);

//say (0,0,"DEBUG: in drop ememy, i=" @ %i );

   // get appropriate type Tank or Herc
   %type = Herc;
   if ( %i>5  && %i<= 8 )   %type = Tank;
   if ( %i>14 && %i<= 17 )  %type = Tank;
   if ( %i>24 && %i<= 26 )  %type = Tank;
   if ( %i>30 && %i<= 33 )  %type = Tank;
   if ( %i == 41 )  %type = Tank;
   if ( %i == 45 )  %type = Tank;
   if ( %i == 51 )  %type = Tank;

   return NewObject( "AI" @ %i, %type, %i );
}

//-----------------------------------------------------------------------------
function getPromie()
{
   // promie ID
   %i = 29;

   // get appropriate type Tank or Herc
   %type = Herc;

   return NewObject( "AI" @ %i, %type, %i );
}

//-----------------------------------------------------------------------------
function dropPromie( %playerVeh )
{

   %herc = getPromie();

     setTeam( %herc, *IDSTR_TEAM_RED );

$hercDropPoint = getNextDropPoint();

%x = getPosition($hercDropPoint,x);
%y = getPosition($hercDropPoint,y);
%z = getPosition($hercDropPoint,z);

   setPilotId(%herc,32);

   addToSet( "MissionGroup/Assasin", %herc );

   order( %herc ,attack, %playerVeh );
   setPosition( %herc, %x, %y, %z);
  order (%herc, Speed, High);

}


//-----------------------------------------------------------------------------
function dropAssasin( %playerVeh )
{


  if ( $gameOver == true ) return;


//say (0,0, "DEBUG: in drop enemy player vehicle = " @ %playerVeh );

// safety check
%player = playerManager::vehicleIdToPlayerNum( %playerVeh );
if(%player == 0) { return; }

$assasinName = "Evil " @ getHUDName( %playerVeh ); 

     $currentAICount++;

   %herc = cloneVehicle(%playerVeh);
// this gets the name to work, dunno how to display it on the HUD by default
// it only displays after scanning
Pilot Special
{
id = 33;

   skill = 2.0;
   accuracy = 2.0;
   aggressiveness = 2.0;
   activateDist = 100.0;
   deactivateBuff = 100.0;
   targetFreq = 0.1;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
name = $assasinName;
};

// dunno if this is needed or not
%herc.name = $assasinName;

   setPilotId(%herc,33);

     setTeam( %herc, *IDSTR_TEAM_RED );

  $hercDropPoint = getNextDropPoint();

  %x = getPosition($hercDropPoint,x);
  %y = getPosition($hercDropPoint,y);
  %z = getPosition($hercDropPoint,z);

  if (RandomInt(1,5) == 3 )
    {
    addToSet( "MissionGroup/redAttack", %herc );
    }
    else
    {
     addToSet( "MissionGroup/Assasin", %herc );
    }

   setPosition( %herc, %x, %y, %z);
   schedule( "order(" @ %herc @ ",attack," @ %playerVeh @ ");", 2 );
   schedule( "order(" @ %herc @ ",Speed, High);", 9 );



// see if we want to add a promie to the mix
   %i = RandomInt(1,8);

   if (%i == 5)
    {
     dropPromie( %playerVeh );
    }

}

//-----------------------------------------------------------------------------
function redirectfire (%destroyedStruct)
{

  for (%i=1; %i <= $maxTargets; %i++ )
    {
     if ( $AITarget[%i] ==  %destroyedStruct )
       {
        $AITargetdestroyed[%i] = True;

echo ( "DEBUG: destroyed $AITarget" @ %i);
       }
    }

  for (%i=1; %i <= $maxTargets; %i++ )
    {
     if ( $AITargetdestroyed[%i] == False )
       {
        $currentAITarget =  $AITarget[%i];
        schedule ("attackNewTarget();", 2);
        
echo ( "DEBUG: attacking $AITarget" @ %i);
         return;
       }
    }
}

//-----------------------------------------------------------------------------
function attackNewTarget()
{
 %thisHerc = getNextObject ($redHercGroup, 0);

for (%i = 0; %i < 25; %i++)
  {

   if (%thisHerc == 0) return;

//say (0,0, "DEBUG: (%thisHerc,=" @ %thisHerc @ " Attack, $currentAITarget= " @ $currentAITarget @ ") " );
     order (%thisHerc, Attack, $currentAITarget );

    schedule ("order("@ %thisHerc @ ", cloak, true);", $cloakInterval);

// now get the next herc ID#
   %thisHerc = getNextObject ($redHercGroup, %thisHerc );
  }

}

//-----------------------------------------------------------------------------
function getNextDropPoint()
{
  $AIDropPoint = getNextObject ($redHercDropGroup, $AIDropPoint);
  if ($AIDropPoint == 0)
   {
     $AIDropPoint = getNextObject ($redHercDropGroup, $AIDropPoint);
   }
  return $AIDropPoint;
}

//-----------------------------------------------------------------------------
// order AI to attack structures
function orderAI()
{
//echo ("in orderAI, ordertime is " @  $orderTime );
  if ($gameOver == true )  return;

  schedule ("orderAI();", $orderTime );

// should the base defenders attack?
  if  (randomInt (1,3) == 1)
   {
     orderDefenders();
   }


  $orderTime = $maxOrderTime; //order time for guard


// get the first herc

 %thisHerc = getNextObject ($redHercGroup, 0);

// make the total number large enough so we dont miss any
// we exit the loop with a return

for (%i = 0; %i < $maxAI + 2; %i++)
  {

// when we cycle thru the group we get a zero back, so exit, since we are done
   if (%thisHerc == 0) return;

     if (isGroupDestroyed(%thisHerc) == false )
      {

// I use the guard attack, so that I can crank up the AI,
// beyond the recommended 0-1 scale. They DO seem smarter with 
// higher numbers, but will not attack

// do the work here
// I picked 250M because thats about where they
// are within sight of the building target, any
// closer and they can be shooting.
     %dis = getDistance( %thisHerc, $currentAITarget );

        if ( %dis < 250 )
         {
echo ("DEBUG: (%thisHerc,=" @ %thisHerc @ " Attack, $currentAITarget= " @ $currentAITarget @ ") " );
           order (%thisHerc, Attack, $currentAITarget );

           schedule ("order("@ %thisHerc @ ", cloak, true);", $cloakInterval);

// we use a shorter order time to keep the AI moving. They will try to attack, but
// sometimes stop. If they are reissued the attack order they will move again,
// and maybe get the target, this time

           $orderTime = $minOrderTime;
         }
         else
         {
echo( "DEBUG: (%thisHerc,=" @ %thisHerc @ " Guard, $currentAITarget= " @ $currentAITarget @ ") " );
           order (%thisHerc, Guard, $currentAITarget );

           schedule ("order("@ %thisHerc @ ", cloak, true);", $cloakInterval);

         }
     } // if (isGroupDestroyed(%thisHerc) == false )
// now get the next herc ID#
   %thisHerc = getNextObject ($redHercGroup, %thisHerc );

  } // end for loop

}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i);

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
           %func = %callback @ "(" @ %obj1 @ ");";
           schedule( %func, 0 );
           %jobRun = true;
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          %func = %callback @ "();";
          schedule( %func, 0 );
          %jobRun = true;
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );
//say(0,0, "DEBUG: rescheduling job " @ %callback);
//echo( "DEBUG: rescheduling job " @ %callback);
   }

}

//-----------------------------------------------------------------------------
function orderAssasin()
{
  if ($gameOver == true )  return;

  schedule ("orderAssasin();", $assasinOrderTime );

//say(0,0, "DEBUG: in order assasin ");

// make the total number large enough so we dont miss any
// we exit the loop with a return
// if I was smarter, I'd know how to do a loop differently

// get the first herc

 %thisHerc = getNextObject ($assasinGroup, 0);

for (%i = 0; %i < 15; %i++)
  {

// when we cycle thru the group we get a zero back, so exit, since we are done
   if (%thisHerc == 0) return;

// do the work here
// if targetID is zero, this herc has no target

//say(0,0, "DEBUG: getCurrentTargetID( %thisHerc ) = " @ getCurrentTargetID( %thisHerc ));


  if ( getCurrentTargetID( %thisHerc ) == 0 )
   {
     %playerVeh = pickPlayer();

echo ("ordering assasin " @ %thisHerc @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));

     order( %thisHerc, attack, %playerVeh );

     order ( %thisHerc, Speed, High);

    schedule ("order("@ %thisHerc @ ", cloak, true);", $cloakInterval);

   }

// now get the next herc ID#
   %thisHerc = getNextObject ($assasinGroup, %thisHerc );

  } // end for loop

}



//-----------------------------------------------------------------------------
function pickDefenderTarget()
{
   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i);

     %herc= playerManager::playerNumToVehicleId( %player);

     if ( %herc != 0 )
     {
       %vehicleName = getVehicleName(%herc);
       if (( %vehicleName ==  *IDVEH_TR_TALO ) ||
           ( %vehicleName ==  *IDVEH_KN_TALO ) ||
           ( %vehicleName ==  *IDVEH_CY_SEEK ) ||
           ( %vehicleName ==  *IDVEH_CY_GOAD ) ||
           ( %vehicleName ==  *IDVEH_MG_SEEK ) ||
           ( %vehicleName ==  *IDVEH_MG_GOAD ) ||
           ( %vehicleName ==  *IDVEH_RB_EMAN ) ||
           ( %vehicleName ==  *IDVEH_PI_EMAN ))
        {
         return %herc;
        }
      } // if ( %herc != 0 )
     } //for
  %herc = pickPlayer ();
  return %herc;
}

//-----------------------------------------------------------------------------
function orderDefenders()
{

//  attepmt to keep scheduleing to happen at the wrong time, ie when the game is over
  if ($gameOver == true ) return;

  if (randomInt (1,2) == 1)
   {
    %playerVeh = pickPlayer();
    if ( %playerVeh != 0 )
      {
       order ($redHerc1, Attack, %playerVeh);
echo ("ordering defender " @ $redHerc1 @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));
      }
   }
   else
   {
     order ($redHerc1, Attack, $currentAITarget);
   }

     order ($redHerc1, Speed, High);

  if (randomInt (1,2) == 1)
   {
   %playerVeh = pickPlayer();
   order ($redHerc2, Attack, %playerVeh);
echo ("ordering defender " @ $redHerc2 @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));
   }
   else
   {
    order ($redHerc2, Attack, $currentAITarget);
   }
     order ($redHerc2, Speed, High);

  if (randomInt (1,2) == 1)
   {
   %playerVeh = pickPlayer();
   order ($redHerc3, Attack, %playerVeh);
echo ("ordering defender " @ $redHerc3 @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));
   }
   else
   {
   order ($redHerc3, Attack, $currentAITarget);
   }
     order ($redHerc3, Speed, High);

  if (randomInt (1,2) == 1)
   {
   %playerVeh = pickPlayer();
   order ($redHerc4, Attack, %playerVeh);
echo ("ordering defender " @ $redHerc4 @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));
   }
   else
   {
   order ($redHerc4, Attack, $currentAITarget);
   }
     order ($redHerc4, Speed, High);

  if ($gameOver == false )
    {
     schedule ("orderDefenders();", $orderDefendersTime);
    }

}

//-----------------------------------------------------------------------------
function createAttackers()
{
  for (%i=0; %i<4; %i++)
   {
     %herc = pickPlayer ();
     makeNewAIAttacker (%herc);
   }
echo ("DEBUG: AI Attackers created");
say (0,0,"<F4>DEBUG: AI Attackers created");
}
//-----------------------------------------------------------------------------
function makeNewAIAttacker(%this)
{

  if ( $gameOver == true ) return;

   $currentAICount++;

     %herc = pickPlayer ();
     if ( %this == 0 )
      {
        %clone = cloneVehicle ( %herc );
      }
     else
      {
        %clone = cloneVehicle ( %this );
      }

   $pilotNumber++;
   if ($pilotNumber > 28)
    {
      $pilotNumber = 26;
    }

   setTeam (%clone, *IDSTR_TEAM_RED);
   setPilotId(%clone, $pilotNumber);

   $hercDropPoint = getNextDropPoint();

   %x = getPosition($hercDropPoint,x);
   %y = getPosition($hercDropPoint,y);
   %z = getPosition($hercDropPoint,z);

   setPosition(%clone, %x, %y, %z);
   order (%clone, Speed, high);
   addToSet( "MissionGroup/redAttack", %clone );

    schedule ("order("@ %clone @ ", cloak, true);", $cloakInterval);

   schedule ("order ("@ %clone @ ", guard, $currentAiTarget);", 1);
}


//-----------------------------------------------------------------------------
function pickPlayer ()
{
// do 100 just to make sure we get a player that is in the game
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if ( %playerVeh != "" )
       {
         return %playerVeh;
       }
     }
  return 0;

}

//-----------------------------------------------------------------------------
function makeAIguards()
{

// this is called only when the game is starting
 $gameOver = false;

   %playerVeh = pickPlayer ();

 if (%playerVeh > 1000)
   {
    makeGuard(1, %playerVeh);
   %playerVeh = pickPlayer ();
    makeGuard(2, %playerVeh);
   %playerVeh = pickPlayer ();
    makeGuard(3, %playerVeh);
   %playerVeh = pickPlayer ();
    makeGuard(4, %playerVeh);

//   schedule ("orderDefenders();", $orderDefendersTime);

  }
  else
  {
  schedule ("makeAIguards();", 60);
  }

}

function makeGuard ( %whichHerc, %playerVeh )
{

  if ( $gameOver == true ) return;

  $currentAICount++;

  %newHerc = pickPlayer ();

   if ( %newHerc == 0 )
     {
      %herc = cloneVehicle(%playerVeh);
     }
    else
     {
      %herc = cloneVehicle( %newHerc );
     }

   SetPilotId( %herc, 29);
   setTeam (%herc, *IDSTR_TEAM_RED);
   addToSet( "MissionGroup/redHercs", %herc );

  $hercDropPoint = getNextDropPoint();

  %x = getPosition($hercDropPoint,x);
  %y = getPosition($hercDropPoint,y);
  %z = getPosition($hercDropPoint,z);

   setPosition( %herc, %x, %y, %z);

  schedule ("order (" @ %herc @ ", Guard, $redHerc" @ %whichHerc @ "Path );", 1);
  schedule ("$redHerc" @ %whichHerc @ " = " @ %herc @ ";", 1);

}

//-----------------------------------------------------------------------------
function dropAssasin( %playerVeh )
{

  if ( $gameOver == true ) return;

//say (0,0, "DEBUG: in drop enemy player vehicle = " @ %playerVeh );

   $currentAICount++;

   %herc = cloneVehicle(%playerVeh);

   $pilotNumber++;
   if ($pilotNumber > 28)
    {
      $pilotNumber = 26;
    }

   setPilotId(%herc, $pilotNumber);

   setTeam( %herc, *IDSTR_TEAM_RED );

  $hercDropPoint = getNextDropPoint();

  %x = getPosition($hercDropPoint,x);
  %y = getPosition($hercDropPoint,y);
  %z = getPosition($hercDropPoint,z);

   addToSet( "MissionGroup/Assasin", %herc );

   setPosition( %herc, %x, %y, %z);
   schedule( "order(" @ %herc @ ",attack," @ %playerVeh @ ");", 2 );
   schedule( "order(" @ %herc @ ",Speed, High);", 9 );
    schedule ("order("@ %herc @ ", cloak, true);", $cloakInterval);

echo ("ordering assasin " @ %herc @ " to attack " @ %playerVeh @ ":" @ getHUDName(%playerVeh));

//
   %i = RandomInt(1,8);
//say(0,0, "i="@%i);
   if (%i == 5)
    {
     dropPromie( %playerVeh );
    }

// say (0,0,"DEBUG:leaving drop squad mate");
}

