//-------Venusian vs. Imperial by ShatteredStar.-------//
//-------Thanks go to Orogogus for many componants.-------//

//-------Name map-------//

$missionName = "VvI_VenusEternal1";

//-------Activate other scripts-------//

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");

//-------Limit teams and set server options-------//

function setDefaultMissionOptions()
{
   $server::TeamPlay          = true;
   $server::AllowDeathmatch   = true;
   $server::AllowTeamPlay     = true;	
	
   $server::AllowTeamRed      = true;
   $server::AllowTeamBlue     = false;
   $server::AllowTeamYellow   = true;
   $server::AllowTeamPurple   = false;

   $server::disableTeamRed    = false;
   $server::disableTeamBlue   = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

   $server::AllowMixedTech    = false ;
   $server::FactoryVehOnly    = false ;

   $server::TimeLimit         = 60;
   $server::FragLimit         = 60;
}

//-------Activate sounds-------//

function onMissionStart()
{
   venusSounds();
   stormSounds();
}

function onMissionLoad()
{
   cdAudioCycle("SS1", "SS3", "SS4"); 

   schedule("say(0, 0, \"Welcome to Venusian vs. Imperial.  Check the game rules for details.\");", 2.0);
}

function adjustTeam(%player, %vehicle)
{
  %initLetter = strAlign(1, l, %vehicle.vehicleName);
  if(%initLetter < "H") adjustTeam1(%player, %vehicle);
  else if((%initLetter >= "H") && (%initLetter < "L")) adjustTeam2(%player, %vehicle);
  else if((%initLetter >= "L") && (%initLetter < "Q")) adjustTeam3(%player, %vehicle);
  else if(%initLetter >= "Q") adjustTeam4(%player, %vehicle);
  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam1(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Adjudicator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "prom";
  }

  else if(%vehicle.vehicleName == "Apocalypse")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Avenger")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Basilisk")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Bolo")
  {
     %vehicle.type = "tank";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Disrupter")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Dreadlock")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Emancipator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Executioner")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Goad")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Gorgon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}


function adjustTeam2(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Harabec's Predator")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Knight's Basilisk")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Apocalypse")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Disruptor")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Gorgon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Minotaur")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Myrmidon")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Paladin")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Talon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam3(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Metagen Goad")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Metagen Seeker")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Metagen Shepherd")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Minotaur")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Myrmidon")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Olympian")
  {
     %vehicle.type = "herc";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Paladin")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Platinum Guard Adjudicator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "platinum";
  }

  else if(%vehicle.vehicleName == "Platinum Guard Executioner")
  {
     %vehicle.type = "herc";
     %vehicle.side= "platinum";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam4(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Recluse")
  {
     %vehicle.type = "tank";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Seeker")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }
				
  else if(%vehicle.vehicleName == "Shepherd")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Talon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function vehicle::OnAdd(%vehicle)
{
  %player = playerManager::vehicleIdToPlayerNum(%vehicle);

  %player.vehicleId = %vehicle;
  %vehicle.vehicleName = getVehicleName(%vehicle);
  %vehicle.color = getTeam(%vehicle);
  if(%player != 0) %vehicle.name = %player.name;
  adjustTeam(%player, %vehicle);

  if ((%vehicle.side == "martian") && (%vehicle.color == "Red Team"))
  {
     setTeam(%vehicle, *IDSTR_TEAM_YELLOW);
     say(%player, 0, "Venusian rebel vehicles are on Yellow Team.");
     redrop(%vehicle);
  }

  if ((%vehicle.side== "terran") && (%vehicle.color == "Yellow Team"))
  {
     setTeam(%vehicle, *IDSTR_TEAM_RED);
     say(%player, 0, "Terran vehicles are on Red Team.");
     redrop(%vehicle);
  }
}

function player::OnAdd(%player)
{
  %player.name = getName(%player);

  %nowDate = getDate();
  %nowTime = getTime();
  %player.IP = getConnection(%player);
  %outputString =  %nowDate @ ", " @ %nowTime @ " -- " @ %player.name @ " joined the game (" @ %player.IP @ ")";
}

function setRules()
{
  %rules = "<F2>GAME TYPE: \n<F0>Venusian vs. Imperial\n\n" @        
  "<tIDMULT_TDM_MAPNAME>"    @ 
  $missionName               @
  "\n\n<F2>CHANGES:\n"       @
  "<F0>Venusian rebels fight Imperial Police.\n\n" @
  "<F0>Up to five AIs spawn in on both teams.\n\n" @
  "<F0>Tech mixing is not allowed.\n\n" @
  "<F0>The following componants are not allowed in this server:\n\n" @
  "<F0>Sensors, shield capacitor, alien antigravity module, and low-refractive armours.\n\n" @
  "\n\n<F2>RULES/OBJECTIVES:\n" @
  "<F0>Locate and destroy enemy vehicles.\n\n" @
  "<tIDMULT_TDM_SCORING_1>"  @
  "<tIDMULT_TDM_SCORING_2>"  @
  $killPoints                @
  "<tIDMULT_TDM_SCORING_3>"  @
  "<tIDMULT_TDM_SCORING_4>"  @
  $deathPoints               @
  "<tIDMULT_TDM_SCORING_5>"  @
  "<tIDMULT_TDM_SCORING_6>"  @
  "<tIDMULT_STD_ITEMS>" ;

   setGameInfo(%rules);      
}

setRules();

//-------Limit vehicles and componants-------//

allowVehicle(all,FALSE);
allowWeapon(all,TRUE);

allowVehicle(1, TRUE);     //TerranApocalypse
allowVehicle(2, TRUE);     //TerranMinotaur
allowVehicle(3, TRUE);     //TerranGorgon
allowVehicle(4,FALSE);     //TerranTalon
allowVehicle(5,FALSE);     //TerranBasilisk
allowVehicle(6, TRUE);     //Paladin
allowVehicle(7,FALSE);     //Myrmidon
allowVehicle(8,FALSE);     //Disrupter

allowVehicle(10,FALSE);    //KnightApocalypse
allowVehicle(11,FALSE);    //KnightMinotaur
allowVehicle(12,FALSE);    //KnightGorgon
allowVehicle(13,FALSE);    //KnightTalon
allowVehicle(14,FALSE);    //KnightBasilisk
allowVehicle(15,FALSE);    //KnightPaladin
allowVehicle(16,FALSE);    //KnightMyrmidon
allowVehicle(17,FALSE);    //KnightDisrupter

allowVehicle(20,FALSE);    //Seeker
allowVehicle(21,FALSE);    //Goad
allowVehicle(22,FALSE);    //Shepherd
allowVehicle(23,FALSE);    //Adjudicator
allowVehicle(24,FALSE);    //Executioner
allowVehicle(25,FALSE);    //Bolo
allowVehicle(26,FALSE);    //Recluse

allowVehicle(30, TRUE);    //Emancipator
allowVehicle(31, TRUE);    //Avenger
allowVehicle(32, TRUE);    //Dreadlock
allowVehicle(33, TRUE);    //Olympian

allowVehicle(35,FALSE);    //MetagenSeeker
allowVehicle(36,FALSE);    //MetagenGoad
allowVehicle(37,FALSE);    //MetagenShepherd

allowVehicle(41,FALSE);    //Predator

allowVehicle(52,FALSE);    //PirateEmancipator

allowVehicle(55,FALSE);    //PlayerPlatAdjudicator
allowVehicle(56,FALSE);    //PlayerPlatExecutioner

allowComponent(400,FALSE); //sensors
allowComponent(401,FALSE);
allowComponent(408,FALSE);
allowComponent(409,FALSE);
allowComponent(410,FALSE);
allowComponent(411,FALSE);
allowComponent(412,FALSE);
allowComponent(413,FALSE);
allowComponent(414,FALSE);
allowComponent(426,FALSE);
allowComponent(427,FALSE);
allowComponent(428,FALSE);
allowComponent(429,FALSE);
allowComponent(430,FALSE);
allowComponent(431,FALSE);
allowComponent(432,FALSE);
allowComponent(433,FALSE);
allowComponent(434,FALSE);
allowComponent(845,FALSE); //scap
allowComponent(910,FALSE); //antigrav
allowComponent(927,FALSE); //qbm
allowComponent(928,FALSE); //durac
allowComponent(930,FALSE); //crystal

//