$missionName = "VehicleResearchCenter";

$server::HudMapViewOffsetX = 5500; 
$server::HudMapViewOffsetY = 4000; 

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

Pilot Clone
{
   id = 52;   
   name = "Clone";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.6;
   activateDist = 15000.0;
   deactivateBuff = 5000.0;
   targetFreq = 2.0;
   trackFreq = 0.3;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   orderFreq = 2.0;
};

function setDefaultMissionOptions()
{
   $server::TeamPlay = false;
   $server::AllowDeathmatch = true;
   $server::AllowTeamPlay = True;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = true;
   $server::AllowTeamYellow = true;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

}

function onMissionStart()
{
   earthquakeSounds();
   mercurySounds();
}

function onMissionLoad()
{
   cdAudioCycle("Cloudburst", "Terror", "Watching"); 
   loopidy();
}

function ZenTransporter::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 100000, 100, 0, false);
   setPosition(%object, 6000, 3900, 400);
}


function player::onAdd(%playerNum)
{
  $playerNum = %playerNum;
}

function vehicle::onAdd(%this)                                                                                                                        
{                                                                                                                                                     
   %num = playerManager::vehicleIdToPlayerNum(%this); 
                                                                                                                                                    
   if(%num == $playerNum)                                                                                                                             
   {                                                                                                                                                  
      $playerId = playerManager::playerNumToVehicleId($playerNum);
      schedule( "trevorsCloneVehicle(\"$Copy1\", " @ %this @ ", 6000, 3000, 400);", 1);
   }                                                                                                                                           
}        

function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup/RedHercs", %clone );
}

function loopidy()
{
    order( "MissionGroup/RedHercs" , attack , $playerID );
    setPilotId("MissionGroup/RedHercs",52);
    schedule( "loopidy();" , 15 );
}

//