$missionName = "Training_2_Venus";

$server::HudMapViewOffsetX = -2000; 
$server::HudMapViewOffsetY = 0; 

exec("multiplayerStdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = True;
   $server::AllowDeathmatch = False;
   $server::AllowTeamPlay = True;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = false;
   $server::AllowTeamYellow = false;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
   $ammoRate = 4;
   venusSounds();
   stormSounds();
}

function onMissionLoad()
{
   cdAudioCycle("SS1", "Terror", "Mechsoul"); 

   $Emac1   = getObjectId( "MissionGroup/AI3/herc1" );
   $Emac2   = getObjectId( "MissionGroup/AI2/herc1" );
   $Oly1   = getObjectId( "MissionGroup/AI1/herc1" );

   order( $Emac1 , attack, "MissionGroup/RedBase" );
   order( $Emac1 , speed, medium );

   order( $Emac2 , attack, "MissionGroup/RedBase" );
   order( $Emac2 , speed, medium );

   order( $Oly1 , attack, "MissionGroup/RedBase" );
   order( $Oly1 , speed, medium );

   $yellowHercsDestroyed = 0;
   $playerKilled = 0;
   $squikked = 0;

   schedule("say(IDSTR_TEAM_RED, 0, \"Sulphur City Surface HQ:  Hah.  It's the Imp.  Hope you aren't too shaky after riding through the Oberwind's turbulence, eh?\");", 2.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"SCSHQ:  You don't get any fancy armour around here, half the junk you Imps use would melt.  You save weight taking out the sensors too because they're pretty much useless here too.\");", 9.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"SCSHQ:  Some of the nastier rebels on this fireball want to scorch this place so the Imps won't have the power they need to that base they got a dozen klicks north.\");", 15.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"SCSHQ:  Nasty weather is cutting us off from the base so we need your help to knock 'em back.  Wait, picking up some-- ah... they're early...\");", 18.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"SCSHQ:  Have fun.  Welcome to Venus.  Enjoy your stay.\");", 22.0);
}

function player::onAdd(%playerNum)
{
  $playerNum = %playerNum;
}

function vehicle::onAdd(%this)                                                                                                                        
{                                                                                                                                                     
   %num = playerManager::vehicleIdToPlayerNum(%this);                                                                                                 
                                                                                                                                                      
   if(%num == $playerNum)                                                                                                                             
   {                                                                                                                                                  
      $playerId = playerManager::playerNumToVehicleId($playerNum);                                                                                    
   }                                                                                                                                                  
}        

function Red1::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  Damnit they got our refinery!" );
   checkForWin();
}

function Red2::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They took out one of the power stations!  Don't you have any tricks up your sleeve, Imp?" );
   checkForWin();
}

function Red4::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They took out one of the power stations!  Don't you have any tricks up your sleeve, Imp?" );
   checkForWin();
}

function Red3::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They got our comm tower!" );
   checkForWin();
}

function Red5::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They got one of the heat dissipators!" );
   checkForWin();
}

function Red6::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They got one of the heat dissipators!" );
   checkForWin();
}

function Red7::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  They got one of the heat dissipators!" );
   checkForWin();
}

function Red8::structure::onDestroyed( %this, %destroyer )
{
   $squikked++;
   say(IDSTR_TEAM_RED, 0, "SCSHQ:  Ah, so much for the greenhouse!" );
   checkForWin();
}

function vehicle::onDestroyed( %this, %destroyer )
{
   if( %this == $Emac1 )
   {
      $yellowHercsDestroyed++;
      say(IDSTR_TEAM_RED, 0, "SCSHQ:  Well that one is breathing ninety bars of redhot CO2 now..." );
   }

   if( %this == $Emac2 )
   {
      $yellowHercsDestroyed++;
      say(IDSTR_TEAM_RED, 0, "SCSHQ:  Welcome to Venus, scuzzbag..." );
   }

   if( %this == $Oly1 )
   {
      $yellowHercsDestroyed++;
      say(IDSTR_TEAM_RED, 0, "SCSHQ:  Hah.  Pop go the atmosphere seal." );
   }

   if( %this == $playerID )
   {
      $playerKilled++;
      setDominantCamera(%destroyer,%this);
   }

   checkForWin();
}

function checkForWin()
{
   if( $yellowHercsDestroyed == 3 )
   {
      fadeEvent( 0, out, 2.5, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 3.0 );
               
      %txt = "Mission Complete!  Hah hah.  You did it.  Guess Terrans are good for something after all.";
      messageBox(0, %txt);
   }

   if( $playerKilled == 1 )
   {
      fadeEvent( 0, out, 15, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 15 );
      
      %txt = "How's that cozy warmth on your breached spacesuit?  Now we gotta write a casualty report to the Imps... bah... ";
      messageBox(0, %txt);
   }

   if( $squikked == 6 )
   {
      fadeEvent( 0, out, 2.5, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 3.0 );
      
      %txt = "We're getting reinforcements.  You let them destroy half our surface facilities.  Go away.";
      messageBox(0, %txt);
   }
}

allowVehicle(all,FALSE);
allowWeapon(all,FALSE);

allowVehicle(5,TRUE);   //TerranBasilisk

allowWeapon(103,TRUE);  //CompressionLaser
allowWeapon(105,TRUE);  //EMP
allowWeapon(117,TRUE);  //HeavyAutocannon

allowComponent(845,FALSE); //SCAP
allowComponent(926,FALSE);
allowComponent(927,FALSE);
allowComponent(929,FALSE);
allowComponent(930,FALSE);
allowComponent(400,FALSE);
allowComponent(401,FALSE);
allowComponent(408,FALSE);
allowComponent(409,FALSE);
allowComponent(410,FALSE);
allowComponent(411,FALSE);
allowComponent(412,FALSE);
allowComponent(413,FALSE);
allowComponent(414,FALSE);
allowComponent(426,FALSE);
allowComponent(427,FALSE);
allowComponent(428,FALSE);
allowComponent(429,FALSE);
allowComponent(430,FALSE);
allowComponent(431,FALSE);
allowComponent(432,FALSE);
allowComponent(433,FALSE);
allowComponent(434,FALSE);

//