$missionName = "Training_1_Mercury";

$server::HudMapViewOffsetX = 0; 
$server::HudMapViewOffsetY = 6000; 

exec("multiplayerStdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = True;
   $server::AllowDeathmatch = False;
   $server::AllowTeamPlay = True;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = false;
   $server::AllowTeamYellow = false;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
   $ammoRate = 3;
   earthquakeSounds();
}

function onMissionLoad()
{
   cdAudioCycle("SS1", "Watching", "Mechsoul"); 

   $Dozer1   = getObjectId( "MissionGroup/Dozer1/Tank1" );
   $Dozer2   = getObjectId( "MissionGroup/Dozer2/Tank1" );
   $Dozer3   = getObjectId( "MissionGroup/Dozer3/Tank1" );
   $RHQ      = "MissionGroup/RedBase/HQ";
   $BHQ      = "MissionGroup/BlueBase/HQ2";
   $BHQ2      = "MissionGroup/BlueBase/HQ3";
   $BHQ3      = "MissionGroup/BlueBase/HQ4";

   order( $Dozer1 , guard, "MissionGroup/Dozer1/Path" );
   order( $Dozer1 , speed, medium );
   order( $Dozer2 , attack, $RHQ );
   order( $Dozer3 , guard, "MissionGroup/Dozer3/Path" );
   order( $Dozer3 , speed, low );

   schedule("order( $Dozer2 , cloak, true );", 5.0);
   schedule("order( $Dozer3 , cloak, true );", 5.0);
   schedule("order( $Dozer3 , cloak, true );", 60.0);
   schedule("order( $Dozer3 , attack, $BHQ );", 60.0);

   $yellowTanksDestroyed = 0;
   $playerKilled = 0;
   $PK = 1;
   $HQ1 = false;
   $HQ2 = false;

   schedule("say(IDSTR_TEAM_RED, 0, \"CR HQ:  Sorry about the limited selection of weapons.  We don't have much here but it should get the job done.  Please check your vehicle and see that it is fully armed.  If you run out of payload during combat we do have a reload facility available.  No repair though, sorry... we're too small for the Empire to bother paying for such luxuries...\");", 2.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"CR HQ:  Ah.  I see you made it.  We were sorta wondering if the Empire would bother sending us help or not.\");", 15.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"CR HQ:  We've got some local pirates up to no good around here and we don't have any vehicles-- or pilots-- to put them in their place.\");", 18.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"CR HQ:  Some of these rockheads have... aquired some mining lasers and mounted them on their bulldozers.  Your job is to eliminate them and their facility a kilometer north of here.\");", 22.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"CR HQ:  Should be a piece of cake for an Imperial Knight, even one in training.  Good luck.\");", 25.0);
}

function player::onAdd(%playerNum)
{
   $playerNum = %playerNum;
}

function vehicle::onAdd(%this)                                                                                                                        
{                                                                                                                                                     
   %num = playerManager::vehicleIdToPlayerNum(%this);                                                                                                 
                                                                                                                                                     
   if(%num == $playerNum)                                                                                                                             
   {                                                                                                                                                  
      $playerId = playerManager::playerNumToVehicleId($playerNum);                                                                                    
   }                                                                                                                                                  
}        

function Garage::structure::onDestroyed( %this, %destroyer )
{
   $yellowTanksDestroyed++;
   say(IDSTR_TEAM_RED, 0, "CR HQ:  Well, you took out that garage of theirs, so they won't be refitting their damned 'dozers anytime soon.  Good work." );
   checkForWin();
}

function HQ::structure::onDestroyed( %this, %destroyer )
{
   say(IDSTR_TEAM_RED, 0, "CR HQ:  They've destroyed our headquarters.  Retreating to shielded bunkers--" );
   order( $Dozer2 , attack, $playerID );
}

function HQ2::structure::onDestroyed( %this, %destroyer )
{
   say(IDSTR_TEAM_RED, 0, "Mining Center HQ:  Our headquarters have been destroyed!  Who's gonna pay for this?" );
   order( $Dozer3 , attack, $BHQ2 );
}

function HQ3::structure::onDestroyed( %this, %destroyer )
{
   say(IDSTR_TEAM_RED, 0, "Mining Center HQ:  Our guard tower is destroyed.  We could really use some help here..." );
   order( $Dozer3 , attack, $BHQ3 );
}

function HQ4::structure::onDestroyed( %this, %destroyer )
{
   fadeEvent( 0, out, 2.5, 1.0, 1.0, 0 ); 
   schedule( "missionEndConditionMet();", 3.0 );
     
   %txt = "You let them fry the Mining Center!  Good grief, I think you need to go back to the Academy!";
   messageBox(0, %txt);
}

function HQ::structure::onAttacked( %this )
{
   if( $HQ1 == false )
   {
   say(IDSTR_TEAM_RED, 0, "CR HQ:  Return to Red Base at once!  One of the pirates is attacking our headquarters!" );
   }
   $HQ1 = true;
}

function HQ2::structure::onAttacked( %this )
{
   if( $HQ2 == false )
   {
   say(IDSTR_TEAM_RED, 0, "Mining Center HQ:  Please come to Nav Bravo!  We're under attack!" );
   }
   $HQ2 = true;
}

function vehicle::onDestroyed( %this, %destroyer )

   if( %this == $Dozer1 )
   {
      $yellowTanksDestroyed++;
      say(IDSTR_TEAM_RED, 0, "CR HQ:  Haha got one." );
   }
    if( %this == $Dozer2 )
   {
      $yellowTanksDestroyed++;
      say(IDSTR_TEAM_RED, 0, "CR HQ:  That one won't be bothering us anymore, eh?" );
   }
   if( %this == $Dozer3 )
   {
      $yellowTanksDestroyed++;
      say(IDSTR_TEAM_RED, 0, "CR HQ:  Good work, you got the leader." );
   }
   if( %this == $playerID )
   {
      $playerKilled++;
      setDominantCamera(%destroyer,%this);
   }
   checkForWin();
}

function checkForWin()
{
   if( $yellowTanksDestroyed == 4 )
   {
      fadeEvent( 0, out, 2.5, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 3.0 );
               
      %txt = "Mission Complete!  Good work!  I don't think we will have any more problems with pirates after the beating you gave these guys!";
      messageBox(0, %txt);
   }

   else if( $playerKilled >= $PK )
   {
      fadeEvent( 0, out, 15, 1.0, 1.0, 0 ); 
      schedule( "missionEndConditionMet();", 20.0 );
      
      %txt = "Lucky you managed to get out of that thing in time.  I can't believe you let some stupid bulldozers with mining lasers fry a Basilisk!!";
      messageBox(0, %txt);
   }
}

allowVehicle(all,FALSE);
allowWeapon(all,FALSE);

allowVehicle(5,TRUE);   //TerranBasilisk

allowWeapon(103,TRUE);  //CompressionLaser
allowWeapon(129,TRUE);  //Minion

//