// FILENAME:	Thunder_Canyon.cs
//
// AUTHORS:  	{VTTK}Zoltar~AH~ 
//		Target
//		Special thanks to BDU Omega[Hawk], for his assistance with some scripts :)
//		
//		Target and I thought we'd put our heads together and 
//		create a map that would be enjoyable for all to play.
//		We hope you enjoy this map as much as we do!
//
//		"BioDerm?' Isn't that a new kind of hand lotion?"
//
//             
//------------------------------------------------------------------------------

$missionName = "Thunder_Canyon";

// move the map
$server::HudMapViewOffsetX = -1500;
$server::HudMapViewOffsetY = 2500;

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

$FlYeRPath = "MissionGroup/AIHercs/IntruderHercs/Paths/FlYeRPath";

Pilot SPFlYeR
{
   id = 8475;
   
   name = "Drone1";
   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 1000.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

// what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

// what can the server admin choose for available teams
        $server::disableTeamRed = false;
        $server::disableTeamBlue = false;
        $server::disableTeamYellow = false;
        $server::disableTeamPurple = false;
}
function player::onAdd(%this)
{
       
        say (%this, 0, "Welcome to Zoltar and Targets Map, Thunder_Canyon!");
	say (%this, 1, "Be sure to read the info tab for game rules");
	say (%this, 2, "For this mission, we thought it would be interesting");
	say (%this, 3, "to bring the gameplay underground.");
	say (%this, 4, "We both hope you'll find Thunder_Canyon both interesting,");
	say (%this, 5, "and entertaining!");
	say (%this, 6, "So have fun and...oh yah, watch your fingers and toes,");
	say (%this, 7, "when operating near the blast doors :)");
}

function onMissionStart()
{
	say(%player, 0, 1, "scene3.wav");
        windSounds();
        iceSounds();

	$FlYeR = getObjectId("MissionGroup/AIHercs/IntruderHercs/Drone1");

	order($FlYeR, guard, $FlYeRPath);


// custom rules for this mission ( teleporter )
   %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
            "<tIDMULT_STD_HEAL>"       @
            "<tIDMULT_STD_RELOAD>";

   setGameInfo(%rules);        
}


function Buddha::structure::onAttacked(%destroyed, %destroyer){
	%sayTo = playerManager::vehicleIdToPlayerNum(%destroyer);
	Say(%sayTo, %sayTo, *IDMULT_YOU_KILLED_BUDDHA);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
}

function ZenTransporter::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 758.184, 3531.59, -145);
	say(0,1,"sfx_thunder1.wav");
}

function ZenTransporter2::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -1704.42, 2522.88, 200);
	say(0,1,"sfx_thunder1.wav");
}

function ZenTransporter3::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 189.985, 3802, -143);
	say(0,1,"sfx_machine3.wav");
}

function ZenTransporter4::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -1896, 3215, 96);
	say(0,1,"sfx_steam.wav");
	say(0,1,"teleport transport sequence suspended..!");
}

function ZenTransporter5::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -1711.78, 1937.37, 81);
}

function ZenTransporter6::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -1390.04, 2191.54, 35.1097);
}

function ZenTransporter7::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -1392.6, 2830.08, 35.1011);
}

function ZenTransporter8::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -2032.01, 2834.23, 35.1203);
}

function ZenTransporter9::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -2033.65, 2190.31, 35.1143);
}


function ZenTransporter10::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -41.0561, 189.212, 772.547 );
}

function ZenTransporter11::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -41.0561, 189.212, 772.547 );
}

function ZenTransporter12::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -41.0561, 189.212, 772.547 );
}

function ZenTransporter13::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -41.0561, 189.212, 772.547 );
}

function ZenTransporter14::trigger::onContact(%this, %object)
{
        Zen::work(%this, %object, 100000, 100, 0, false);
        setPosition(%object, -41.0561, 189.212, 772.547 );
}

// Healing Pad Functionality
//------------------------------------------------------------------------------

function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------

function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 

//This will enable the doors on the yellow platform to animate
//------------------------------------------------------------------------------

}
function Door1::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door1"), 0, true);
}
function Door1::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door1"), 0, false);
}
function Door2::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door2"), 0, true);
}
function Door2::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door2"), 0, false);
}
function Door3::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door3"), 0, true);
}
function Door3::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door3"), 0, false);
}
function Door4::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "getting Chill Eh?", "CC.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door4"), 0, true);
}
function Door4::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door4"), 0, false);
}
function Door5::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door5"), 0, true);
}
function Door5::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door5"), 0, false);
}
function Door6::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "getting Chill Eh?", "CIN_CA_02.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door6"), 0, true);
}
function Door6::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door6"), 0, false);
}
function Door7::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door7"), 0, true);
}
function Door7::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door7"), 0, false);
}
function Door8::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door8"), 0, true);
}
function Door8::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door8"), 0, false);
}
function Door9::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "Returning to Red Base,.. ", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door9"), 0, true);
}
function Door9::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door9"), 0, false);
}
function Door10::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door10"), 0, true);
}
function Door10::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door10"), 0, false);
}
function Door11::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door11"), 0, true);
}
function Door11::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door11"), 0, false);
}
function Door12::trigger::onEnter(%this, %vehicleId){
     %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0)
      return;
      say(%player, 0, "PSsssttt....", "sfx_steam.wav");
      playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door12"), 0, true);
}
function Door12::trigger::onLeave(%this, %vehicleId){
	playAnimSequence(getObjectId("MissionGroup\\Triggers\\Door12"), 0, false);
}

//This script tells the player something when he enters the teleporter
//------------------------------------------------------------------------------
//This cool stuff makes various sounds when you walk through triggers at strategically
//located areas throughout the map :)
//Kinda reflects this maps name when you hear these sounds!
//------------------------------------------------------------------------------

function soundEffect1::trigger::onEnter(%this, %vehicleId){
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);
	if(%player == 0)
	return;
	say(%player, 0,"sfx_thunder2.wav");
}
function soundEffect2::trigger::onEnter(%this, %vehicleId)
{
	say(0,1,"sfx_thunder2.wav");
}
function soundEffect3::trigger::onEnter(%this, %vehicleId)
{	
	say(0,1,"sfx_thunder2.wav");
}
function soundEffect4::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"sfx_thunder2.wav");
}
function soundEffect9::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"CIN_PILOT03.wav");
}
function soundEffect10::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"CIN_REBEL01.wav");
}
function soundEffect11::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"Teleporter transport sequence engaged...,");
	say(0,1,"scene5.wav");
}
function soundEffect12::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"sfx_lava.wav");
}
function soundEffect13::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"sfx_lava.wav");
}
function soundEffect14::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"sfx_lava.wav");
}
function soundEffect15::trigger::onLeave(%this, %vehicleId)
{
	say(0,1,"sfx_lava.wav");
}
//The following functions give Buddahs something to do
//heh heh :)
//-------------------------------------------------------------------------------

function soundEffect5::trigger::onEnter(%this, %vehicleId)
{
	say(0,0,"Walk lightly, you are trespassing on the Ancients burial grounds!");
	say(0,0,"At the time of thier deaths, the Ancients power was absorbed into these grounds.");
	say(0,0,"sfx_thunder1.wav");
}
function soundEffect6::trigger::onEnter(%this, %vehicleId)
{
	say(0,0,"In 2798, the Buddahs were placed over this site because of there ability");
	say(0,0,"to absorb and manufacture the power left here by the Ancients.");
	say(0,0,"sfx_thunder1.wav");
}
function soundEffect7::trigger::onEnter(%this, %vehicleId)
{
	say(0,0,"Loss of the Buddahs would mean the destruction of this planets");
	say(0,0,"natural atmosphere and therefore all its defenses.");
	say(0,0,"sfx_thunder1.wav");
}
function soundEffect8::trigger::onEnter(%this, %vehicleId)
{
	say(0,0,"Without the Buddahs power we all shall surely DIE!");
	say(0,0,"sfx_thunder1.wav");
}
// When the AI hercs are killed..
//--------------------------------------------------------------------------------
//Thank you Chojun for this script!
function vehicle::onDestroyed(%destroyed, %destroyer)
{
	vehicle::onDestroyedLog(%destroyed, %destroyer);
   
	if(%destroyed == $FlYeR)
	{
		%txt = "<F5>" @ getHUDName(%destroyer);
		say(0,0, %txt @ ", you BASTARD!  You killed Zoltars ship!");
      	schedule( "trevorsCloneVehicle(\"$FlYeR\", " @ %destroyed @ ", -2509.4, 476.91, 60);", $respawnDelay);
	}
	
	else
	{
		%message = getFancyDeathMessage(getHUDName(%destroyed), getHUDName(%destroyer));
		if(%message != "")
   		{
      		say(0, 0, %message);
   		}
	}
	
	if($server::TeamPlay == true)
   	{
      	if((getTeam(%destroyed) == getTeam(%destroyer)) && (%destroyed != %destroyer))
      	{
         		antiTeamKill(%destroyer);
      	}
   	}   

}
