
//To use old atrstyle scoring execute this script in dmStdLib.cs
//add the line:
// exec(atrscoring);
//to the end of dmStdlib and game you HOST will be affected

//------------------------------------------------------------------------------
// New ATR Scoreboard 


function getModKills(%a)
{
  return( getKills(%a) - %a.lobbyKills );
}

function getModDeaths(%a)
{
  return( getDeaths(%a) - %a.lobbyDeaths );
}

function getPlayerScore(%a)
{
   return( getModKills(%a) / ( getModDeaths(%a) + 1 ) *100 );
}

function getTeamScore(%a)
{
   return( getTeamKills(%a) / ( getTeamDeaths(%a) + 1 ) *100 );
}

function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

   if($server::TeamPlay == "True")	
   {
	   // Player ScoreBoard column headings
	   $ScoreBoard::PlayerColumnHeader1 = *IDMULT_SCORE_TEAM;
	   $ScoreBoard::PlayerColumnHeader2 = *IDMULT_SCORE_SQUAD;
	   $ScoreBoard::PlayerColumnHeader3 = *IDMULT_SCORE_SCORE;
	   $ScoreBoard::PlayerColumnHeader4 = *IDMULT_SCORE_KILLS;
	   $ScoreBoard::PlayerColumnHeader5 = *IDMULT_SCORE_DEATHS;

	   // Player ScoreBoard column functions
	   $ScoreBoard::PlayerColumnFunction1 = "getTeam";
	   $ScoreBoard::PlayerColumnFunction2 = "getSquad";
	   $ScoreBoard::PlayerColumnFunction3 = "getPlayerScore";
	   $ScoreBoard::PlayerColumnFunction4 = "getKills";
	   $ScoreBoard::PlayerColumnFunction5 = "getDeaths";
   }
   else
   {
       // Player ScoreBoard column headings
	   $ScoreBoard::PlayerColumnHeader1 = *IDMULT_SCORE_SQUAD;
	   $ScoreBoard::PlayerColumnHeader2 = *IDMULT_SCORE_SCORE;
	   $ScoreBoard::PlayerColumnHeader3 = *IDMULT_SCORE_KILLS;
	   $ScoreBoard::PlayerColumnHeader4 = *IDMULT_SCORE_DEATHS;

	   // Player ScoreBoard column functions
	   $ScoreBoard::PlayerColumnFunction1 = "getSquad";
	   $ScoreBoard::PlayerColumnFunction2 = "getPlayerScore";
	   $ScoreBoard::PlayerColumnFunction3 = "getModKills";
	   $ScoreBoard::PlayerColumnFunction4 = "getModDeaths";
   }

   // Team ScoreBoard column headings
   $ScoreBoard::TeamColumnHeader1 = *IDMULT_SCORE_SCORE;
   $ScoreBoard::TeamColumnHeader2 = *IDMULT_SCORE_PLAYERS;
   $ScoreBoard::TeamColumnHeader3 = *IDMULT_SCORE_KILLS;
   $ScoreBoard::TeamColumnHeader4 = *IDMULT_SCORE_DEATHS;

   // Team ScoreBoard column functions
   $ScoreBoard::TeamColumnFunction1 = "getTeamScore";
   $ScoreBoard::TeamColumnFunction2 = "getNumberOfPlayersOnTeam";
   $ScoreBoard::TeamColumnFunction3 = "getTeamKills";
   $ScoreBoard::TeamColumnFunction4 = "getTeamDeaths";

   // tell server to process all the scoreboard definitions defined above
   serverInitScoreBoard();
}
